/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.serializers.KafkaJsonSerializer;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KafkaJsonSerializerTest {
    private ObjectMapper objectMapper = new ObjectMapper();
    private KafkaJsonSerializer<Object> serializer;

    @Before
    public void setup() {
        this.serializer = new KafkaJsonSerializer();
        this.serializer.configure(Collections.emptyMap(), false);
    }

    @Test
    public void serializeNull() {
        Assert.assertNull((Object)this.serializer.serialize("foo", null));
    }

    @Test
    public void serialize() throws Exception {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("foo", "bar");
        message.put("baz", 354.99);
        byte[] bytes = this.serializer.serialize("foo", message);
        Object deserialized = this.objectMapper.readValue(bytes, Object.class);
        Assert.assertEquals(message, (Object)deserialized);
    }
}

