/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.serializers.KafkaJsonDeserializer;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class KafkaJsonDeserializerTest {
    @Test
    public void deserializeNullOrEmpty() {
        KafkaJsonDeserializer deserializer = new KafkaJsonDeserializer();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("json.key.type", Object.class.getName());
        deserializer.configure(props, true);
        Assert.assertNull((Object)deserializer.deserialize("topic", null));
        Assert.assertNull((Object)deserializer.deserialize("topic", new byte[0]));
    }

    @Test
    public void deserializePojoKey() {
        KafkaJsonDeserializer deserializer = new KafkaJsonDeserializer();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("json.key.type", Foo.class.getName());
        deserializer.configure(props, true);
        Foo foo = (Foo)deserializer.deserialize(null, "{\"bar\":\"baz\"}".getBytes());
        Assert.assertNotNull((Object)foo);
        Assert.assertEquals((Object)"baz", (Object)foo.getBar());
    }

    @Test
    public void deserializePojoValue() {
        KafkaJsonDeserializer deserializer = new KafkaJsonDeserializer();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("json.value.type", Foo.class.getName());
        deserializer.configure(props, false);
        Foo foo = (Foo)deserializer.deserialize(null, "{\"bar\":\"baz\"}".getBytes());
        Assert.assertNotNull((Object)foo);
        Assert.assertEquals((Object)"baz", (Object)foo.getBar());
    }

    @Test
    public void deserializeObject() {
        KafkaJsonDeserializer deserializer = new KafkaJsonDeserializer();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("json.value.type", Object.class.getName());
        deserializer.configure(props, false);
        Assert.assertEquals((Object)45.3, (Object)deserializer.deserialize(null, "45.3".getBytes()));
        Assert.assertEquals((Object)799, (Object)deserializer.deserialize(null, "799".getBytes()));
        Assert.assertEquals((Object)"hello", (Object)deserializer.deserialize(null, "\"hello\"".getBytes()));
        Assert.assertEquals(null, (Object)deserializer.deserialize(null, "null".getBytes()));
        Assert.assertEquals(Arrays.asList("foo", "bar"), (Object)deserializer.deserialize(null, "[\"foo\",\"bar\"]".getBytes()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        Assert.assertEquals(map, (Object)deserializer.deserialize(null, "{\"foo\":\"bar\"}".getBytes()));
    }

    public static class Foo {
        private String bar;

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }
    }
}

