/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaInject;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaString;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.validation.constraints.Min;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class KafkaJsonSchemaSerializerTest {
    private static final String recordWithDefaultsSchemaString = "{\"properties\": {\n     \"null\": {\"type\": \"null\", \"default\": null},\n     \"boolean\": {\"type\": \"boolean\", \"default\": true},\n     \"number\": {\"type\": \"number\", \"default\": 123},\n     \"string\": {\"type\": \"string\", \"default\": \"abc\"}\n  },\n  \"additionalProperties\": false\n}";
    private static final JsonSchema recordWithDefaultsSchema = new JsonSchema("{\"properties\": {\n     \"null\": {\"type\": \"null\", \"default\": null},\n     \"boolean\": {\"type\": \"boolean\", \"default\": true},\n     \"number\": {\"type\": \"number\", \"default\": 123},\n     \"string\": {\"type\": \"string\", \"default\": \"abc\"}\n  },\n  \"additionalProperties\": false\n}");
    private final Properties config = new Properties();
    private final SchemaRegistryClient schemaRegistry;
    private KafkaJsonSchemaSerializer<Object> serializer;
    private KafkaJsonSchemaSerializer<Object> latestSerializer;
    private KafkaJsonSchemaDeserializer<Object> deserializer;
    private final String topic;

    public KafkaJsonSchemaSerializerTest() {
        this.config.put("auto.register.schemas", (Object)true);
        this.config.put("schema.registry.url", "bogus");
        this.config.put("json.fail.invalid.schema", (Object)true);
        this.config.put("json.write.dates.iso8601", (Object)true);
        this.schemaRegistry = new MockSchemaRegistryClient(Collections.singletonList(new JsonSchemaProvider()));
        this.serializer = new KafkaJsonSchemaSerializer(this.schemaRegistry, new HashMap<Object, Object>(this.config));
        this.deserializer = this.getDeserializer(Object.class);
        Properties latestConfig = new Properties(this.config);
        latestConfig.put("auto.register.schemas", (Object)false);
        latestConfig.put("schema.registry.url", "bogus");
        latestConfig.put("use.latest.version", (Object)true);
        latestConfig.put("latest.compatibility.strict", (Object)false);
        latestConfig.put("json.default.property.inclusion", "NON_NULL");
        this.latestSerializer = new KafkaJsonSchemaSerializer(this.schemaRegistry, new HashMap<Object, Object>(latestConfig));
        this.topic = "test";
    }

    private <T> KafkaJsonSchemaDeserializer<T> getDeserializer(Class<T> cls) {
        return new KafkaJsonSchemaDeserializer(this.schemaRegistry, new HashMap<Object, Object>(this.config), cls);
    }

    @Test
    public void testKafkaJsonSchemaSerializer() {
        byte[] bytes = this.serializer.serialize(this.topic, null);
        Assert.assertEquals(null, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)NullNode.getInstance());
        Assert.assertEquals(null, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)true);
        Assert.assertEquals((Object)true, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)BooleanNode.getTrue());
        Assert.assertEquals((Object)true, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)123);
        Assert.assertEquals((Object)123, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)IntNode.valueOf((int)123));
        Assert.assertEquals((Object)123, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)345L);
        Assert.assertEquals((Object)345, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)LongNode.valueOf((long)345L));
        Assert.assertEquals((Object)345, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)Float.valueOf(1.23f));
        Assert.assertEquals((Object)new BigDecimal("1.23"), (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)FloatNode.valueOf((float)1.23f));
        Assert.assertEquals((Object)new BigDecimal("1.23"), (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)2.34);
        Assert.assertEquals((Object)new BigDecimal("2.34"), (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)DoubleNode.valueOf((double)2.34));
        Assert.assertEquals((Object)new BigDecimal("2.34"), (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)"abc");
        Assert.assertEquals((Object)"abc", (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)TextNode.valueOf((String)"abc"));
        Assert.assertEquals((Object)"abc", (Object)this.deserializer.deserialize(this.topic, bytes));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testKafkaJsonSchemaSerializerWithoutConfigure() {
        KafkaJsonSchemaSerializer unconfiguredSerializer = new KafkaJsonSchemaSerializer();
        User user = new User();
        unconfiguredSerializer.serialize("foo", (Object)user);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testKafkaJsonSchemaDeserializerWithoutConfigure() {
        KafkaJsonSchemaDeserializer unconfiguredSerializer = new KafkaJsonSchemaDeserializer();
        byte[] randomBytes = "foo".getBytes();
        unconfiguredSerializer.deserialize("foo", randomBytes);
    }

    @Test
    public void serializeNull() {
        Assert.assertNull((Object)this.serializer.serialize("foo", null));
    }

    @Test
    @Ignore
    public void serializeMap() throws Exception {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("foo", "bar");
        message.put("baz", new BigDecimal("354.99"));
        byte[] bytes = this.serializer.serialize("foo", message);
        Object deserialized = this.deserializer.deserialize(this.topic, bytes);
        Assert.assertEquals(message, (Object)deserialized);
    }

    @Test
    public void serializeUser() throws Exception {
        User user = new User("john", "doe", 50, "jack", LocalDate.parse("2018-12-27"));
        byte[] bytes = this.serializer.serialize("foo", (Object)user);
        Object deserialized = this.getDeserializer(User.class).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
        deserialized = this.getDeserializer(null).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
        deserialized = this.getDeserializer(Object.class).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
    }

    @Test(expected=SerializationException.class)
    public void serializeInvalidUser() throws Exception {
        User user = new User("john", "doe", -1, "jack", LocalDate.parse("2018-12-27"));
        byte[] bytes = this.serializer.serialize("foo", (Object)user);
        Object deserialized = this.getDeserializer(User.class).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
    }

    @Test
    public void serializeUserIgnoreNulls() throws Exception {
        User user = new User("john", "doe", 50, "jack", null);
        JsonSchema userSchema = JsonSchemaUtils.getSchema((Object)user, null, (boolean)false, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)userSchema);
        byte[] bytes = this.latestSerializer.serialize(this.topic, (Object)user);
        Object deserialized = this.getDeserializer(User.class).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
    }

    @Test
    public void serializeUserRef() throws Exception {
        String schema = "{\n  \"$schema\": \"http://json-schema.org/draft-07/schema#\",\n  \"title\": \"Schema references\",\n  \"description\": \"List of schema references for multiple types in a single topic\",\n  \"oneOf\": [\n    { \"$ref\": \"customer.json\"},\n    { \"$ref\": \"user.json\"}\n  ]\n}";
        Customer customer = new Customer("acme", null);
        User user = new User("john", "doe", 50, "jack", null);
        JsonSchema userSchema = JsonSchemaUtils.getSchema((Object)user);
        JsonSchema customerSchema = JsonSchemaUtils.getSchema((Object)customer);
        this.schemaRegistry.register("user", (ParsedSchema)userSchema);
        this.schemaRegistry.register("customer", (ParsedSchema)customerSchema);
        ImmutableList refs = ImmutableList.of((Object)new SchemaReference("user.json", "user", Integer.valueOf(1)), (Object)new SchemaReference("customer.json", "customer", Integer.valueOf(1)));
        ImmutableMap resolvedRefs = ImmutableMap.of((Object)"user.json", (Object)userSchema.canonicalString(), (Object)"customer.json", (Object)customerSchema.canonicalString());
        JsonSchema jsonSchema = new JsonSchema(schema, (List)refs, (Map)resolvedRefs, null);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.latestSerializer.serialize(this.topic, (Object)user);
        Object deserialized = this.getDeserializer(null).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
        bytes = this.latestSerializer.serialize(this.topic, (Object)customer);
        deserialized = this.getDeserializer(null).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)customer, (Object)deserialized);
    }

    @Test
    public void serializeRecordWithDefaults() throws Exception {
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)recordWithDefaultsSchema);
        String json = "{}";
        JsonNode record = new ObjectMapper().readTree(json);
        byte[] bytes = this.latestSerializer.serialize(this.topic, (Object)record);
        String expectedJson = "{\n    \"null\": null,\n    \"boolean\": true,\n    \"number\": 123,\n    \"string\": \"abc\"\n}";
        JsonNode expectedRecord = new ObjectMapper().readTree(expectedJson);
        Object deserialized = this.getDeserializer(null).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)expectedRecord, (Object)deserialized);
    }

    @JsonSchemaInject(strings={@JsonSchemaString(path="javaType", value="io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerTest$User")})
    public static class User {
        @JsonProperty
        public String firstName;
        @JsonProperty
        public String lastName;
        @JsonProperty
        @Min(value=0L)
        public @Min(value=0L) short age;
        @JsonProperty
        public Optional<String> nickName;
        @JsonProperty
        public LocalDate birthdate;

        public User() {
        }

        public User(String firstName, String lastName, short age, String nickName, LocalDate birthdate) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
            this.nickName = Optional.ofNullable(nickName);
            this.birthdate = birthdate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.age == user.age && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.nickName, user.nickName) && Objects.equals(this.birthdate, user.birthdate);
        }

        public int hashCode() {
            return Objects.hash(this.firstName, this.lastName, this.age, this.nickName, this.birthdate);
        }
    }

    @JsonSchemaInject(strings={@JsonSchemaString(path="javaType", value="io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerTest$Customer")})
    public static class Customer {
        @JsonProperty
        public String customerName;
        @JsonProperty
        public LocalDate acquireDate;

        public Customer() {
        }

        public Customer(String customerName, LocalDate acquireDate) {
            this.customerName = customerName;
            this.acquireDate = acquireDate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Customer customer = (Customer)o;
            return Objects.equals(this.customerName, customer.customerName) && Objects.equals(this.acquireDate, customer.acquireDate);
        }

        public int hashCode() {
            return Objects.hash(this.customerName, this.acquireDate);
        }
    }
}

