/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.formatter.json.JsonSchemaMessageFormatter;
import io.confluent.kafka.formatter.json.JsonSchemaMessageReader;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KafkaJsonSchemaFormatterTest {
    private Properties props;
    private JsonSchemaMessageFormatter formatter;
    private JsonSchema recordSchema = null;
    private JsonSchema keySchema = null;
    private SchemaRegistryClient schemaRegistry = null;
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Before
    public void setUp() {
        this.props = new Properties();
        this.props.put("schema.registry.url", "bogus");
        String userSchema = "{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"}}, \"additionalProperties\": false }";
        this.recordSchema = new JsonSchema(userSchema);
        String keySchema = "{\"type\":\"integer\"}";
        this.keySchema = new JsonSchema(keySchema);
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.formatter = new JsonSchemaMessageFormatter(this.schemaRegistry, null);
    }

    @Test
    public void testKafkaJsonSchemaValueFormatter() throws Exception {
        this.formatter.init(this.props);
        String inputJson = "{\"name\":\"myname\"}\n";
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(inputJson.getBytes())));
        JsonSchemaMessageReader jsonSchemaReader = new JsonSchemaMessageReader(this.schemaRegistry, null, this.recordSchema, "topic1", false, reader, true, false);
        ProducerRecord message = jsonSchemaReader.readMessage();
        byte[] serializedValue = (byte[])message.value();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord crecord = new ConsumerRecord("topic1", 0, 200L, 1000L, TimestampType.LOG_APPEND_TIME, 0L, 0, serializedValue.length, null, (Object)serializedValue);
        this.formatter.writeTo(crecord, ps);
        String outputJson = baos.toString();
        Assert.assertEquals((String)"Input value json should match output value json", (Object)objectMapper.readTree(inputJson), (Object)objectMapper.readTree(outputJson));
    }

    @Test
    public void testKafkaJsonSchemaKeyValueFormatter() throws Exception {
        this.props.put("print.key", "true");
        this.formatter.init(this.props);
        String inputJson = "10\t{\"name\":\"myname\"}\n";
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(inputJson.getBytes())));
        JsonSchemaMessageReader jsonSchemaReader = new JsonSchemaMessageReader(this.schemaRegistry, this.keySchema, this.recordSchema, "topic1", true, reader, true, false);
        ProducerRecord message = jsonSchemaReader.readMessage();
        byte[] serializedKey = (byte[])message.key();
        byte[] serializedValue = (byte[])message.value();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord crecord = new ConsumerRecord("topic1", 0, 200L, 1000L, TimestampType.LOG_APPEND_TIME, 0L, serializedKey.length, serializedValue.length, (Object)serializedKey, (Object)serializedValue);
        this.formatter.writeTo(crecord, ps);
        String outputJson = baos.toString();
        Assert.assertEquals((String)"Input key/value json should match output key/value json", (Object)objectMapper.readTree(inputJson), (Object)objectMapper.readTree(outputJson));
    }

    @Test
    public void testInvalidFormat() {
        String inputJson = "{\"invalid-field-name\":\"myname\"}\n";
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(inputJson.getBytes())));
        JsonSchemaMessageReader jsonSchemaReader = new JsonSchemaMessageReader(this.schemaRegistry, null, this.recordSchema, "topic1", false, reader, true, false);
        try {
            jsonSchemaReader.readMessage();
            Assert.fail((String)"Registering an invalid schema should fail");
        }
        catch (SerializationException e) {
            Assert.assertTrue((String)"The cause of the exception should be json schema", (boolean)(e.getCause() instanceof SerializationException));
        }
    }
}

