/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class SchemaDiffTest {
    @Test
    public void checkJsonSchemaCompatibility() {
        JSONArray testCases = new JSONArray(SchemaDiffTest.readFile("diff-schema-examples.json"));
        this.checkJsonSchemaCompatibility(testCases);
    }

    @Test
    public void checkJsonSchemaCompatibilityForCombinedSchemas() {
        JSONArray testCases = new JSONArray(SchemaDiffTest.readFile("diff-combined-schema-examples.json"));
        this.checkJsonSchemaCompatibility(testCases);
    }

    private void checkJsonSchemaCompatibility(JSONArray testCases) {
        for (Object testCaseObject : testCases) {
            JSONObject testCase = (JSONObject)testCaseObject;
            Schema original = SchemaLoader.load((JSONObject)testCase.getJSONObject("original_schema"));
            Schema update = SchemaLoader.load((JSONObject)testCase.getJSONObject("update_schema"));
            JSONArray changes = (JSONArray)testCase.get("changes");
            boolean isCompatible = testCase.getBoolean("compatible");
            List errorMessages = changes.toList().stream().map(Object::toString).collect(Collectors.toList());
            String description = (String)testCase.get("description");
            List differences = SchemaDiff.compare((Schema)original, (Schema)update);
            List incompatibleDiffs = differences.stream().filter(diff -> !SchemaDiff.COMPATIBLE_CHANGES.contains(diff.getType())).collect(Collectors.toList());
            Assert.assertThat((String)description, differences.stream().map(change -> change.getType().toString() + " " + change.getJsonPath()).collect(Collectors.toList()), (Matcher)CoreMatchers.is(errorMessages));
            Assert.assertEquals((String)description, (Object)isCompatible, (Object)incompatibleDiffs.isEmpty());
        }
    }

    @Test
    public void testRecursiveCheck() {
        Schema original = SchemaLoader.load((JSONObject)new JSONObject(SchemaDiffTest.readFile("recursive-schema.json")));
        Schema newOne = SchemaLoader.load((JSONObject)new JSONObject(SchemaDiffTest.readFile("recursive-schema.json")));
        Assert.assertTrue((boolean)SchemaDiff.compare((Schema)original, (Schema)newOne).isEmpty());
    }

    @Test
    public void testSchemaAddsProperties() {
        Schema first = SchemaLoader.load((JSONObject)new JSONObject("{}"));
        Schema second = SchemaLoader.load((JSONObject)new JSONObject("{\"properties\": {}}"));
        List changes = SchemaDiff.compare((Schema)first, (Schema)second);
        Assert.assertTrue((boolean)changes.isEmpty());
    }

    public static String readFile(String fileName) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            return reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return null;
    }
}

