/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json;

import java.util.ArrayList;
import java.util.Collections;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;

public class TestSchemas {
    static final Schema BOOLEAN_SCHEMA = BooleanSchema.builder().build();
    static final Schema INT_SCHEMA = NumberSchema.builder().requiresInteger(true).build();
    static final Schema NUMBER_SCHEMA = NumberSchema.builder().requiresNumber(true).build();
    static final Schema STRING_SCHEMA = StringSchema.builder().build();
    static final Schema INT_ARRAY_SCHEMA = ArraySchema.builder().allItemSchema(INT_SCHEMA).build();
    static final Schema NUMBER_ARRAY_SCHEMA = ArraySchema.builder().allItemSchema(NUMBER_SCHEMA).build();
    static final Schema STRING_ARRAY_SCHEMA = ArraySchema.builder().allItemSchema(STRING_SCHEMA).build();
    static final Schema ENUM1_AB_SCHEMA = EnumSchema.builder().possibleValue((Object)"A").possibleValue((Object)"B").build();
    static final Schema ENUM1_ABC_SCHEMA = EnumSchema.builder().possibleValue((Object)"A").possibleValue((Object)"B").possibleValue((Object)"C").build();
    static final Schema ENUM1_BC_SCHEMA = EnumSchema.builder().possibleValue((Object)"B").possibleValue((Object)"C").build();
    static final Schema STRING_UNION_SCHEMA = CombinedSchema.builder().criterion(CombinedSchema.ONE_CRITERION).subschema(STRING_SCHEMA).build();
    static final Schema STRING_INT_UNION_SCHEMA = CombinedSchema.builder().criterion(CombinedSchema.ONE_CRITERION).subschema(STRING_SCHEMA).subschema(INT_SCHEMA).build();
    static final Schema EMPTY_RECORD1 = ObjectSchema.builder().additionalProperties(false).build();
    static final Schema A_INT_RECORD1 = ObjectSchema.builder().addPropertySchema("a", (Schema)NumberSchema.builder().requiresInteger(true).build()).additionalProperties(false).build();
    static final Schema A_INT_OPEN_RECORD1 = ObjectSchema.builder().addPropertySchema("a", (Schema)NumberSchema.builder().requiresInteger(true).build()).additionalProperties(true).build();
    static final Schema A_INT_B_INT_RECORD1 = ObjectSchema.builder().addPropertySchema("a", (Schema)NumberSchema.builder().requiresInteger(true).build()).addPropertySchema("b", (Schema)NumberSchema.builder().requiresInteger(true).build()).additionalProperties(false).build();
    static final Schema A_INT_B_INT_REQUIRED_RECORD1 = ObjectSchema.builder().addPropertySchema("a", (Schema)NumberSchema.builder().requiresInteger(true).build()).addPropertySchema("b", (Schema)NumberSchema.builder().requiresInteger(true).build()).addRequiredProperty("b").additionalProperties(false).build();
    static final Schema A_INT_B_DINT_RECORD1 = ObjectSchema.builder().addPropertySchema("a", (Schema)NumberSchema.builder().requiresInteger(true).build()).addPropertySchema("b", NumberSchema.builder().requiresInteger(true).defaultValue((Object)0).build()).additionalProperties(false).build();
    static final Schema A_INT_B_DINT_REQUIRED_RECORD1 = ObjectSchema.builder().addPropertySchema("a", (Schema)NumberSchema.builder().requiresInteger(true).build()).addPropertySchema("b", NumberSchema.builder().requiresInteger(true).defaultValue((Object)0).build()).addRequiredProperty("b").additionalProperties(false).build();
    static final Schema A_DINT_B_DINT_RECORD1 = ObjectSchema.builder().addPropertySchema("a", NumberSchema.builder().requiresInteger(true).defaultValue((Object)0).build()).addPropertySchema("b", NumberSchema.builder().requiresInteger(true).defaultValue((Object)0).build()).additionalProperties(false).build();

    @SafeVarargs
    static <E> ArrayList<E> list(E ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    static final class ReaderWriter {
        private final Schema mReader;
        private final Schema mWriter;

        public ReaderWriter(Schema reader, Schema writer) {
            this.mReader = reader;
            this.mWriter = writer;
        }

        public Schema getReader() {
            return this.mReader;
        }

        public Schema getWriter() {
            return this.mWriter;
        }
    }
}

