/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaValidator;
import io.confluent.kafka.schemaregistry.SchemaValidatorBuilder;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.TestSchemas;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaValidation {
    public static final List<TestSchemas.ReaderWriter> COMPATIBLE_READER_WRITER_TEST_CASES = TestSchemas.list(new TestSchemas.ReaderWriter(TestSchemas.NUMBER_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.NUMBER_ARRAY_SCHEMA, TestSchemas.INT_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_ABC_SCHEMA, TestSchemas.ENUM1_AB_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_INT_UNION_SCHEMA, TestSchemas.STRING_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_INT_UNION_SCHEMA, TestSchemas.STRING_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_UNION_SCHEMA, TestSchemas.STRING_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_SCHEMA, TestSchemas.STRING_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.A_INT_RECORD1, TestSchemas.EMPTY_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_B_DINT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_B_DINT_RECORD1, TestSchemas.EMPTY_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_B_DINT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_OPEN_RECORD1, TestSchemas.A_INT_B_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_B_INT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_B_DINT_REQUIRED_RECORD1, TestSchemas.A_INT_RECORD1));
    public static final List<TestSchemas.ReaderWriter> INCOMPATIBLE_READER_WRITER_TEST_CASES = TestSchemas.list(new TestSchemas.ReaderWriter(TestSchemas.BOOLEAN_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.BOOLEAN_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.NUMBER_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_SCHEMA, TestSchemas.BOOLEAN_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_ARRAY_SCHEMA, TestSchemas.NUMBER_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_ARRAY_SCHEMA, TestSchemas.STRING_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_AB_SCHEMA, TestSchemas.ENUM1_ABC_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_BC_SCHEMA, TestSchemas.ENUM1_ABC_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.ENUM1_AB_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_AB_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_UNION_SCHEMA, TestSchemas.STRING_INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.STRING_INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.A_INT_B_INT_REQUIRED_RECORD1, TestSchemas.A_INT_RECORD1));
    SchemaValidatorBuilder builder = new SchemaValidatorBuilder();
    Schema rec = ObjectSchema.builder().addPropertySchema("a", NumberSchema.builder().requiresInteger(true).defaultValue((Object)1).build()).addPropertySchema("b", (Schema)NumberSchema.builder().requiresNumber(true).build()).additionalProperties(false).build();
    Schema rec2 = ObjectSchema.builder().addPropertySchema("a", NumberSchema.builder().requiresInteger(true).defaultValue((Object)1).build()).addPropertySchema("b", (Schema)NumberSchema.builder().requiresNumber(true).build()).addPropertySchema("c", NumberSchema.builder().requiresInteger(true).defaultValue((Object)0).build()).additionalProperties(false).build();
    Schema rec3 = ObjectSchema.builder().addPropertySchema("b", (Schema)NumberSchema.builder().requiresNumber(true).build()).addPropertySchema("c", NumberSchema.builder().requiresInteger(true).defaultValue((Object)0).build()).additionalProperties(true).build();
    Schema rec4 = ObjectSchema.builder().addPropertySchema("b", (Schema)NumberSchema.builder().requiresNumber(true).build()).addPropertySchema("c", (Schema)NumberSchema.builder().requiresInteger(true).build()).additionalProperties(false).build();

    @Test
    public void testAllTypes() {
        ObjectSchema s = ObjectSchema.builder().addPropertySchema("boolF", (Schema)BooleanSchema.builder().build()).addRequiredProperty("boolF").addPropertySchema("intF", (Schema)NumberSchema.builder().requiresInteger(true).build()).addRequiredProperty("intF").addPropertySchema("numberF", (Schema)NumberSchema.builder().requiresNumber(true).build()).addRequiredProperty("numberF").addPropertySchema("stringF", (Schema)StringSchema.builder().build()).addRequiredProperty("stringF").addPropertySchema("enumF", (Schema)EnumSchema.builder().possibleValue((Object)"S").build()).addRequiredProperty("enumF").addPropertySchema("arrayF", (Schema)ArraySchema.builder().allItemSchema((Schema)StringSchema.builder().build()).build()).addRequiredProperty("arrayF").addPropertySchema("recordF", (Schema)ObjectSchema.builder().addPropertySchema("f", (Schema)NumberSchema.builder().build()).build()).addRequiredProperty("recordF").addPropertySchema("bool0", (Schema)BooleanSchema.builder().build()).build();
        this.testValidatorPasses(this.builder.mutualReadStrategy().validateLatest(), (Schema)s, new Schema[]{s});
    }

    @Test
    public void testReadOnePrior() {
        this.testValidatorPasses(this.builder.canReadStrategy().validateLatest(), this.rec3, this.rec);
        this.testValidatorFails(this.builder.canReadStrategy().validateLatest(), this.rec4, this.rec);
    }

    @Test
    public void testReadAllPrior() {
        this.testValidatorPasses(this.builder.canReadStrategy().validateAll(), this.rec3, this.rec, this.rec2);
        this.testValidatorFails(this.builder.canReadStrategy().validateAll(), this.rec4, this.rec, this.rec2, this.rec3);
    }

    @Test
    public void testOnePriorCanRead() {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateLatest(), this.rec, this.rec3);
        this.testValidatorFails(this.builder.canBeReadStrategy().validateLatest(), this.rec, this.rec4);
    }

    @Test
    public void testAllPriorCanRead() {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateAll(), this.rec, this.rec3, this.rec2);
        this.testValidatorFails(this.builder.canBeReadStrategy().validateAll(), this.rec, this.rec4, this.rec3, this.rec2);
    }

    @Test
    public void testUnionWithIncompatibleElements() {
        CombinedSchema union1 = CombinedSchema.builder().criterion(CombinedSchema.ONE_CRITERION).subschema((Schema)ArraySchema.builder().allItemSchema(this.rec).build()).build();
        CombinedSchema union2 = CombinedSchema.builder().criterion(CombinedSchema.ONE_CRITERION).subschema((Schema)ArraySchema.builder().allItemSchema(this.rec4).build()).build();
        this.testValidatorFails(this.builder.canReadStrategy().validateAll(), (Schema)union2, new Schema[]{union1});
    }

    @Test
    public void testUnionWithCompatibleElements() {
        CombinedSchema union1 = CombinedSchema.builder().criterion(CombinedSchema.ONE_CRITERION).subschema((Schema)ArraySchema.builder().allItemSchema(this.rec).build()).build();
        CombinedSchema union2 = CombinedSchema.builder().criterion(CombinedSchema.ONE_CRITERION).subschema((Schema)ArraySchema.builder().allItemSchema(this.rec3).build()).build();
        this.testValidatorPasses(this.builder.canReadStrategy().validateAll(), (Schema)union2, new Schema[]{union1});
    }

    @Test
    public void testSchemaCompatibilitySuccesses() {
        for (TestSchemas.ReaderWriter tc : COMPATIBLE_READER_WRITER_TEST_CASES) {
            this.testValidatorPasses(this.builder.canReadStrategy().validateAll(), tc.getReader(), tc.getWriter());
        }
    }

    @Test
    public void testSchemaCompatibilityFailures() {
        for (TestSchemas.ReaderWriter tc : INCOMPATIBLE_READER_WRITER_TEST_CASES) {
            Schema reader = tc.getReader();
            Schema writer = tc.getWriter();
            SchemaValidator validator = this.builder.canReadStrategy().validateAll();
            boolean valid = validator.validate((ParsedSchema)new JsonSchema(reader), Collections.singleton(new JsonSchema(writer)));
            Assert.assertFalse((boolean)valid);
        }
    }

    private void testValidatorPasses(SchemaValidator validator, Schema schema, Schema ... prev) {
        ArrayList<JsonSchema> prior = new ArrayList<JsonSchema>();
        for (int i = prev.length - 1; i >= 0; --i) {
            prior.add(new JsonSchema(prev[i]));
        }
        validator.validate((ParsedSchema)new JsonSchema(schema), prior);
    }

    private void testValidatorFails(SchemaValidator validator, Schema schemaFails, Schema ... prev) {
        ArrayList<JsonSchema> prior = new ArrayList<JsonSchema>();
        for (int i = prev.length - 1; i >= 0; --i) {
            prior.add(new JsonSchema(prev[i]));
        }
        boolean valid = validator.validate((ParsedSchema)new JsonSchema(schemaFails), prior);
        Assert.assertFalse((boolean)valid);
    }
}

