/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.protobuf;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import io.confluent.connect.protobuf.ProtobufData;
import io.confluent.connect.protobuf.test.RecursiveKeyValue;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.serializers.protobuf.ProtobufSchemaAndValue;
import io.confluent.kafka.serializers.protobuf.test.NestedTestProto;
import io.confluent.kafka.serializers.protobuf.test.SInt32ValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.SInt64ValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.TimestampValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.UInt32ValueOuterClass;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufDataTest {
    private static final Logger log = LoggerFactory.getLogger(ProtobufDataTest.class);
    private static Schema OPTIONAL_INT32_SCHEMA = SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_INT64_SCHEMA = SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_FLOAT32_SCHEMA = SchemaBuilder.float32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_FLOAT64_SCHEMA = SchemaBuilder.float64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_BOOLEAN_SCHEMA = SchemaBuilder.bool().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_STRING_SCHEMA = SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_BYTES_SCHEMA = SchemaBuilder.bytes().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static final String VALUE_FIELD_NAME = "value";

    private SchemaAndValue getExpectedSchemaAndValue(Schema fieldSchema, Message message, Object value) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name(message.getDescriptorForType().getName());
        schemaBuilder.field(VALUE_FIELD_NAME, fieldSchema);
        Schema schema = schemaBuilder.build();
        Struct expectedResult = new Struct(schema);
        expectedResult.put(VALUE_FIELD_NAME, value);
        return new SchemaAndValue(schema, (Object)expectedResult);
    }

    private StringValue createStringValueMessage(String messageText) {
        StringValue.Builder builder = StringValue.newBuilder();
        builder.setValue(messageText);
        return builder.build();
    }

    private NestedTestProto.NestedMessage createNestedTestProtoStringUserId() throws ParseException {
        return this.createNestedTestProto(NestedTestProto.UserId.newBuilder().setKafkaUserId("my_user").build());
    }

    private NestedTestProto.NestedMessage createNestedTestProtoIntUserId() throws ParseException {
        return this.createNestedTestProto(NestedTestProto.UserId.newBuilder().setOtherUserId(5).build());
    }

    private NestedTestProto.NestedMessage createNestedTestProto(NestedTestProto.UserId id) throws ParseException {
        NestedTestProto.NestedMessage.Builder message = NestedTestProto.NestedMessage.newBuilder();
        message.setUserId(id);
        message.setIsActive(true);
        message.addExperimentsActive("first experiment");
        message.addExperimentsActive("second experiment");
        message.setStatus(NestedTestProto.Status.INACTIVE);
        NestedTestProto.NestedMessage.InnerMessage.Builder inner = NestedTestProto.NestedMessage.InnerMessage.newBuilder();
        inner.setId("");
        message.setInner(inner.build());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date = sdf.parse("2017/09/18");
        Timestamp timestamp = Timestamps.fromMillis((long)date.getTime());
        message.setUpdatedAt(timestamp);
        message.putMapType("Hello", "World");
        return message.build();
    }

    private NestedTestProto.NestedMessage createEmptyNestedTestProto() throws ParseException {
        NestedTestProto.NestedMessage.Builder message = NestedTestProto.NestedMessage.newBuilder();
        return message.build();
    }

    private Schema getExpectedNestedTestProtoSchemaStringUserId() {
        return this.getExpectedNestedTestProtoSchema();
    }

    private Schema getExpectedNestedTestProtoSchemaIntUserId() {
        return this.getExpectedNestedTestProtoSchema();
    }

    private SchemaBuilder getComplexTypeSchemaBuilder() {
        SchemaBuilder complexTypeBuilder = SchemaBuilder.struct();
        complexTypeBuilder.name("ComplexType");
        SchemaBuilder someValBuilder = SchemaBuilder.struct();
        someValBuilder.name("io.confluent.connect.protobuf.Union.some_val");
        someValBuilder.field("one_id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        someValBuilder.field("other_id", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        complexTypeBuilder.field("some_val_0", someValBuilder.optional().build());
        complexTypeBuilder.field("is_active", SchemaBuilder.bool().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).build());
        return complexTypeBuilder;
    }

    private SchemaBuilder getInnerMessageSchemaBuilder() {
        SchemaBuilder innerMessageBuilder = SchemaBuilder.struct();
        innerMessageBuilder.name("InnerMessage");
        innerMessageBuilder.field("id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        innerMessageBuilder.field("ids", SchemaBuilder.array((Schema)SchemaBuilder.int32().optional().build()).optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        return innerMessageBuilder;
    }

    private Schema getExpectedNestedTestProtoSchema() {
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.name("NestedMessage");
        SchemaBuilder userIdBuilder = SchemaBuilder.struct();
        userIdBuilder.name("UserId");
        SchemaBuilder idBuilder = SchemaBuilder.struct();
        idBuilder.name("io.confluent.connect.protobuf.Union.user_id");
        idBuilder.field("kafka_user_id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        idBuilder.field("other_user_id", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        SchemaBuilder messageIdBuilder = SchemaBuilder.struct();
        messageIdBuilder.name("MessageId");
        messageIdBuilder.field("id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        idBuilder.field("another_id", messageIdBuilder.optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).build());
        userIdBuilder.field("user_id_0", idBuilder.optional().build());
        builder.field("user_id", userIdBuilder.optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        builder.field("is_active", SchemaBuilder.bool().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        builder.field("experiments_active", SchemaBuilder.array((Schema)SchemaBuilder.string().optional().build()).optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).build());
        builder.field("updated_at", org.apache.kafka.connect.data.Timestamp.builder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(4)).build());
        builder.field("status", SchemaBuilder.string().name("Status").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(5)).parameter("io.confluent.connect.protobuf.Enum", "Status").parameter("io.confluent.connect.protobuf.Enum.ACTIVE", "0").parameter("io.confluent.connect.protobuf.Enum.INACTIVE", "1").build());
        builder.field("complex_type", this.getComplexTypeSchemaBuilder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(6)).build());
        builder.field("map_type", SchemaBuilder.map((Schema)OPTIONAL_STRING_SCHEMA, (Schema)SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build()).name("map_type").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(7)).build());
        builder.field("inner", this.getInnerMessageSchemaBuilder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(8)).build());
        return builder.build();
    }

    private Map<String, String> getTestKeyValueMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Hello", "World");
        return result;
    }

    private Struct getExpectedNestedProtoResultStringUserId() throws ParseException {
        Schema schema = this.getExpectedNestedTestProtoSchemaStringUserId();
        Struct result = new Struct(schema.schema());
        Struct userId = new Struct(schema.field("user_id").schema());
        Struct union = new Struct(schema.field("user_id").schema().field("user_id_0").schema());
        union.put("kafka_user_id", (Object)"my_user");
        userId.put("user_id_0", (Object)union);
        result.put("user_id", (Object)userId);
        result.put("is_active", (Object)true);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date = sdf.parse("2017/09/18");
        result.put("updated_at", (Object)date);
        ArrayList<String> experiments = new ArrayList<String>();
        experiments.add("first experiment");
        experiments.add("second experiment");
        result.put("experiments_active", experiments);
        result.put("status", (Object)"INACTIVE");
        result.put("map_type", this.getTestKeyValueMap());
        Struct inner = new Struct(schema.field("inner").schema());
        inner.put("id", (Object)"");
        inner.put("ids", new ArrayList());
        result.put("inner", (Object)inner);
        return result;
    }

    private Struct getExpectedNestedTestProtoResultIntUserId() throws ParseException {
        Schema schema = this.getExpectedNestedTestProtoSchemaIntUserId();
        Struct result = new Struct(schema.schema());
        Struct userId = new Struct(schema.field("user_id").schema());
        Struct union = new Struct(schema.field("user_id").schema().field("user_id_0").schema());
        union.put("other_user_id", (Object)5);
        userId.put("user_id_0", (Object)union);
        result.put("user_id", (Object)userId);
        result.put("is_active", (Object)true);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date = sdf.parse("2017/09/18");
        result.put("updated_at", (Object)date);
        ArrayList<String> experiments = new ArrayList<String>();
        experiments.add("first experiment");
        experiments.add("second experiment");
        result.put("experiments_active", experiments);
        result.put("status", (Object)"INACTIVE");
        result.put("map_type", this.getTestKeyValueMap());
        Struct inner = new Struct(schema.field("inner").schema());
        inner.put("id", (Object)"");
        inner.put("ids", new ArrayList());
        result.put("inner", (Object)inner);
        return result;
    }

    private Struct getExpectedEmptyNestedTestProtoResult() throws ParseException {
        Schema schema = this.getExpectedNestedTestProtoSchema();
        Struct result = new Struct(schema.schema());
        result.put("is_active", (Object)false);
        ArrayList experiments = new ArrayList();
        result.put("experiments_active", experiments);
        result.put("status", (Object)"ACTIVE");
        result.put("map_type", new HashMap());
        return result;
    }

    private NestedTestProto.ComplexType createProtoDefaultOneOf() throws ParseException {
        NestedTestProto.ComplexType.Builder complexTypeBuilder = NestedTestProto.ComplexType.newBuilder();
        complexTypeBuilder.setOtherId(0);
        return complexTypeBuilder.build();
    }

    private NestedTestProto.ComplexType createProtoMultipleSetOneOf() throws ParseException {
        NestedTestProto.ComplexType.Builder complexTypeBuilder = NestedTestProto.ComplexType.newBuilder();
        complexTypeBuilder.setOneId("asdf");
        complexTypeBuilder.setOtherId(0);
        return complexTypeBuilder.build();
    }

    private Struct getExpectedComplexTypeProtoWithDefaultOneOf() {
        Schema schema = this.getComplexTypeSchemaBuilder().build();
        Struct result = new Struct(schema.schema());
        Struct union = new Struct(schema.field("some_val_0").schema());
        union.put("other_id", (Object)0);
        result.put("some_val_0", (Object)union);
        result.put("is_active", (Object)false);
        return result;
    }

    private void assertSchemasEqual(Schema expectedSchema, Schema actualSchema) {
        Assert.assertEquals((Object)expectedSchema.isOptional(), (Object)actualSchema.isOptional());
        Assert.assertEquals((Object)expectedSchema.version(), (Object)actualSchema.version());
        Assert.assertEquals((Object)expectedSchema.name(), (Object)actualSchema.name());
        Assert.assertEquals((Object)expectedSchema.doc(), (Object)actualSchema.doc());
        Assert.assertEquals((Object)expectedSchema.type(), (Object)actualSchema.type());
        Assert.assertEquals((Object)expectedSchema.defaultValue(), (Object)actualSchema.defaultValue());
        Assert.assertEquals((Object)expectedSchema.parameters(), (Object)actualSchema.parameters());
        if (expectedSchema.type() == Schema.Type.STRUCT) {
            Assert.assertEquals((long)expectedSchema.fields().size(), (long)actualSchema.fields().size());
            for (int i = 0; i < expectedSchema.fields().size(); ++i) {
                Field expectedField = (Field)expectedSchema.fields().get(i);
                Field actualField = actualSchema.field(expectedField.name());
                this.assertSchemasEqual(expectedField.schema(), actualField.schema());
            }
        } else if (expectedSchema.type() == Schema.Type.ARRAY) {
            this.assertSchemasEqual(expectedSchema.valueSchema(), actualSchema.valueSchema());
        } else if (expectedSchema.type() == Schema.Type.MAP) {
            this.assertSchemasEqual(expectedSchema.keySchema(), actualSchema.keySchema());
            this.assertSchemasEqual(expectedSchema.valueSchema(), actualSchema.valueSchema());
        }
    }

    private SchemaAndValue getSchemaAndValue(Message message) throws Exception {
        DynamicMessage dynamicMessage;
        ProtobufData protobufData = new ProtobufData();
        ProtobufSchema protobufSchema = new ProtobufSchema(message.getDescriptorForType());
        SchemaAndValue schemaAndValue = protobufData.toConnectData(protobufSchema, (Message)(dynamicMessage = DynamicMessage.parseFrom((Descriptors.Descriptor)protobufSchema.toDescriptor(), (byte[])message.toByteArray())));
        if (schemaAndValue.schema() != null) {
            ConnectSchema.validateValue((Schema)schemaAndValue.schema(), (Object)schemaAndValue.value());
        }
        return schemaAndValue;
    }

    @Test
    public void testToConnectDataWithNestedProtobufMessageAndStringUserId() throws Exception {
        NestedTestProto.NestedMessage message = this.createNestedTestProtoStringUserId();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getExpectedNestedTestProtoSchemaStringUserId();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getExpectedNestedProtoResultStringUserId();
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectDataWithNestedProtobufMessageAndIntUserId() throws Exception {
        NestedTestProto.NestedMessage message = this.createNestedTestProtoIntUserId();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getExpectedNestedTestProtoSchemaIntUserId();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getExpectedNestedTestProtoResultIntUserId();
        this.assertSchemasEqual(expected.schema(), ((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected.schema(), (Object)((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectDataWithEmptyNestedProtobufMessage() throws Exception {
        NestedTestProto.NestedMessage message = this.createEmptyNestedTestProto();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getExpectedNestedTestProtoSchema();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getExpectedEmptyNestedTestProtoResult();
        this.assertSchemasEqual(expected.schema(), ((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected.schema(), (Object)((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectDataDefaultOneOf() throws Exception {
        Schema schema = this.getComplexTypeSchemaBuilder().build();
        NestedTestProto.ComplexType message = this.createProtoDefaultOneOf();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        this.assertSchemasEqual(schema, result.schema());
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)this.getExpectedComplexTypeProtoWithDefaultOneOf()), (Object)result);
    }

    @Test
    public void testToConnectDataDefaultOneOfCannotHaveTwoOneOfsSet() throws Exception {
        Schema schema = this.getComplexTypeSchemaBuilder().build();
        NestedTestProto.ComplexType message = this.createProtoMultipleSetOneOf();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        this.assertSchemasEqual(schema, result.schema());
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)this.getExpectedComplexTypeProtoWithDefaultOneOf()), (Object)result);
    }

    @Test
    public void testToConnectNull() {
        ProtobufData protobufData = new ProtobufData();
        Schema schema = OPTIONAL_BOOLEAN_SCHEMA.schema();
        Assert.assertNull((Object)protobufData.toConnectData(schema, null));
        Assert.assertNull((Object)protobufData.toConnectData((Schema)null, null));
    }

    @Test
    public void testToConnectBoolean() throws Exception {
        Boolean expectedValue = true;
        BoolValue.Builder builder = BoolValue.newBuilder();
        builder.setValue(expectedValue.booleanValue());
        BoolValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_BOOLEAN_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32() throws Exception {
        Integer expectedValue = 12;
        Int32Value.Builder builder = Int32Value.newBuilder();
        builder.setValue(expectedValue.intValue());
        Int32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT32_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32With0() throws Exception {
        Integer expectedValue = 0;
        Int32Value.Builder builder = Int32Value.newBuilder();
        builder.setValue(expectedValue.intValue());
        Int32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT32_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32WithSint32() throws Exception {
        int expectedValue = 12;
        SInt32ValueOuterClass.SInt32Value.Builder builder = SInt32ValueOuterClass.SInt32Value.newBuilder();
        builder.setValue(expectedValue);
        SInt32ValueOuterClass.SInt32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT32_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32WithUInt32() throws Exception {
        Long UNSIGNED_RESULT = 0xFFFFFFFFL;
        Integer expectedValue = -1;
        UInt32ValueOuterClass.UInt32Value.Builder builder = UInt32ValueOuterClass.UInt32Value.newBuilder();
        builder.setValue(expectedValue.intValue());
        UInt32ValueOuterClass.UInt32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT64_SCHEMA, (Message)message, UNSIGNED_RESULT), (Object)result);
    }

    @Test
    public void testToConnectInt64() throws Exception {
        Long expectedValue = 12L;
        Int64Value.Builder builder = Int64Value.newBuilder();
        builder.setValue(expectedValue.longValue());
        Int64Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT64_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectSInt64() throws Exception {
        Long expectedValue = 12L;
        SInt64ValueOuterClass.SInt64Value.Builder builder = SInt64ValueOuterClass.SInt64Value.newBuilder();
        builder.setValue(expectedValue.longValue());
        SInt64ValueOuterClass.SInt64Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT64_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectFloat32() throws Exception {
        Float expectedValue = Float.valueOf(12.0f);
        FloatValue.Builder builder = FloatValue.newBuilder();
        builder.setValue(expectedValue.floatValue());
        FloatValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_FLOAT32_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectFloat64() throws Exception {
        Double expectedValue = 12.0;
        DoubleValue.Builder builder = DoubleValue.newBuilder();
        builder.setValue(expectedValue.doubleValue());
        DoubleValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_FLOAT64_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectString() throws Exception {
        String expectedValue = "Hello";
        StringValue message = this.createStringValueMessage(expectedValue);
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_STRING_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectEmptyString() throws Exception {
        String expectedValue = "";
        StringValue message = this.createStringValueMessage(expectedValue);
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_STRING_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectTimestamp() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date expectedValue = sdf.parse("2017/12/31");
        Timestamp timestamp = Timestamps.fromMillis((long)expectedValue.getTime());
        TimestampValueOuterClass.TimestampValue.Builder builder = TimestampValueOuterClass.TimestampValue.newBuilder();
        builder.setValue(timestamp);
        TimestampValueOuterClass.TimestampValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema timestampSchema = org.apache.kafka.connect.data.Timestamp.builder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(timestampSchema, (Message)message, expectedValue), (Object)result);
    }

    @Test(expected=DataException.class)
    public void testToConnectSchemaMismatchArray() {
        ProtobufData protobufData = new ProtobufData();
        Schema schema = SchemaBuilder.array((Schema)OPTIONAL_STRING_SCHEMA).build();
        protobufData.toConnectData(schema, Arrays.asList(1, 2, 3));
    }

    private byte[] getMessageBytes(Schema schema, Object value) throws Exception {
        Schema structSchema = SchemaBuilder.struct().field(VALUE_FIELD_NAME, schema).build();
        Struct struct = new Struct(structSchema.schema());
        struct.put(VALUE_FIELD_NAME, value);
        SchemaAndValue schemaAndValue = new SchemaAndValue(structSchema, (Object)struct);
        return this.getMessageBytes(schemaAndValue);
    }

    private byte[] getMessageBytes(SchemaAndValue schemaAndValue) throws Exception {
        ProtobufData protobufData = new ProtobufData();
        ProtobufSchemaAndValue protobufSchemaAndValue = protobufData.fromConnectData(schemaAndValue);
        DynamicMessage dynamicMessage = (DynamicMessage)protobufSchemaAndValue.getValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        dynamicMessage.writeTo((OutputStream)baos);
        return baos.toByteArray();
    }

    @Test
    public void testFromConnectDataWithNestedProtobufMessageAndStringUserId() throws Exception {
        NestedTestProto.NestedMessage nestedMessage = this.createNestedTestProtoStringUserId();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)nestedMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        NestedTestProto.NestedMessage message = NestedTestProto.NestedMessage.parseFrom((byte[])messageBytes);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    @Test
    public void testFromConnectDataWithNestedProtobufMessageAndIntUserId() throws Exception {
        NestedTestProto.NestedMessage nestedMessage = this.createNestedTestProtoIntUserId();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)nestedMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        NestedTestProto.NestedMessage message = NestedTestProto.NestedMessage.parseFrom((byte[])messageBytes);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    @Test
    public void testFromConnectDataWithEmptyNestedProtobufMessage() throws Exception {
        NestedTestProto.NestedMessage nestedMessage = this.createEmptyNestedTestProto();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)nestedMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        NestedTestProto.NestedMessage message = NestedTestProto.NestedMessage.parseFrom((byte[])messageBytes);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    @Test
    public void testFromConnectComplex() {
        Schema schema = SchemaBuilder.struct().field("int8", SchemaBuilder.int8().defaultValue((Object)2).doc("int8 field").build()).field("int16", Schema.INT16_SCHEMA).field("int32", Schema.INT32_SCHEMA).field("int64", Schema.INT64_SCHEMA).field("float32", Schema.FLOAT32_SCHEMA).field("float64", Schema.FLOAT64_SCHEMA).field("boolean", Schema.BOOLEAN_SCHEMA).field("string", Schema.STRING_SCHEMA).field("bytes", Schema.BYTES_SCHEMA).field("array", SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).build()).field("map", SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA).build()).field("mapNonStringKeys", SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.INT32_SCHEMA).build()).field("enum", SchemaBuilder.string().name("Status").optional().parameter("io.confluent.connect.protobuf.Enum", "Status").parameter("io.confluent.connect.protobuf.Enum.ACTIVE", "0").parameter("io.confluent.connect.protobuf.Enum.INACTIVE", "1").build()).build();
        Struct struct = new Struct(schema).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)ByteBuffer.wrap("foo".getBytes())).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1)).put("mapNonStringKeys", Collections.singletonMap(1, 1)).put("enum", (Object)"INACTIVE");
        ProtobufSchemaAndValue convertedRecord = new ProtobufData().fromConnectData(schema, (Object)struct);
        ProtobufSchema protobufSchema = convertedRecord.getSchema();
        DynamicMessage message = (DynamicMessage)convertedRecord.getValue();
        MessageElement messageElem = (MessageElement)protobufSchema.rawSchema().getTypes().get(0);
        FieldElement fieldElem = (FieldElement)messageElem.getFields().get(0);
        Assert.assertEquals((Object)"int8", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"int32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(1);
        Assert.assertEquals((Object)"int16", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"int32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(2);
        Assert.assertEquals((Object)"int32", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"int32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(3);
        Assert.assertEquals((Object)"int64", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"int64", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(4);
        Assert.assertEquals((Object)"float32", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"float", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(5);
        Assert.assertEquals((Object)"float64", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"double", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(6);
        Assert.assertEquals((Object)"boolean", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"bool", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(7);
        Assert.assertEquals((Object)"string", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"string", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(8);
        Assert.assertEquals((Object)"bytes", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"bytes", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(9);
        Assert.assertEquals((Object)"array", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"string", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(10);
        Assert.assertEquals((Object)"map", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"ConnectDefault2Entry", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(11);
        Assert.assertEquals((Object)"mapNonStringKeys", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"ConnectDefault3Entry", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(12);
        Assert.assertEquals((Object)"enum", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"Status", (Object)fieldElem.getType());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName("int8");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("int16");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("int32");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("int64");
        Assert.assertEquals((Object)12L, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("float32");
        Assert.assertEquals((Object)Float.valueOf(12.2f), (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("float64");
        Assert.assertEquals((Object)12.2, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("boolean");
        Assert.assertEquals((Object)true, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("string");
        Assert.assertEquals((Object)"foo", (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("bytes");
        Assert.assertEquals((Object)ByteString.copyFrom((byte[])"foo".getBytes()), (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("array");
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("map");
        Object value = message.getField(fieldDescriptor);
        DynamicMessage dynamicMessage = (DynamicMessage)((List)value).get(0);
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName("key");
        Assert.assertEquals((Object)"field", (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)1, (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("mapNonStringKeys");
        value = message.getField(fieldDescriptor);
        dynamicMessage = (DynamicMessage)((List)value).get(0);
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName("key");
        Assert.assertEquals((Object)1, (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)1, (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("enum");
        Descriptors.EnumValueDescriptor enumValueDescriptor = (Descriptors.EnumValueDescriptor)message.getField(fieldDescriptor);
        Assert.assertEquals((Object)"INACTIVE", (Object)enumValueDescriptor.getName());
    }

    @Test
    public void testFromConnectNull() throws Exception {
        ProtobufData protobufData = new ProtobufData();
        Schema schema = SchemaBuilder.struct().field(VALUE_FIELD_NAME, OPTIONAL_BOOLEAN_SCHEMA).build();
        ProtobufSchemaAndValue converted = protobufData.fromConnectData(schema, null);
        Assert.assertNull((Object)converted.getValue());
        converted = protobufData.fromConnectData(null, null);
        Assert.assertNull((Object)converted.getSchema());
        Assert.assertNull((Object)converted.getValue());
    }

    @Test
    public void testFromConnectInt8() throws Exception {
        Byte value = 15;
        byte[] messageBytes = this.getMessageBytes(Schema.OPTIONAL_INT8_SCHEMA, value);
        Int32Value message = Int32Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value.intValue(), (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectInt16() throws Exception {
        Short value = 15;
        byte[] messageBytes = this.getMessageBytes(Schema.OPTIONAL_INT16_SCHEMA, value);
        Int32Value message = Int32Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value.intValue(), (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectInt32() throws Exception {
        Integer value = 15;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_INT32_SCHEMA, value);
        Int32Value message = Int32Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectInt64() throws Exception {
        Long value = 15L;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_INT64_SCHEMA, value);
        Int64Value message = Int64Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectTimestamp() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date = sdf.parse("2017/09/18");
        Timestamp timestamp = Timestamps.fromMillis((long)date.getTime());
        TimestampValueOuterClass.TimestampValue.Builder builder = TimestampValueOuterClass.TimestampValue.newBuilder();
        builder.setValue(timestamp);
        TimestampValueOuterClass.TimestampValue timestampMessage = builder.build();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)timestampMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        TimestampValueOuterClass.TimestampValue message = TimestampValueOuterClass.TimestampValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)Timestamps.fromMillis((long)date.getTime()), (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectFloat32() throws Exception {
        Float value = Float.valueOf(12.3f);
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_FLOAT32_SCHEMA, value);
        FloatValue message = FloatValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectFloat64() throws Exception {
        Double value = 12.3;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_FLOAT64_SCHEMA, value);
        DoubleValue message = DoubleValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectBoolean() throws Exception {
        Boolean value = true;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_BOOLEAN_SCHEMA, value);
        BoolValue message = BoolValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectBooleanWithFalse() throws Exception {
        Boolean value = false;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_BOOLEAN_SCHEMA, value);
        BoolValue message = BoolValue.parseFrom((byte[])messageBytes);
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectString() throws Exception {
        String value = "Hello";
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_STRING_SCHEMA, value);
        StringValue message = StringValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectEmptyString() throws Exception {
        String value = "";
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_STRING_SCHEMA, value);
        StringValue message = StringValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)0L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectBytes() throws Exception {
        byte[] value = ByteBuffer.wrap("foo".getBytes()).array();
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_BYTES_SCHEMA, value);
        BytesValue message = BytesValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)ByteString.copyFrom((byte[])value), (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testToConnectRecursiveSchema() {
        ProtobufSchema protobufSchema = new ProtobufSchema(RecursiveKeyValue.RecursiveKeyValueMessage.getDescriptor());
        ProtobufData protobufData = new ProtobufData();
        Schema expected = this.getRecursiveSchema();
        Schema actual = protobufData.toConnectSchema(protobufSchema);
        Assert.assertEquals((Object)expected.field("key"), (Object)actual.field("key"));
        Assert.assertEquals((Object)expected.field(VALUE_FIELD_NAME), (Object)actual.field(VALUE_FIELD_NAME));
        Schema expectedNested = expected.field("key_value").schema();
        Schema actualNested = actual.field("key_value").schema();
        Assert.assertEquals((Object)expectedNested.name(), (Object)actualNested.name());
        Assert.assertEquals((Object)expectedNested.type(), (Object)actualNested.type());
        Assert.assertEquals((Object)expectedNested.parameters(), (Object)actualNested.parameters());
    }

    @Test
    public void testFromConnectRecursiveSchema() {
        Descriptors.Descriptor expected = RecursiveKeyValue.RecursiveKeyValueMessage.getDescriptor();
        ProtobufData protobufData = new ProtobufData();
        ProtobufSchema protobufSchema = protobufData.fromConnectSchema(this.getRecursiveSchema());
        Descriptors.Descriptor actual = protobufSchema.toDescriptor();
        Descriptors.FieldDescriptor expectedKey = expected.findFieldByName("key");
        Descriptors.FieldDescriptor expectedValue = expected.findFieldByName(VALUE_FIELD_NAME);
        Descriptors.FieldDescriptor expectedKeyValue = expected.findFieldByName("key_value");
        Descriptors.FieldDescriptor actualKey = actual.findFieldByName("key");
        Descriptors.FieldDescriptor actualValue = actual.findFieldByName(VALUE_FIELD_NAME);
        Descriptors.FieldDescriptor actualKeyValue = actual.findFieldByName("key_value");
        Assert.assertEquals((Object)expectedKey.getType(), (Object)actualKey.getType());
        Assert.assertEquals((long)expectedKey.getNumber(), (long)actualKey.getNumber());
        Assert.assertEquals((Object)expectedValue.getType(), (Object)actualValue.getType());
        Assert.assertEquals((long)expectedValue.getNumber(), (long)actualValue.getNumber());
        Assert.assertEquals((Object)actual, (Object)actualKeyValue.getMessageType());
        Assert.assertEquals((long)expectedKeyValue.getNumber(), (long)actualKeyValue.getNumber());
    }

    private Schema getRecursiveSchema() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name("RecursiveKeyValueMessage");
        schemaBuilder.field("key", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        schemaBuilder.field(VALUE_FIELD_NAME, SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        schemaBuilder.field("key_value", new ProtobufData.SchemaWrapper(schemaBuilder).optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(10)).build());
        return schemaBuilder.build();
    }
}

