/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.protobuf;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.confluent.connect.protobuf.ProtobufConverter;
import io.confluent.connect.protobuf.test.Key;
import io.confluent.connect.protobuf.test.KeyValue;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.test.TestMessageProtos;
import io.confluent.kafka.serializers.subject.DefaultReferenceSubjectNameStrategy;
import io.confluent.kafka.serializers.subject.strategy.ReferenceSubjectNameStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ProtobufConverterTest {
    private static final String TOPIC = "topic";
    private static final int PROTOBUF_BYTES_START = 6;
    private static final String TEST_MSG_STRING = "Hello World";
    private static final TestMessageProtos.TestMessage HELLO_WORLD_MESSAGE = TestMessageProtos.TestMessage.newBuilder().setTestString("Hello World").setTestInt32(123).build();
    private static final TestMessageProtos.TestMessage2 HELLO_WORLD_MESSAGE2 = TestMessageProtos.TestMessage2.newBuilder().setTestString("Hello World").setTestInt32(123).build();
    private static final TestMessageProtos.TestMessage2 HELLO_WORLD_MESSAGE_NESTED = TestMessageProtos.TestMessage2.newBuilder().setTestString("Hello World").setTestInt32(123).setTestMessage(HELLO_WORLD_MESSAGE).build();
    private static final Map<String, ?> SR_CONFIG = Collections.singletonMap("schema.registry.url", "localhost");
    private final SchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
    private final ProtobufConverter converter = new ProtobufConverter(this.schemaRegistry);

    @Before
    public void setUp() {
        this.converter.configure(Collections.singletonMap("schema.registry.url", "http://fake-url"), false);
    }

    private Schema getTestMessageSchema() {
        return this.getTestMessageSchema("TestMessage");
    }

    private Schema getTestMessageSchema(String name) {
        return this.getTestMessageSchemaBuilder(name).version(Integer.valueOf(1)).build();
    }

    private SchemaBuilder getTestMessageSchemaBuilder(String name) {
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.name(name);
        builder.field("test_string", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        builder.field("test_bool", SchemaBuilder.bool().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        builder.field("test_bytes", SchemaBuilder.bytes().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).build());
        builder.field("test_double", SchemaBuilder.float64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(4)).build());
        builder.field("test_float", SchemaBuilder.float32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(5)).build());
        builder.field("test_fixed32", SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(6)).build());
        builder.field("test_fixed64", SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(7)).build());
        builder.field("test_int32", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(8)).build());
        builder.field("test_int64", SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(9)).build());
        builder.field("test_sfixed32", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(10)).build());
        builder.field("test_sfixed64", SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(11)).build());
        builder.field("test_sint32", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(12)).build());
        builder.field("test_sint64", SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(13)).build());
        builder.field("test_uint32", SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(14)).build());
        builder.field("test_uint64", SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(15)).build());
        return builder;
    }

    private Struct getTestMessageStruct(String messageText, int messageInt) {
        return this.getTestMessageStruct("TestMessage", messageText, messageInt);
    }

    private Struct getTestMessageStruct(String schemaName, String messageText, int messageInt) {
        Schema schema = this.getTestMessageSchema(schemaName);
        return this.getTestMessageStruct(schema, messageText, messageInt);
    }

    private Struct getTestMessageStruct(Schema schema, String messageText, int messageInt) {
        Struct result = new Struct(schema.schema());
        result.put("test_string", (Object)messageText);
        result.put("test_bool", (Object)false);
        result.put("test_bytes", (Object)ByteBuffer.allocate(0));
        result.put("test_double", (Object)0.0);
        result.put("test_float", (Object)Float.valueOf(0.0f));
        result.put("test_fixed32", (Object)0L);
        result.put("test_fixed64", (Object)0L);
        result.put("test_int32", (Object)messageInt);
        result.put("test_int64", (Object)0L);
        result.put("test_sfixed32", (Object)0);
        result.put("test_sfixed64", (Object)0L);
        result.put("test_sint32", (Object)0);
        result.put("test_sint64", (Object)0L);
        result.put("test_uint32", (Object)0L);
        result.put("test_uint64", (Object)0L);
        return result;
    }

    private ProtobufConverter getConfiguredProtobufConverter(boolean isKey) {
        ProtobufConverter protobufConverter = new ProtobufConverter();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("schema.registry.url", "bogus");
        protobufConverter.configure(configs, isKey);
        return protobufConverter;
    }

    @Test
    public void testFromConnectDataForKey() {
        byte[] expected = HELLO_WORLD_MESSAGE.toByteArray();
        this.converter.configure(SR_CONFIG, true);
        byte[] result = this.converter.fromConnectData("my-topic", this.getTestMessageSchema(), (Object)this.getTestMessageStruct(TEST_MSG_STRING, 123));
        Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(result, 6, result.length));
    }

    @Test
    public void testFromConnectDataForValue() {
        byte[] expected = HELLO_WORLD_MESSAGE.toByteArray();
        this.converter.configure(SR_CONFIG, false);
        byte[] result = this.converter.fromConnectData("my-topic", this.getTestMessageSchema(), (Object)this.getTestMessageStruct(TEST_MSG_STRING, 123));
        Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(result, 6, result.length));
    }

    @Test
    public void testFromConnectDataForValueWithNamespace() {
        byte[] expected = HELLO_WORLD_MESSAGE.toByteArray();
        this.converter.configure(SR_CONFIG, false);
        String fullName = "io.confluent.kafka.serializers.protobuf.test.TestMessage";
        byte[] result = this.converter.fromConnectData("my-topic", this.getTestMessageSchema(fullName), (Object)this.getTestMessageStruct(fullName, TEST_MSG_STRING, 123));
        Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(result, 6, result.length));
    }

    @Test
    public void testFromConnectDataForValueWithNamespaceNested() {
        byte[] expected = HELLO_WORLD_MESSAGE_NESTED.toByteArray();
        this.converter.configure(SR_CONFIG, false);
        String fullName = "io.confluent.kafka.serializers.protobuf.test.TestMessage2";
        Schema nested = this.getTestMessageSchemaBuilder("io.confluent.kafka.serializers.protobuf.test.TestMessage").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(16)).build();
        SchemaBuilder builder = this.getTestMessageSchemaBuilder(fullName);
        builder.field("test_message", nested);
        Schema schema = builder.version(Integer.valueOf(1)).build();
        Struct struct = this.getTestMessageStruct(schema, TEST_MSG_STRING, 123);
        struct.put("test_message", (Object)this.getTestMessageStruct(nested, TEST_MSG_STRING, 123));
        byte[] result = this.converter.fromConnectData("my-topic", schema, (Object)struct);
        Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(result, 6, result.length));
    }

    @Test
    public void testToConnectDataForKey() throws Exception {
        this.converter.configure(SR_CONFIG, true);
        byte[] input = ProtobufConverterTest.concat(new byte[]{0, 0, 0, 0, 1, 0}, HELLO_WORLD_MESSAGE.toByteArray());
        this.schemaRegistry.register("my-topic-key", (ParsedSchema)ProtobufConverterTest.getSchema(TestMessageProtos.TestMessage.getDescriptor()));
        SchemaAndValue result = this.converter.toConnectData("my-topic", input);
        SchemaAndValue expected = new SchemaAndValue(this.getTestMessageSchema(), (Object)this.getTestMessageStruct(TEST_MSG_STRING, 123));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testToConnectDataForKeyWithSecondMessage() throws Exception {
        this.converter.configure(SR_CONFIG, true);
        byte[] input = ProtobufConverterTest.concat(new byte[]{0, 0, 0, 0, 1, 2, 2}, HELLO_WORLD_MESSAGE2.toByteArray());
        this.schemaRegistry.register("my-topic-key", (ParsedSchema)ProtobufConverterTest.getSchema(TestMessageProtos.TestMessage2.getDescriptor()));
        SchemaAndValue result = this.converter.toConnectData("my-topic", input);
        SchemaBuilder builder = this.getTestMessageSchemaBuilder("TestMessage2");
        builder.field("test_message", this.getTestMessageSchemaBuilder("TestMessage").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(16)).build());
        Schema schema = builder.version(Integer.valueOf(1)).build();
        Struct struct = this.getTestMessageStruct(schema, TEST_MSG_STRING, 123);
        struct.put("test_message", null);
        SchemaAndValue expected = new SchemaAndValue(schema, (Object)struct);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testToConnectDataForValue() throws Exception {
        this.converter.configure(SR_CONFIG, false);
        byte[] input = ProtobufConverterTest.concat(new byte[]{0, 0, 0, 0, 1, 0}, HELLO_WORLD_MESSAGE.toByteArray());
        this.schemaRegistry.register("my-topic-value", (ParsedSchema)ProtobufConverterTest.getSchema(TestMessageProtos.TestMessage.getDescriptor()));
        SchemaAndValue result = this.converter.toConnectData("my-topic", input);
        SchemaAndValue expected = new SchemaAndValue(this.getTestMessageSchema(), (Object)this.getTestMessageStruct(TEST_MSG_STRING, 123));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testToConnectDataForValueWithSecondMessage() throws Exception {
        this.converter.configure(SR_CONFIG, false);
        byte[] input = ProtobufConverterTest.concat(new byte[]{0, 0, 0, 0, 1, 2, 2}, HELLO_WORLD_MESSAGE2.toByteArray());
        this.schemaRegistry.register("my-topic-value", (ParsedSchema)ProtobufConverterTest.getSchema(TestMessageProtos.TestMessage2.getDescriptor()));
        SchemaAndValue result = this.converter.toConnectData("my-topic", input);
        SchemaBuilder builder = this.getTestMessageSchemaBuilder("TestMessage2");
        builder.field("test_message", this.getTestMessageSchemaBuilder("TestMessage").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(16)).build());
        Schema schema = builder.version(Integer.valueOf(1)).build();
        Struct struct = this.getTestMessageStruct(schema, TEST_MSG_STRING, 123);
        struct.put("test_message", null);
        SchemaAndValue expected = new SchemaAndValue(schema, (Object)struct);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testToConnectDataForValueWithBothMessages() throws Exception {
        this.converter.configure(SR_CONFIG, false);
        byte[] input = ProtobufConverterTest.concat(new byte[]{0, 0, 0, 0, 1, 0}, HELLO_WORLD_MESSAGE.toByteArray());
        this.schemaRegistry.register("my-topic-value", (ParsedSchema)ProtobufConverterTest.getSchema(TestMessageProtos.TestMessage.getDescriptor()));
        SchemaAndValue result = this.converter.toConnectData("my-topic", input);
        SchemaAndValue expected = new SchemaAndValue(this.getTestMessageSchema(), (Object)this.getTestMessageStruct(TEST_MSG_STRING, 123));
        Assert.assertEquals((Object)expected, (Object)result);
        input = ProtobufConverterTest.concat(new byte[]{0, 0, 0, 0, 1, 2, 2}, HELLO_WORLD_MESSAGE2.toByteArray());
        this.schemaRegistry.register("my-topic-value", (ParsedSchema)ProtobufConverterTest.getSchema(TestMessageProtos.TestMessage2.getDescriptor()));
        result = this.converter.toConnectData("my-topic", input);
        SchemaBuilder builder = this.getTestMessageSchemaBuilder("TestMessage2");
        builder.field("test_message", this.getTestMessageSchemaBuilder("TestMessage").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(16)).build());
        Schema schema = builder.version(Integer.valueOf(1)).build();
        Struct struct = this.getTestMessageStruct(schema, TEST_MSG_STRING, 123);
        struct.put("test_message", null);
        expected = new SchemaAndValue(schema, (Object)struct);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testToConnectDataForValueWithNamespace() throws Exception {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("schema.registry.url", "bogus");
        configs.put("enhanced.protobuf.schema.support", true);
        this.converter.configure(configs, false);
        byte[] input = ProtobufConverterTest.concat(new byte[]{0, 0, 0, 0, 1, 0}, HELLO_WORLD_MESSAGE.toByteArray());
        this.schemaRegistry.register("my-topic-value", (ParsedSchema)ProtobufConverterTest.getSchema(TestMessageProtos.TestMessage.getDescriptor()));
        SchemaAndValue result = this.converter.toConnectData("my-topic", input);
        String fullName = "io.confluent.kafka.serializers.protobuf.test.TestMessage";
        SchemaAndValue expected = new SchemaAndValue(this.getTestMessageSchema(fullName), (Object)this.getTestMessageStruct(fullName, TEST_MSG_STRING, 123));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testToConnectDataForValueWithNamespaceNested() throws Exception {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("schema.registry.url", "bogus");
        configs.put("enhanced.protobuf.schema.support", true);
        this.converter.configure(configs, false);
        byte[] input = ProtobufConverterTest.concat(new byte[]{0, 0, 0, 0, 1, 2, 2}, HELLO_WORLD_MESSAGE_NESTED.toByteArray());
        this.schemaRegistry.register("my-topic-value", (ParsedSchema)ProtobufConverterTest.getSchema(TestMessageProtos.TestMessage2.getDescriptor()));
        SchemaAndValue result = this.converter.toConnectData("my-topic", input);
        String fullName = "io.confluent.kafka.serializers.protobuf.test.TestMessage2";
        Schema nested = this.getTestMessageSchemaBuilder("io.confluent.kafka.serializers.protobuf.test.TestMessage").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(16)).build();
        SchemaBuilder builder = this.getTestMessageSchemaBuilder(fullName);
        builder.field("test_message", nested);
        Schema schema = builder.version(Integer.valueOf(1)).build();
        Struct struct = this.getTestMessageStruct(schema, TEST_MSG_STRING, 123);
        struct.put("test_message", (Object)this.getTestMessageStruct(nested, TEST_MSG_STRING, 123));
        SchemaAndValue expected = new SchemaAndValue(schema, (Object)struct);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testComplex() {
        SchemaBuilder builder = SchemaBuilder.struct().field("int32", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", "1").build()).field("int64", SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", "2").build()).field("float32", SchemaBuilder.float32().optional().parameter("io.confluent.connect.protobuf.Tag", "3").build()).field("float64", SchemaBuilder.float64().optional().parameter("io.confluent.connect.protobuf.Tag", "4").build()).field("boolean", SchemaBuilder.bool().optional().parameter("io.confluent.connect.protobuf.Tag", "5").build()).field("string", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", "6").build()).field("bytes", SchemaBuilder.bytes().optional().parameter("io.confluent.connect.protobuf.Tag", "7").build()).field("array", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().parameter("io.confluent.connect.protobuf.Tag", "8").build()).field("map", SchemaBuilder.map((Schema)SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", "1").build(), (Schema)SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", "2").build()).name("connect_default2").optional().parameter("io.confluent.connect.protobuf.Tag", "9").build());
        Schema schema = builder.build();
        Struct original = new Struct(schema).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)ByteBuffer.wrap("foo".getBytes())).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1));
        Schema expectedSchema = builder.name("ConnectDefault1").version(Integer.valueOf(1)).build();
        Struct expected = new Struct(expectedSchema).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)ByteBuffer.wrap("foo".getBytes()).asReadOnlyBuffer()).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1));
        byte[] converted = this.converter.fromConnectData(TOPIC, original.schema(), (Object)original);
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, converted);
        Assert.assertEquals((Object)expected.schema(), (Object)((Struct)schemaAndValue.value()).schema());
        Assert.assertEquals((Object)expected, (Object)schemaAndValue.value());
    }

    @Test
    public void testNull() {
        Schema schema = SchemaBuilder.struct().build();
        byte[] converted = this.converter.fromConnectData(TOPIC, schema, null);
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, converted);
        Assert.assertEquals((Object)SchemaAndValue.NULL, (Object)schemaAndValue);
    }

    @Test
    public void testVersionExtractedForDefaultSubjectNameStrategy() throws Exception {
        String subject = "topic-value";
        KafkaProtobufSerializer serializer = new KafkaProtobufSerializer(this.schemaRegistry, (Map)ImmutableMap.of((Object)"schema.registry.url", (Object)"http://fake-url"));
        ProtobufConverter protobufConverter = new ProtobufConverter(this.schemaRegistry);
        protobufConverter.configure(Collections.singletonMap("schema.registry.url", "http://fake-url"), false);
        this.testVersionExtracted(subject, serializer, protobufConverter);
    }

    private void testVersionExtracted(String subject, KafkaProtobufSerializer serializer, ProtobufConverter jsonConverter) throws IOException, RestClientException {
        Key.KeyMessage.Builder keyBuilder = Key.KeyMessage.newBuilder();
        Key.KeyMessage keyMessage = keyBuilder.setKey(15).build();
        KeyValue.KeyValueMessage.Builder kvBuilder = KeyValue.KeyValueMessage.newBuilder();
        KeyValue.KeyValueMessage keyValueMessage = kvBuilder.setKey(15).setValue("bar").build();
        byte[] serializedRecord1 = serializer.serialize(TOPIC, (Message)keyMessage);
        byte[] serializedRecord2 = serializer.serialize(TOPIC, (Message)keyValueMessage);
        SchemaAndValue converted1 = jsonConverter.toConnectData(TOPIC, serializedRecord1);
        Assert.assertEquals((long)1L, (long)converted1.schema().version().intValue());
        SchemaAndValue converted2 = jsonConverter.toConnectData(TOPIC, serializedRecord2);
        Assert.assertEquals((long)2L, (long)converted2.schema().version().intValue());
    }

    @Test
    @Ignore
    public void testVersionMaintained() {
        Schema newerSchema = SchemaBuilder.struct().version(Integer.valueOf(2)).field("orig", Schema.OPTIONAL_INT16_SCHEMA).field("new", Schema.OPTIONAL_INT16_SCHEMA).build();
        SchemaAndValue newer = new SchemaAndValue(newerSchema, (Object)new Struct(newerSchema));
        byte[] newerSerialized = this.converter.fromConnectData(TOPIC, newer.schema(), newer.value());
        Schema olderSchema = SchemaBuilder.struct().version(Integer.valueOf(1)).field("orig", Schema.OPTIONAL_INT16_SCHEMA).build();
        SchemaAndValue older = new SchemaAndValue(olderSchema, (Object)new Struct(olderSchema));
        byte[] olderSerialized = this.converter.fromConnectData(TOPIC, older.schema(), older.value());
        Assert.assertEquals((long)2L, (long)this.converter.toConnectData(TOPIC, newerSerialized).schema().version().intValue());
        Assert.assertEquals((long)1L, (long)this.converter.toConnectData(TOPIC, olderSerialized).schema().version().intValue());
    }

    @Test
    public void testSameSchemaMultipleTopicForValue() throws IOException, RestClientException {
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        ProtobufConverter protobufConverter = new ProtobufConverter((SchemaRegistryClient)schemaRegistry);
        protobufConverter.configure(SR_CONFIG, false);
        this.assertSameSchemaMultipleTopic(protobufConverter, (SchemaRegistryClient)schemaRegistry, false);
    }

    @Test
    public void testSameSchemaMultipleTopicForKey() throws IOException, RestClientException {
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        ProtobufConverter protobufConverter = new ProtobufConverter((SchemaRegistryClient)schemaRegistry);
        protobufConverter.configure(SR_CONFIG, true);
        this.assertSameSchemaMultipleTopic(protobufConverter, (SchemaRegistryClient)schemaRegistry, true);
    }

    @Test
    public void testExplicitlyNamedNestedMapsWithNonStringKeys() {
        Schema fieldschema = SchemaBuilder.map((Schema)SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", "1").build(), (Schema)SchemaBuilder.map((Schema)SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", "1").build(), (Schema)SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", "2").build()).name("foo_bar").optional().parameter("io.confluent.connect.protobuf.Tag", "2").build()).name("biz_baz").optional().parameter("io.confluent.connect.protobuf.Tag", "1").build();
        Schema schema = SchemaBuilder.struct().name("ConnectDefault1").field("map", fieldschema).version(Integer.valueOf(1)).build();
        ProtobufConverter protobufConverter = new ProtobufConverter((SchemaRegistryClient)new MockSchemaRegistryClient());
        protobufConverter.configure(Collections.singletonMap("schema.registry.url", "localhost"), false);
        Struct value = new Struct(schema).put("map", Collections.singletonMap("foo", Collections.singletonMap("bar", 1)));
        byte[] bytes = protobufConverter.fromConnectData(TOPIC, schema, (Object)value);
        SchemaAndValue schemaAndValue = protobufConverter.toConnectData(TOPIC, bytes);
        Assert.assertEquals((Object)schemaAndValue.schema(), (Object)schema);
        Assert.assertEquals((Object)schemaAndValue.value(), (Object)value);
    }

    private void assertSameSchemaMultipleTopic(ProtobufConverter converter, SchemaRegistryClient schemaRegistry, boolean isKey) throws IOException, RestClientException {
        Key.KeyMessage.Builder keyBuilder = Key.KeyMessage.newBuilder();
        Key.KeyMessage keyMessage = keyBuilder.setKey(15).build();
        KeyValue.KeyValueMessage.Builder kvBuilder = KeyValue.KeyValueMessage.newBuilder();
        KeyValue.KeyValueMessage keyValueMessage = kvBuilder.setKey(15).setValue("bar").build();
        KeyValue.KeyValueMessage.Builder kvBuilder2 = KeyValue.KeyValueMessage.newBuilder();
        KeyValue.KeyValueMessage keyValueMessage2 = kvBuilder2.setKey(15).setValue("bar").build();
        String subjectSuffix = isKey ? "key" : "value";
        ProtobufSchema schema = ProtobufConverterTest.getSchema(keyValueMessage.getDescriptorForType());
        DefaultReferenceSubjectNameStrategy strategy = new DefaultReferenceSubjectNameStrategy();
        schema = KafkaProtobufSerializer.resolveDependencies((SchemaRegistryClient)schemaRegistry, (boolean)true, (boolean)false, null, (ReferenceSubjectNameStrategy)strategy, (String)"topic1", (boolean)isKey, (ProtobufSchema)schema);
        schemaRegistry.register("topic1-" + subjectSuffix, (ParsedSchema)schema);
        schema = ProtobufConverterTest.getSchema(keyMessage.getDescriptorForType());
        schema = KafkaProtobufSerializer.resolveDependencies((SchemaRegistryClient)schemaRegistry, (boolean)true, (boolean)false, null, (ReferenceSubjectNameStrategy)strategy, (String)"topic2", (boolean)isKey, (ProtobufSchema)schema);
        schemaRegistry.register("topic2-" + subjectSuffix, (ParsedSchema)schema);
        schema = ProtobufConverterTest.getSchema(keyValueMessage2.getDescriptorForType());
        schema = KafkaProtobufSerializer.resolveDependencies((SchemaRegistryClient)schemaRegistry, (boolean)true, (boolean)false, null, (ReferenceSubjectNameStrategy)strategy, (String)"topic2", (boolean)isKey, (ProtobufSchema)schema);
        schemaRegistry.register("topic2-" + subjectSuffix, (ParsedSchema)schema);
        KafkaProtobufSerializer serializer = new KafkaProtobufSerializer(schemaRegistry);
        serializer.configure(SR_CONFIG, isKey);
        byte[] serializedRecord1 = serializer.serialize("topic1", (Message)keyValueMessage);
        byte[] serializedRecord2 = serializer.serialize("topic2", (Message)keyValueMessage2);
        SchemaAndValue converted1 = converter.toConnectData("topic1", serializedRecord1);
        Assert.assertEquals((long)1L, (long)converted1.schema().version().intValue());
        SchemaAndValue converted2 = converter.toConnectData("topic2", serializedRecord2);
        Assert.assertEquals((long)2L, (long)converted2.schema().version().intValue());
        converted2 = converter.toConnectData("topic2", serializedRecord2);
        Assert.assertEquals((long)2L, (long)converted2.schema().version().intValue());
    }

    private static ProtobufSchema getSchema(Descriptors.Descriptor descriptor) {
        return new ProtobufSchema(new ProtobufSchema(descriptor).toString());
    }

    private static byte[] concat(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

