/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.connect.json.JsonSchemaDataConfig;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;

public class JsonSchemaData {
    public static final String NAMESPACE = "io.confluent.connect.json";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    public static final String CONNECT_TYPE_PROP = "connect.type";
    public static final String CONNECT_VERSION_PROP = "connect.version";
    public static final String CONNECT_PARAMETERS_PROP = "connect.parameters";
    public static final String CONNECT_INDEX_PROP = "connect.index";
    public static final String CONNECT_TYPE_INT8 = "int8";
    public static final String CONNECT_TYPE_INT16 = "int16";
    public static final String CONNECT_TYPE_INT32 = "int32";
    public static final String CONNECT_TYPE_INT64 = "int64";
    public static final String CONNECT_TYPE_FLOAT32 = "float32";
    public static final String CONNECT_TYPE_FLOAT64 = "float64";
    public static final String CONNECT_TYPE_BYTES = "bytes";
    public static final String CONNECT_TYPE_MAP = "map";
    public static final String JSON_TYPE_ENUM = "io.confluent.connect.json.Enum";
    public static final String JSON_TYPE_ENUM_PREFIX = "io.confluent.connect.json.Enum.";
    public static final String JSON_TYPE_ONE_OF = "io.confluent.connect.json.OneOf";
    private static final JsonNodeFactory JSON_NODE_FACTORY = JsonNodeFactory.withExactBigDecimals((boolean)true);
    private static final ObjectMapper OBJECT_MAPPER = Jackson.newObjectMapper();
    private static final Map<Schema.Type, JsonToConnectTypeConverter> TO_CONNECT_CONVERTERS = new EnumMap<Schema.Type, JsonToConnectTypeConverter>(Schema.Type.class);
    private static final HashMap<String, JsonToConnectLogicalTypeConverter> TO_CONNECT_LOGICAL_CONVERTERS;
    private static final HashMap<String, ConnectToJsonLogicalTypeConverter> TO_JSON_LOGICAL_CONVERTERS;
    private JsonSchemaDataConfig config;
    private Cache<org.apache.kafka.connect.data.Schema, Schema> fromConnectSchemaCache;
    private Cache<JsonSchema, org.apache.kafka.connect.data.Schema> toConnectSchemaCache;

    private static boolean isInstanceOfSchemaTypeForSimpleSchema(org.apache.kafka.connect.data.Schema fieldSchema, JsonNode value) {
        switch (fieldSchema.type()) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                return value.isIntegralNumber();
            }
            case FLOAT32: 
            case FLOAT64: {
                return value.isNumber();
            }
            case BOOLEAN: {
                return value.isBoolean();
            }
            case STRING: {
                return value.isTextual();
            }
            case BYTES: {
                return value.isBinary() || value.isBigDecimal();
            }
            case ARRAY: {
                return value.isArray();
            }
            case MAP: {
                return value.isObject() || value.isArray();
            }
            case STRUCT: {
                return value.isObject();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + fieldSchema.type());
    }

    public JsonSchemaData() {
        this(new JsonSchemaDataConfig.Builder().with("schemas.cache.size", 1000).build());
    }

    public JsonSchemaData(JsonSchemaDataConfig jsonSchemaDataConfig) {
        this.config = jsonSchemaDataConfig;
        this.fromConnectSchemaCache = new SynchronizedCache((Cache)new LRUCache(jsonSchemaDataConfig.schemaCacheSize()));
        this.toConnectSchemaCache = new SynchronizedCache((Cache)new LRUCache(jsonSchemaDataConfig.schemaCacheSize()));
    }

    /*
     * Unable to fully structure code
     */
    public JsonNode fromConnectData(org.apache.kafka.connect.data.Schema schema, Object logicalValue) {
        if (logicalValue == null) {
            if (schema == null) {
                return null;
            }
            if (schema.defaultValue() != null) {
                return this.fromConnectData(schema, schema.defaultValue());
            }
            if (schema.isOptional()) {
                return JsonSchemaData.JSON_NODE_FACTORY.nullNode();
            }
            throw new DataException("Conversion error: null value for field that is required and has no default value");
        }
        value = logicalValue;
        if (schema != null && schema.name() != null && (logicalConverter = JsonSchemaData.TO_JSON_LOGICAL_CONVERTERS.get(schema.name())) != null) {
            return logicalConverter.convert(schema, logicalValue, this.config);
        }
        try {
            if (schema == null) {
                schemaType = ConnectSchema.schemaType(value.getClass());
                if (schemaType == null) {
                    throw new DataException("Java class " + value.getClass() + " does not have corresponding schema type.");
                }
            } else {
                schemaType = schema.type();
            }
            switch (1.$SwitchMap$org$apache$kafka$connect$data$Schema$Type[schemaType.ordinal()]) {
                case 1: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode(((Byte)value).shortValue());
                }
                case 2: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Short)value);
                }
                case 3: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Integer)value);
                }
                case 4: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Long)value);
                }
                case 5: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Float)value);
                }
                case 6: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Double)value);
                }
                case 7: {
                    return JsonSchemaData.JSON_NODE_FACTORY.booleanNode(((Boolean)value).booleanValue());
                }
                case 8: {
                    charSeq = (CharSequence)value;
                    return JsonSchemaData.JSON_NODE_FACTORY.textNode(charSeq.toString());
                }
                case 9: {
                    if (value instanceof byte[]) {
                        return JsonSchemaData.JSON_NODE_FACTORY.binaryNode((byte[])value);
                    }
                    if (value instanceof ByteBuffer) {
                        return JsonSchemaData.JSON_NODE_FACTORY.binaryNode(((ByteBuffer)value).array());
                    }
                    if (value instanceof BigDecimal) {
                        return JsonSchemaData.JSON_NODE_FACTORY.numberNode((BigDecimal)value);
                    }
                    throw new DataException("Invalid type for bytes type: " + value.getClass());
                }
                case 10: {
                    collection = (Collection)value;
                    list = JsonSchemaData.JSON_NODE_FACTORY.arrayNode();
                    for (E elem : collection) {
                        valueSchema = schema == null ? null : schema.valueSchema();
                        fieldValue = this.fromConnectData(valueSchema, elem);
                        list.add(fieldValue);
                    }
                    return list;
                }
                case 11: {
                    map = (Map)value;
                    if (schema != null) ** GOTO lbl64
                    objectMode = true;
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        if (entry.getKey() instanceof String) continue;
                        objectMode = false;
                        ** GOTO lbl65
                    }
                    ** GOTO lbl65
lbl64:
                    // 1 sources

                    objectMode = schema.keySchema().type() == Schema.Type.STRING && schema.keySchema().isOptional() == false;
lbl65:
                    // 3 sources

                    obj = null;
                    list = null;
                    if (objectMode) {
                        obj = JsonSchemaData.JSON_NODE_FACTORY.objectNode();
                    } else {
                        list = JsonSchemaData.JSON_NODE_FACTORY.arrayNode();
                    }
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        keySchema = schema == null ? null : schema.keySchema();
                        valueSchema = schema == null ? null : schema.valueSchema();
                        mapKey = this.fromConnectData(keySchema, entry.getKey());
                        mapValue = this.fromConnectData(valueSchema, entry.getValue());
                        if (objectMode) {
                            obj.set(mapKey.asText(), mapValue);
                            continue;
                        }
                        o = JsonSchemaData.JSON_NODE_FACTORY.objectNode();
                        o.set("key", mapKey);
                        o.set("value", mapValue);
                        list.add((JsonNode)o);
                    }
                    return objectMode != false ? obj : list;
                }
                case 12: {
                    struct = (Struct)value;
                    if (!struct.schema().equals(schema)) {
                        throw new DataException("Mismatching schema.");
                    }
                    if ("io.confluent.connect.json.OneOf".equals(schema.name())) {
                        for (Field field : schema.fields()) {
                            object = struct.get(field);
                            if (object == null) continue;
                            return this.fromConnectData(field.schema(), object);
                        }
                        return this.fromConnectData(schema, null);
                    }
                    obj = JsonSchemaData.JSON_NODE_FACTORY.objectNode();
                    for (Field field : schema.fields()) {
                        obj.set(field.name(), this.fromConnectData(field.schema(), struct.get(field)));
                    }
                    return obj;
                }
            }
            throw new DataException("Couldn't convert " + value + " to JSON.");
        }
        catch (ClassCastException e) {
            schemaTypeStr = schema != null ? schema.type().toString() : "unknown schema";
            throw new DataException("Invalid type for " + schemaTypeStr + ": " + value.getClass());
        }
    }

    public static Object toConnectData(org.apache.kafka.connect.data.Schema schema, JsonNode jsonValue) {
        JsonToConnectLogicalTypeConverter logicalConverter;
        JsonToConnectTypeConverter typeConverter;
        Schema.Type schemaType;
        if (schema != null) {
            schemaType = schema.type();
            if (jsonValue == null || jsonValue.isNull()) {
                if (schema.defaultValue() != null) {
                    return schema.defaultValue();
                }
                if (schema.isOptional()) {
                    return null;
                }
                throw new DataException("Invalid null value for required " + schemaType + " field");
            }
        } else {
            if (jsonValue == null) {
                return null;
            }
            switch (jsonValue.getNodeType()) {
                case NULL: {
                    return null;
                }
                case BOOLEAN: {
                    schemaType = Schema.Type.BOOLEAN;
                    break;
                }
                case NUMBER: {
                    if (jsonValue.isIntegralNumber()) {
                        schemaType = Schema.Type.INT64;
                        break;
                    }
                    schemaType = Schema.Type.FLOAT64;
                    break;
                }
                case ARRAY: {
                    schemaType = Schema.Type.ARRAY;
                    break;
                }
                case OBJECT: {
                    schemaType = Schema.Type.MAP;
                    break;
                }
                case STRING: {
                    schemaType = Schema.Type.STRING;
                    break;
                }
                default: {
                    schemaType = null;
                }
            }
        }
        if ((typeConverter = TO_CONNECT_CONVERTERS.get(schemaType)) == null) {
            throw new DataException("Unknown schema type: " + schemaType);
        }
        if (schema != null && schema.name() != null && (logicalConverter = TO_CONNECT_LOGICAL_CONVERTERS.get(schema.name())) != null) {
            return logicalConverter.convert(schema, jsonValue);
        }
        return typeConverter.convert(schema, jsonValue);
    }

    public JsonSchema fromConnectSchema(org.apache.kafka.connect.data.Schema schema) {
        return new JsonSchema(this.rawSchemaFromConnectSchema(schema));
    }

    private Schema rawSchemaFromConnectSchema(org.apache.kafka.connect.data.Schema schema) {
        if (schema == null) {
            return null;
        }
        Schema cachedSchema = (Schema)this.fromConnectSchemaCache.get((Object)schema);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        Schema resultSchema = this.rawSchemaFromConnectSchema(schema, null);
        this.fromConnectSchemaCache.put((Object)schema, (Object)resultSchema);
        return resultSchema;
    }

    private Schema rawSchemaFromConnectSchema(org.apache.kafka.connect.data.Schema schema, Integer index) {
        return this.rawSchemaFromConnectSchema(schema, index, false);
    }

    private Schema rawSchemaFromConnectSchema(org.apache.kafka.connect.data.Schema schema, Integer index, boolean ignoreOptional) {
        CombinedSchema.Builder combinedBuilder;
        BooleanSchema.Builder builder;
        if (schema == null) {
            return null;
        }
        HashMap<String, Object> unprocessedProps = new HashMap<String, Object>();
        switch (schema.type()) {
            case INT8: {
                builder = NumberSchema.builder().requiresInteger(true);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT8);
                break;
            }
            case INT16: {
                builder = NumberSchema.builder().requiresInteger(true);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT16);
                break;
            }
            case INT32: {
                builder = NumberSchema.builder().requiresInteger(true);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT32);
                break;
            }
            case INT64: {
                builder = NumberSchema.builder().requiresInteger(true);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT64);
                break;
            }
            case FLOAT32: {
                builder = NumberSchema.builder().requiresInteger(false);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_FLOAT32);
                break;
            }
            case FLOAT64: {
                builder = NumberSchema.builder().requiresInteger(false);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_FLOAT64);
                break;
            }
            case BOOLEAN: {
                builder = BooleanSchema.builder();
                break;
            }
            case STRING: {
                if (schema.parameters() != null && schema.parameters().containsKey(JSON_TYPE_ENUM)) {
                    EnumSchema.Builder enumBuilder = EnumSchema.builder();
                    for (Map.Entry entry : schema.parameters().entrySet()) {
                        if (!((String)entry.getKey()).startsWith(JSON_TYPE_ENUM_PREFIX)) continue;
                        enumBuilder.possibleValue(entry.getValue());
                    }
                    builder = enumBuilder;
                    break;
                }
                builder = StringSchema.builder();
                break;
            }
            case BYTES: {
                builder = "org.apache.kafka.connect.data.Decimal".equals(schema.name()) ? NumberSchema.builder() : StringSchema.builder();
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_BYTES);
                break;
            }
            case ARRAY: {
                builder = ArraySchema.builder().allItemSchema(this.rawSchemaFromConnectSchema(schema.valueSchema()));
                break;
            }
            case MAP: {
                if (schema.keySchema().type() == Schema.Type.STRING && !schema.keySchema().isOptional()) {
                    Schema valueSchema = this.rawSchemaFromConnectSchema(schema.valueSchema());
                    builder = ObjectSchema.builder().schemaOfAdditionalProperties(valueSchema);
                    unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_MAP);
                    break;
                }
                ObjectSchema.Builder entryBuilder = ObjectSchema.builder();
                Schema keySchema = this.rawSchemaFromConnectSchema(schema.keySchema(), 0);
                Schema valueSchema = this.rawSchemaFromConnectSchema(schema.valueSchema(), 1);
                entryBuilder.addPropertySchema(KEY_FIELD, keySchema);
                entryBuilder.addPropertySchema(VALUE_FIELD, valueSchema);
                builder = ArraySchema.builder().allItemSchema((Schema)entryBuilder.build());
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_MAP);
                break;
            }
            case STRUCT: {
                if (JSON_TYPE_ONE_OF.equals(schema.name())) {
                    combinedBuilder = CombinedSchema.builder();
                    combinedBuilder.criterion(CombinedSchema.ONE_CRITERION);
                    if (schema.isOptional()) {
                        combinedBuilder.subschema((Schema)NullSchema.INSTANCE);
                    }
                    for (Field field : schema.fields()) {
                        combinedBuilder.subschema(this.rawSchemaFromConnectSchema(JsonSchemaData.nonOptional(field.schema()), field.index(), true));
                    }
                    builder = combinedBuilder;
                    break;
                }
                if (schema.isOptional()) {
                    combinedBuilder = CombinedSchema.builder();
                    combinedBuilder.criterion(CombinedSchema.ONE_CRITERION);
                    combinedBuilder.subschema((Schema)NullSchema.INSTANCE);
                    combinedBuilder.subschema(this.rawSchemaFromConnectSchema(JsonSchemaData.nonOptional(schema)));
                    builder = combinedBuilder;
                    break;
                }
                ObjectSchema.Builder objectBuilder = ObjectSchema.builder();
                for (Field field : schema.fields()) {
                    Schema fieldSchema = this.rawSchemaFromConnectSchema(field.schema(), field.index());
                    objectBuilder.addPropertySchema(field.name(), fieldSchema);
                }
                builder = objectBuilder;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type " + schema.type());
            }
        }
        if (!(builder instanceof CombinedSchema.Builder)) {
            Map<String, String> parameters;
            if (schema.name() != null) {
                builder.title(schema.name());
            }
            if (schema.version() != null) {
                unprocessedProps.put(CONNECT_VERSION_PROP, schema.version());
            }
            if (schema.doc() != null) {
                builder.description(schema.doc());
            }
            if (schema.parameters() != null && (parameters = schema.parameters().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith(NAMESPACE)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).size() > 0) {
                unprocessedProps.put(CONNECT_PARAMETERS_PROP, parameters);
            }
            if (schema.defaultValue() != null) {
                builder.defaultValue(schema.defaultValue());
            }
            if (!ignoreOptional && schema.isOptional()) {
                combinedBuilder = CombinedSchema.builder();
                combinedBuilder.criterion(CombinedSchema.ONE_CRITERION);
                combinedBuilder.subschema((Schema)NullSchema.INSTANCE);
                combinedBuilder.subschema(builder.unprocessedProperties(unprocessedProps).build());
                if (index != null) {
                    combinedBuilder.unprocessedProperties(Collections.singletonMap(CONNECT_INDEX_PROP, index));
                }
                builder = combinedBuilder;
                unprocessedProps = new HashMap();
            }
        }
        if (index != null) {
            unprocessedProps.put(CONNECT_INDEX_PROP, index);
        }
        return builder.unprocessedProperties(unprocessedProps).build();
    }

    private static org.apache.kafka.connect.data.Schema nonOptional(org.apache.kafka.connect.data.Schema schema) {
        return new ConnectSchema(schema.type(), false, schema.defaultValue(), schema.name(), schema.version(), schema.doc(), schema.parameters(), JsonSchemaData.fields(schema), JsonSchemaData.keySchema(schema), JsonSchemaData.valueSchema(schema));
    }

    private static List<Field> fields(org.apache.kafka.connect.data.Schema schema) {
        Schema.Type type = schema.type();
        if (Schema.Type.STRUCT.equals((Object)type)) {
            return schema.fields();
        }
        return null;
    }

    private static org.apache.kafka.connect.data.Schema keySchema(org.apache.kafka.connect.data.Schema schema) {
        Schema.Type type = schema.type();
        if (Schema.Type.MAP.equals((Object)type)) {
            return schema.keySchema();
        }
        return null;
    }

    private static org.apache.kafka.connect.data.Schema valueSchema(org.apache.kafka.connect.data.Schema schema) {
        Schema.Type type = schema.type();
        if (Schema.Type.MAP.equals((Object)type) || Schema.Type.ARRAY.equals((Object)type)) {
            return schema.valueSchema();
        }
        return null;
    }

    public org.apache.kafka.connect.data.Schema toConnectSchema(JsonSchema schema) {
        if (schema == null) {
            return null;
        }
        org.apache.kafka.connect.data.Schema cachedSchema = (org.apache.kafka.connect.data.Schema)this.toConnectSchemaCache.get((Object)schema);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        org.apache.kafka.connect.data.Schema resultSchema = this.toConnectSchema(schema.rawSchema(), schema.version(), false);
        this.toConnectSchemaCache.put((Object)schema, (Object)resultSchema);
        return resultSchema;
    }

    @VisibleForTesting
    protected org.apache.kafka.connect.data.Schema toConnectSchema(Schema jsonSchema) {
        return this.toConnectSchema(jsonSchema, null);
    }

    private org.apache.kafka.connect.data.Schema toConnectSchema(Schema jsonSchema, Integer version) {
        return this.toConnectSchema(jsonSchema, version, false);
    }

    private org.apache.kafka.connect.data.Schema toConnectSchema(Schema jsonSchema, Integer version, boolean forceOptional) {
        Map parameters;
        Integer connectVersion;
        Object type;
        SchemaBuilder builder;
        if (jsonSchema == null) {
            return null;
        }
        if (jsonSchema instanceof BooleanSchema) {
            builder = SchemaBuilder.bool();
        } else if (jsonSchema instanceof NumberSchema) {
            NumberSchema numberSchema = (NumberSchema)jsonSchema;
            type = (String)numberSchema.getUnprocessedProperties().get(CONNECT_TYPE_PROP);
            if (type == null) {
                builder = numberSchema.requiresInteger() ? SchemaBuilder.int64() : SchemaBuilder.float64();
            } else {
                switch (type) {
                    case "int8": {
                        builder = SchemaBuilder.int8();
                        break;
                    }
                    case "int16": {
                        builder = SchemaBuilder.int16();
                        break;
                    }
                    case "int32": {
                        builder = SchemaBuilder.int32();
                        break;
                    }
                    case "int64": {
                        builder = SchemaBuilder.int64();
                        break;
                    }
                    case "float32": {
                        builder = SchemaBuilder.float32();
                        break;
                    }
                    case "float64": {
                        builder = SchemaBuilder.float64();
                        break;
                    }
                    case "bytes": {
                        builder = SchemaBuilder.bytes();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type " + (String)type);
                    }
                }
            }
        } else if (jsonSchema instanceof StringSchema) {
            String type2 = (String)jsonSchema.getUnprocessedProperties().get(CONNECT_TYPE_PROP);
            builder = CONNECT_TYPE_BYTES.equals(type2) ? SchemaBuilder.bytes() : SchemaBuilder.string();
        } else if (jsonSchema instanceof EnumSchema) {
            EnumSchema enumSchema = (EnumSchema)jsonSchema;
            builder = SchemaBuilder.string();
            builder.parameter(JSON_TYPE_ENUM, "");
            for (Object enumObj : enumSchema.getPossibleValuesAsList()) {
                String enumSymbol = enumObj.toString();
                builder.parameter(JSON_TYPE_ENUM_PREFIX + enumSymbol, enumSymbol);
            }
        } else if (jsonSchema instanceof CombinedSchema) {
            CombinedSchema combinedSchema = (CombinedSchema)jsonSchema;
            CombinedSchema.ValidationCriterion criterion = combinedSchema.getCriterion();
            String name = null;
            if (criterion != CombinedSchema.ONE_CRITERION && criterion != CombinedSchema.ANY_CRITERION) {
                if (criterion == CombinedSchema.ALL_CRITERION) {
                    return this.allOfToConnectSchema(combinedSchema, version, forceOptional);
                }
                throw new IllegalArgumentException("Unsupported criterion: " + criterion);
            }
            name = JSON_TYPE_ONE_OF;
            if (combinedSchema.getSubschemas().size() == 2) {
                boolean foundNullSchema = false;
                Iterator<Object> nonNullSchema = null;
                for (Schema subSchema : combinedSchema.getSubschemas()) {
                    if (subSchema instanceof NullSchema) {
                        foundNullSchema = true;
                        continue;
                    }
                    nonNullSchema = subSchema;
                }
                if (foundNullSchema) {
                    return this.toConnectSchema((Schema)nonNullSchema, version, true);
                }
            }
            int index = 0;
            builder = SchemaBuilder.struct().name(name);
            for (Schema schema : combinedSchema.getSubschemas()) {
                if (schema instanceof NullSchema) {
                    builder.optional();
                    continue;
                }
                String subFieldName = name + ".field." + index++;
                builder.field(subFieldName, this.toConnectSchema(schema, null, true));
            }
        } else if (jsonSchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)jsonSchema;
            Schema itemsSchema = arraySchema.getAllItemSchema();
            if (itemsSchema == null) {
                throw new DataException("Array schema did not specify the items type");
            }
            String type3 = (String)arraySchema.getUnprocessedProperties().get(CONNECT_TYPE_PROP);
            if (CONNECT_TYPE_MAP.equals(type3) && itemsSchema instanceof ObjectSchema) {
                ObjectSchema objectSchema = (ObjectSchema)itemsSchema;
                builder = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)this.toConnectSchema((Schema)objectSchema.getPropertySchemas().get(KEY_FIELD)), (org.apache.kafka.connect.data.Schema)this.toConnectSchema((Schema)objectSchema.getPropertySchemas().get(VALUE_FIELD)));
            } else {
                builder = SchemaBuilder.array((org.apache.kafka.connect.data.Schema)this.toConnectSchema(itemsSchema));
            }
        } else if (jsonSchema instanceof ObjectSchema) {
            ObjectSchema objectSchema = (ObjectSchema)jsonSchema;
            type = (String)objectSchema.getUnprocessedProperties().get(CONNECT_TYPE_PROP);
            if (CONNECT_TYPE_MAP.equals(type)) {
                builder = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)this.toConnectSchema(objectSchema.getSchemaOfAdditionalProperties()));
            } else {
                builder = SchemaBuilder.struct();
                Map properties = objectSchema.getPropertySchemas();
                TreeMap<Integer, Map.Entry> sortedMap = new TreeMap<Integer, Map.Entry>();
                for (Map.Entry entry : properties.entrySet()) {
                    Schema subSchema = (Schema)entry.getValue();
                    Integer index = (Integer)subSchema.getUnprocessedProperties().get(CONNECT_INDEX_PROP);
                    if (index == null) {
                        index = sortedMap.size();
                    }
                    sortedMap.put(index, entry);
                }
                for (Map.Entry entry : sortedMap.values()) {
                    String subFieldName = (String)entry.getKey();
                    Schema subSchema = (Schema)entry.getValue();
                    builder.field(subFieldName, this.toConnectSchema(subSchema));
                }
            }
        } else {
            if (jsonSchema instanceof ReferenceSchema) {
                ReferenceSchema refSchema = (ReferenceSchema)jsonSchema;
                return this.toConnectSchema(refSchema.getReferredSchema(), version);
            }
            throw new DataException("Unsupported schema type " + jsonSchema.getClass().getName());
        }
        String title = jsonSchema.getTitle();
        if (title != null) {
            builder.name(title);
        }
        if ((connectVersion = (Integer)jsonSchema.getUnprocessedProperties().get(CONNECT_VERSION_PROP)) != null) {
            builder.version(connectVersion);
        } else if (version != null) {
            builder.version(version);
        }
        String description = jsonSchema.getDescription();
        if (description != null) {
            builder.doc(description);
        }
        if ((parameters = (Map)jsonSchema.getUnprocessedProperties().get(CONNECT_PARAMETERS_PROP)) != null) {
            builder.parameters(parameters);
        }
        if (jsonSchema.hasDefaultValue()) {
            JsonNode jsonNode = (JsonNode)OBJECT_MAPPER.convertValue(jsonSchema.getDefaultValue(), JsonNode.class);
            builder.defaultValue(JsonSchemaData.toConnectData((org.apache.kafka.connect.data.Schema)builder, jsonNode));
        }
        if (forceOptional) {
            builder.optional();
        }
        org.apache.kafka.connect.data.Schema result = builder.build();
        return result;
    }

    private org.apache.kafka.connect.data.Schema allOfToConnectSchema(CombinedSchema combinedSchema, Integer version, boolean forceOptional) {
        EnumSchema enumSchema = null;
        NumberSchema numberSchema = null;
        StringSchema stringSchema = null;
        for (Schema subSchema : combinedSchema.getSubschemas()) {
            if (subSchema instanceof EnumSchema) {
                enumSchema = (EnumSchema)subSchema;
                continue;
            }
            if (subSchema instanceof NumberSchema) {
                numberSchema = (NumberSchema)subSchema;
                continue;
            }
            if (!(subSchema instanceof StringSchema)) continue;
            stringSchema = (StringSchema)subSchema;
        }
        if (enumSchema != null && stringSchema != null) {
            return this.toConnectSchema((Schema)enumSchema, version, forceOptional);
        }
        if (numberSchema != null && stringSchema != null && stringSchema.getFormatValidator() != null) {
            return this.toConnectSchema((Schema)numberSchema, version, forceOptional);
        }
        throw new IllegalArgumentException("Unsupported criterion " + combinedSchema.getCriterion() + " for " + combinedSchema);
    }

    static {
        TO_CONNECT_CONVERTERS.put(Schema.Type.BOOLEAN, (schema, value) -> value.booleanValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT8, (schema, value) -> (byte)value.shortValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT16, (schema, value) -> value.shortValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT32, (schema, value) -> value.intValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT64, (schema, value) -> value.longValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.FLOAT32, (schema, value) -> Float.valueOf(value.floatValue()));
        TO_CONNECT_CONVERTERS.put(Schema.Type.FLOAT64, (schema, value) -> value.doubleValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.BYTES, (schema, value) -> {
            try {
                Object o = value.binaryValue();
                if (o == null) {
                    o = value.decimalValue();
                }
                return o;
            }
            catch (IOException e) {
                throw new DataException("Invalid bytes field", (Throwable)e);
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.STRING, (schema, value) -> value.textValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.ARRAY, (schema, value) -> {
            org.apache.kafka.connect.data.Schema elemSchema = schema == null ? null : schema.valueSchema();
            ArrayList<Object> result = new ArrayList<Object>();
            for (JsonNode elem : value) {
                result.add(JsonSchemaData.toConnectData(elemSchema, elem));
            }
            return result;
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.MAP, (schema, value) -> {
            org.apache.kafka.connect.data.Schema keySchema = schema == null ? null : schema.keySchema();
            org.apache.kafka.connect.data.Schema valueSchema = schema == null ? null : schema.valueSchema();
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            if (schema == null || keySchema.type() == Schema.Type.STRING && !keySchema.isOptional()) {
                if (!value.isObject()) {
                    throw new DataException("Maps with string fields should be encoded as JSON objects, but found " + value.getNodeType());
                }
                Iterator fieldIt = value.fields();
                while (fieldIt.hasNext()) {
                    Map.Entry entry = (Map.Entry)fieldIt.next();
                    result.put(entry.getKey(), JsonSchemaData.toConnectData(valueSchema, (JsonNode)entry.getValue()));
                }
            } else {
                if (!value.isArray()) {
                    throw new DataException("Maps with non-string fields should be encoded as JSON array of objects, but found " + value.getNodeType());
                }
                for (JsonNode entry : value) {
                    if (!entry.isObject()) {
                        throw new DataException("Found invalid map entry instead of object: " + entry.getNodeType());
                    }
                    if (entry.size() != 2) {
                        throw new DataException("Found invalid map entry, expected length 2 but found :" + entry.size());
                    }
                    result.put(JsonSchemaData.toConnectData(keySchema, entry.get(KEY_FIELD)), JsonSchemaData.toConnectData(valueSchema, entry.get(VALUE_FIELD)));
                }
            }
            return result;
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.STRUCT, (schema, value) -> {
            if (schema.name() != null && schema.name().equals(JSON_TYPE_ONE_OF)) {
                int index = 0;
                for (Field field : schema.fields()) {
                    org.apache.kafka.connect.data.Schema fieldSchema = field.schema();
                    if (JsonSchemaData.isInstanceOfSchemaTypeForSimpleSchema(fieldSchema, value)) {
                        return new Struct(schema.schema()).put("io.confluent.connect.json.OneOf.field." + index, JsonSchemaData.toConnectData(fieldSchema, value));
                    }
                    ++index;
                }
                throw new DataException("Did not find matching oneof field for data: " + value.toString());
            }
            if (!value.isObject()) {
                throw new DataException("Structs should be encoded as JSON objects, but found " + value.getNodeType());
            }
            Struct result = new Struct(schema.schema());
            for (Field field : schema.fields()) {
                result.put(field, JsonSchemaData.toConnectData(field.schema(), value.get(field.name())));
            }
            return result;
        });
        TO_CONNECT_LOGICAL_CONVERTERS = new HashMap();
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", (schema, value) -> {
            if (value.isNumber()) {
                return value.decimalValue();
            }
            if (value.isBinary() || value.isTextual()) {
                try {
                    return Decimal.toLogical((org.apache.kafka.connect.data.Schema)schema, (byte[])value.binaryValue());
                }
                catch (Exception e) {
                    throw new DataException("Invalid bytes for Decimal field", (Throwable)e);
                }
            }
            throw new DataException("Invalid type for Decimal, underlying representation should be numeric or bytes but was " + value.getNodeType());
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", (schema, value) -> {
            if (!value.isInt()) {
                throw new DataException("Invalid type for Date, underlying representation should be integer but was " + value.getNodeType());
            }
            return Date.toLogical((org.apache.kafka.connect.data.Schema)schema, (int)value.intValue());
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", (schema, value) -> {
            if (!value.isInt()) {
                throw new DataException("Invalid type for Time, underlying representation should be integer but was " + value.getNodeType());
            }
            return Time.toLogical((org.apache.kafka.connect.data.Schema)schema, (int)value.intValue());
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", (schema, value) -> {
            if (!value.isIntegralNumber()) {
                throw new DataException("Invalid type for Timestamp, underlying representation should be integral but was " + value.getNodeType());
            }
            return Timestamp.toLogical((org.apache.kafka.connect.data.Schema)schema, (long)value.longValue());
        });
        TO_JSON_LOGICAL_CONVERTERS = new HashMap();
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", (schema, value, config) -> {
            if (!(value instanceof BigDecimal)) {
                throw new DataException("Invalid type for Decimal, expected BigDecimal but was " + value.getClass());
            }
            BigDecimal decimal = (BigDecimal)value;
            switch (config.decimalFormat()) {
                case NUMERIC: {
                    return JSON_NODE_FACTORY.numberNode(decimal);
                }
                case BASE64: {
                    return JSON_NODE_FACTORY.binaryNode(Decimal.fromLogical((org.apache.kafka.connect.data.Schema)schema, (BigDecimal)decimal));
                }
            }
            throw new DataException("Unexpected decimal.format: " + config.decimalFormat());
        });
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", (schema, value, config) -> {
            if (!(value instanceof java.util.Date)) {
                throw new DataException("Invalid type for Date, expected Date but was " + value.getClass());
            }
            return JSON_NODE_FACTORY.numberNode(Date.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)value)));
        });
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", (schema, value, config) -> {
            if (!(value instanceof java.util.Date)) {
                throw new DataException("Invalid type for Time, expected Date but was " + value.getClass());
            }
            return JSON_NODE_FACTORY.numberNode(Time.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)value)));
        });
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", (schema, value, config) -> {
            if (!(value instanceof java.util.Date)) {
                throw new DataException("Invalid type for Timestamp, expected Date but was " + value.getClass());
            }
            return JSON_NODE_FACTORY.numberNode(Timestamp.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)value)));
        });
    }

    private static interface JsonToConnectLogicalTypeConverter {
        public Object convert(org.apache.kafka.connect.data.Schema var1, JsonNode var2);
    }

    private static interface ConnectToJsonLogicalTypeConverter {
        public JsonNode convert(org.apache.kafka.connect.data.Schema var1, Object var2, JsonSchemaDataConfig var3);
    }

    private static interface JsonToConnectTypeConverter {
        public Object convert(org.apache.kafka.connect.data.Schema var1, JsonNode var2);
    }
}

