/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ResourceLoader {
    public static final ResourceLoader DEFAULT = new ResourceLoader("/io/confluent/connect/json/");
    private final String rootPath;

    public ResourceLoader(String rootPath) {
        this.rootPath = Objects.requireNonNull(rootPath, "rootPath cannot be null");
    }

    public JSONObject readJSONObject(String relPath) {
        InputStream stream = this.getStream(relPath);
        return new JSONObject(new JSONTokener(stream));
    }

    public JsonNode readJsonNode(String relPath) throws IOException {
        InputStream stream = this.getStream(relPath);
        return new ObjectMapper().readTree(stream);
    }

    public InputStream getStream(String relPath) {
        String absPath = this.rootPath + relPath;
        InputStream rval = this.getClass().getResourceAsStream(absPath);
        if (rval == null) {
            throw new IllegalArgumentException(String.format("failed to load resource by relPath [%s].\nInputStream by path [%s] is null", relPath, absPath));
        }
        return rval;
    }
}

