/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.avro;

import com.connect.avro.EnumStringUnion;
import com.connect.avro.EnumUnion;
import com.connect.avro.UserType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import foo.bar.EnumTest;
import foo.bar.Kind;
import io.confluent.connect.avro.AvroData;
import io.confluent.connect.avro.AvroDataConfig;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.util.Utf8;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

public class AvroDataTest {
    private static final int TEST_SCALE = 2;
    private static final BigDecimal TEST_DECIMAL = new BigDecimal(new BigInteger("156"), 2);
    private static final byte[] TEST_DECIMAL_BYTES = new byte[]{0, -100};
    private static final GregorianCalendar EPOCH = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    private static final GregorianCalendar EPOCH_PLUS_TEN_THOUSAND_DAYS;
    private static final GregorianCalendar EPOCH_PLUS_TEN_THOUSAND_MILLIS;
    private static final org.apache.kafka.connect.data.Schema NAMED_MAP_SCHEMA;
    private static final Schema NAMED_AVRO_MAP_SCHEMA;
    private AvroData avroData = new AvroData(2);

    @Test
    public void testFromConnectBoolean() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().booleanType();
        this.checkNonRecordConversion(avroSchema, true, org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA, true, this.avroData);
        this.checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema.OPTIONAL_BOOLEAN_SCHEMA);
    }

    @Test
    public void testFromConnectByte() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.type", "int8");
        this.checkNonRecordConversion(avroSchema, 12, org.apache.kafka.connect.data.Schema.INT8_SCHEMA, (byte)12, this.avroData);
        this.checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema.OPTIONAL_INT8_SCHEMA);
    }

    @Test
    public void testFromConnectShort() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.type", "int16");
        this.checkNonRecordConversion(avroSchema, 12, org.apache.kafka.connect.data.Schema.INT16_SCHEMA, (short)12, this.avroData);
        this.checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema.OPTIONAL_INT16_SCHEMA);
    }

    @Test
    public void testFromConnectInteger() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        this.checkNonRecordConversion(avroSchema, 12, org.apache.kafka.connect.data.Schema.INT32_SCHEMA, 12, this.avroData);
        this.checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema.OPTIONAL_INT32_SCHEMA);
    }

    @Test
    public void testFromConnectLong() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        this.checkNonRecordConversion(avroSchema, 12L, org.apache.kafka.connect.data.Schema.INT64_SCHEMA, 12L, this.avroData);
        this.checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema.OPTIONAL_INT64_SCHEMA);
    }

    @Test
    public void testFromConnectFloat() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().floatType();
        this.checkNonRecordConversion(avroSchema, Float.valueOf(12.2f), org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA, Float.valueOf(12.2f), this.avroData);
        this.checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema.OPTIONAL_FLOAT32_SCHEMA);
    }

    @Test
    public void testFromConnectDouble() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().doubleType();
        this.checkNonRecordConversion(avroSchema, 12.2, org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA, 12.2, this.avroData);
        this.checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema.OPTIONAL_FLOAT64_SCHEMA);
    }

    @Test
    public void testFromConnectBytes() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().bytesType();
        this.checkNonRecordConversion(avroSchema, ByteBuffer.wrap("foo".getBytes()), org.apache.kafka.connect.data.Schema.BYTES_SCHEMA, "foo".getBytes(), this.avroData);
        this.checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema.OPTIONAL_BYTES_SCHEMA);
    }

    @Test
    public void testFromConnectString() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().stringType();
        this.checkNonRecordConversion(avroSchema, "string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA, "string", this.avroData);
        this.checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA);
    }

    @Test
    public void testFromConnectEnum() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("enhanced.avro.schema.support", (Object)true).build();
        AvroData avroData = new AvroData(avroDataConfig);
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().enumeration("enum").symbols(new String[]{"one", "two", "three"});
        GenericData.EnumSymbol avroObj = new GenericData.EnumSymbol(avroSchema, "one");
        ImmutableMap connectPropsMap = ImmutableMap.of((Object)"connect.enum.doc", (Object)"null", (Object)"io.confluent.connect.avro.Enum", (Object)"enum", (Object)"io.confluent.connect.avro.Enum.one", (Object)"one", (Object)"io.confluent.connect.avro.Enum.two", (Object)"two", (Object)"io.confluent.connect.avro.Enum.three", (Object)"three");
        avroSchema.addProp("connect.parameters", (Object)connectPropsMap);
        avroSchema.addProp("connect.name", "enum");
        SchemaAndValue schemaAndValue = avroData.toConnectData(avroSchema, (Object)avroObj);
        this.checkNonRecordConversion(avroSchema, avroObj, schemaAndValue.schema(), schemaAndValue.value(), avroData);
    }

    @Test
    public void testFromConnectEnumWithGeneralizedSumTypeSupport() {
        this.avroData = new AvroData(new AvroDataConfig.Builder().with("schemas.cache.config", (Object)2).with("generalized.sum.type.support", (Object)true).build());
        Schema avroSchema = (Schema)((SchemaBuilder.EnumBuilder)org.apache.avro.SchemaBuilder.builder().enumeration("TestEnum").doc("some documentation")).symbols(new String[]{"foo", "bar", "baz"});
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("io.confluent.connect.avro.enum.doc.TestEnum", "some documentation");
        params.put("org.apache.kafka.connect.data.Enum", "TestEnum");
        params.put("org.apache.kafka.connect.data.Enum.foo", "0");
        params.put("org.apache.kafka.connect.data.Enum.bar", "1");
        params.put("org.apache.kafka.connect.data.Enum.baz", "2");
        avroSchema.addProp("connect.parameters", params);
        avroSchema.addProp("connect.name", "TestEnum");
        SchemaBuilder builder = SchemaBuilder.string().name("TestEnum");
        builder.parameter("io.confluent.connect.avro.enum.doc.TestEnum", "some documentation");
        builder.parameter("org.apache.kafka.connect.data.Enum", "TestEnum");
        int i = 0;
        for (String enumSymbol : new String[]{"foo", "bar", "baz"}) {
            builder.parameter("org.apache.kafka.connect.data.Enum." + enumSymbol, String.valueOf(i++));
        }
        this.checkNonRecordConversion(avroSchema, new GenericData.EnumSymbol(avroSchema, "bar"), builder.build(), "bar", this.avroData);
    }

    @Test
    public void testFromConnectMapWithStringKey() {
        SchemaBuilder schema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA);
        Schema expected = (Schema)org.apache.avro.SchemaBuilder.map().values((Schema)org.apache.avro.SchemaBuilder.builder().intType());
        Assert.assertThat((Object)this.avroData.fromConnectSchema((org.apache.kafka.connect.data.Schema)schema), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testFromConnectMapWithOptionalKey() {
        SchemaBuilder schema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA);
        Schema expected = (Schema)org.apache.avro.SchemaBuilder.array().items((Schema)org.apache.avro.SchemaBuilder.record((String)"io.confluent.connect.avro.MapEntry").fields().optionalString("key").requiredInt("value").endRecord());
        Assert.assertThat((Object)this.avroData.fromConnectSchema((org.apache.kafka.connect.data.Schema)schema), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testFromConnectMapWithAllowOptionalKey() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("allow.optional.map.keys", (Object)true).build();
        AvroData avroData = new AvroData(avroDataConfig);
        SchemaBuilder schema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA);
        Schema expected = (Schema)org.apache.avro.SchemaBuilder.map().values((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.unionOf().nullType()).and().stringType()).endUnion());
        Assert.assertThat((Object)avroData.fromConnectSchema((org.apache.kafka.connect.data.Schema)schema), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testFromConnectMapWithNonStringKey() {
        SchemaBuilder schema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA);
        Schema expected = (Schema)org.apache.avro.SchemaBuilder.array().items((Schema)org.apache.avro.SchemaBuilder.record((String)"io.confluent.connect.avro.MapEntry").fields().requiredInt("key").requiredInt("value").endRecord());
        Assert.assertThat((Object)this.avroData.fromConnectSchema((org.apache.kafka.connect.data.Schema)schema), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testFromNamedConnectMapWithNonStringKey() {
        Assert.assertThat((Object)this.avroData.fromConnectSchema(NAMED_MAP_SCHEMA), (Matcher)CoreMatchers.equalTo((Object)NAMED_AVRO_MAP_SCHEMA));
    }

    @Test
    public void testFromConnectBytesFixed() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("sample").size(4);
        GenericData.Fixed avroObj = new GenericData.Fixed(avroSchema, "foob".getBytes());
        avroSchema.addProp("connect.parameters", (Object)ImmutableMap.of((Object)"connect.fixed.size", (Object)"4"));
        avroSchema.addProp("connect.name", "sample");
        SchemaAndValue schemaAndValue = this.avroData.toConnectData(avroSchema, (Object)avroObj);
        this.checkNonRecordConversion(avroSchema, avroObj, schemaAndValue.schema(), schemaAndValue.value(), this.avroData);
    }

    @Test
    public void testFromConnectFixedUnion() {
        Schema sampleSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("sample").size(4);
        Schema otherSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("other").size(6);
        Schema sameOtherSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("sameOther").size(6);
        Schema unionSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(sampleSchema)).and().type(otherSchema)).and().type(sameOtherSchema)).endUnion();
        org.apache.kafka.connect.data.Schema union = SchemaBuilder.struct().name("io.confluent.connect.avro.Union").field("sample", SchemaBuilder.bytes().name("sample").parameter("connect.fixed.size", "4").optional().build()).field("other", SchemaBuilder.bytes().name("other").parameter("connect.fixed.size", "6").optional().build()).field("sameOther", SchemaBuilder.bytes().name("sameOther").parameter("connect.fixed.size", "6").optional().build()).build();
        Struct unionSample = new Struct(union).put("sample", (Object)ByteBuffer.wrap("foob".getBytes()));
        Struct unionOther = new Struct(union).put("other", (Object)ByteBuffer.wrap("foobar".getBytes()));
        Struct unionSameOther = new Struct(union).put("sameOther", (Object)ByteBuffer.wrap("foobar".getBytes()));
        GenericData genericData = GenericData.get();
        Assert.assertEquals((long)0L, (long)genericData.resolveUnion(unionSchema, this.avroData.fromConnectData(union, (Object)unionSample)));
        Assert.assertEquals((long)1L, (long)genericData.resolveUnion(unionSchema, this.avroData.fromConnectData(union, (Object)unionOther)));
        Assert.assertEquals((long)2L, (long)genericData.resolveUnion(unionSchema, this.avroData.fromConnectData(union, (Object)unionSameOther)));
    }

    @Test
    public void testFromConnectUnionWithGeneralizedSumTypeSupport() {
        this.avroData = new AvroData(new AvroDataConfig.Builder().with("schemas.cache.config", (Object)2).with("generalized.sum.type.support", (Object)true).build());
        Schema avroRecordSchema1 = (Schema)org.apache.avro.SchemaBuilder.builder().record("Test1").fields().requiredInt("test").endRecord();
        avroRecordSchema1.addProp("connect.name", "Test1");
        Schema avroRecordSchema2 = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("Test2").namespace("io.confluent")).fields().requiredInt("test").endRecord();
        avroRecordSchema2.addProp("connect.name", "io.confluent.Test2");
        Schema avroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().intType()).and().stringType()).and().type(avroRecordSchema1)).and().type(avroRecordSchema2)).endUnion();
        org.apache.kafka.connect.data.Schema recordSchema1 = SchemaBuilder.struct().name("Test1").field("test", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema recordSchema2 = SchemaBuilder.struct().name("io.confluent.Test2").field("test", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("connect_union_0").parameter("org.apache.kafka.connect.data.Union", "connect_union_0").field("connect_union_field_0", org.apache.kafka.connect.data.Schema.OPTIONAL_INT32_SCHEMA).field("connect_union_field_1", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).field("connect_union_field_2", recordSchema1).field("connect_union_field_3", recordSchema2).build();
        Assert.assertEquals((Object)12, (Object)this.avroData.fromConnectData(schema, (Object)new Struct(schema).put("connect_union_field_0", (Object)12)));
        Assert.assertEquals((Object)"teststring", (Object)this.avroData.fromConnectData(schema, (Object)new Struct(schema).put("connect_union_field_1", (Object)"teststring")));
        Struct schema1Test = new Struct(schema).put("connect_union_field_2", (Object)new Struct(recordSchema1).put("test", (Object)12));
        GenericData.Record record1Test = new GenericRecordBuilder(avroRecordSchema1).set("test", (Object)12).build();
        Struct schema2Test = new Struct(schema).put("connect_union_field_3", (Object)new Struct(recordSchema2).put("test", (Object)12));
        GenericData.Record record2Test = new GenericRecordBuilder(avroRecordSchema2).set("test", (Object)12).build();
        Assert.assertEquals((Object)record1Test, (Object)this.avroData.fromConnectData(schema, (Object)schema1Test));
        Assert.assertEquals((Object)record2Test, (Object)this.avroData.fromConnectData(schema, (Object)schema2Test));
    }

    @Test
    public void testFromConnectWithInvalidName() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("scrub.invalid.names", (Object)true).with("connect.meta.data", (Object)false).build();
        AvroData avroData = new AvroData(avroDataConfig);
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("org.acme.invalid record-name").field("invalid field-name", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(schema);
        struct.put("invalid field-name", (Object)"foo");
        Schema expectedSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)"invalid_record_name").namespace("org.acme")).fields().requiredString("invalid_field_name").endRecord();
        Schema avroSchema = avroData.fromConnectSchema(schema);
        GenericRecord convertedRecord = (GenericRecord)avroData.fromConnectData(schema, (Object)struct);
        Assert.assertEquals((Object)"invalid_record_name", (Object)avroSchema.getName());
        Assert.assertEquals((Object)"invalid_field_name", (Object)((Schema.Field)avroSchema.getFields().get(0)).name());
        Assert.assertEquals((Object)"invalid_record_name", (Object)convertedRecord.getSchema().getName());
        Assert.assertEquals((Object)"invalid_field_name", (Object)((Schema.Field)convertedRecord.getSchema().getFields().get(0)).name());
        Assert.assertEquals((Object)"foo", (Object)convertedRecord.get("invalid_field_name"));
    }

    @Test
    public void testFromConnectOptionalRecordWithInvalidName() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("scrub.invalid.names", (Object)true).with("connect.meta.data", (Object)false).build();
        AvroData avroData = new AvroData(avroDataConfig);
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("invalid record-name").optional().field("invalid field-name", SchemaBuilder.bool().optional().defaultValue(null).build()).build();
        Schema avroSchema = avroData.fromConnectSchema(schema);
        Schema recordSchema = (Schema)org.apache.avro.SchemaBuilder.builder().record("invalid_record_name").fields().name("invalid_field_name").type((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().booleanType()).endUnion()).withDefault(null).endRecord();
        Schema expectedAvroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().record("invalid_record_name").fields().name("invalid_field_name").type((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().booleanType()).endUnion()).withDefault(null).endRecord()).endUnion();
        Assert.assertEquals((Object)expectedAvroSchema, (Object)avroSchema);
        Struct struct = new Struct(schema).put("invalid field-name", (Object)true);
        Object convertedRecord = avroData.fromConnectData(schema, (Object)struct);
        GenericData.Record avroRecord = new GenericRecordBuilder(recordSchema).set("invalid_field_name", (Object)true).build();
        Assert.assertEquals((Object)avroRecord, (Object)convertedRecord);
    }

    @Test
    public void testFromConnectOptionalRecordWithNullName() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("scrub.invalid.names", (Object)true).with("connect.meta.data", (Object)false).build();
        AvroData avroData = new AvroData(avroDataConfig);
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().optional().field("invalid field-name", SchemaBuilder.bool().optional().defaultValue(null).build()).build();
        Schema avroSchema = avroData.fromConnectSchema(schema);
        Schema recordSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("ConnectDefault").namespace("io.confluent.connect.avro")).fields().name("invalid_field_name").type((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().booleanType()).endUnion()).withDefault(null).endRecord();
        Schema expectedAvroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.RecordBuilder)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().record("ConnectDefault").namespace("io.confluent.connect.avro")).fields().name("invalid_field_name").type((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().booleanType()).endUnion()).withDefault(null).endRecord()).endUnion();
        Assert.assertEquals((Object)expectedAvroSchema, (Object)avroSchema);
        Struct struct = new Struct(schema).put("invalid field-name", (Object)true);
        Object convertedRecord = avroData.fromConnectData(schema, (Object)struct);
        GenericData.Record avroRecord = new GenericRecordBuilder(recordSchema).set("invalid_field_name", (Object)true).build();
        Assert.assertEquals((Object)avroRecord, (Object)convertedRecord);
    }

    @Test
    public void testNameScrubbing() {
        Assert.assertEquals(null, (Object)AvroData.doScrubName(null));
        Assert.assertEquals((Object)"", (Object)AvroData.doScrubName((String)""));
        Assert.assertEquals((Object)"abc_DEF_123", (Object)AvroData.doScrubName((String)"abc_DEF_123"));
        Assert.assertEquals((Object)"abc_2B____", (Object)AvroData.doScrubName((String)"abc+-.*_"));
        Assert.assertEquals((Object)"abc_def", (Object)AvroData.doScrubName((String)"abc-def"));
        Assert.assertEquals((Object)"abc_2Bdef", (Object)AvroData.doScrubName((String)"abc+def"));
        Assert.assertEquals((Object)"abc__def", (Object)AvroData.doScrubName((String)"abc  def"));
        Assert.assertEquals((Object)"abc_def", (Object)AvroData.doScrubName((String)"abc.def"));
        Assert.assertEquals((Object)"x0abc_def", (Object)AvroData.doScrubName((String)"0abc.def"));
        Assert.assertEquals((Object)"x0abc", (Object)AvroData.doScrubName((String)"0abc"));
    }

    @Test
    public void testFromConnectComplex() {
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().field("int8", SchemaBuilder.int8().defaultValue((Object)2).doc("int8 field").build()).field("int16", org.apache.kafka.connect.data.Schema.INT16_SCHEMA).field("int32", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).field("int64", org.apache.kafka.connect.data.Schema.INT64_SCHEMA).field("float32", org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA).field("float64", org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA).field("boolean", org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).field("bytes", org.apache.kafka.connect.data.Schema.BYTES_SCHEMA).field("array", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build()).field("map", SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build()).field("mapNonStringKeys", SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build()).build();
        Struct struct = new Struct(schema).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)ByteBuffer.wrap("foo".getBytes())).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1)).put("mapNonStringKeys", Collections.singletonMap(1, 1));
        Object convertedRecord = this.avroData.fromConnectData(schema, (Object)struct);
        Schema complexMapElementSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)"MapEntry").namespace("io.confluent.connect.avro")).fields().requiredInt("key").requiredInt("value").endRecord();
        Schema int8Schema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        int8Schema.addProp("connect.doc", "int8 field");
        int8Schema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode(2));
        int8Schema.addProp("connect.type", "int8");
        Schema int16Schema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        int16Schema.addProp("connect.type", "int16");
        Schema avroSchema = (Schema)((SchemaBuilder.ArrayDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)"ConnectDefault").namespace("io.confluent.connect.avro")).fields().name("int8").type(int8Schema).withDefault((Object)2).name("int16").type(int16Schema).noDefault().requiredInt("int32").requiredLong("int64").requiredFloat("float32").requiredDouble("float64").requiredBoolean("boolean").requiredString("string").requiredBytes("bytes").name("array").type().array().items().stringType()).noDefault().name("map").type().map().values().intType()).noDefault().name("mapNonStringKeys").type().array().items(complexMapElementSchema)).noDefault().endRecord();
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("int8", (Object)12).set("int16", (Object)12).set("int32", (Object)12).set("int64", (Object)12L).set("float32", (Object)Float.valueOf(12.2f)).set("float64", (Object)12.2).set("boolean", (Object)true).set("string", (Object)"foo").set("bytes", (Object)ByteBuffer.wrap("foo".getBytes())).set("array", Arrays.asList("a", "b", "c")).set("map", Collections.singletonMap("field", 1)).set("mapNonStringKeys", Arrays.asList(new GenericRecordBuilder(complexMapElementSchema).set("key", (Object)1).set("value", (Object)1).build())).build();
        Assert.assertEquals((Object)avroSchema, (Object)((GenericRecord)convertedRecord).getSchema());
        Assert.assertEquals((Object)avroRecord, (Object)convertedRecord);
    }

    @Test
    public void testFromConnectComplexWithDefaultStructContainingNulls() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().field("int8", SchemaBuilder.int8().optional().doc("int8 field").build()).field("int16", SchemaBuilder.int16().optional().doc("int16 field").build()).field("int32", SchemaBuilder.int32().optional().doc("int32 field").build()).field("int64", SchemaBuilder.int64().optional().doc("int64 field").build()).field("float32", SchemaBuilder.float32().optional().doc("float32 field").build()).field("float64", SchemaBuilder.float64().optional().doc("float64 field").build()).field("boolean", SchemaBuilder.bool().optional().doc("bool field").build()).field("string", SchemaBuilder.string().optional().doc("string field").build()).field("bytes", SchemaBuilder.bytes().optional().doc("bytes field").build()).field("array", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA).optional().build()).field("map", SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build()).field("date", Date.builder().doc("date field").optional().build()).field("time", Time.builder().doc("time field").optional().build()).field("ts", Timestamp.builder().doc("ts field").optional().build()).field("decimal", Decimal.builder((int)5).doc("decimal field").optional().build());
        Struct defaultValue = new Struct((org.apache.kafka.connect.data.Schema)schemaBuilder);
        defaultValue.put("int8", (Object)2);
        org.apache.kafka.connect.data.Schema schema2 = schemaBuilder.defaultValue((Object)defaultValue).build();
        Schema avroSchema = this.avroData.fromConnectSchema(schema2);
        Assert.assertNotNull((Object)avroSchema);
    }

    @Test
    public void testFromConnectComplexWithDefaults() {
        int dateDefVal = 100;
        int timeDefVal = 0x6DDD00;
        long tsDefVal = 1471229028L;
        java.util.Date dateDef = Date.toLogical((org.apache.kafka.connect.data.Schema)Date.SCHEMA, (int)dateDefVal);
        java.util.Date timeDef = Time.toLogical((org.apache.kafka.connect.data.Schema)Time.SCHEMA, (int)timeDefVal);
        java.util.Date tsDef = Timestamp.toLogical((org.apache.kafka.connect.data.Schema)Timestamp.SCHEMA, (long)tsDefVal);
        BigDecimal decimalDef = new BigDecimal(BigInteger.valueOf(314159L), 5);
        byte[] decimalDefVal = decimalDef.unscaledValue().toByteArray();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().field("int8", SchemaBuilder.int8().defaultValue((Object)2).doc("int8 field").build()).field("int16", SchemaBuilder.int16().defaultValue((Object)12).doc("int16 field").build()).field("int32", SchemaBuilder.int32().defaultValue((Object)12).doc("int32 field").build()).field("int64", SchemaBuilder.int64().defaultValue((Object)12L).doc("int64 field").build()).field("float32", SchemaBuilder.float32().defaultValue((Object)Float.valueOf(12.2f)).doc("float32 field").build()).field("float64", SchemaBuilder.float64().defaultValue((Object)12.2).doc("float64 field").build()).field("boolean", SchemaBuilder.bool().defaultValue((Object)true).doc("bool field").build()).field("string", SchemaBuilder.string().defaultValue((Object)"foo").doc("string field").build()).field("bytes", SchemaBuilder.bytes().defaultValue((Object)ByteBuffer.wrap("foo".getBytes())).doc("bytes field").build()).field("array", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA).defaultValue(Arrays.asList("a", "b", "c")).build()).field("map", SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).defaultValue(Collections.singletonMap("field", 1)).build()).field("date", Date.builder().defaultValue((Object)dateDef).doc("date field").build()).field("time", Time.builder().defaultValue((Object)timeDef).doc("time field").build()).field("ts", Timestamp.builder().defaultValue((Object)tsDef).doc("ts field").build()).field("decimal", Decimal.builder((int)5).defaultValue((Object)decimalDef).doc("decimal field").build()).build();
        Struct struct = new Struct(schema).put("int8", (Object)2).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)ByteBuffer.wrap("foo".getBytes())).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1)).put("date", (Object)dateDef).put("time", (Object)timeDef).put("ts", (Object)tsDef).put("decimal", (Object)decimalDef);
        Schema complexMapElementSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)"MapEntry").namespace("io.confluent.connect.avro")).fields().requiredInt("key").requiredInt("value").endRecord();
        Schema int8Schema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        int8Schema.addProp("connect.doc", "int8 field");
        int8Schema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode(2));
        int8Schema.addProp("connect.type", "int8");
        Schema int16Schema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        int16Schema.addProp("connect.doc", "int16 field");
        int16Schema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode((short)12).intValue());
        int16Schema.addProp("connect.type", "int16");
        Schema int32Schema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        int32Schema.addProp("connect.doc", "int32 field");
        int32Schema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode(12));
        Schema int64Schema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        int64Schema.addProp("connect.doc", "int64 field");
        int64Schema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode(12L));
        Schema float32Schema = (Schema)org.apache.avro.SchemaBuilder.builder().floatType();
        float32Schema.addProp("connect.doc", "float32 field");
        float32Schema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode(12.2f));
        Schema float64Schema = (Schema)org.apache.avro.SchemaBuilder.builder().doubleType();
        float64Schema.addProp("connect.doc", "float64 field");
        float64Schema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode(12.2));
        Schema boolSchema = (Schema)org.apache.avro.SchemaBuilder.builder().booleanType();
        boolSchema.addProp("connect.doc", "bool field");
        boolSchema.addProp("connect.default", (Object)JsonNodeFactory.instance.booleanNode(true));
        Schema stringSchema = (Schema)org.apache.avro.SchemaBuilder.builder().stringType();
        stringSchema.addProp("connect.doc", "string field");
        stringSchema.addProp("connect.default", (Object)JsonNodeFactory.instance.textNode("foo"));
        Schema bytesSchema = (Schema)org.apache.avro.SchemaBuilder.builder().bytesType();
        bytesSchema.addProp("connect.doc", "bytes field");
        bytesSchema.addProp("connect.default", (Object)JsonNodeFactory.instance.textNode(new String("foo".getBytes(), StandardCharsets.ISO_8859_1)));
        Schema dateSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        dateSchema.addProp("connect.doc", "date field");
        dateSchema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode(dateDefVal));
        dateSchema.addProp("connect.name", "org.apache.kafka.connect.data.Date");
        dateSchema.addProp("connect.version", (Object)1);
        LogicalTypes.date().addToSchema(dateSchema);
        dateSchema.addProp("logicalType", "date");
        Schema timeSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        timeSchema.addProp("connect.doc", "time field");
        timeSchema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode(timeDefVal));
        timeSchema.addProp("connect.name", "org.apache.kafka.connect.data.Time");
        timeSchema.addProp("connect.version", (Object)1);
        LogicalTypes.timeMillis().addToSchema(timeSchema);
        timeSchema.addProp("logicalType", "time-millis");
        Schema tsSchema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        tsSchema.addProp("connect.doc", "ts field");
        tsSchema.addProp("connect.default", (Object)JsonNodeFactory.instance.numberNode(tsDefVal));
        tsSchema.addProp("connect.name", "org.apache.kafka.connect.data.Timestamp");
        tsSchema.addProp("connect.version", (Object)1);
        LogicalTypes.timestampMillis().addToSchema(tsSchema);
        tsSchema.addProp("logicalType", "timestamp-millis");
        Schema decimalSchema = (Schema)org.apache.avro.SchemaBuilder.builder().bytesType();
        decimalSchema.addProp("scale", (Object)5);
        decimalSchema.addProp("precision", (Object)64);
        decimalSchema.addProp("connect.doc", "decimal field");
        decimalSchema.addProp("connect.version", (Object)1);
        decimalSchema.addProp("connect.default", (Object)JsonNodeFactory.instance.textNode(new String(decimalDefVal, StandardCharsets.ISO_8859_1)));
        decimalSchema.addProp("connect.parameters", (Object)this.parameters("scale", "5"));
        decimalSchema.addProp("connect.name", "org.apache.kafka.connect.data.Decimal");
        LogicalTypes.decimal((int)64, (int)5).addToSchema(decimalSchema);
        decimalSchema.addProp("logicalType", "decimal");
        Schema arraySchema = (Schema)org.apache.avro.SchemaBuilder.builder().array().items().stringType();
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        arrayNode.add("a");
        arrayNode.add("b");
        arrayNode.add("c");
        arraySchema.addProp("connect.default", (Object)arrayNode);
        Schema mapSchema = (Schema)org.apache.avro.SchemaBuilder.builder().map().values().intType();
        ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
        mapNode.put("field", 1);
        mapSchema.addProp("connect.default", (Object)mapNode);
        Schema nonStringMapSchema = (Schema)org.apache.avro.SchemaBuilder.builder().array().items(complexMapElementSchema);
        ArrayNode nonStringMapNode = JsonNodeFactory.instance.arrayNode();
        nonStringMapNode.add((JsonNode)JsonNodeFactory.instance.numberNode(1));
        nonStringMapNode.add((JsonNode)JsonNodeFactory.instance.numberNode(1));
        ArrayNode nonStringMapArrayNode = JsonNodeFactory.instance.arrayNode();
        nonStringMapArrayNode.add((JsonNode)nonStringMapNode);
        nonStringMapSchema.addProp("connect.default", (Object)nonStringMapArrayNode);
        Schema avroSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)"ConnectDefault").namespace("io.confluent.connect.avro")).fields().name("int8").type(int8Schema).withDefault((Object)2).name("int16").type(int16Schema).withDefault((Object)12).name("int32").type(int32Schema).withDefault((Object)12).name("int64").type(int64Schema).withDefault((Object)12L).name("float32").type(float32Schema).withDefault((Object)Float.valueOf(12.2f)).name("float64").type(float64Schema).withDefault((Object)12.2).name("boolean").type(boolSchema).withDefault((Object)true).name("string").type(stringSchema).withDefault((Object)"foo").name("bytes").type(bytesSchema).withDefault((Object)ByteBuffer.wrap("foo".getBytes())).name("array").type(arraySchema).withDefault(Arrays.asList("a", "b", "c")).name("map").type(mapSchema).withDefault(Collections.singletonMap("field", 1)).name("date").type(dateSchema).withDefault((Object)dateDefVal).name("time").type(timeSchema).withDefault((Object)timeDefVal).name("ts").type(tsSchema).withDefault((Object)tsDefVal).name("decimal").type(decimalSchema).withDefault((Object)ByteBuffer.wrap(decimalDefVal)).endRecord();
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("int8", (Object)2).set("int16", (Object)12).set("int32", (Object)12).set("int64", (Object)12L).set("float32", (Object)Float.valueOf(12.2f)).set("float64", (Object)12.2).set("boolean", (Object)true).set("string", (Object)"foo").set("bytes", (Object)ByteBuffer.wrap("foo".getBytes())).set("array", Arrays.asList("a", "b", "c")).set("map", Collections.singletonMap("field", 1)).set("date", (Object)dateDefVal).set("time", (Object)timeDefVal).set("ts", (Object)tsDefVal).set("decimal", (Object)decimalDefVal).build();
        SchemaAndValue schemaAndValue = new SchemaAndValue(schema, (Object)struct);
        schemaAndValue = this.convertToConnect(avroSchema, (GenericRecord)avroRecord, schemaAndValue);
        schemaAndValue = this.convertToConnect(avroSchema, (GenericRecord)avroRecord, schemaAndValue);
        schemaAndValue = this.convertToConnect(avroSchema, (GenericRecord)avroRecord, schemaAndValue);
        Assert.assertNotNull((Object)schemaAndValue);
    }

    @Test
    public void testFromConnectOptionalAndNonOptionalStruct() {
        org.apache.kafka.connect.data.Schema innerSchema = SchemaBuilder.struct().name("inner").field("value", org.apache.kafka.connect.data.Schema.INT64_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema outerSchema = SchemaBuilder.struct().name("outer").field("struct", innerSchema).field("array", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)innerSchema).build()).build();
        Struct innerStruct = new Struct(innerSchema).put("value", (Object)46421L);
        Struct outerStruct = new Struct(outerSchema).put("struct", (Object)innerStruct).put("array", Collections.singletonList(innerStruct));
        Schema int64Schema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        Schema recordSchema = (Schema)org.apache.avro.SchemaBuilder.builder().record("inner").fields().name("value").type(int64Schema).noDefault().endRecord();
        recordSchema.addProp("connect.name", "inner");
        Schema unionSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().type(recordSchema)).endUnion();
        Schema arraySchema = (Schema)org.apache.avro.SchemaBuilder.builder().array().items(unionSchema);
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.record((String)"outer").fields().name("struct").type(unionSchema).withDefault(null).name("array").type(arraySchema).noDefault().endRecord();
        avroSchema.addProp("connect.name", "outer");
        GenericData.Record innerRecord = new GenericRecordBuilder(recordSchema).set("value", (Object)46421L).build();
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("struct", (Object)innerRecord).set("array", Collections.singletonList(innerRecord)).build();
        SchemaAndValue schemaAndValue = new SchemaAndValue(outerSchema, (Object)outerStruct);
        schemaAndValue = this.convertToConnect(avroSchema, (GenericRecord)avroRecord, schemaAndValue);
        Assert.assertNotNull((Object)schemaAndValue);
    }

    @Test
    public void testFromConnectStructsWithNullName() {
        org.apache.kafka.connect.data.Schema innerSchema = SchemaBuilder.struct().field("value", org.apache.kafka.connect.data.Schema.INT64_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema outerSchema = SchemaBuilder.struct().field("struct", innerSchema).field("array", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)innerSchema).build()).build();
        Struct innerStruct = new Struct(innerSchema).put("value", (Object)46421L);
        Struct outerStruct = new Struct(outerSchema).put("struct", (Object)innerStruct).put("array", Collections.singletonList(innerStruct));
        Schema int64Schema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        Schema recordSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("ConnectDefault2").namespace("io.confluent.connect.avro")).fields().name("value").type(int64Schema).noDefault().endRecord();
        Schema unionSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().type(recordSchema)).endUnion();
        Schema arraySchema = (Schema)org.apache.avro.SchemaBuilder.builder().array().items(unionSchema);
        Schema avroSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)"ConnectDefault").namespace("io.confluent.connect.avro")).fields().name("struct").type(unionSchema).withDefault(null).name("array").type(arraySchema).noDefault().endRecord();
        GenericData.Record innerRecord = new GenericRecordBuilder(recordSchema).set("value", (Object)46421L).build();
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("struct", (Object)innerRecord).set("array", Collections.singletonList(innerRecord)).build();
        SchemaAndValue schemaAndValue = new SchemaAndValue(outerSchema, (Object)outerStruct);
        schemaAndValue = this.convertToConnect(avroSchema, (GenericRecord)avroRecord, schemaAndValue);
        Assert.assertNotNull((Object)schemaAndValue);
    }

    protected SchemaAndValue convertToConnect(Schema expectedAvroSchema, GenericRecord expectedAvroRecord, SchemaAndValue connectSchemaAndValue) {
        Schema avroSchema = this.avroData.fromConnectSchema(connectSchemaAndValue.schema());
        Assert.assertEquals((Object)avroSchema.toString(), (Object)new AvroSchema(avroSchema.toString()).toString());
        Object convertedRecord = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        GenericRecord convertedAvroRecord = (GenericRecord)convertedRecord;
        this.assertSchemaEquals(expectedAvroSchema, convertedAvroRecord.getSchema());
        this.assertSchemaEquals(expectedAvroRecord.getSchema(), convertedAvroRecord.getSchema());
        for (Schema.Field field : expectedAvroSchema.getFields()) {
            Object actual = convertedAvroRecord.get(field.name());
            Object expected = expectedAvroRecord.get(field.name());
            this.assertValueEquals(expected, actual);
        }
        SchemaAndValue schemaAndValue = this.avroData.toConnectData(convertedAvroRecord.getSchema(), convertedRecord);
        Assert.assertEquals((Object)connectSchemaAndValue.schema(), (Object)schemaAndValue.schema());
        Assert.assertEquals((Object)connectSchemaAndValue.value(), (Object)schemaAndValue.value());
        return schemaAndValue;
    }

    @Test
    public void testFromConnectOptionalWithDefaultNull() {
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().field("optionalBool", SchemaBuilder.bool().optional().defaultValue(null).build()).build();
        Schema avroSchema = this.avroData.fromConnectSchema(schema);
        Schema expectedAvroSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("ConnectDefault").namespace("io.confluent.connect.avro")).fields().name("optionalBool").type((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().booleanType()).endUnion()).withDefault(null).endRecord();
        Assert.assertEquals((Object)expectedAvroSchema, (Object)avroSchema);
        Struct struct = new Struct(schema).put("optionalBool", (Object)true);
        Object convertedRecord = this.avroData.fromConnectData(schema, (Object)struct);
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("optionalBool", (Object)true).build();
        Assert.assertEquals((Object)avroRecord, (Object)convertedRecord);
    }

    @Test
    public void testFromConnectOptionalWithInvalidDefault() {
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().field("array", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)SchemaBuilder.string().optional().build()).defaultValue(Arrays.asList("a", "b", "c")).build()).build();
        Schema avroSchema = this.avroData.fromConnectSchema(schema);
        Schema arraySchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().array().items().unionOf().nullType()).and().stringType()).endUnion();
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        arrayNode.add("a");
        arrayNode.add("b");
        arrayNode.add("c");
        arraySchema.addProp("connect.default", (Object)arrayNode);
        Schema expectedAvroSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("ConnectDefault").namespace("io.confluent.connect.avro")).fields().name("array").type(arraySchema).noDefault().endRecord();
        Assert.assertEquals((Object)expectedAvroSchema, (Object)avroSchema);
        Struct struct = new Struct(schema).put("array", Arrays.asList("a", "b", "c"));
        Object convertedRecord = this.avroData.fromConnectData(schema, (Object)struct);
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("array", Arrays.asList("a", "b", "c")).build();
        Assert.assertEquals((Object)avroRecord, (Object)convertedRecord);
    }

    @Test
    public void testFromConnectOptionalAnonymousStruct() {
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().optional().field("int32", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build();
        Struct struct = new Struct(schema).put("int32", (Object)12);
        Object convertedRecord = this.avroData.fromConnectData(schema, (Object)struct);
        Assert.assertThat((Object)convertedRecord, (Matcher)CoreMatchers.instanceOf(GenericRecord.class));
        Assert.assertThat((Object)((GenericRecord)convertedRecord).get("int32"), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void testFromConnectStructIgnoreDefaultForNullables() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("ignore.default.for.nullables", (Object)true).build();
        AvroData avroData = new AvroData(avroDataConfig);
        org.apache.kafka.connect.data.Schema connectStringSchema = SchemaBuilder.string().optional().defaultValue((Object)"default-string").build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("Record").field("int32", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).field("string", connectStringSchema).build();
        Struct struct = new Struct(schema).put("int32", (Object)12);
        Object convertedRecord = avroData.fromConnectData(schema, (Object)struct);
        Assert.assertThat((Object)convertedRecord, (Matcher)CoreMatchers.instanceOf(GenericRecord.class));
        Assert.assertThat((Object)((GenericRecord)convertedRecord).get("int32"), (Matcher)CoreMatchers.equalTo((Object)12));
        Assert.assertNull((Object)((GenericRecord)convertedRecord).get("string"));
    }

    @Test
    public void testFromConnectOptionalComplex() {
        org.apache.kafka.connect.data.Schema optionalStructSchema = SchemaBuilder.struct().optional().name("optionalStruct").field("int32", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().field("int32", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).field("optionalStruct", optionalStructSchema).field("optionalArray", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build()).field("optionalMap", SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build()).field("optionalMapNonStringKeys", SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build()).build();
        Struct struct = new Struct(schema).put("int32", (Object)12).put("optionalStruct", (Object)new Struct(optionalStructSchema).put("int32", (Object)12)).put("optionalArray", Arrays.asList(12, 13)).put("optionalMap", Collections.singletonMap("field", 12)).put("optionalMapNonStringKeys", Collections.singletonMap(123, 12));
        Object convertedRecord = this.avroData.fromConnectData(schema, (Object)struct);
        Schema structAvroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().record("optionalStruct").fields().requiredInt("int32").endRecord();
        Schema mapNonStringKeysAvroSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("MapEntry").namespace("io.confluent.connect.avro")).fields().requiredInt("key").requiredInt("value").endRecord();
        Schema avroSchema = this.avroData.fromConnectSchema(schema);
        GenericData.Record avroStruct = new GenericRecordBuilder(structAvroSchema).set("int32", (Object)12).build();
        GenericData.Record mapNonStringKeysAvroStruct = new GenericRecordBuilder(mapNonStringKeysAvroSchema).set("key", (Object)123).set("value", (Object)12).build();
        ArrayList<GenericData.Record> mapNonStringKeys = new ArrayList<GenericData.Record>();
        mapNonStringKeys.add(mapNonStringKeysAvroStruct);
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("int32", (Object)12).set("optionalStruct", (Object)avroStruct).set("optionalArray", Arrays.asList(12, 13)).set("optionalMap", Collections.singletonMap("field", 12)).set("optionalMapNonStringKeys", mapNonStringKeys).build();
        Assert.assertEquals((Object)avroRecord, (Object)convertedRecord);
        struct = new Struct(schema).put("int32", (Object)12).put("optionalStruct", null).put("optionalArray", null).put("optionalMap", null).put("optionalMapNonStringKeys", null);
        convertedRecord = this.avroData.fromConnectData(schema, (Object)struct);
        avroRecord = new GenericRecordBuilder(avroSchema).set("int32", (Object)12).set("optionalStruct", null).set("optionalArray", null).set("optionalMap", null).set("optionalMapNonStringKeys", null).build();
        Assert.assertEquals((Object)avroRecord, (Object)convertedRecord);
    }

    @Test
    public void testFromConnectOptionalPrimitiveWithMetadata() {
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.string().doc("doc").defaultValue((Object)"foo").name("io.confluent.stringtype").version(Integer.valueOf(2)).optional().parameter("foo", "bar").parameter("baz", "baz").build();
        Schema wrongAvroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().stringType()).and().nullType()).endUnion();
        Schema avroStringSchema = (Schema)org.apache.avro.SchemaBuilder.builder().stringType();
        avroStringSchema.addProp("connect.name", "io.confluent.stringtype");
        avroStringSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(2));
        avroStringSchema.addProp("connect.doc", "doc");
        avroStringSchema.addProp("connect.default", "foo");
        ObjectNode params = JsonNodeFactory.instance.objectNode();
        params.put("foo", "bar");
        params.put("baz", "baz");
        avroStringSchema.addProp("connect.parameters", (Object)params);
        Schema avroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(avroStringSchema)).and().nullType()).endUnion();
        NonRecordContainer converted = this.checkNonRecordConversion(avroSchema, "string", schema, "string", this.avroData);
        Assert.assertNotEquals((Object)wrongAvroSchema, (Object)converted.getSchema());
        this.checkNonRecordConversionNull(schema);
    }

    @Test
    public void testFromConnectRecordWithMetadata() {
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("io.confluent.test.TestSchema").version(Integer.valueOf(12)).doc("doc").field("int32", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build();
        Struct struct = new Struct(schema).put("int32", (Object)12);
        Object convertedRecord = this.avroData.fromConnectData(schema, (Object)struct);
        Schema avroSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)"TestSchema").namespace("io.confluent.test")).fields().requiredInt("int32").endRecord();
        avroSchema.addProp("connect.name", "io.confluent.test.TestSchema");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(12));
        avroSchema.addProp("connect.doc", "doc");
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("int32", (Object)12).build();
        Assert.assertEquals((Object)avroSchema, (Object)((GenericRecord)convertedRecord).getSchema());
        Assert.assertEquals((Object)avroRecord, (Object)convertedRecord);
    }

    private static Schema createDecimalSchema(boolean required, int precision) {
        return AvroDataTest.createDecimalSchema(required, precision, 2);
    }

    private static Schema createDecimalSchema(boolean required, int precision, int scale) {
        Schema avroSchema = required ? (Schema)org.apache.avro.SchemaBuilder.builder().bytesType() : (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().bytesType()).endUnion();
        Schema decimalSchema = required ? avroSchema : (Schema)avroSchema.getTypes().get(1);
        decimalSchema.addProp("scale", (Object)scale);
        decimalSchema.addProp("precision", (Object)precision);
        decimalSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        ObjectNode avroParams = JsonNodeFactory.instance.objectNode();
        avroParams.put("scale", Integer.toString(scale));
        avroParams.put("connect.decimal.precision", Integer.toString(precision));
        decimalSchema.addProp("connect.parameters", (Object)avroParams);
        decimalSchema.addProp("connect.name", "org.apache.kafka.connect.data.Decimal");
        decimalSchema.addProp("logicalType", "decimal");
        if (scale >= 0 && scale <= precision) {
            LogicalTypes.decimal((int)precision, (int)scale).addToSchema(decimalSchema);
        }
        return avroSchema;
    }

    @Test
    public void testFromConnectLogicalDecimalNew() {
        Schema avroSchema = AvroDataTest.createDecimalSchema(true, 64);
        this.checkNonRecordConversionNew(avroSchema, ByteBuffer.wrap(TEST_DECIMAL_BYTES), Decimal.builder((int)2).parameter("connect.decimal.precision", "64").build(), TEST_DECIMAL, this.avroData);
        this.checkNonRecordConversionNull(Decimal.builder((int)2).optional().build());
    }

    @Test
    public void testFromConnectLogicalDateNew() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Date");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        avroSchema.addProp("logicalType", "date");
        LogicalTypes.date().addToSchema(avroSchema);
        this.checkNonRecordConversionNew(avroSchema, 10000, Date.SCHEMA, EPOCH_PLUS_TEN_THOUSAND_DAYS.getTime(), this.avroData);
    }

    @Test
    public void testFromConnectLogicalTimeNew() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Time");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        avroSchema.addProp("logicalType", "time-millis");
        LogicalTypes.timeMillis().addToSchema(avroSchema);
        this.checkNonRecordConversionNew(avroSchema, 10000, Time.SCHEMA, EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime(), this.avroData);
    }

    @Test
    public void testFromConnectLogicalTimestampNew() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Timestamp");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        avroSchema.addProp("logicalType", "timestamp-millis");
        LogicalTypes.timestampMillis().addToSchema(avroSchema);
        java.util.Date date = new java.util.Date();
        this.checkNonRecordConversionNew(avroSchema, date.getTime(), Timestamp.SCHEMA, date, this.avroData);
    }

    @Test
    public void testFromConnectLogicalDecimalScaleGreaterThanPrecision() {
        int precision = 5;
        int scale = 7;
        BigDecimal testDecimal = new BigDecimal(new BigInteger("12358"), scale);
        Schema avroSchema = AvroDataTest.createDecimalSchema(true, precision, scale);
        this.checkNonRecordConversion(avroSchema, ByteBuffer.wrap(testDecimal.unscaledValue().toByteArray()), Decimal.builder((int)scale).parameter("connect.decimal.precision", Integer.toString(precision)).build(), testDecimal, this.avroData);
        this.checkNonRecordConversionNull(Decimal.builder((int)scale).optional().build());
    }

    @Test
    public void testFromConnectLogicalDecimal() {
        Schema avroSchema = AvroDataTest.createDecimalSchema(true, 64);
        this.checkNonRecordConversion(avroSchema, ByteBuffer.wrap(TEST_DECIMAL_BYTES), Decimal.builder((int)2).parameter("connect.decimal.precision", "64").build(), TEST_DECIMAL, this.avroData);
        this.checkNonRecordConversionNull(Decimal.builder((int)2).optional().build());
    }

    @Test
    public void testFromConnectLogicalDate() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Date");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        avroSchema.addProp("logicalType", "date");
        this.checkNonRecordConversion(avroSchema, 10000, Date.SCHEMA, EPOCH_PLUS_TEN_THOUSAND_DAYS.getTime(), this.avroData);
    }

    @Test
    public void testFromConnectLogicalTime() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Time");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        avroSchema.addProp("logicalType", "time-millis");
        this.checkNonRecordConversion(avroSchema, 10000, Time.SCHEMA, EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime(), this.avroData);
    }

    @Test
    public void testFromConnectLogicalTimestamp() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Timestamp");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        avroSchema.addProp("logicalType", "timestamp-millis");
        java.util.Date date = new java.util.Date();
        this.checkNonRecordConversion(avroSchema, date.getTime(), Timestamp.SCHEMA, date, this.avroData);
    }

    @Test(expected=DataException.class)
    public void testFromConnectMismatchSchemaPrimitive() {
        this.avroData.fromConnectData(org.apache.kafka.connect.data.Schema.OPTIONAL_BOOLEAN_SCHEMA, (Object)12);
    }

    @Test(expected=DataException.class)
    public void testFromConnectMismatchSchemaPrimitiveRequired() {
        this.avroData.fromConnectData(org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA, null);
    }

    @Test(expected=DataException.class)
    public void testFromConnectMismatchSchemaArray() {
        this.avroData.fromConnectData(SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA).build(), Arrays.asList(12));
    }

    @Test(expected=DataException.class)
    public void testFromConnectMismatchSchemaMapWithStringKeyMismatchKey() {
        this.avroData.fromConnectData(SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build(), Collections.singletonMap(true, 12));
    }

    @Test(expected=DataException.class)
    public void testFromConnectMismatchSchemaMapWithStringKeyMismatchValue() {
        this.avroData.fromConnectData(SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build(), Collections.singletonMap("foobar", 12L));
    }

    @Test(expected=DataException.class)
    public void testFromConnectMismatchSchemaMapWithNonStringKeyMismatchKey() {
        this.avroData.fromConnectData(SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build(), Collections.singletonMap(true, 12));
    }

    @Test(expected=DataException.class)
    public void testFromConnectMismatchSchemaMapWithNonStringKeyMismatchValue() {
        this.avroData.fromConnectData(SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build(), Collections.singletonMap(12, 12L));
    }

    @Test(expected=DataException.class)
    public void testFromConnectMismatchSchemaRecord() {
        org.apache.kafka.connect.data.Schema firstSchema = SchemaBuilder.struct().field("foo", org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA).build();
        org.apache.kafka.connect.data.Schema secondSchema = SchemaBuilder.struct().field("foo", org.apache.kafka.connect.data.Schema.OPTIONAL_BOOLEAN_SCHEMA).build();
        this.avroData.fromConnectData(firstSchema, (Object)new Struct(secondSchema).put("foo", null));
    }

    @Test(expected=DataException.class)
    public void testToConnectRecordWithIllegalNullValue() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().record("Record").fields().requiredString("string").endRecord();
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("string", (Object)"some value").build();
        avroRecord.put("string", null);
        this.avroData.toConnectData(avroSchema, (Object)avroRecord);
    }

    @Test
    public void testFromConnectSchemaless() {
        Object nullConverted = this.avroData.fromConnectData(null, null);
        Assert.assertNull((Object)nullConverted);
        this.checkNonRecordConversionNull(null);
        GenericData.Record avroIntRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("int", (Object)12).build();
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroIntRecord, null, (byte)12, this.avroData);
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroIntRecord, null, (short)12, this.avroData);
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroIntRecord, null, 12, this.avroData);
        GenericData.Record avroLongRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("long", (Object)12L).build();
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroLongRecord, null, 12L, this.avroData);
        GenericData.Record avroFloatRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("float", (Object)Float.valueOf(12.2f)).build();
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroFloatRecord, null, Float.valueOf(12.2f), this.avroData);
        GenericData.Record avroDoubleRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("double", (Object)12.2).build();
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroDoubleRecord, null, 12.2, this.avroData);
        GenericData.Record avroBooleanRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("boolean", (Object)true).build();
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroBooleanRecord, null, true, this.avroData);
        GenericData.Record avroStringRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("string", (Object)"teststring").build();
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroStringRecord, null, "teststring", this.avroData);
        GenericData.Record avroNullRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).build();
        GenericData.Record avroArrayRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("array", Arrays.asList(avroIntRecord, avroStringRecord, avroNullRecord)).build();
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroArrayRecord, null, Arrays.asList(12, "teststring", null), this.avroData);
        GenericData.Record avroMapEntry = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA_MAP_ELEMENT).set("key", (Object)avroIntRecord).set("value", (Object)avroStringRecord).build();
        GenericData.Record avroMapEntryNull = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA_MAP_ELEMENT).set("key", (Object)new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("int", (Object)13).build()).set("value", (Object)avroNullRecord).build();
        GenericData.Record avroMapRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("map", Arrays.asList(avroMapEntry, avroMapEntryNull)).build();
        HashMap<Integer, String> convertedMap = new HashMap<Integer, String>();
        convertedMap.put(12, "teststring");
        convertedMap.put(13, null);
        this.checkNonRecordConversion(AvroData.ANYTHING_SCHEMA, avroMapRecord, null, convertedMap, this.avroData);
    }

    @Test
    public void testCacheSchemaFromConnectConversion() {
        Map cache = (Map)Whitebox.getInternalState((Object)this.avroData, (String)"fromConnectSchemaCache");
        Assert.assertEquals((long)0L, (long)cache.size());
        this.avroData.fromConnectData(org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA, (Object)true);
        Assert.assertEquals((long)1L, (long)cache.size());
        this.avroData.fromConnectData(org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA, (Object)true);
        Assert.assertEquals((long)1L, (long)cache.size());
        this.avroData.fromConnectData(org.apache.kafka.connect.data.Schema.OPTIONAL_BOOLEAN_SCHEMA, (Object)true);
        Assert.assertEquals((long)2L, (long)cache.size());
        this.avroData.fromConnectData(org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (Object)"foo");
        Assert.assertEquals((long)2L, (long)cache.size());
    }

    @Test
    public void testEnum() throws Exception {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("enhanced.avro.schema.support", (Object)true).build();
        AvroData avroData = new AvroData(avroDataConfig);
        EnumTest testModel = EnumTest.newBuilder().setTestkey("name").setKind(Kind.ONE).build();
        SchemaAndValue schemaAndValue = avroData.toConnectData(EnumTest.SCHEMA$, (Object)testModel);
        org.apache.kafka.connect.data.Schema schema = schemaAndValue.schema();
        Object schemaValue = schemaAndValue.value();
        GenericData.Record value = (GenericData.Record)avroData.fromConnectData(schema, schemaValue);
        GenericContainer userTypeValue = (GenericContainer)value.get("kind");
        Assert.assertEquals((Object)userTypeValue.getSchema().getType(), (Object)Schema.Type.ENUM);
    }

    @Test
    public void testEnumUnion() throws Exception {
        GenericData genericData = GenericData.get();
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("enhanced.avro.schema.support", (Object)true).build();
        AvroData avroData = new AvroData(avroDataConfig);
        EnumUnion testModel = EnumUnion.newBuilder().setUserType(UserType.ANONYMOUS).build();
        SchemaAndValue schemaAndValue = avroData.toConnectData(EnumUnion.SCHEMA$, (Object)testModel);
        org.apache.kafka.connect.data.Schema schema = schemaAndValue.schema();
        Object schemaValue = schemaAndValue.value();
        GenericData.Record value = (GenericData.Record)avroData.fromConnectData(schema, schemaValue);
        Schema userTypeSchema = EnumUnion.SCHEMA$.getField("userType").schema();
        Object userTypeValue = value.get("userType");
        int unionIndex = genericData.resolveUnion(userTypeSchema, userTypeValue);
        Assert.assertEquals((long)1L, (long)unionIndex);
    }

    @Test
    public void testEnumUnionNullValue() throws Exception {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("enhanced.avro.schema.support", (Object)true).build();
        AvroData avroData = new AvroData(avroDataConfig);
        EnumUnion testModel = EnumUnion.newBuilder().setUserType(null).build();
        SchemaAndValue schemaAndValue = avroData.toConnectData(EnumUnion.SCHEMA$, (Object)testModel);
        org.apache.kafka.connect.data.Schema schema = schemaAndValue.schema();
        Object schemaValue = schemaAndValue.value();
        GenericData.Record value = (GenericData.Record)avroData.fromConnectData(schema, schemaValue);
        Object userTypeValue = value.get("userType");
        Assert.assertNull((Object)userTypeValue);
    }

    @Test
    public void testEnumStringUnion() throws Exception {
        GenericData genericData = GenericData.get();
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("enhanced.avro.schema.support", (Object)true).build();
        AvroData avroData = new AvroData(avroDataConfig);
        EnumStringUnion testModel = EnumStringUnion.newBuilder().setUserType((Object)UserType.ANONYMOUS).build();
        SchemaAndValue schemaAndValue = avroData.toConnectData(EnumStringUnion.SCHEMA$, (Object)testModel);
        org.apache.kafka.connect.data.Schema schema = schemaAndValue.schema();
        Object schemaValue = schemaAndValue.value();
        GenericData.Record value = (GenericData.Record)avroData.fromConnectData(schema, schemaValue);
        Schema userTypeSchema = EnumStringUnion.SCHEMA$.getField("userType").schema();
        Object userTypeValue = value.get("userType");
        int unionIndex = genericData.resolveUnion(userTypeSchema, userTypeValue);
        Assert.assertEquals((long)2L, (long)unionIndex);
    }

    @Test
    public void testEnumStringUnionGeneric() throws Exception {
        Schema enumField = (Schema)((SchemaBuilder.EnumBuilder)org.apache.avro.SchemaBuilder.builder().enumeration("testEnum").namespace("com")).symbols(new String[]{"A", "B", "C", "D"});
        Schema unionField = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().stringType()).and().type(enumField)).endUnion();
        Schema avroSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("EnumUnionTest").namespace("com")).fields().name("id").type(unionField).noDefault().endRecord();
        GenericData.Record avroRecord1 = new GenericRecordBuilder(avroSchema).set("id", null).build();
        GenericData.Record avroRecord2 = new GenericRecordBuilder(avroSchema).set("id", (Object)"teststring").build();
        GenericData.Record avroRecord3 = new GenericRecordBuilder(avroSchema).set("id", (Object)new GenericData.EnumSymbol(enumField, "A")).build();
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("enhanced.avro.schema.support", (Object)true).build();
        AvroData avroData = new AvroData(avroDataConfig);
        SchemaAndValue schemaAndValue1 = avroData.toConnectData(avroSchema, (Object)avroRecord1);
        SchemaAndValue schemaAndValue2 = avroData.toConnectData(avroSchema, (Object)avroRecord2);
        SchemaAndValue schemaAndValue3 = avroData.toConnectData(avroSchema, (Object)avroRecord3);
        GenericRecord convertedRecord1 = (GenericRecord)avroData.fromConnectData(schemaAndValue1.schema(), schemaAndValue1.value());
        Assert.assertEquals((Object)avroRecord1.get("id"), (Object)convertedRecord1.get("id"));
        GenericRecord convertedRecord2 = (GenericRecord)avroData.fromConnectData(schemaAndValue2.schema(), schemaAndValue2.value());
        Assert.assertEquals((Object)avroRecord2.get("id"), (Object)convertedRecord2.get("id"));
        GenericRecord convertedRecord3 = (GenericRecord)avroData.fromConnectData(schemaAndValue3.schema(), schemaAndValue3.value());
        Assert.assertEquals((Object)avroRecord3.get("id"), (Object)convertedRecord3.get("id"));
    }

    @Test
    public void testToConnectNull() {
        Assert.assertNull((Object)this.avroData.toConnectData(null, null));
    }

    @Test
    public void testToConnectBoolean() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().booleanType();
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA, (Object)true), (Object)this.avroData.toConnectData(avroSchema, (Object)true));
    }

    @Test
    public void testToConnectInt32() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.INT32_SCHEMA, (Object)12), (Object)this.avroData.toConnectData(avroSchema, (Object)12));
    }

    @Test
    public void testToConnectInt64() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.INT64_SCHEMA, (Object)12L), (Object)this.avroData.toConnectData(avroSchema, (Object)12L));
    }

    @Test
    public void testToConnectFloat32() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().floatType();
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA, (Object)Float.valueOf(12.0f)), (Object)this.avroData.toConnectData(avroSchema, (Object)Float.valueOf(12.0f)));
    }

    @Test
    public void testToConnectFloat64() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().doubleType();
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA, (Object)12.0), (Object)this.avroData.toConnectData(avroSchema, (Object)12.0));
    }

    @Test
    public void testToConnectNullableStringNullvalue() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.nullable().stringType();
        Assert.assertEquals(null, (Object)this.avroData.toConnectData(avroSchema, null));
    }

    @Test
    public void testToConnectNullableString() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.nullable().stringType();
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA, (Object)"teststring"), (Object)this.avroData.toConnectData(avroSchema, (Object)"teststring"));
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA, (Object)"teststring"), (Object)this.avroData.toConnectData(avroSchema, (Object)new Utf8("teststring")));
    }

    @Test
    public void testToConnectString() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().stringType();
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (Object)"teststring"), (Object)this.avroData.toConnectData(avroSchema, (Object)"teststring"));
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (Object)"teststring"), (Object)this.avroData.toConnectData(avroSchema, (Object)new Utf8("teststring")));
    }

    @Test
    public void testToConnectBytes() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().bytesType();
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.BYTES_SCHEMA, (Object)ByteBuffer.wrap("foo".getBytes())), (Object)this.avroData.toConnectData(avroSchema, (Object)"foo".getBytes()));
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.BYTES_SCHEMA, (Object)ByteBuffer.wrap("foo".getBytes())), (Object)this.avroData.toConnectData(avroSchema, (Object)ByteBuffer.wrap("foo".getBytes())));
    }

    @Test
    public void testToConnectArray() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().array().items().intType();
        avroSchema.getElementType().addProp("connect.type", "int8");
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT8_SCHEMA).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, Arrays.asList((byte)12, (byte)13)), (Object)this.avroData.toConnectData(avroSchema, Arrays.asList(12, 13)));
    }

    @Test
    public void testToConnectMapStringKeys() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().map().values().intType();
        avroSchema.getValueType().addProp("connect.type", "int8");
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT8_SCHEMA).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, Collections.singletonMap("field", (byte)12)), (Object)this.avroData.toConnectData(avroSchema, Collections.singletonMap("field", 12)));
    }

    @Test
    public void testToConnectRecord() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().record("Record").fields().requiredInt("int8").requiredString("string").endRecord();
        avroSchema.getField("int8").schema().addProp("connect.type", "int8");
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("int8", (Object)12).set("string", (Object)"sample string").build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("Record").field("int8", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(schema).put("int8", (Object)12).put("string", (Object)"sample string");
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)struct), (Object)this.avroData.toConnectData(avroSchema, (Object)avroRecord));
    }

    @Test
    public void testToConnectRecordWithOptionalValue() {
        this.testToConnectRecordWithOptional("sample string");
    }

    @Test
    public void testToConnectRecordWithOptionalNullValue() {
        this.testToConnectRecordWithOptional(null);
    }

    private void testToConnectRecordWithOptional(String value) {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().record("Record").fields().requiredInt("int8").optionalString("string").endRecord();
        avroSchema.getField("int8").schema().addProp("connect.type", "int8");
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("int8", (Object)12).set("string", (Object)value).build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("Record").field("int8", org.apache.kafka.connect.data.Schema.INT8_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).build();
        Struct struct = new Struct(schema).put("int8", (Object)12).put("string", (Object)value);
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)struct), (Object)this.avroData.toConnectData(avroSchema, (Object)avroRecord));
    }

    @Test
    public void testToConnectRecordWithOptionalArrayValue() {
        this.testToConnectRecordWithOptionalArray(Arrays.asList("test"));
    }

    @Test
    public void testToConnectRecordWithOptionalArrayNullValue() {
        this.testToConnectRecordWithOptionalArray(null);
    }

    private void testToConnectRecordWithOptionalArray(List<String> value) {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().record("Record").fields().optionalString("string").name("array").type((Schema)org.apache.avro.SchemaBuilder.builder().nullable().array().items().stringType()).noDefault().endRecord();
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("string", (Object)"xx").set("array", value).build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("Record").field("string", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).field("array", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA).optional().build()).build();
        Struct struct = new Struct(schema).put("string", (Object)"xx").put("array", value);
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)struct), (Object)this.avroData.toConnectData(avroSchema, (Object)avroRecord));
    }

    @Test
    public void testToConnectNestedRecordWithOptionalRecordValue() {
        Schema avroSchema = this.nestedRecordAvroSchema();
        org.apache.kafka.connect.data.Schema schema = this.nestedRecordSchema();
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("nestedRecord", (Object)new GenericRecordBuilder(this.recordWithStringAvroSchema()).set("string", (Object)"xx").build()).build();
        Struct struct = new Struct(schema).put("nestedRecord", (Object)new Struct(this.recordWithStringSchema()).put("string", (Object)"xx"));
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)struct), (Object)this.avroData.toConnectData(avroSchema, (Object)avroRecord));
    }

    @Test
    public void testToConnectNestedRecordWithOptionalRecordNullValue() {
        Schema avroSchema = this.nestedRecordAvroSchema();
        org.apache.kafka.connect.data.Schema schema = this.nestedRecordSchema();
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("nestedRecord", null).build();
        Struct struct = new Struct(schema).put("nestedRecord", null);
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)struct), (Object)this.avroData.toConnectData(avroSchema, (Object)avroRecord));
    }

    private Schema recordWithStringAvroSchema() {
        return (Schema)org.apache.avro.SchemaBuilder.builder().record("nestedRecord").fields().requiredString("string").endRecord();
    }

    private Schema nestedRecordAvroSchema() {
        Schema optionalRecordAvroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(this.recordWithStringAvroSchema())).and().nullType()).endUnion();
        return (Schema)org.apache.avro.SchemaBuilder.builder().record("Record").fields().name("nestedRecord").type(optionalRecordAvroSchema).noDefault().endRecord();
    }

    private org.apache.kafka.connect.data.Schema recordWithStringSchema() {
        return SchemaBuilder.struct().optional().name("nestedRecord").field("string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build();
    }

    private org.apache.kafka.connect.data.Schema nestedRecordSchema() {
        return SchemaBuilder.struct().name("Record").field("nestedRecord", this.recordWithStringSchema()).build();
    }

    @Test
    public void testToConnectDecimal() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().bytesType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Decimal");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        ObjectNode avroParams = JsonNodeFactory.instance.objectNode();
        avroParams.put("scale", "2");
        avroSchema.addProp("connect.parameters", (Object)avroParams);
        Assert.assertEquals((Object)new SchemaAndValue(Decimal.schema((int)2), (Object)TEST_DECIMAL), (Object)this.avroData.toConnectData(avroSchema, (Object)TEST_DECIMAL_BYTES));
    }

    @Test
    public void testToConnectDecimalAvro() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().bytesType();
        avroSchema.addProp("logicalType", "decimal");
        avroSchema.addProp("precision", (Object)50);
        avroSchema.addProp("scale", (Object)2);
        SchemaAndValue expected = new SchemaAndValue(Decimal.builder((int)2).parameter("connect.decimal.precision", "50").build(), (Object)TEST_DECIMAL);
        SchemaAndValue actual = this.avroData.toConnectData(avroSchema, (Object)TEST_DECIMAL_BYTES);
        Assert.assertThat((String)"schema.parameters() does not match.", (Object)actual.schema().parameters(), (Matcher)IsEqual.equalTo((Object)expected.schema().parameters()));
        Assert.assertEquals((String)"schema does not match.", (Object)expected.schema(), (Object)actual.schema());
        Assert.assertEquals((String)"value does not match.", (Object)expected.value(), (Object)actual.value());
    }

    @Test
    public void testToConnectDecimalAvroDefaultScale() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().bytesType();
        avroSchema.addProp("logicalType", "decimal");
        avroSchema.addProp("precision", (Object)50);
        SchemaAndValue expected = new SchemaAndValue(Decimal.builder((int)0).parameter("connect.decimal.precision", "50").build(), (Object)new BigDecimal(new BigInteger("156"), 0));
        SchemaAndValue actual = this.avroData.toConnectData(avroSchema, (Object)TEST_DECIMAL_BYTES);
        Assert.assertThat((String)"schema.parameters() does not match.", (Object)actual.schema().parameters(), (Matcher)IsEqual.equalTo((Object)expected.schema().parameters()));
        Assert.assertEquals((String)"schema does not match.", (Object)expected.schema(), (Object)actual.schema());
        Assert.assertEquals((String)"value does not match.", (Object)expected.value(), (Object)actual.value());
    }

    @Test
    public void testToConnectDate() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Date");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        Assert.assertEquals((Object)new SchemaAndValue(Date.SCHEMA, (Object)EPOCH_PLUS_TEN_THOUSAND_DAYS.getTime()), (Object)this.avroData.toConnectData(avroSchema, (Object)10000));
    }

    @Test
    public void testToConnectDateAvro() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("logicalType", "date");
        Assert.assertEquals((Object)new SchemaAndValue(Date.SCHEMA, (Object)EPOCH_PLUS_TEN_THOUSAND_DAYS.getTime()), (Object)this.avroData.toConnectData(avroSchema, (Object)10000));
    }

    @Test
    public void testToConnectTime() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Time");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        Assert.assertEquals((Object)new SchemaAndValue(Time.SCHEMA, (Object)EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime()), (Object)this.avroData.toConnectData(avroSchema, (Object)10000));
    }

    @Test
    public void testToConnectTimeAvro() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("logicalType", "time-millis");
        Assert.assertEquals((Object)new SchemaAndValue(Time.SCHEMA, (Object)EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime()), (Object)this.avroData.toConnectData(avroSchema, (Object)10000));
    }

    @Test
    public void testToConnectTimestamp() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        avroSchema.addProp("connect.name", "org.apache.kafka.connect.data.Timestamp");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(1));
        java.util.Date date = new java.util.Date();
        Assert.assertEquals((Object)new SchemaAndValue(Timestamp.SCHEMA, (Object)date), (Object)this.avroData.toConnectData(avroSchema, (Object)date.getTime()));
    }

    @Test
    public void testToConnectTimestampAvro() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
        avroSchema.addProp("logicalType", "timestamp-millis");
        java.util.Date date = new java.util.Date();
        Assert.assertEquals((Object)new SchemaAndValue(Timestamp.SCHEMA, (Object)date), (Object)this.avroData.toConnectData(avroSchema, (Object)date.getTime()));
    }

    @Test
    public void testToConnectInt8() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.type", "int8");
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.INT8_SCHEMA, (Object)12), (Object)this.avroData.toConnectData(avroSchema, (Object)12));
    }

    @Test
    public void testToConnectInt16() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        avroSchema.addProp("connect.type", "int16");
        Assert.assertEquals((Object)new SchemaAndValue(org.apache.kafka.connect.data.Schema.INT16_SCHEMA, (Object)12), (Object)this.avroData.toConnectData(avroSchema, (Object)12));
    }

    @Test
    public void testToConnectMapNonStringKeys() {
        Schema avroSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().array().items().record("MapEntry").namespace("io.confluent.connect.avro")).fields().name("key").type((Schema)org.apache.avro.SchemaBuilder.builder().intType()).noDefault().name("value").type((Schema)org.apache.avro.SchemaBuilder.builder().intType()).noDefault().endRecord();
        avroSchema.getElementType().getField("key").schema().addProp("connect.type", "int8");
        avroSchema.getElementType().getField("value").schema().addProp("connect.type", "int16");
        GenericData.Record record = new GenericRecordBuilder(avroSchema.getElementType()).set("key", (Object)12).set("value", (Object)16).build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT8_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT16_SCHEMA).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, Collections.singletonMap((byte)12, (short)16)), (Object)this.avroData.toConnectData(avroSchema, Arrays.asList(record)));
    }

    @Test
    public void testToConnectMapOptionalValue() {
        this.testToConnectMapOptional("some value");
    }

    @Test
    public void testToConnectMapOptionalNullValue() {
        this.testToConnectMapOptional(null);
    }

    private void testToConnectMapOptional(String value) {
        Schema avroSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().array().items().record("MapEntry").namespace("io.confluent.connect.avro")).fields().name("key").type((Schema)org.apache.avro.SchemaBuilder.builder().intType()).noDefault().name("value").type((Schema)org.apache.avro.SchemaBuilder.builder().nullable().stringType()).noDefault().endRecord();
        avroSchema.getElementType().getField("key").schema().addProp("connect.type", "int8");
        GenericData.Record record = new GenericRecordBuilder(avroSchema.getElementType()).set("key", (Object)12).set("value", (Object)value).build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT8_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, Collections.singletonMap((byte)12, value)), (Object)this.avroData.toConnectData(avroSchema, Arrays.asList(record)));
    }

    @Test
    public void testToConnectMapWithNamedSchema() {
        Assert.assertThat((Object)this.avroData.toConnectSchema(NAMED_AVRO_MAP_SCHEMA), (Matcher)CoreMatchers.equalTo((Object)NAMED_MAP_SCHEMA));
    }

    @Test(expected=DataException.class)
    public void testToConnectNullType() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().nullType();
        this.avroData.toConnectData(avroSchema, (Object)true);
    }

    @Test
    public void testToConnectFixed() {
        org.apache.kafka.connect.data.Schema connectSchema = SchemaBuilder.bytes().name("sample").parameter("connect.fixed.size", "4").build();
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("sample").size(4);
        Assert.assertEquals((Object)new SchemaAndValue(connectSchema, (Object)ByteBuffer.wrap("foob".getBytes())), (Object)this.avroData.toConnectData(avroSchema, (Object)"foob".getBytes()));
        Assert.assertEquals((Object)new SchemaAndValue(connectSchema, (Object)ByteBuffer.wrap("foob".getBytes())), (Object)this.avroData.toConnectData(avroSchema, (Object)ByteBuffer.wrap("foob".getBytes())));
        Assert.assertEquals((Object)new SchemaAndValue(connectSchema, (Object)ByteBuffer.wrap("foob".getBytes())), (Object)this.avroData.toConnectData(avroSchema, (Object)new GenericData.Fixed(avroSchema, "foob".getBytes())));
    }

    @Test
    public void testToConnectFixedUnion() {
        Schema sampleSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("sample").size(4);
        Schema otherSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("other").size(6);
        Schema sameOtherSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("sameOther").size(6);
        Schema unionAvroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(sampleSchema)).and().type(otherSchema)).and().type(sameOtherSchema)).endUnion();
        org.apache.kafka.connect.data.Schema unionConnectSchema = SchemaBuilder.struct().name("io.confluent.connect.avro.Union").field("sample", SchemaBuilder.bytes().name("sample").parameter("connect.fixed.size", "4").optional().build()).field("other", SchemaBuilder.bytes().name("other").parameter("connect.fixed.size", "6").optional().build()).field("sameOther", SchemaBuilder.bytes().name("sameOther").parameter("connect.fixed.size", "6").optional().build()).build();
        GenericData.Fixed valueSample = new GenericData.Fixed(sampleSchema, "foob".getBytes());
        GenericData.Fixed valueOther = new GenericData.Fixed(otherSchema, "foobar".getBytes());
        GenericData.Fixed valueSameOther = new GenericData.Fixed(sameOtherSchema, "foobar".getBytes());
        org.apache.kafka.connect.data.Schema generatedSchema = this.avroData.toConnectSchema(unionAvroSchema);
        Assert.assertEquals((Object)unionConnectSchema, (Object)generatedSchema);
        Struct unionSame = new Struct(unionConnectSchema).put("sample", (Object)ByteBuffer.wrap("foob".getBytes()));
        Assert.assertEquals((Object)new SchemaAndValue(unionConnectSchema, (Object)unionSame), (Object)this.avroData.toConnectData(unionAvroSchema, (Object)valueSample));
        Struct unionOther = new Struct(unionConnectSchema).put("other", (Object)ByteBuffer.wrap("foobar".getBytes()));
        Assert.assertEquals((Object)new SchemaAndValue(unionConnectSchema, (Object)unionOther), (Object)this.avroData.toConnectData(unionAvroSchema, (Object)valueOther));
        Struct unionSameOther = new Struct(unionConnectSchema).put("sameOther", (Object)ByteBuffer.wrap("foobar".getBytes()));
        Assert.assertEquals((Object)new SchemaAndValue(unionConnectSchema, (Object)unionSameOther), (Object)this.avroData.toConnectData(unionAvroSchema, (Object)valueSameOther));
    }

    @Test
    public void testToConnectFixedUnionWithEnhanced() {
        this.avroData = new AvroData(new AvroDataConfig.Builder().with("schemas.cache.config", (Object)2).with("enhanced.avro.schema.support", (Object)true).build());
        Schema sampleSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("sample").size(4);
        Schema otherSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("other").size(6);
        Schema sameOtherSchema = (Schema)org.apache.avro.SchemaBuilder.builder().fixed("sameOther").size(6);
        Schema unionAvroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(sampleSchema)).and().type(otherSchema)).and().type(sameOtherSchema)).endUnion();
        org.apache.kafka.connect.data.Schema unionConnectSchema = SchemaBuilder.struct().name("io.confluent.connect.avro.Union").field("sample", SchemaBuilder.bytes().name("sample").parameter("connect.fixed.size", "4").optional().build()).field("other", SchemaBuilder.bytes().name("other").parameter("connect.fixed.size", "6").optional().build()).field("sameOther", SchemaBuilder.bytes().name("sameOther").parameter("connect.fixed.size", "6").optional().build()).build();
        GenericData.Fixed valueSample = new GenericData.Fixed(sampleSchema, "foob".getBytes());
        GenericData.Fixed valueOther = new GenericData.Fixed(otherSchema, "foobar".getBytes());
        GenericData.Fixed valueSameOther = new GenericData.Fixed(sameOtherSchema, "foobar".getBytes());
        org.apache.kafka.connect.data.Schema generatedSchema = this.avroData.toConnectSchema(unionAvroSchema);
        Assert.assertEquals((Object)unionConnectSchema, (Object)generatedSchema);
        Struct unionSame = new Struct(unionConnectSchema).put("sample", (Object)ByteBuffer.wrap("foob".getBytes()));
        Assert.assertEquals((Object)new SchemaAndValue(unionConnectSchema, (Object)unionSame), (Object)this.avroData.toConnectData(unionAvroSchema, (Object)valueSample));
        Struct unionOther = new Struct(unionConnectSchema).put("other", (Object)ByteBuffer.wrap("foobar".getBytes()));
        Assert.assertEquals((Object)new SchemaAndValue(unionConnectSchema, (Object)unionOther), (Object)this.avroData.toConnectData(unionAvroSchema, (Object)valueOther));
        Struct unionSameOther = new Struct(unionConnectSchema).put("sameOther", (Object)ByteBuffer.wrap("foobar".getBytes()));
        Assert.assertEquals((Object)new SchemaAndValue(unionConnectSchema, (Object)unionSameOther), (Object)this.avroData.toConnectData(unionAvroSchema, (Object)valueSameOther));
    }

    @Test
    public void testToConnectUnion() {
        Schema avroRecordSchema1 = (Schema)org.apache.avro.SchemaBuilder.builder().record("Test1").fields().requiredInt("test").endRecord();
        Schema avroRecordSchema2 = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("Test2").namespace("io.confluent")).fields().requiredInt("test").endRecord();
        Schema avroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().intType()).and().stringType()).and().type(avroRecordSchema1)).and().type(avroRecordSchema2)).endUnion();
        org.apache.kafka.connect.data.Schema recordSchema1 = SchemaBuilder.struct().name("Test1").field("test", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema recordSchema2 = SchemaBuilder.struct().name("io.confluent.Test2").field("test", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("io.confluent.connect.avro.Union").field("int", org.apache.kafka.connect.data.Schema.OPTIONAL_INT32_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).field("Test1", recordSchema1).field("Test2", recordSchema2).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)new Struct(schema).put("int", (Object)12)), (Object)this.avroData.toConnectData(avroSchema, (Object)12));
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)new Struct(schema).put("string", (Object)"teststring")), (Object)this.avroData.toConnectData(avroSchema, (Object)"teststring"));
        Struct schema1Test = new Struct(schema).put("Test1", (Object)new Struct(recordSchema1).put("test", (Object)12));
        GenericData.Record record1Test = new GenericRecordBuilder(avroRecordSchema1).set("test", (Object)12).build();
        Struct schema2Test = new Struct(schema).put("Test2", (Object)new Struct(recordSchema2).put("test", (Object)12));
        GenericData.Record record2Test = new GenericRecordBuilder(avroRecordSchema2).set("test", (Object)12).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)schema1Test), (Object)this.avroData.toConnectData(avroSchema, (Object)record1Test));
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)schema2Test), (Object)this.avroData.toConnectData(avroSchema, (Object)record2Test));
    }

    @Test
    public void testToConnectUnionWithEnhanced() {
        this.avroData = new AvroData(new AvroDataConfig.Builder().with("schemas.cache.config", (Object)2).with("enhanced.avro.schema.support", (Object)true).build());
        Schema avroRecordSchema1 = (Schema)org.apache.avro.SchemaBuilder.builder().record("Test1").fields().requiredInt("test").endRecord();
        Schema avroRecordSchema2 = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("Test2").namespace("io.confluent")).fields().requiredInt("test").endRecord();
        Schema avroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().intType()).and().stringType()).and().type(avroRecordSchema1)).and().type(avroRecordSchema2)).endUnion();
        org.apache.kafka.connect.data.Schema recordSchema1 = SchemaBuilder.struct().name("Test1").field("test", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema recordSchema2 = SchemaBuilder.struct().name("io.confluent.Test2").field("test", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("io.confluent.connect.avro.Union").field("int", org.apache.kafka.connect.data.Schema.OPTIONAL_INT32_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).field("Test1", recordSchema1).field("io.confluent.Test2", recordSchema2).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)new Struct(schema).put("int", (Object)12)), (Object)this.avroData.toConnectData(avroSchema, (Object)12));
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)new Struct(schema).put("string", (Object)"teststring")), (Object)this.avroData.toConnectData(avroSchema, (Object)"teststring"));
        Struct schema1Test = new Struct(schema).put("Test1", (Object)new Struct(recordSchema1).put("test", (Object)12));
        GenericData.Record record1Test = new GenericRecordBuilder(avroRecordSchema1).set("test", (Object)12).build();
        Struct schema2Test = new Struct(schema).put("io.confluent.Test2", (Object)new Struct(recordSchema2).put("test", (Object)12));
        GenericData.Record record2Test = new GenericRecordBuilder(avroRecordSchema2).set("test", (Object)12).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)schema1Test), (Object)this.avroData.toConnectData(avroSchema, (Object)record1Test));
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)schema2Test), (Object)this.avroData.toConnectData(avroSchema, (Object)record2Test));
    }

    @Test
    public void testToConnectUnionWithGeneralizedSumTypeSupport() {
        this.avroData = new AvroData(new AvroDataConfig.Builder().with("schemas.cache.config", (Object)2).with("generalized.sum.type.support", (Object)true).build());
        Schema avroRecordSchema1 = (Schema)org.apache.avro.SchemaBuilder.builder().record("Test1").fields().requiredInt("test").endRecord();
        Schema avroRecordSchema2 = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("Test2").namespace("io.confluent")).fields().requiredInt("test").endRecord();
        Schema avroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().intType()).and().stringType()).and().type(avroRecordSchema1)).and().type(avroRecordSchema2)).endUnion();
        org.apache.kafka.connect.data.Schema recordSchema1 = SchemaBuilder.struct().name("Test1").field("test", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema recordSchema2 = SchemaBuilder.struct().name("io.confluent.Test2").field("test", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).optional().build();
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("connect_union_0").parameter("org.apache.kafka.connect.data.Union", "connect_union_0").field("connect_union_field_0", org.apache.kafka.connect.data.Schema.OPTIONAL_INT32_SCHEMA).field("connect_union_field_1", org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).field("connect_union_field_2", recordSchema1).field("connect_union_field_3", recordSchema2).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)new Struct(schema).put("connect_union_field_0", (Object)12)), (Object)this.avroData.toConnectData(avroSchema, (Object)12));
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)new Struct(schema).put("connect_union_field_1", (Object)"teststring")), (Object)this.avroData.toConnectData(avroSchema, (Object)"teststring"));
        Struct schema1Test = new Struct(schema).put("connect_union_field_2", (Object)new Struct(recordSchema1).put("test", (Object)12));
        GenericData.Record record1Test = new GenericRecordBuilder(avroRecordSchema1).set("test", (Object)12).build();
        Struct schema2Test = new Struct(schema).put("connect_union_field_3", (Object)new Struct(recordSchema2).put("test", (Object)12));
        GenericData.Record record2Test = new GenericRecordBuilder(avroRecordSchema2).set("test", (Object)12).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)schema1Test), (Object)this.avroData.toConnectData(avroSchema, (Object)record1Test));
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)schema2Test), (Object)this.avroData.toConnectData(avroSchema, (Object)record2Test));
    }

    @Test(expected=DataException.class)
    public void testToConnectUnionRecordConflict() {
        Schema avroRecordSchema1 = (Schema)org.apache.avro.SchemaBuilder.builder().record("Test1").fields().requiredInt("test").endRecord();
        Schema avroRecordSchema2 = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("Test1").namespace("io.confluent")).fields().requiredInt("test").endRecord();
        Schema avroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(avroRecordSchema1)).and().type(avroRecordSchema2)).endUnion();
        GenericData.Record recordTest = new GenericRecordBuilder(avroRecordSchema1).set("test", (Object)12).build();
        this.avroData.toConnectData(avroSchema, (Object)recordTest);
    }

    @Test
    public void testToConnectUnionRecordConflictWithEnhanced() {
        this.avroData = new AvroData(new AvroDataConfig.Builder().with("schemas.cache.config", (Object)2).with("enhanced.avro.schema.support", (Object)true).build());
        Schema avroRecordSchema1 = (Schema)org.apache.avro.SchemaBuilder.builder().record("Test1").fields().requiredInt("test").endRecord();
        Schema avroRecordSchema2 = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("Test1").namespace("io.confluent")).fields().requiredInt("test").endRecord();
        Schema avroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(avroRecordSchema1)).and().type(avroRecordSchema2)).endUnion();
        GenericData.Record recordTest = new GenericRecordBuilder(avroRecordSchema1).set("test", (Object)12).build();
        this.avroData.toConnectData(avroSchema, (Object)recordTest);
    }

    @Test
    public void testToConnectUnionDocChange() {
        Schema oldSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("FirstRecord").doc("old doc")).fields().requiredInt("int1").endRecord();
        Schema newSchema = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("FirstRecord").doc("new doc")).fields().requiredInt("int1").endRecord();
        Schema irrelevant = (Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().record("placeholder").doc("old doc")).fields().requiredInt("holder").endRecord();
        Schema unionAvroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(oldSchema)).and().type(irrelevant)).endUnion();
        Schema unionAvroSchemaNew = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(newSchema)).and().type(irrelevant)).endUnion();
        GenericData.Record record1Test = new GenericRecordBuilder(oldSchema).set("int1", (Object)12).build();
        GenericData.Record record2Test = new GenericRecordBuilder(newSchema).set("int1", (Object)12).build();
        Assert.assertNotNull((Object)this.avroData.toConnectData(unionAvroSchema, (Object)record1Test));
        Assert.assertNotNull((Object)this.avroData.toConnectData(unionAvroSchemaNew, (Object)record2Test));
    }

    @Test
    public void testToConnectEnum() {
        Schema avroSchema = (Schema)((SchemaBuilder.EnumBuilder)org.apache.avro.SchemaBuilder.builder().enumeration("TestEnum").doc("some documentation")).symbols(new String[]{"foo", "bar", "baz"});
        SchemaBuilder builder = SchemaBuilder.string().name("TestEnum");
        builder.parameter("io.confluent.connect.avro.enum.doc.TestEnum", "some documentation");
        builder.parameter("io.confluent.connect.avro.Enum", "TestEnum");
        for (String enumSymbol : new String[]{"foo", "bar", "baz"}) {
            builder.parameter("io.confluent.connect.avro.Enum." + enumSymbol, enumSymbol);
        }
        Assert.assertEquals((Object)new SchemaAndValue(builder.build(), (Object)"bar"), (Object)this.avroData.toConnectData(avroSchema, (Object)"bar"));
        Assert.assertEquals((Object)new SchemaAndValue(builder.build(), (Object)"bar"), (Object)this.avroData.toConnectData(avroSchema, (Object)new GenericData.EnumSymbol(avroSchema, "bar")));
    }

    @Test
    public void testToConnectEnumWithNoDoc() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().enumeration("TestEnum").symbols(new String[]{"foo", "bar", "baz"});
        SchemaBuilder builder = SchemaBuilder.string().name("TestEnum");
        builder.parameter("io.confluent.connect.avro.Enum", "TestEnum");
        for (String enumSymbol : new String[]{"foo", "bar", "baz"}) {
            builder.parameter("io.confluent.connect.avro.Enum." + enumSymbol, enumSymbol);
        }
        Assert.assertEquals((Object)new SchemaAndValue(builder.build(), (Object)"bar"), (Object)this.avroData.toConnectData(avroSchema, (Object)"bar"));
        Assert.assertEquals((Object)new SchemaAndValue(builder.build(), (Object)"bar"), (Object)this.avroData.toConnectData(avroSchema, (Object)new GenericData.EnumSymbol(avroSchema, "bar")));
    }

    @Test
    public void testToConnectEnumWithGeneralizedSumTypeSupport() {
        this.avroData = new AvroData(new AvroDataConfig.Builder().with("schemas.cache.config", (Object)2).with("generalized.sum.type.support", (Object)true).build());
        Schema avroSchema = (Schema)((SchemaBuilder.EnumBuilder)org.apache.avro.SchemaBuilder.builder().enumeration("TestEnum").doc("some documentation")).symbols(new String[]{"foo", "bar", "baz"});
        SchemaBuilder builder = SchemaBuilder.string().name("TestEnum");
        builder.parameter("io.confluent.connect.avro.enum.doc.TestEnum", "some documentation");
        builder.parameter("org.apache.kafka.connect.data.Enum", "TestEnum");
        int i = 0;
        for (String enumSymbol : new String[]{"foo", "bar", "baz"}) {
            builder.parameter("org.apache.kafka.connect.data.Enum." + enumSymbol, String.valueOf(i++));
        }
        Assert.assertEquals((Object)new SchemaAndValue(builder.build(), (Object)"bar"), (Object)this.avroData.toConnectData(avroSchema, (Object)"bar"));
        Assert.assertEquals((Object)new SchemaAndValue(builder.build(), (Object)"bar"), (Object)this.avroData.toConnectData(avroSchema, (Object)new GenericData.EnumSymbol(avroSchema, "bar")));
    }

    @Test
    public void testToConnectOptionalPrimitiveWithConnectMetadata() {
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.string().doc("doc").defaultValue((Object)"foo").name("io.confluent.stringtype").version(Integer.valueOf(2)).optional().parameter("foo", "bar").parameter("baz", "baz").build();
        Schema avroStringSchema = (Schema)org.apache.avro.SchemaBuilder.builder().stringType();
        avroStringSchema.addProp("connect.name", "io.confluent.stringtype");
        avroStringSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(2));
        avroStringSchema.addProp("connect.doc", "doc");
        avroStringSchema.addProp("connect.default", "foo");
        ObjectNode params = JsonNodeFactory.instance.objectNode();
        params.put("foo", "bar");
        params.put("baz", "baz");
        avroStringSchema.addProp("connect.parameters", (Object)params);
        Schema avroSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(avroStringSchema)).and().nullType()).endUnion();
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)"string"), (Object)this.avroData.toConnectData(avroSchema, (Object)"string"));
    }

    @Test
    public void testToConnectRecordWithMetadata() {
        org.apache.kafka.connect.data.Schema schema = SchemaBuilder.struct().name("io.confluent.test.TestSchema").version(Integer.valueOf(12)).doc("doc").field("int32", SchemaBuilder.int32().defaultValue((Object)7).parameter("io.confluent.connect.avro.field.default", "true").build()).parameter("io.confluent.connect.avro.field.doc.int32", "field doc").build();
        Struct struct = new Struct(schema).put("int32", (Object)12);
        Schema avroSchema = (Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)"TestSchema").namespace("io.confluent.test")).fields().name("int32").doc("field doc")).type().intType().intDefault(7).endRecord();
        avroSchema.addProp("connect.name", "io.confluent.test.TestSchema");
        avroSchema.addProp("connect.version", (Object)JsonNodeFactory.instance.numberNode(12));
        avroSchema.addProp("connect.doc", "doc");
        GenericData.Record avroRecord = new GenericRecordBuilder(avroSchema).set("int32", (Object)12).build();
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)struct), (Object)this.avroData.toConnectData(avroSchema, (Object)avroRecord));
    }

    @Test
    public void testToConnectSchemaless() {
        GenericData.Record avroNullRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).build();
        Assert.assertEquals((Object)new SchemaAndValue(null, null), (Object)this.avroData.toConnectData(AvroData.ANYTHING_SCHEMA, (Object)avroNullRecord));
        GenericData.Record avroIntRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("int", (Object)12).build();
        Assert.assertEquals((Object)new SchemaAndValue(null, (Object)12), (Object)this.avroData.toConnectData(AvroData.ANYTHING_SCHEMA, (Object)avroIntRecord));
        GenericData.Record avroLongRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("long", (Object)12L).build();
        Assert.assertEquals((Object)new SchemaAndValue(null, (Object)12L), (Object)this.avroData.toConnectData(AvroData.ANYTHING_SCHEMA, (Object)avroLongRecord));
        GenericData.Record avroFloatRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("float", (Object)Float.valueOf(12.2f)).build();
        Assert.assertEquals((Object)new SchemaAndValue(null, (Object)Float.valueOf(12.2f)), (Object)this.avroData.toConnectData(AvroData.ANYTHING_SCHEMA, (Object)avroFloatRecord));
        GenericData.Record avroDoubleRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("double", (Object)12.2).build();
        Assert.assertEquals((Object)new SchemaAndValue(null, (Object)12.2), (Object)this.avroData.toConnectData(AvroData.ANYTHING_SCHEMA, (Object)avroDoubleRecord));
        GenericData.Record avroBooleanRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("boolean", (Object)true).build();
        Assert.assertEquals((Object)new SchemaAndValue(null, (Object)true), (Object)this.avroData.toConnectData(AvroData.ANYTHING_SCHEMA, (Object)avroBooleanRecord));
        GenericData.Record avroStringRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("string", (Object)"teststring").build();
        Assert.assertEquals((Object)new SchemaAndValue(null, (Object)"teststring"), (Object)this.avroData.toConnectData(AvroData.ANYTHING_SCHEMA, (Object)avroStringRecord));
        GenericData.Record avroArrayRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("array", Arrays.asList(avroIntRecord, avroStringRecord, avroNullRecord)).build();
        Assert.assertEquals((Object)new SchemaAndValue(null, Arrays.asList(12, "teststring", null)), (Object)this.avroData.toConnectData(AvroData.ANYTHING_SCHEMA, (Object)avroArrayRecord));
        GenericData.Record avroMapEntry = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA_MAP_ELEMENT).set("key", (Object)avroIntRecord).set("value", (Object)avroStringRecord).build();
        GenericData.Record avroMapEntryNull = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA_MAP_ELEMENT).set("key", (Object)new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("int", (Object)13).build()).set("value", (Object)avroNullRecord).build();
        GenericData.Record avroMapRecord = new GenericRecordBuilder(AvroData.ANYTHING_SCHEMA).set("map", Arrays.asList(avroMapEntry, avroMapEntryNull)).build();
        HashMap<Integer, String> convertedMap = new HashMap<Integer, String>();
        convertedMap.put(12, "teststring");
        convertedMap.put(13, null);
        Assert.assertEquals((Object)new SchemaAndValue(null, convertedMap), (Object)this.avroData.toConnectData(AvroData.ANYTHING_SCHEMA, (Object)avroMapRecord));
    }

    @Test(expected=DataException.class)
    public void testToConnectSchemaMismatchPrimitive() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
        this.avroData.toConnectData(avroSchema, (Object)12L);
    }

    @Test(expected=DataException.class)
    public void testToConnectSchemaMismatchArray() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().array().items().stringType();
        this.avroData.toConnectData(avroSchema, Arrays.asList(1, 2, 3));
    }

    @Test(expected=DataException.class)
    public void testToConnectSchemaMismatchMapMismatchKey() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().map().values().intType();
        this.avroData.toConnectData(avroSchema, Collections.singletonMap(12, 12));
    }

    @Test(expected=DataException.class)
    public void testToConnectSchemaMismatchMapMismatchValue() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().map().values().intType();
        this.avroData.toConnectData(avroSchema, Collections.singletonMap("foo", 12L));
    }

    @Test(expected=DataException.class)
    public void testToConnectSchemaMismatchRecord() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().record("Record").fields().requiredString("string").endRecord();
        Schema avroSchemaWrong = (Schema)org.apache.avro.SchemaBuilder.builder().record("Record").fields().requiredInt("string").endRecord();
        GenericData.Record avroRecordWrong = new GenericRecordBuilder(avroSchemaWrong).set("string", (Object)12).build();
        this.avroData.toConnectData(avroSchema, (Object)avroRecordWrong);
    }

    @Test
    public void testCacheSchemaToConnectConversion() {
        Map cache = (Map)Whitebox.getInternalState((Object)this.avroData, (String)"toConnectSchemaCache");
        Assert.assertEquals((long)0L, (long)cache.size());
        this.avroData.toConnectData((Schema)org.apache.avro.SchemaBuilder.builder().booleanType(), (Object)true);
        Assert.assertEquals((long)1L, (long)cache.size());
        this.avroData.toConnectData((Schema)org.apache.avro.SchemaBuilder.builder().booleanType(), (Object)true);
        Assert.assertEquals((long)1L, (long)cache.size());
        this.avroData.toConnectData((Schema)org.apache.avro.SchemaBuilder.builder().intType(), (Object)32);
        Assert.assertEquals((long)2L, (long)cache.size());
        this.avroData.toConnectData((Schema)org.apache.avro.SchemaBuilder.builder().stringType(), (Object)"foo");
        Assert.assertEquals((long)2L, (long)cache.size());
    }

    @Test
    public void testAvroWithAndWithoutMetaData() {
        String s1 = "{  \"type\": \"record\",  \"name\": \"ListingStateChangedEventKeyRecord\",  \"namespace\": \"com.acme.property\",  \"doc\": \"Listing State Changed Event Key\",  \"fields\": [    {      \"name\": \"listingUuid\",      \"type\": {        \"type\": \"string\",        \"avro.java.string\": \"String\"      }    }  ]}";
        String s2 = "{  \"type\": \"record\",  \"name\": \"ListingStateChangedEventKeyRecord\",  \"namespace\": \"com.acme.property\",  \"doc\": \"Another listing State Changed Event Key\",  \"fields\": [    {      \"name\": \"listingUuid\",      \"type\": \"string\"    }  ]}";
        Schema avroSchema1 = new Schema.Parser().parse(s1);
        Schema avroSchema2 = new Schema.Parser().parse(s2);
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("connect.meta.data", (Object)false).build();
        AvroData avroData = new AvroData(avroDataConfig);
        org.apache.kafka.connect.data.Schema schema1 = avroData.toConnectSchema(avroSchema1);
        org.apache.kafka.connect.data.Schema schema2 = avroData.toConnectSchema(avroSchema2);
        Assert.assertEquals((Object)schema1.parameters(), (Object)schema2.parameters());
    }

    @Test
    public void testIntWithConnectDefault() {
        String s = "{  \"type\": \"record\",  \"name\": \"SomeThing\",  \"namespace\": \"com.acme.property\",  \"fields\": [    {      \"name\": \"f\",      \"type\": {        \"type\": \"int\",        \"connect.default\": 42,        \"connect.version\": 1      }    }  ]}";
        Schema avroSchema = new Schema.Parser().parse("{  \"type\": \"record\",  \"name\": \"SomeThing\",  \"namespace\": \"com.acme.property\",  \"fields\": [    {      \"name\": \"f\",      \"type\": {        \"type\": \"int\",        \"connect.default\": 42,        \"connect.version\": 1      }    }  ]}");
        AvroData avroData = new AvroData(0);
        org.apache.kafka.connect.data.Schema schema = avroData.toConnectSchema(avroSchema);
        Assert.assertEquals((Object)42, (Object)schema.field("f").schema().defaultValue());
    }

    @Test
    public void testLongWithConnectDefault() {
        String s = "{  \"type\": \"record\",  \"name\": \"SomeThing\",  \"namespace\": \"com.acme.property\",  \"fields\": [    {      \"name\": \"f\",      \"type\": {        \"type\": \"long\",        \"connect.default\": 42,        \"connect.version\": 1      }    }  ]}";
        Schema avroSchema = new Schema.Parser().parse("{  \"type\": \"record\",  \"name\": \"SomeThing\",  \"namespace\": \"com.acme.property\",  \"fields\": [    {      \"name\": \"f\",      \"type\": {        \"type\": \"long\",        \"connect.default\": 42,        \"connect.version\": 1      }    }  ]}");
        AvroData avroData = new AvroData(0);
        org.apache.kafka.connect.data.Schema schema = avroData.toConnectSchema(avroSchema);
        Assert.assertEquals((Object)42L, (Object)schema.field("f").schema().defaultValue());
    }

    @Test
    public void testFloatWithInvalidDefault() {
        String s = "{  \"type\": \"record\",  \"name\": \"SomeThing\",  \"namespace\": \"com.acme.property\",  \"fields\": [    {      \"name\": \"f\",      \"type\": \"float\",      \"default\": [1.23]    }  ]}";
        Schema avroSchema = new Schema.Parser().setValidateDefaults(false).parse("{  \"type\": \"record\",  \"name\": \"SomeThing\",  \"namespace\": \"com.acme.property\",  \"fields\": [    {      \"name\": \"f\",      \"type\": \"float\",      \"default\": [1.23]    }  ]}");
        AvroData avroData = new AvroData(0);
        org.apache.kafka.connect.data.Schema schema = avroData.toConnectSchema(avroSchema);
        Assert.assertNull((Object)schema.field("f").schema().defaultValue());
    }

    @Test
    public void testNestedRecordWithNullDefault() {
        String fullSchema = "{  \"name\": \"RecordWithObjectDefault\",  \"type\": \"record\",  \"fields\": [{    \"name\": \"obj\",      \"default\": {\"nullableString\": null},      \"type\": {        \"name\": \"Object\",        \"type\": \"record\",        \"fields\": [{            \"name\": \"nullableString\",            \"type\": [\"null\",\"string\"]}        ]}    }]}";
        Schema avroSchema = new Schema.Parser().parse("{  \"name\": \"RecordWithObjectDefault\",  \"type\": \"record\",  \"fields\": [{    \"name\": \"obj\",      \"default\": {\"nullableString\": null},      \"type\": {        \"name\": \"Object\",        \"type\": \"record\",        \"fields\": [{            \"name\": \"nullableString\",            \"type\": [\"null\",\"string\"]}        ]}    }]}");
        Schema innerSchema = new Schema.Parser().parse("{        \"name\": \"Object\",        \"type\": \"record\",        \"fields\": [{            \"name\": \"nullableString\",            \"type\": [\"null\",\"string\"]}        ]}");
        AvroData avroData = new AvroData(0);
        GenericData.Record nestedRecord = new GenericRecordBuilder(avroSchema).set("obj", (Object)new GenericRecordBuilder(innerSchema).set("nullableString", null).build()).build();
        SchemaAndValue schemaAndValue = avroData.toConnectData(avroSchema, (Object)nestedRecord);
        Struct value = (Struct)schemaAndValue.value();
        Assert.assertNotNull((Object)value.get("obj"));
        Struct objFieldValue = (Struct)value.get("obj");
        Assert.assertNull((Object)objFieldValue.get("nullableString"));
    }

    @Test
    public void testNestedRecordWithInvalidDefault() {
        String fullSchema = "{  \"name\": \"RecordWithObjectDefault\",  \"type\": \"record\",  \"fields\": [{    \"name\": \"obj\",      \"type\": {        \"name\": \"Object\",        \"type\": \"record\",        \"connect.default\": [1.23],        \"fields\": [{            \"name\": \"nullableString\",            \"type\": [\"null\",\"string\"]}        ]}    }]}";
        Schema avroSchema = new Schema.Parser().setValidateDefaults(false).parse("{  \"name\": \"RecordWithObjectDefault\",  \"type\": \"record\",  \"fields\": [{    \"name\": \"obj\",      \"type\": {        \"name\": \"Object\",        \"type\": \"record\",        \"connect.default\": [1.23],        \"fields\": [{            \"name\": \"nullableString\",            \"type\": [\"null\",\"string\"]}        ]}    }]}");
        Schema innerSchema = new Schema.Parser().parse("{        \"name\": \"Object\",        \"type\": \"record\",        \"fields\": [{            \"name\": \"nullableString\",            \"type\": [\"null\",\"string\"]}        ]}");
        AvroData avroData = new AvroData(0);
        GenericData.Record nestedRecord = new GenericRecordBuilder(avroSchema).set("obj", (Object)new GenericRecordBuilder(innerSchema).set("nullableString", null).build()).build();
        SchemaAndValue schemaAndValue = avroData.toConnectData(avroSchema, (Object)nestedRecord);
        Struct value = (Struct)schemaAndValue.value();
        Assert.assertNotNull((Object)value.get("obj"));
        Struct objFieldValue = (Struct)value.get("obj");
        Assert.assertNull((Object)objFieldValue.get("nullableString"));
    }

    @Test
    public void testArrayOfRecordWithNullNamespace() {
        Schema avroSchema = (Schema)org.apache.avro.SchemaBuilder.array().items().record("item").fields().name("value").type().intType().noDefault().endRecord();
        this.avroData.toConnectSchema(avroSchema);
    }

    @Test
    public void testLogicalTypeWithMatchingNameAndVersion() {
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Message\",\"namespace\":\"org.cmatta.kafka.connect.irc\",\"fields\":[{\"name\":\"createdat\",\"type\":{\"type\":\"long\",\"connect.doc\":\"When this message was received.\",\"connect.version\":1,\"connect.name\":\"org.apache.kafka.connect.data.Timestamp\",\"logicalType\":\"timestamp-millis\"}}]}");
        this.avroData.toConnectSchema(schema);
    }

    @Test(expected=DataException.class)
    public void testLogicalTypeWithMismatchingName() {
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Message\",\"namespace\":\"org.cmatta.kafka.connect.irc\",\"fields\":[{\"name\":\"createdat\",\"type\":{\"type\":\"long\",\"connect.doc\":\"When this message was received.\",\"connect.version\":1,\"connect.name\":\"com.custom.Timestamp\",\"logicalType\":\"timestamp-millis\"}}]}");
        this.avroData.toConnectSchema(schema);
    }

    @Test(expected=DataException.class)
    public void testLogicalTypeWithMismatchingVersion() {
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Message\",\"namespace\":\"org.cmatta.kafka.connect.irc\",\"fields\":[{\"name\":\"createdat\",\"type\":{\"type\":\"long\",\"connect.doc\":\"When this message was received.\",\"connect.version\":2,\"connect.name\":\"org.apache.kafka.connect.data.Timestamp\",\"logicalType\":\"timestamp-millis\"}}]}");
        this.avroData.toConnectSchema(schema);
    }

    @Test
    public void testCyclicalAvroSchema() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("connect.meta.data", (Object)false).with("enhanced.avro.schema.support", (Object)false).build();
        AvroData listAvroData = new AvroData(avroDataConfig);
        String linkedListAvroSchema = "{\"type\": \"record\",\"name\": \"linked_list\",\"fields\" : [{\"name\": \"value\", \"type\": \"long\"},{\"name\": \"next\", \"type\": [\"null\", \"linked_list\"],\"default\" : null}]}";
        Schema.Parser avroParser = new Schema.Parser();
        Schema avroSchema = avroParser.parse(linkedListAvroSchema);
        GenericData.Record next = new GenericRecordBuilder(avroSchema).set("value", (Object)2L).set("next", null).build();
        GenericData.Record headNode = new GenericRecordBuilder(avroSchema).set("value", (Object)3L).set("next", (Object)next).build();
        SchemaAndValue schemaAndValue = listAvroData.toConnectData(avroSchema, (Object)headNode);
        this.assertNonNullSchemaValue(schemaAndValue);
        Struct linkedListNode = (Struct)schemaAndValue.value();
        Assert.assertEquals((Object)3L, (Object)linkedListNode.get("value"));
        Assert.assertNotNull((Object)linkedListNode.get("next"));
        linkedListNode = (Struct)linkedListNode.get("next");
        Assert.assertEquals((Object)2L, (Object)linkedListNode.get("value"));
        Assert.assertNull((Object)linkedListNode.get("next"));
        GenericRecord genericRecord = (GenericRecord)listAvroData.fromConnectData(schemaAndValue.schema(), schemaAndValue.value());
        Assert.assertEquals((Object)headNode, (Object)genericRecord);
    }

    @Test
    public void testArrayCycle() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("connect.meta.data", (Object)false).with("enhanced.avro.schema.support", (Object)false).build();
        AvroData graphAvroData = new AvroData(avroDataConfig);
        Schema.Parser avroParser = new Schema.Parser();
        String graphAvroSchema = "{\"type\": \"record\",\"name\": \"Users\",\"fields\" : [{\"name\": \"name\", \"type\": \"string\"},{\"name\": \"friends\", \"type\" : [ \"null\", {\"type\": \"array\", \"items\":\"Users\"}], \"default\" : null}]}";
        Schema graphSchema = avroParser.parse(graphAvroSchema);
        Schema friendsListSchema = (Schema)graphSchema.getField("friends").schema().getTypes().get(1);
        GenericData.Record friend1 = new GenericRecordBuilder(graphSchema).set("name", (Object)"Person A").build();
        GenericData.Record friend2 = new GenericRecordBuilder(graphSchema).set("name", (Object)"Person B").set("friends", (Object)new GenericData.Array(friendsListSchema, Arrays.asList(friend1))).build();
        GenericData.Record person = new GenericRecordBuilder(graphSchema).set("name", (Object)"Person C").set("friends", (Object)new GenericData.Array(friendsListSchema, Arrays.asList(friend1, friend2))).build();
        SchemaAndValue schemaAndValue = graphAvroData.toConnectData(graphSchema, (Object)person);
        ImmutableMap expectedMap = ImmutableMap.of((Object)"Person C", Arrays.asList("Person A", "Person B"), (Object)"Person B", Arrays.asList("Person A"), (Object)"Person A", Arrays.asList(new String[0]));
        this.assertNonNullSchemaValue(schemaAndValue);
        this.assertPersons("Person C", schemaAndValue.value(), (Map<String, List<String>>)expectedMap);
        GenericRecord genericRecord = (GenericRecord)graphAvroData.fromConnectData(schemaAndValue.schema(), schemaAndValue.value());
        Assert.assertEquals((Object)person, (Object)genericRecord);
    }

    private void assertPersons(String currentPerson, Object value, Map<String, List<String>> expectedMap) {
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof Struct));
        Struct personStruct = (Struct)value;
        Assert.assertEquals((Object)currentPerson, (Object)personStruct.get("name"));
        if (expectedMap.containsKey(currentPerson) && expectedMap.get(currentPerson).size() > 0) {
            Assert.assertNotNull((Object)personStruct.get("friends"));
            Assert.assertTrue((boolean)(personStruct.get("friends") instanceof List));
            List friends = personStruct.getArray("friends");
            Assert.assertEquals((long)expectedMap.get(currentPerson).size(), (long)friends.size());
            for (int i = 0; i < friends.size(); ++i) {
                this.assertPersons(expectedMap.get(currentPerson).get(i), friends.get(i), expectedMap);
            }
        } else {
            Assert.assertNull((Object)personStruct.get("friends"));
        }
    }

    @Test
    public void testMapCycle() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("connect.meta.data", (Object)false).build();
        AvroData avroData = new AvroData(avroDataConfig);
        Schema.Parser avroParser = new Schema.Parser();
        String mapCycleSchema = "{\"type\": \"record\",\"name\": \"Node\",\"fields\" : [{\"name\": \"value\", \"type\": \"long\"},{\"name\": \"siblings\", \"type\" : [ \"null\", {\"type\": \"map\", \"values\":\"Node\"}], \"default\" : null}]}";
        Schema graphSchema = avroParser.parse(mapCycleSchema);
        GenericData.Record node1 = new GenericRecordBuilder(graphSchema).set("value", (Object)1L).build();
        GenericData.Record node2 = new GenericRecordBuilder(graphSchema).set("value", (Object)2L).set("siblings", (Object)ImmutableMap.of((Object)"node1", (Object)node1)).build();
        ImmutableMap siblings = ImmutableMap.of((Object)"node1", (Object)node1, (Object)"node2", (Object)node2);
        GenericData.Record person = new GenericRecordBuilder(graphSchema).set("value", (Object)3L).set("siblings", (Object)siblings).build();
        SchemaAndValue schemaAndValue = avroData.toConnectData(graphSchema, (Object)person);
        ImmutableMap expectedMap = ImmutableMap.of((Object)3L, (Object)ImmutableMap.of((Object)"node1", (Object)1L, (Object)"node2", (Object)2L), (Object)2L, (Object)ImmutableMap.of((Object)"node1", (Object)1L), (Object)1L, (Object)ImmutableMap.of());
        this.assertNonNullSchemaValue(schemaAndValue);
        this.assertMapCycle(3L, schemaAndValue.value(), (Map<Long, Map<String, Long>>)expectedMap);
        GenericRecord genericRecord = (GenericRecord)avroData.fromConnectData(schemaAndValue.schema(), schemaAndValue.value());
        Assert.assertEquals((Object)person, (Object)genericRecord);
    }

    private void assertMapCycle(Long current, Object value, Map<Long, Map<String, Long>> expectedMap) {
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof Struct));
        Struct struct = (Struct)value;
        Assert.assertEquals((Object)current, (Object)struct.get("value"));
        if (expectedMap.containsKey(current) && expectedMap.get(current).size() > 0) {
            Assert.assertNotNull((Object)struct.get("siblings"));
            Assert.assertTrue((boolean)(struct.get("siblings") instanceof Map));
            Map siblings = struct.getMap("siblings");
            Assert.assertEquals((long)expectedMap.get(current).size(), (long)siblings.size());
            Assert.assertTrue((boolean)expectedMap.get(current).keySet().equals(siblings.keySet()));
            for (Map.Entry<String, Long> entry : expectedMap.get(current).entrySet()) {
                this.assertMapCycle(entry.getValue(), siblings.get(entry.getKey()), expectedMap);
            }
        } else {
            Assert.assertNull((Object)struct.get("siblings"));
        }
    }

    private NonRecordContainer checkNonRecordConversion(Schema expectedSchema, Object expected, org.apache.kafka.connect.data.Schema schema, Object value, AvroData avroData) {
        Object converted = avroData.fromConnectData(schema, value);
        Assert.assertTrue((boolean)(converted instanceof NonRecordContainer));
        NonRecordContainer container = (NonRecordContainer)converted;
        Assert.assertEquals((Object)expectedSchema, (Object)container.getSchema());
        Assert.assertEquals((Object)expected, (Object)container.getValue());
        return container;
    }

    private NonRecordContainer checkNonRecordConversionNew(Schema expectedSchema, Object expected, org.apache.kafka.connect.data.Schema schema, Object value, AvroData avroData) {
        Object converted = avroData.fromConnectData(schema, value);
        Assert.assertTrue((boolean)(converted instanceof NonRecordContainer));
        NonRecordContainer container = (NonRecordContainer)converted;
        this.assertSchemaEquals(expectedSchema, container.getSchema());
        this.assertValueEquals(expected, container.getValue());
        return container;
    }

    private void checkNonRecordConversionNull(org.apache.kafka.connect.data.Schema schema) {
        Object converted = this.avroData.fromConnectData(schema, null);
        Assert.assertNull((Object)converted);
    }

    private void assertNonNullSchemaValue(SchemaAndValue schemaAndValue) {
        Assert.assertNotNull((Object)schemaAndValue);
        Assert.assertNotNull((Object)schemaAndValue.schema());
        Assert.assertNotNull((Object)schemaAndValue.value());
    }

    protected void assertSchemaEquals(Schema expected, Schema actual) {
        Assert.assertEquals((Object)expected.getObjectProps(), (Object)actual.getObjectProps());
        Assert.assertEquals((Object)expected.getLogicalType(), (Object)actual.getLogicalType());
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((Object)expected.getDoc(), (Object)actual.getDoc());
        Assert.assertEquals((Object)expected.getLogicalType(), (Object)actual.getLogicalType());
        switch (actual.getType()) {
            case UNION: {
                Assert.assertEquals((Object)expected.getTypes(), (Object)actual.getTypes());
                break;
            }
            case ENUM: {
                Assert.assertEquals((Object)expected.getEnumSymbols(), (Object)actual.getEnumSymbols());
                for (String symbol : actual.getEnumSymbols()) {
                    Assert.assertEquals((long)expected.getEnumOrdinal(symbol), (long)actual.getEnumOrdinal(symbol));
                }
                Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
                Assert.assertEquals((Object)expected.getNamespace(), (Object)actual.getNamespace());
                Assert.assertEquals((Object)expected.getFullName(), (Object)actual.getFullName());
                Assert.assertEquals((Object)expected.getAliases(), (Object)actual.getAliases());
                break;
            }
            case RECORD: {
                this.assertFieldEquals(expected.getFields(), actual.getFields());
                Assert.assertEquals((Object)expected.isError(), (Object)actual.isError());
                Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
                Assert.assertEquals((Object)expected.getNamespace(), (Object)actual.getNamespace());
                Assert.assertEquals((Object)expected.getFullName(), (Object)actual.getFullName());
                Assert.assertEquals((Object)expected.getAliases(), (Object)actual.getAliases());
                break;
            }
            case FIXED: {
                Assert.assertEquals((long)expected.getFixedSize(), (long)actual.getFixedSize());
                Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
                Assert.assertEquals((Object)expected.getNamespace(), (Object)actual.getNamespace());
                Assert.assertEquals((Object)expected.getFullName(), (Object)actual.getFullName());
                Assert.assertEquals((Object)expected.getAliases(), (Object)actual.getAliases());
                break;
            }
            case ARRAY: {
                Assert.assertEquals((Object)expected.getElementType(), (Object)actual.getElementType());
                break;
            }
        }
    }

    protected void assertFieldEquals(List<Schema.Field> expected, List<Schema.Field> actual) {
        Set expectedNames = expected.stream().map(f -> f.name()).collect(Collectors.toSet());
        Set actualNames = actual.stream().map(f -> f.name()).collect(Collectors.toSet());
        Assert.assertEquals(expectedNames, actualNames);
        for (int i = 0; i != actualNames.size(); ++i) {
            this.assertFieldEquals(expected.get(i), actual.get(i));
        }
    }

    protected void assertFieldEquals(Schema.Field expected, Schema.Field actual) {
        Assert.assertEquals((Object)expected.name(), (Object)actual.name());
        Assert.assertEquals((Object)expected.aliases(), (Object)actual.aliases());
        Assert.assertEquals((Object)expected.doc(), (Object)actual.doc());
        this.assertSchemaEquals(expected.schema(), actual.schema());
        Object expectedDef = expected.defaultVal();
        Object actualDef = actual.defaultVal();
        String msg = "Mismatched default value for field '" + expected.name() + "'";
        if (expectedDef == null) {
            Assert.assertNull((String)msg, (Object)actualDef);
            return;
        }
        switch (actual.schema().getType()) {
            case INT: 
            case LONG: {
                long expectedLong = ((Number)expectedDef).longValue();
                long actualLong = ((Number)actualDef).longValue();
                Assert.assertEquals((String)msg, (long)expectedLong, (long)actualLong);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                double expectedDouble = ((Number)expectedDef).doubleValue();
                double actualDouble = ((Number)actualDef).doubleValue();
                Assert.assertEquals((String)msg, (double)expectedDouble, (double)actualDouble, (double)(expectedDouble / 100.0));
                break;
            }
            case BYTES: {
                Assert.assertArrayEquals((String)msg, (byte[])((byte[])expectedDef), (byte[])((byte[])actualDef));
                break;
            }
            default: {
                Assert.assertEquals((String)msg, (Object)expectedDef, (Object)actualDef);
            }
        }
    }

    protected void assertValueEquals(Object expected, Object actual) {
        if (actual instanceof byte[]) {
            actual = ByteBuffer.wrap((byte[])actual);
        }
        if (expected instanceof byte[]) {
            expected = ByteBuffer.wrap((byte[])expected);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private JsonNode parameters(String key1, String v1) {
        return this.parametersFromConnect(Collections.singletonMap(key1, v1));
    }

    private JsonNode parametersFromConnect(Map<String, String> params) {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Test
    public void testUnionCycle() {
        String schemaStr = "{\n  \"type\": \"record\",\n  \"name\": \"Person\",\n  \"fields\": [\n    {\n      \"name\": \"name\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"follows\",\n      \"type\": [\n        \"null\",\n        \"string\",\n        \"Person\"\n      ]\n    }\n  ]\n}\n";
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("connect.meta.data", (Object)false).build();
        AvroData graphAvroData = new AvroData(avroDataConfig);
        Schema schema = graphAvroData.fromConnectSchema(graphAvroData.toConnectSchema(new Schema.Parser().parse(schemaStr)));
        Integer version = 1;
        GenericRecord person = this.getUnionCycleRecord(schema);
        SchemaAndValue sv = graphAvroData.toConnectData(schema, (Object)person, version);
        Assert.assertEquals((Object)sv, (Object)graphAvroData.toConnectData(schema, (Object)this.getUnionCycleRecord(schema), version));
        Assert.assertEquals((Object)person, (Object)graphAvroData.fromConnectData(sv.schema(), sv.value()));
    }

    private GenericRecord getUnionCycleRecord(Schema connectSchema) {
        GenericData.Record leader = new GenericRecordBuilder(connectSchema).set("name", (Object)"Leader").set("follows", null).build();
        GenericData.Record follower = new GenericRecordBuilder(connectSchema).set("name", (Object)"Follower").set("follows", (Object)leader).build();
        return follower;
    }

    @Test
    public void testRecordUnionSingleTypeCycle() {
        String schemaStr = "{\n  \"fields\": [\n    {\n      \"default\": \"\",\n      \"name\": \"field1\",\n      \"type\": [\n        \"string\"\n      ]\n    }\n  ],\n  \"name\": \"TestRecord\",\n  \"type\": \"record\"\n}";
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("connect.meta.data", (Object)false).build();
        AvroData testAvroData = new AvroData(avroDataConfig);
        Schema avroSchema = new Schema.Parser().parse(schemaStr);
        this.avroData.fromConnectSchema(testAvroData.toConnectSchema(avroSchema));
        Integer version = 1;
        GenericData.Record record = new GenericRecordBuilder(avroSchema).set("field1", (Object)"value1").build();
        SchemaAndValue sv = testAvroData.toConnectData(avroSchema, (Object)record, version);
        Assert.assertEquals((Object)sv, (Object)testAvroData.toConnectData(avroSchema, (Object)record, version));
        Assert.assertEquals((Object)record, (Object)testAvroData.fromConnectData(sv.schema(), sv.value()));
    }

    @Test
    public void testRecordUnionMultipleTypeCycle() {
        String schemaStr = "{\n  \"fields\": [\n    {\n      \"default\": \"\",\n      \"name\": \"field1\",\n      \"type\": [\n        \"string\",\n        \"int\",\n        \"float\"\n      ]\n    }\n  ],\n  \"name\": \"TestRecord\",\n  \"type\": \"record\"\n}";
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("connect.meta.data", (Object)false).build();
        AvroData testAvroData = new AvroData(avroDataConfig);
        Schema avroSchema = new Schema.Parser().parse(schemaStr);
        this.avroData.fromConnectSchema(testAvroData.toConnectSchema(avroSchema));
        Integer version = 1;
        GenericData.Record record = new GenericRecordBuilder(avroSchema).set("field1", (Object)"value1").build();
        SchemaAndValue sv = testAvroData.toConnectData(avroSchema, (Object)record, version);
        Assert.assertEquals((Object)sv, (Object)testAvroData.toConnectData(avroSchema, (Object)record, version));
        Assert.assertEquals((Object)record, (Object)testAvroData.fromConnectData(sv.schema(), sv.value()));
    }

    @Test
    public void testRecordDefaultAtFieldLevel() {
        String schemaStr = "{\n   \"name\": \"top\",\n   \"type\": \"record\",\n   \"fields\": [\n        {\n            \"default\": {},\n            \"name\": \"settlement\",\n            \"type\": {\n                \"fields\": [\n                    {\n                        \"default\": \"\",\n                        \"name\": \"time\",\n                        \"type\": \"string\"\n                    },\n                    {\n                        \"default\": 0,\n                        \"name\": \"cycle\",\n                        \"type\": \"int\"\n                    },\n                    {\n                        \"default\": \"\",\n                        \"name\": \"date\",\n                        \"type\": \"string\"\n                    },\n                    {\n                        \"default\": \"\",\n                        \"name\": \"priority\",\n                        \"type\": \"string\"\n                    }\n                ],\n                \"name\": \"settlement\",\n                \"type\": \"record\"\n            }\n        }\n    ] \n}";
        Schema avroSchema = new Schema.Parser().setValidateDefaults(true).parse(schemaStr);
        org.apache.kafka.connect.data.Schema schema = this.avroData.toConnectSchema(avroSchema);
        Assert.assertNotNull((Object)this.avroData.fromConnectSchema(schema));
    }

    static {
        EPOCH.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_DAYS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_TEN_THOUSAND_DAYS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_DAYS.add(5, 10000);
        EPOCH_PLUS_TEN_THOUSAND_MILLIS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.add(14, 10000);
        NAMED_MAP_SCHEMA = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).name("foo.bar").build();
        NAMED_AVRO_MAP_SCHEMA = (Schema)((SchemaBuilder.ArrayBuilder)org.apache.avro.SchemaBuilder.array().prop("connect.name", "foo.bar")).items((Schema)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)"foo.bar").prop("connect.internal.type", "MapEntry")).fields().optionalString("key").requiredInt("value").endRecord());
    }
}

