/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.avro;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.avro.AvroDataConfig;
import io.test.avro.core.AvroMessage;
import io.test.avro.doc.DocTestRecord;
import io.test.avro.union.FirstOption;
import io.test.avro.union.MultiTypeUnionMessage;
import io.test.avro.union.SecondOption;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.Union;
import org.apache.avro.specific.SpecificData;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.co.jemos.podam.api.PodamFactoryImpl;

public class AdditionalAvroDataTest {
    private AvroData avroData;

    @Before
    public void before() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("schemas.cache.config", (Object)1).with("connect.meta.data", (Object)false).with("enhanced.avro.schema.support", (Object)true).build();
        this.avroData = new AvroData(avroDataConfig);
    }

    @Test
    public void testDocumentationPreservedSchema() throws IOException {
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/DocTestRecord.avsc"));
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Schema outputAvroSchema = this.avroData.fromConnectSchema(connectSchema);
        Assert.assertEquals((Object)avroSchema, (Object)outputAvroSchema);
    }

    @Test
    public void testDocumentationPreservedData() throws IOException {
        PodamFactoryImpl factory = new PodamFactoryImpl();
        DocTestRecord testRecord = (DocTestRecord)((Object)factory.manufacturePojo(DocTestRecord.class, new Type[0]));
        SchemaAndValue connectSchemaAndValue = this.avroData.toConnectData(testRecord.getSchema(), (Object)testRecord);
        Object output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)testRecord), (Object)SpecificData.get().toString(output));
    }

    @Test
    public void testComplexUnionSchema() throws IOException {
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/AvroMessage.avsc"));
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Schema outputAvroSchema = this.avroData.fromConnectSchema(connectSchema);
        Assert.assertEquals((Object)avroSchema, (Object)outputAvroSchema);
    }

    @Test
    public void testComplexUnionData() throws IOException {
        PodamFactoryImpl factory = new PodamFactoryImpl();
        AvroMessage avroMessage = (AvroMessage)((Object)factory.manufacturePojo(AvroMessage.class, new Type[0]));
        SchemaAndValue connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        Object output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
    }

    @Test
    public void testComplexMultiUnionData() throws IOException {
        PodamFactoryImpl factory = new PodamFactoryImpl();
        MultiTypeUnionMessage avroMessage = (MultiTypeUnionMessage)((Object)factory.manufacturePojo(MultiTypeUnionMessage.class, new Type[0]));
        SchemaAndValue connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        Object output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
        avroMessage.setCompositeRecord((Object)new FirstOption("x", 2L));
        connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
        avroMessage.setCompositeRecord((Object)new SecondOption("y", 3L));
        connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
        avroMessage.setCompositeRecord(Arrays.asList("1", "2"));
        connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
    }

    @Test
    public void testNestedUnion() {
        Schema myAvroObjectSchema = new Schema.Parser().parse("{  \"type\" : \"record\",  \"name\" : \"MyObjectToPersist\",  \"namespace\" : \"io.confluent.connect.avro.AdditionalAvroDataTest\",  \"fields\" : [ {    \"name\" : \"obj\",    \"type\" : [ \"null\", {      \"type\" : \"record\",      \"name\" : \"MyImpl1\",      \"fields\" : [ {        \"name\" : \"data\",        \"type\" : [ \"null\", \"string\" ],        \"default\" : null      } ]    }, {      \"type\" : \"record\",      \"name\" : \"MyImpl2\",      \"fields\" : [ {        \"name\" : \"data\",        \"type\" : [ \"null\", \"string\" ],        \"default\" : null      } ]    } ],    \"default\" : null  } ]}");
        Schema myImpl1Schema = ReflectData.AllowNull.get().getSchema(MyImpl1.class);
        GenericData.Record nestedRecord = new GenericRecordBuilder(myImpl1Schema).set("data", (Object)"mydata").build();
        GenericData.Record obj = new GenericRecordBuilder(myAvroObjectSchema).set("obj", (Object)nestedRecord).build();
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(myAvroObjectSchema);
        SchemaAndValue schemaAndValue = this.avroData.toConnectData(myAvroObjectSchema, (Object)obj);
        Object o = this.avroData.fromConnectData(schemaAndValue.schema(), schemaAndValue.value());
        Assert.assertEquals((Object)obj, (Object)o);
        this.avroData.fromConnectSchema(connectSchema);
    }

    @Test
    public void testRecordDefault() {
        Schema myAvroObjectSchema = new Schema.Parser().parse("{  \"type\" : \"record\",  \"name\" : \"MyRecord\",  \"namespace\" : \"io.confluent.connect.avro.AdditionalAvroDataTest\",  \"fields\" : [ {    \"name\" : \"obj\",    \"type\" : {      \"name\" : \"obj2\",      \"type\" : \"record\",      \"fields\" : [ {        \"name\" : \"data\",        \"type\" : \"string\",        \"default\" : \"\"      } ]    },    \"default\" : { \"data\" : \"\" }  } ]}");
        GenericData.Record obj = new GenericRecordBuilder(myAvroObjectSchema).build();
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(myAvroObjectSchema);
        SchemaAndValue schemaAndValue = this.avroData.toConnectData(myAvroObjectSchema, (Object)obj);
        Object o = this.avroData.fromConnectData(schemaAndValue.schema(), schemaAndValue.value());
        Assert.assertEquals((Object)obj, (Object)o);
        this.avroData.fromConnectSchema(connectSchema);
    }

    @Test
    public void testFieldRecordEnumDocumentationSchema() throws IOException {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("schemas.cache.config", (Object)1).with("connect.meta.data", (Object)true).with("enhanced.avro.schema.support", (Object)true).build();
        this.avroData = new AvroData(avroDataConfig);
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/RepeatedTypeWithDocFull.avsc"));
        Assert.assertEquals((Object)avroSchema.getField("enumField").schema(), (Object)avroSchema.getField("anotherEnumField").schema());
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Schema outputAvroSchema = this.avroData.fromConnectSchema(connectSchema);
        Assert.assertEquals((Object)"record's doc", (Object)outputAvroSchema.getDoc());
        Assert.assertEquals((Object)"field's doc", (Object)outputAvroSchema.getField("stringField").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("stringField").schema().getDoc());
        Assert.assertNull((Object)outputAvroSchema.getField("anotherStringField").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("anotherStringField").schema().getDoc());
        Assert.assertEquals((Object)"record field's doc", (Object)outputAvroSchema.getField("recordField").doc());
        Assert.assertEquals((Object)"nested record's doc", (Object)outputAvroSchema.getField("recordField").schema().getDoc());
        Assert.assertEquals((Object)"nested record field's doc", (Object)outputAvroSchema.getField("recordField").schema().getField("nestedRecordField").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("recordField").schema().getField("nestedRecordField").schema().getDoc());
        Assert.assertNull((Object)outputAvroSchema.getField("recordField").schema().getField("anotherNestedRecordField").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("recordField").schema().getField("anotherNestedRecordField").schema().getDoc());
        Assert.assertEquals((Object)"another record field's doc", (Object)outputAvroSchema.getField("anotherRecordField").doc());
        Assert.assertEquals((Object)"nested record's doc", (Object)outputAvroSchema.getField("anotherRecordField").schema().getDoc());
        Assert.assertEquals((Object)"nested record field's doc", (Object)outputAvroSchema.getField("anotherRecordField").schema().getField("nestedRecordField").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("anotherRecordField").schema().getField("nestedRecordField").schema().getDoc());
        Assert.assertNull((Object)outputAvroSchema.getField("anotherRecordField").schema().getField("anotherNestedRecordField").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("anotherRecordField").schema().getField("anotherNestedRecordField").schema().getDoc());
        Assert.assertNull((Object)outputAvroSchema.getField("recordFieldWithoutDoc").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("doclessRecordField").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("doclessRecordField").schema().getDoc());
        Assert.assertEquals((Object)"docless record field's doc", (Object)outputAvroSchema.getField("doclessRecordFieldWithDoc").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("doclessRecordFieldWithDoc").schema().getDoc());
        Assert.assertEquals((Object)"enum field's doc", (Object)outputAvroSchema.getField("enumField").doc());
        Assert.assertEquals((Object)"enum's doc", (Object)outputAvroSchema.getField("enumField").schema().getDoc());
        Assert.assertEquals((Object)"another enum field's doc", (Object)outputAvroSchema.getField("anotherEnumField").doc());
        Assert.assertEquals((Object)"enum's doc", (Object)outputAvroSchema.getField("anotherEnumField").schema().getDoc());
        Assert.assertNull((Object)outputAvroSchema.getField("doclessEnumField").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("diffEnumField").doc());
        Assert.assertEquals((Object)"diffEnum's doc", (Object)outputAvroSchema.getField("diffEnumField").schema().getDoc());
        Assert.assertEquals((Object)outputAvroSchema.getField("stringField").schema(), (Object)outputAvroSchema.getField("anotherStringField").schema());
        Assert.assertEquals((Object)outputAvroSchema.getField("recordField").schema(), (Object)outputAvroSchema.getField("anotherRecordField").schema());
        Assert.assertEquals((Object)outputAvroSchema.getField("recordField").schema(), (Object)outputAvroSchema.getField("recordFieldWithoutDoc").schema());
        Assert.assertEquals((Object)outputAvroSchema.getField("doclessRecordField").schema(), (Object)outputAvroSchema.getField("doclessRecordFieldWithDoc").schema());
        Assert.assertEquals((Object)outputAvroSchema.getField("enumField").schema(), (Object)outputAvroSchema.getField("anotherEnumField").schema());
        Assert.assertEquals((Object)outputAvroSchema.getField("enumField").schema(), (Object)outputAvroSchema.getField("doclessEnumField").schema());
    }

    @Test
    public void testRepeatedTypeWithDefault() throws IOException {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("schemas.cache.config", (Object)1).with("connect.meta.data", (Object)true).with("enhanced.avro.schema.support", (Object)true).build();
        this.avroData = new AvroData(avroDataConfig);
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/RepeatedTypeWithDefault.avsc"));
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Schema outputAvroSchema = this.avroData.fromConnectSchema(connectSchema);
        Assert.assertEquals((Object)"field's default", (Object)outputAvroSchema.getField("stringField").defaultVal());
        Assert.assertEquals(null, (Object)outputAvroSchema.getField("anotherStringField").defaultVal());
        Assert.assertEquals((Object)"ONE", (Object)outputAvroSchema.getField("enumField").defaultVal());
        Assert.assertEquals((Object)"TWO", (Object)outputAvroSchema.getField("anotherEnumField").defaultVal());
        Assert.assertEquals((Object)"B", (Object)outputAvroSchema.getField("enumFieldWithDiffDefault").defaultVal());
        Assert.assertEquals((Object)"A", (Object)outputAvroSchema.getField("enumFieldWithDiffDefault").schema().getEnumDefault());
        Assert.assertEquals((Object)Float.valueOf(9.18f), (Object)outputAvroSchema.getField("floatField").defaultVal());
        Assert.assertEquals((Object)outputAvroSchema.getField("enumField").schema(), (Object)outputAvroSchema.getField("anotherEnumField").schema());
        Assert.assertEquals((Object)outputAvroSchema.getField("stringField").schema(), (Object)outputAvroSchema.getField("anotherStringField").schema());
    }

    @Test
    public void testRepeatedTypeWithDefaultWithoutConnectMetaData() throws IOException {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("schemas.cache.config", (Object)1).with("connect.meta.data", (Object)false).with("enhanced.avro.schema.support", (Object)true).build();
        this.avroData = new AvroData(avroDataConfig);
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/RepeatedTypeWithDefault.avsc"));
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Assert.assertNull((Object)connectSchema.field("stringField").schema().parameters());
        Assert.assertFalse((boolean)connectSchema.field("enumFieldWithDiffDefault").schema().parameters().containsKey("io.confluent.connect.avro.field.default"));
        Schema outputAvroSchema = this.avroData.fromConnectSchema(connectSchema);
        Assert.assertEquals((Object)"B", (Object)outputAvroSchema.getField("enumFieldWithDiffDefault").defaultVal());
        Assert.assertNull((Object)outputAvroSchema.getField("enumFieldWithDiffDefault").schema().getEnumDefault());
    }

    @Test
    public void testArrayOfRecordsWithDefaultValue() throws IOException {
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/ArrayOfRecordsWithDefault.avsc"));
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Object object = connectSchema.field("records").schema().defaultValue();
        Assert.assertTrue((boolean)(object instanceof List));
        List arrayList = (List)object;
        Assert.assertEquals((long)arrayList.size(), (long)2L);
        Struct item1 = (Struct)arrayList.get(0);
        Assert.assertEquals((Object)item1.get("itemName"), (Object)"item1");
        Assert.assertEquals((Object)item1.get("itemValue"), (Object)"value1");
        Struct item2 = (Struct)arrayList.get(1);
        Assert.assertEquals((Object)item2.get("itemName"), (Object)"item2");
        Assert.assertEquals((Object)item2.get("itemValue"), (Object)"value2");
    }

    @Test
    public void testDiscardTypeDoc() throws IOException {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("schemas.cache.config", (Object)1).with("connect.meta.data", (Object)true).with("enhanced.avro.schema.support", (Object)true).with("discard.type.doc.default", (Object)true).build();
        this.avroData = new AvroData(avroDataConfig);
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/RepeatedTypeWithDocFull.avsc"));
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Assert.assertEquals((Object)"field's doc", (Object)connectSchema.field("stringField").schema().doc());
        Assert.assertNull((Object)connectSchema.field("anotherStringField").schema().doc());
        Assert.assertEquals((Object)"record field's doc", (Object)connectSchema.field("recordField").schema().doc());
        Assert.assertEquals((Object)"nested record field's doc", (Object)connectSchema.field("recordField").schema().field("nestedRecordField").schema().doc());
        Assert.assertEquals((Object)"another record field's doc", (Object)connectSchema.field("anotherRecordField").schema().doc());
        Assert.assertEquals((Object)"nested record's doc", (Object)connectSchema.field("recordFieldWithoutDoc").schema().doc());
        Assert.assertEquals((Object)"enum field's doc", (Object)connectSchema.field("enumField").schema().doc());
        Assert.assertEquals((Object)"another enum field's doc", (Object)connectSchema.field("anotherEnumField").schema().doc());
        Assert.assertEquals((Object)"diffEnum's doc", (Object)connectSchema.field("diffEnumField").schema().doc());
        Schema outputAvroSchema = this.avroData.fromConnectSchema(connectSchema);
        Assert.assertEquals((Object)"field's doc", (Object)outputAvroSchema.getField("stringField").doc());
        Assert.assertNull((Object)outputAvroSchema.getField("anotherStringField").doc());
        Assert.assertEquals((Object)"record field's doc", (Object)outputAvroSchema.getField("recordField").doc());
        Assert.assertEquals((Object)"nested record's doc", (Object)outputAvroSchema.getField("recordField").schema().getDoc());
        Assert.assertEquals((Object)"nested record field's doc", (Object)outputAvroSchema.getField("recordField").schema().getField("nestedRecordField").doc());
        Assert.assertEquals((Object)"another record field's doc", (Object)outputAvroSchema.getField("anotherRecordField").doc());
        Assert.assertEquals((String)"Nested record's type doc populate to field doc", (Object)"nested record's doc", (Object)outputAvroSchema.getField("recordFieldWithoutDoc").doc());
        Assert.assertEquals((Object)"enum field's doc", (Object)outputAvroSchema.getField("enumField").doc());
        Assert.assertEquals((Object)"enum's doc", (Object)outputAvroSchema.getField("enumField").schema().getDoc());
        Assert.assertEquals((Object)"another enum field's doc", (Object)outputAvroSchema.getField("anotherEnumField").doc());
        Assert.assertEquals((String)"Enum's type doc populate to field doc", (Object)"enum's doc", (Object)outputAvroSchema.getField("doclessEnumField").doc());
    }

    @Test
    public void testDiscardTypeDefault() throws IOException {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("schemas.cache.config", (Object)1).with("connect.meta.data", (Object)true).with("enhanced.avro.schema.support", (Object)true).with("discard.type.doc.default", (Object)true).build();
        this.avroData = new AvroData(avroDataConfig);
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/RepeatedTypeWithDefault.avsc"));
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Assert.assertEquals((Object)"field's default", (Object)connectSchema.field("stringField").schema().defaultValue());
        Assert.assertNull((Object)connectSchema.field("anotherStringField").schema().defaultValue());
        Assert.assertEquals((Object)Float.valueOf(9.18f), (Object)connectSchema.field("floatField").schema().defaultValue());
        Assert.assertEquals((Object)"ONE", (Object)connectSchema.field("enumField").schema().defaultValue());
        Assert.assertEquals((Object)"TWO", (Object)connectSchema.field("anotherEnumField").schema().defaultValue());
        Assert.assertEquals((Object)"B", (Object)connectSchema.field("enumFieldWithDiffDefault").schema().defaultValue());
        Assert.assertNull((Object)connectSchema.field("enumFieldWithoutDefault").schema().defaultValue());
        Schema outputAvroSchema = this.avroData.fromConnectSchema(connectSchema);
        Assert.assertEquals((Object)"field's default", (Object)outputAvroSchema.getField("stringField").defaultVal());
        Assert.assertNull((Object)outputAvroSchema.getField("anotherStringField").defaultVal());
        Assert.assertEquals((Object)Float.valueOf(9.18f), (Object)outputAvroSchema.getField("floatField").defaultVal());
        Assert.assertEquals((Object)"ONE", (Object)outputAvroSchema.getField("enumField").defaultVal());
        Assert.assertEquals((Object)"TWO", (Object)outputAvroSchema.getField("anotherEnumField").defaultVal());
        Assert.assertEquals((Object)"B", (Object)outputAvroSchema.getField("enumFieldWithDiffDefault").defaultVal());
        Assert.assertNull((String)"Enum's type default will be dropped", (Object)outputAvroSchema.getField("enumFieldWithDiffDefault").schema().getEnumDefault());
        Assert.assertNull((Object)outputAvroSchema.getField("enumFieldWithoutDefault").defaultVal());
    }

    static class MyObjectToPersist {
        private MyInterface obj;

        MyObjectToPersist() {
        }
    }

    static class MyImpl2
    implements MyInterface {
        private String data;

        MyImpl2() {
        }
    }

    static class MyImpl1
    implements MyInterface {
        private String data;

        MyImpl1() {
        }
    }

    @Union(value={MyImpl1.class, MyImpl2.class})
    static interface MyInterface {
    }
}

