/*
 * Decompiled with CFR 0.152.
 */
package io.test.trade.v1.common.contingent;

import io.test.trade.v1.Id;
import io.test.trade.v1.common.contingent.StopValueType;
import io.test.trade.v1.common.contingent.TrailingStop;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Stop
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -179795393719464122L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Stop\",\"namespace\":\"io.test.trade.v1.common.contingent\",\"fields\":[{\"name\":\"value\",\"type\":\"double\",\"doc\":\"Stop value can be expressed either as a Level or Distance. Use this field in conjunction with valueType\"},{\"name\":\"valueType\",\"type\":{\"type\":\"enum\",\"name\":\"StopValueType\",\"symbols\":[\"DISTANCE\",\"LEVEL\"]},\"doc\":\"Represents the unit in which the stop value is expressed\"},{\"name\":\"isGuaranteed\",\"type\":\"boolean\",\"default\":false},{\"name\":\"lrPremium\",\"type\":[\"null\",\"double\"],\"doc\":\"This field represents a multiplier to be applied to the trade's size to derive a limited risk fee (LR Fee). The LR fee is a monetary amount and is expressed in the currency of the order.\",\"default\":null},{\"name\":\"trailingStop\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"TrailingStop\",\"fields\":[{\"name\":\"distance\",\"type\":\"double\",\"default\":0.0},{\"name\":\"increment\",\"type\":\"double\",\"default\":0.0}]}],\"default\":null},{\"name\":\"orderIds\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Id\",\"namespace\":\"io.test.trade.v1\",\"doc\":\"Id of an order or position.\",\"fields\":[{\"name\":\"source\",\"type\":{\"type\":\"enum\",\"name\":\"Source\",\"symbols\":[\"ORDER_SERVER\",\"CLIENT\",\"UNIVERSE\",\"L2\",\"L2_CHAIN\",\"EXCHANGE\",\"UNIVERSE_ATTR\",\"UNDEFINED\"]}},{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}}],\"doc\":\"Ids identifying this stop.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Stop> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Stop> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double value;
    @Deprecated
    public StopValueType valueType;
    @Deprecated
    public boolean isGuaranteed;
    @Deprecated
    public Double lrPremium;
    @Deprecated
    public TrailingStop trailingStop;
    @Deprecated
    public List<Id> orderIds;
    private static final DatumWriter<Stop> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Stop> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<Stop> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<Stop> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Stop> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Stop fromByteBuffer(ByteBuffer b) throws IOException {
        return (Stop)((Object)DECODER.decode(b));
    }

    public Stop() {
    }

    public Stop(Double value, StopValueType valueType, Boolean isGuaranteed, Double lrPremium, TrailingStop trailingStop, List<Id> orderIds) {
        this.value = value;
        this.valueType = valueType;
        this.isGuaranteed = isGuaranteed;
        this.lrPremium = lrPremium;
        this.trailingStop = trailingStop;
        this.orderIds = orderIds;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.value;
            }
            case 1: {
                return this.valueType;
            }
            case 2: {
                return this.isGuaranteed;
            }
            case 3: {
                return this.lrPremium;
            }
            case 4: {
                return this.trailingStop;
            }
            case 5: {
                return this.orderIds;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.value = (Double)value$;
                break;
            }
            case 1: {
                this.valueType = (StopValueType)((Object)value$);
                break;
            }
            case 2: {
                this.isGuaranteed = (Boolean)value$;
                break;
            }
            case 3: {
                this.lrPremium = (Double)value$;
                break;
            }
            case 4: {
                this.trailingStop = (TrailingStop)((Object)value$);
                break;
            }
            case 5: {
                this.orderIds = (List)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public StopValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(StopValueType value) {
        this.valueType = value;
    }

    public boolean getIsGuaranteed() {
        return this.isGuaranteed;
    }

    public void setIsGuaranteed(boolean value) {
        this.isGuaranteed = value;
    }

    public Double getLrPremium() {
        return this.lrPremium;
    }

    public void setLrPremium(Double value) {
        this.lrPremium = value;
    }

    public TrailingStop getTrailingStop() {
        return this.trailingStop;
    }

    public void setTrailingStop(TrailingStop value) {
        this.trailingStop = value;
    }

    public List<Id> getOrderIds() {
        return this.orderIds;
    }

    public void setOrderIds(List<Id> value) {
        this.orderIds = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(Stop other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.value);
        out.writeEnum(this.valueType.ordinal());
        out.writeBoolean(this.isGuaranteed);
        if (this.lrPremium == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.lrPremium.doubleValue());
        }
        if (this.trailingStop == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            this.trailingStop.customEncode(out);
        }
        if (this.orderIds == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.orderIds.size();
            out.writeArrayStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (Id e0 : this.orderIds) {
                ++actualSize0;
                out.startItem();
                e0.customEncode(out);
            }
            out.writeArrayEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.value = in.readDouble();
            this.valueType = StopValueType.values()[in.readEnum()];
            this.isGuaranteed = in.readBoolean();
            if (in.readIndex() != 1) {
                in.readNull();
                this.lrPremium = null;
            } else {
                this.lrPremium = in.readDouble();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.trailingStop = null;
            } else {
                if (this.trailingStop == null) {
                    this.trailingStop = new TrailingStop();
                }
                this.trailingStop.customDecode(in);
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.orderIds = null;
            } else {
                GenericData.Array ga0;
                long size0 = in.readArrayStart();
                GenericData.Array a0 = this.orderIds;
                if (a0 == null) {
                    this.orderIds = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("orderIds").schema().getTypes().get(1));
                } else {
                    a0.clear();
                }
                GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                while (0L < size0) {
                    while (size0 != 0L) {
                        Id e0;
                        Id id = e0 = ga0 != null ? (Id)((Object)ga0.peek()) : null;
                        if (e0 == null) {
                            e0 = new Id();
                        }
                        e0.customDecode(in);
                        a0.add(e0);
                        --size0;
                    }
                    size0 = in.arrayNext();
                }
            }
        } else {
            block10: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.value = in.readDouble();
                        continue block10;
                    }
                    case 1: {
                        this.valueType = StopValueType.values()[in.readEnum()];
                        continue block10;
                    }
                    case 2: {
                        this.isGuaranteed = in.readBoolean();
                        continue block10;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lrPremium = null;
                            continue block10;
                        }
                        this.lrPremium = in.readDouble();
                        continue block10;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.trailingStop = null;
                            continue block10;
                        }
                        if (this.trailingStop == null) {
                            this.trailingStop = new TrailingStop();
                        }
                        this.trailingStop.customDecode(in);
                        continue block10;
                    }
                    case 5: {
                        GenericData.Array ga0;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.orderIds = null;
                            continue block10;
                        }
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.orderIds;
                        if (a0 == null) {
                            this.orderIds = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("orderIds").schema().getTypes().get(1));
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                Id e0;
                                Id id = e0 = ga0 != null ? (Id)((Object)ga0.peek()) : null;
                                if (e0 == null) {
                                    e0 = new Id();
                                }
                                e0.customDecode(in);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<Stop>
    implements RecordBuilder<Stop> {
        private double value;
        private StopValueType valueType;
        private boolean isGuaranteed;
        private Double lrPremium;
        private TrailingStop trailingStop;
        private TrailingStop.Builder trailingStopBuilder;
        private List<Id> orderIds;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.valueType))) {
                this.valueType = (StopValueType)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.valueType));
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.isGuaranteed)) {
                this.isGuaranteed = (Boolean)this.data().deepCopy(this.fields()[2].schema(), (Object)other.isGuaranteed);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.lrPremium)) {
                this.lrPremium = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.lrPremium);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.trailingStop))) {
                this.trailingStop = (TrailingStop)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.trailingStop));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (other.hasTrailingStopBuilder()) {
                this.trailingStopBuilder = TrailingStop.newBuilder(other.getTrailingStopBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], other.orderIds)) {
                this.orderIds = (List)this.data().deepCopy(this.fields()[5].schema(), other.orderIds);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(Stop other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.valueType))) {
                this.valueType = (StopValueType)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.valueType));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.isGuaranteed)) {
                this.isGuaranteed = (Boolean)this.data().deepCopy(this.fields()[2].schema(), (Object)other.isGuaranteed);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.lrPremium)) {
                this.lrPremium = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.lrPremium);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.trailingStop))) {
                this.trailingStop = (TrailingStop)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.trailingStop));
                this.fieldSetFlags()[4] = true;
            }
            this.trailingStopBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[5], other.orderIds)) {
                this.orderIds = (List)this.data().deepCopy(this.fields()[5].schema(), other.orderIds);
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getValue() {
            return this.value;
        }

        public Builder setValue(double value) {
            this.validate(this.fields()[0], value);
            this.value = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearValue() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public StopValueType getValueType() {
            return this.valueType;
        }

        public Builder setValueType(StopValueType value) {
            this.validate(this.fields()[1], (Object)value);
            this.valueType = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasValueType() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearValueType() {
            this.valueType = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public boolean getIsGuaranteed() {
            return this.isGuaranteed;
        }

        public Builder setIsGuaranteed(boolean value) {
            this.validate(this.fields()[2], value);
            this.isGuaranteed = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasIsGuaranteed() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearIsGuaranteed() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Double getLrPremium() {
            return this.lrPremium;
        }

        public Builder setLrPremium(Double value) {
            this.validate(this.fields()[3], value);
            this.lrPremium = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasLrPremium() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearLrPremium() {
            this.lrPremium = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public TrailingStop getTrailingStop() {
            return this.trailingStop;
        }

        public Builder setTrailingStop(TrailingStop value) {
            this.validate(this.fields()[4], (Object)value);
            this.trailingStopBuilder = null;
            this.trailingStop = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasTrailingStop() {
            return this.fieldSetFlags()[4];
        }

        public TrailingStop.Builder getTrailingStopBuilder() {
            if (this.trailingStopBuilder == null) {
                if (this.hasTrailingStop()) {
                    this.setTrailingStopBuilder(TrailingStop.newBuilder(this.trailingStop));
                } else {
                    this.setTrailingStopBuilder(TrailingStop.newBuilder());
                }
            }
            return this.trailingStopBuilder;
        }

        public Builder setTrailingStopBuilder(TrailingStop.Builder value) {
            this.clearTrailingStop();
            this.trailingStopBuilder = value;
            return this;
        }

        public boolean hasTrailingStopBuilder() {
            return this.trailingStopBuilder != null;
        }

        public Builder clearTrailingStop() {
            this.trailingStop = null;
            this.trailingStopBuilder = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public List<Id> getOrderIds() {
            return this.orderIds;
        }

        public Builder setOrderIds(List<Id> value) {
            this.validate(this.fields()[5], value);
            this.orderIds = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasOrderIds() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearOrderIds() {
            this.orderIds = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Stop build() {
            try {
                Stop record = new Stop();
                record.value = this.fieldSetFlags()[0] ? this.value : (Double)this.defaultValue(this.fields()[0]);
                record.valueType = this.fieldSetFlags()[1] ? this.valueType : (StopValueType)((Object)this.defaultValue(this.fields()[1]));
                record.isGuaranteed = this.fieldSetFlags()[2] ? this.isGuaranteed : (Boolean)this.defaultValue(this.fields()[2]);
                Double d = record.lrPremium = this.fieldSetFlags()[3] ? this.lrPremium : (Double)this.defaultValue(this.fields()[3]);
                if (this.trailingStopBuilder != null) {
                    try {
                        record.trailingStop = this.trailingStopBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("trailingStop"));
                        throw e;
                    }
                } else {
                    record.trailingStop = this.fieldSetFlags()[4] ? this.trailingStop : (TrailingStop)((Object)this.defaultValue(this.fields()[4]));
                }
                record.orderIds = this.fieldSetFlags()[5] ? this.orderIds : (List)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

