/*
 * Decompiled with CFR 0.152.
 */
package io.test.trade.v1.common.dma;

import io.test.trade.v1.Id;
import io.test.trade.v1.common.Size;
import io.test.trade.v1.common.TimeInForce;
import io.test.trade.v1.common.dma.ExecType;
import io.test.trade.v1.common.dma.Fills;
import io.test.trade.v1.common.dma.OrderType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Order
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1192881718228845777L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Order\",\"namespace\":\"io.test.trade.v1.common.dma\",\"fields\":[{\"name\":\"pseudoPositionId\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Id\",\"namespace\":\"io.test.trade.v1\",\"doc\":\"Id of an order or position.\",\"fields\":[{\"name\":\"source\",\"type\":{\"type\":\"enum\",\"name\":\"Source\",\"symbols\":[\"ORDER_SERVER\",\"CLIENT\",\"UNIVERSE\",\"L2\",\"L2_CHAIN\",\"EXCHANGE\",\"UNIVERSE_ATTR\",\"UNDEFINED\"]}},{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}],\"doc\":\"Represents ID of position created by a partially filled DMA order.\",\"default\":null},{\"name\":\"orderType\",\"type\":{\"type\":\"enum\",\"name\":\"OrderType\",\"symbols\":[\"MARKET\",\"LIMIT\",\"STOP\",\"STOP_LIMIT\",\"MARKET_ON_CLOSE\",\"WITH_OR_WITHOUT\",\"LIMIT_OR_BETTER\",\"LIMIT_WITH_OR_WITHOUT\",\"ON_BASIS\",\"ON_CLOSE\",\"LIMIT_ON_CLOSE\",\"FOREX_MARKET\",\"PREVIOUSLY_QUOTED\",\"PREVIOUSLY_INDICATED\",\"FOREX_LIMIT\",\"PEGGED\",\"TRADE_REPORT\",\"FAST_BINARY\",\"UNKNOWN\"]}},{\"name\":\"timeInForce\",\"type\":{\"type\":\"enum\",\"name\":\"TimeInForce\",\"namespace\":\"io.test.trade.v1.common\",\"symbols\":[\"DAY\",\"GOOD_TILL_CANCEL\",\"AT_THE_OPENING\",\"IMMEDIATE_OR_CANCEL\",\"FILL_OR_KILL\",\"GOOD_TILL_CROSSING\",\"GOOD_TILL_DATE\",\"AT_THE_CLOSE\",\"DAY_ALL_SESSIONS\"]}},{\"name\":\"originalSize\",\"type\":{\"type\":\"record\",\"name\":\"Size\",\"namespace\":\"io.test.trade.v1.common\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]},\"doc\":\"The original size on a DMA working order. This is in display terms and does not include lotSize\"},{\"name\":\"fills\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Fills\",\"fields\":[{\"name\":\"aggregatedFill\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"AggregatedFill\",\"doc\":\"Aggregated information of fills received per hedge account\",\"fields\":[{\"name\":\"hedgeAccountId\",\"type\":{\"type\":\"record\",\"name\":\"Id\",\"namespace\":\"io.test.trade.v1.common.account\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}},{\"name\":\"averageLevel\",\"type\":{\"type\":\"record\",\"name\":\"Level\",\"namespace\":\"io.test.trade.v1.common\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]},\"doc\":\"A volume-weighted-average level of all fills originating from this hedge account\"},{\"name\":\"totalSize\",\"type\":\"io.test.trade.v1.common.Size\",\"doc\":\"Total size of all fills received from this hedge account\"},{\"name\":\"averageExchangeFee\",\"type\":\"double\",\"doc\":\"The fee is expressed in account's currency.\"}]}}],\"doc\":\"A collection of DMA fills aggregated per hedge account\",\"default\":null},{\"name\":\"updateType\",\"type\":{\"type\":\"enum\",\"name\":\"FillsUpdateType\",\"symbols\":[\"ADD\",\"COPY\",\"DELETE_ALL\"]},\"default\":\"COPY\"},{\"name\":\"nextWorkingOrderId\",\"type\":[\"null\",\"io.test.trade.v1.Id\"],\"default\":null}]}],\"default\":null},{\"name\":\"isDMAInteractable\",\"type\":\"boolean\",\"default\":true},{\"name\":\"executionPricePreference\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"ExecType\",\"symbols\":[\"ASK\",\"BID\"]}],\"doc\":\"Called executionInstruction in current schema. This field represents DMA FX Stop Order execution price preference, could be either empty, ASK(0) or BID(9) and indicates whether one's order gets executed closer to the Bid or Ask side compared to the specified order direction.\",\"default\":null},{\"name\":\"uvOrderId\",\"type\":[\"null\",\"io.test.trade.v1.Id\"],\"default\":null},{\"name\":\"isPseudoPosition\",\"type\":\"boolean\",\"doc\":\"Is this position a partial fill for a DMA order?\",\"default\":false},{\"name\":\"nextPseudoPositionId\",\"type\":[\"null\",\"io.test.trade.v1.Id\"],\"doc\":\"In a DMA amend scenario, the id of a pseudo-position changes and this field indicates the new pseudo position id.\",\"default\":null}]}");
    @Deprecated
    public Id pseudoPositionId;
    @Deprecated
    public OrderType orderType;
    @Deprecated
    public TimeInForce timeInForce;
    @Deprecated
    public Size originalSize;
    @Deprecated
    public Fills fills;
    @Deprecated
    public boolean isDMAInteractable;
    @Deprecated
    public ExecType executionPricePreference;
    @Deprecated
    public Id uvOrderId;
    @Deprecated
    public boolean isPseudoPosition;
    @Deprecated
    public Id nextPseudoPositionId;
    private static final DatumWriter WRITER$ = new SpecificDatumWriter(SCHEMA$);
    private static final DatumReader READER$ = new SpecificDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public Order() {
    }

    public Order(Id pseudoPositionId, OrderType orderType, TimeInForce timeInForce, Size originalSize, Fills fills, Boolean isDMAInteractable, ExecType executionPricePreference, Id uvOrderId, Boolean isPseudoPosition, Id nextPseudoPositionId) {
        this.pseudoPositionId = pseudoPositionId;
        this.orderType = orderType;
        this.timeInForce = timeInForce;
        this.originalSize = originalSize;
        this.fills = fills;
        this.isDMAInteractable = isDMAInteractable;
        this.executionPricePreference = executionPricePreference;
        this.uvOrderId = uvOrderId;
        this.isPseudoPosition = isPseudoPosition;
        this.nextPseudoPositionId = nextPseudoPositionId;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.pseudoPositionId;
            }
            case 1: {
                return this.orderType;
            }
            case 2: {
                return this.timeInForce;
            }
            case 3: {
                return this.originalSize;
            }
            case 4: {
                return this.fills;
            }
            case 5: {
                return this.isDMAInteractable;
            }
            case 6: {
                return this.executionPricePreference;
            }
            case 7: {
                return this.uvOrderId;
            }
            case 8: {
                return this.isPseudoPosition;
            }
            case 9: {
                return this.nextPseudoPositionId;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.pseudoPositionId = (Id)((Object)value$);
                break;
            }
            case 1: {
                this.orderType = (OrderType)((Object)value$);
                break;
            }
            case 2: {
                this.timeInForce = (TimeInForce)((Object)value$);
                break;
            }
            case 3: {
                this.originalSize = (Size)((Object)value$);
                break;
            }
            case 4: {
                this.fills = (Fills)((Object)value$);
                break;
            }
            case 5: {
                this.isDMAInteractable = (Boolean)value$;
                break;
            }
            case 6: {
                this.executionPricePreference = (ExecType)((Object)value$);
                break;
            }
            case 7: {
                this.uvOrderId = (Id)((Object)value$);
                break;
            }
            case 8: {
                this.isPseudoPosition = (Boolean)value$;
                break;
            }
            case 9: {
                this.nextPseudoPositionId = (Id)((Object)value$);
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Id getPseudoPositionId() {
        return this.pseudoPositionId;
    }

    public void setPseudoPositionId(Id value) {
        this.pseudoPositionId = value;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderType value) {
        this.orderType = value;
    }

    public TimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public void setTimeInForce(TimeInForce value) {
        this.timeInForce = value;
    }

    public Size getOriginalSize() {
        return this.originalSize;
    }

    public void setOriginalSize(Size value) {
        this.originalSize = value;
    }

    public Fills getFills() {
        return this.fills;
    }

    public void setFills(Fills value) {
        this.fills = value;
    }

    public Boolean getIsDMAInteractable() {
        return this.isDMAInteractable;
    }

    public void setIsDMAInteractable(Boolean value) {
        this.isDMAInteractable = value;
    }

    public ExecType getExecutionPricePreference() {
        return this.executionPricePreference;
    }

    public void setExecutionPricePreference(ExecType value) {
        this.executionPricePreference = value;
    }

    public Id getUvOrderId() {
        return this.uvOrderId;
    }

    public void setUvOrderId(Id value) {
        this.uvOrderId = value;
    }

    public Boolean getIsPseudoPosition() {
        return this.isPseudoPosition;
    }

    public void setIsPseudoPosition(Boolean value) {
        this.isPseudoPosition = value;
    }

    public Id getNextPseudoPositionId() {
        return this.nextPseudoPositionId;
    }

    public void setNextPseudoPositionId(Id value) {
        this.nextPseudoPositionId = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Order other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Order>
    implements RecordBuilder<Order> {
        private Id pseudoPositionId;
        private Id.Builder pseudoPositionIdBuilder;
        private OrderType orderType;
        private TimeInForce timeInForce;
        private Size originalSize;
        private Size.Builder originalSizeBuilder;
        private Fills fills;
        private Fills.Builder fillsBuilder;
        private boolean isDMAInteractable;
        private ExecType executionPricePreference;
        private Id uvOrderId;
        private Id.Builder uvOrderIdBuilder;
        private boolean isPseudoPosition;
        private Id nextPseudoPositionId;
        private Id.Builder nextPseudoPositionIdBuilder;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.pseudoPositionId))) {
                this.pseudoPositionId = (Id)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.pseudoPositionId));
                this.fieldSetFlags()[0] = true;
            }
            if (other.hasPseudoPositionIdBuilder()) {
                this.pseudoPositionIdBuilder = Id.newBuilder(other.getPseudoPositionIdBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.orderType))) {
                this.orderType = (OrderType)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.orderType));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.timeInForce))) {
                this.timeInForce = (TimeInForce)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeInForce));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.originalSize))) {
                this.originalSize = (Size)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.originalSize));
                this.fieldSetFlags()[3] = true;
            }
            if (other.hasOriginalSizeBuilder()) {
                this.originalSizeBuilder = Size.newBuilder(other.getOriginalSizeBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.fills))) {
                this.fills = (Fills)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.fills));
                this.fieldSetFlags()[4] = true;
            }
            if (other.hasFillsBuilder()) {
                this.fillsBuilder = Fills.newBuilder(other.getFillsBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.isDMAInteractable)) {
                this.isDMAInteractable = (Boolean)this.data().deepCopy(this.fields()[5].schema(), (Object)other.isDMAInteractable);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.executionPricePreference))) {
                this.executionPricePreference = (ExecType)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.executionPricePreference));
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.uvOrderId))) {
                this.uvOrderId = (Id)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.uvOrderId));
                this.fieldSetFlags()[7] = true;
            }
            if (other.hasUvOrderIdBuilder()) {
                this.uvOrderIdBuilder = Id.newBuilder(other.getUvOrderIdBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.isPseudoPosition)) {
                this.isPseudoPosition = (Boolean)this.data().deepCopy(this.fields()[8].schema(), (Object)other.isPseudoPosition);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)((Object)other.nextPseudoPositionId))) {
                this.nextPseudoPositionId = (Id)((Object)this.data().deepCopy(this.fields()[9].schema(), (Object)other.nextPseudoPositionId));
                this.fieldSetFlags()[9] = true;
            }
            if (other.hasNextPseudoPositionIdBuilder()) {
                this.nextPseudoPositionIdBuilder = Id.newBuilder(other.getNextPseudoPositionIdBuilder());
            }
        }

        private Builder(Order other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.pseudoPositionId))) {
                this.pseudoPositionId = (Id)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.pseudoPositionId));
                this.fieldSetFlags()[0] = true;
            }
            this.pseudoPositionIdBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.orderType))) {
                this.orderType = (OrderType)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.orderType));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.timeInForce))) {
                this.timeInForce = (TimeInForce)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeInForce));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.originalSize))) {
                this.originalSize = (Size)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.originalSize));
                this.fieldSetFlags()[3] = true;
            }
            this.originalSizeBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.fills))) {
                this.fills = (Fills)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.fills));
                this.fieldSetFlags()[4] = true;
            }
            this.fillsBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.isDMAInteractable)) {
                this.isDMAInteractable = (Boolean)this.data().deepCopy(this.fields()[5].schema(), (Object)other.isDMAInteractable);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.executionPricePreference))) {
                this.executionPricePreference = (ExecType)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.executionPricePreference));
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.uvOrderId))) {
                this.uvOrderId = (Id)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.uvOrderId));
                this.fieldSetFlags()[7] = true;
            }
            this.uvOrderIdBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.isPseudoPosition)) {
                this.isPseudoPosition = (Boolean)this.data().deepCopy(this.fields()[8].schema(), (Object)other.isPseudoPosition);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)((Object)other.nextPseudoPositionId))) {
                this.nextPseudoPositionId = (Id)((Object)this.data().deepCopy(this.fields()[9].schema(), (Object)other.nextPseudoPositionId));
                this.fieldSetFlags()[9] = true;
            }
            this.nextPseudoPositionIdBuilder = null;
        }

        public Id getPseudoPositionId() {
            return this.pseudoPositionId;
        }

        public Builder setPseudoPositionId(Id value) {
            this.validate(this.fields()[0], (Object)value);
            this.pseudoPositionIdBuilder = null;
            this.pseudoPositionId = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasPseudoPositionId() {
            return this.fieldSetFlags()[0];
        }

        public Id.Builder getPseudoPositionIdBuilder() {
            if (this.pseudoPositionIdBuilder == null) {
                if (this.hasPseudoPositionId()) {
                    this.setPseudoPositionIdBuilder(Id.newBuilder(this.pseudoPositionId));
                } else {
                    this.setPseudoPositionIdBuilder(Id.newBuilder());
                }
            }
            return this.pseudoPositionIdBuilder;
        }

        public Builder setPseudoPositionIdBuilder(Id.Builder value) {
            this.clearPseudoPositionId();
            this.pseudoPositionIdBuilder = value;
            return this;
        }

        public boolean hasPseudoPositionIdBuilder() {
            return this.pseudoPositionIdBuilder != null;
        }

        public Builder clearPseudoPositionId() {
            this.pseudoPositionId = null;
            this.pseudoPositionIdBuilder = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public OrderType getOrderType() {
            return this.orderType;
        }

        public Builder setOrderType(OrderType value) {
            this.validate(this.fields()[1], (Object)value);
            this.orderType = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasOrderType() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearOrderType() {
            this.orderType = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public TimeInForce getTimeInForce() {
            return this.timeInForce;
        }

        public Builder setTimeInForce(TimeInForce value) {
            this.validate(this.fields()[2], (Object)value);
            this.timeInForce = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTimeInForce() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTimeInForce() {
            this.timeInForce = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Size getOriginalSize() {
            return this.originalSize;
        }

        public Builder setOriginalSize(Size value) {
            this.validate(this.fields()[3], (Object)value);
            this.originalSizeBuilder = null;
            this.originalSize = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasOriginalSize() {
            return this.fieldSetFlags()[3];
        }

        public Size.Builder getOriginalSizeBuilder() {
            if (this.originalSizeBuilder == null) {
                if (this.hasOriginalSize()) {
                    this.setOriginalSizeBuilder(Size.newBuilder(this.originalSize));
                } else {
                    this.setOriginalSizeBuilder(Size.newBuilder());
                }
            }
            return this.originalSizeBuilder;
        }

        public Builder setOriginalSizeBuilder(Size.Builder value) {
            this.clearOriginalSize();
            this.originalSizeBuilder = value;
            return this;
        }

        public boolean hasOriginalSizeBuilder() {
            return this.originalSizeBuilder != null;
        }

        public Builder clearOriginalSize() {
            this.originalSize = null;
            this.originalSizeBuilder = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Fills getFills() {
            return this.fills;
        }

        public Builder setFills(Fills value) {
            this.validate(this.fields()[4], (Object)value);
            this.fillsBuilder = null;
            this.fills = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasFills() {
            return this.fieldSetFlags()[4];
        }

        public Fills.Builder getFillsBuilder() {
            if (this.fillsBuilder == null) {
                if (this.hasFills()) {
                    this.setFillsBuilder(Fills.newBuilder(this.fills));
                } else {
                    this.setFillsBuilder(Fills.newBuilder());
                }
            }
            return this.fillsBuilder;
        }

        public Builder setFillsBuilder(Fills.Builder value) {
            this.clearFills();
            this.fillsBuilder = value;
            return this;
        }

        public boolean hasFillsBuilder() {
            return this.fillsBuilder != null;
        }

        public Builder clearFills() {
            this.fills = null;
            this.fillsBuilder = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Boolean getIsDMAInteractable() {
            return this.isDMAInteractable;
        }

        public Builder setIsDMAInteractable(boolean value) {
            this.validate(this.fields()[5], value);
            this.isDMAInteractable = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasIsDMAInteractable() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearIsDMAInteractable() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public ExecType getExecutionPricePreference() {
            return this.executionPricePreference;
        }

        public Builder setExecutionPricePreference(ExecType value) {
            this.validate(this.fields()[6], (Object)value);
            this.executionPricePreference = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasExecutionPricePreference() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearExecutionPricePreference() {
            this.executionPricePreference = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Id getUvOrderId() {
            return this.uvOrderId;
        }

        public Builder setUvOrderId(Id value) {
            this.validate(this.fields()[7], (Object)value);
            this.uvOrderIdBuilder = null;
            this.uvOrderId = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasUvOrderId() {
            return this.fieldSetFlags()[7];
        }

        public Id.Builder getUvOrderIdBuilder() {
            if (this.uvOrderIdBuilder == null) {
                if (this.hasUvOrderId()) {
                    this.setUvOrderIdBuilder(Id.newBuilder(this.uvOrderId));
                } else {
                    this.setUvOrderIdBuilder(Id.newBuilder());
                }
            }
            return this.uvOrderIdBuilder;
        }

        public Builder setUvOrderIdBuilder(Id.Builder value) {
            this.clearUvOrderId();
            this.uvOrderIdBuilder = value;
            return this;
        }

        public boolean hasUvOrderIdBuilder() {
            return this.uvOrderIdBuilder != null;
        }

        public Builder clearUvOrderId() {
            this.uvOrderId = null;
            this.uvOrderIdBuilder = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Boolean getIsPseudoPosition() {
            return this.isPseudoPosition;
        }

        public Builder setIsPseudoPosition(boolean value) {
            this.validate(this.fields()[8], value);
            this.isPseudoPosition = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasIsPseudoPosition() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearIsPseudoPosition() {
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Id getNextPseudoPositionId() {
            return this.nextPseudoPositionId;
        }

        public Builder setNextPseudoPositionId(Id value) {
            this.validate(this.fields()[9], (Object)value);
            this.nextPseudoPositionIdBuilder = null;
            this.nextPseudoPositionId = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasNextPseudoPositionId() {
            return this.fieldSetFlags()[9];
        }

        public Id.Builder getNextPseudoPositionIdBuilder() {
            if (this.nextPseudoPositionIdBuilder == null) {
                if (this.hasNextPseudoPositionId()) {
                    this.setNextPseudoPositionIdBuilder(Id.newBuilder(this.nextPseudoPositionId));
                } else {
                    this.setNextPseudoPositionIdBuilder(Id.newBuilder());
                }
            }
            return this.nextPseudoPositionIdBuilder;
        }

        public Builder setNextPseudoPositionIdBuilder(Id.Builder value) {
            this.clearNextPseudoPositionId();
            this.nextPseudoPositionIdBuilder = value;
            return this;
        }

        public boolean hasNextPseudoPositionIdBuilder() {
            return this.nextPseudoPositionIdBuilder != null;
        }

        public Builder clearNextPseudoPositionId() {
            this.nextPseudoPositionId = null;
            this.nextPseudoPositionIdBuilder = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Order build() {
            try {
                Order record = new Order();
                record.pseudoPositionId = this.pseudoPositionIdBuilder != null ? this.pseudoPositionIdBuilder.build() : (this.fieldSetFlags()[0] ? this.pseudoPositionId : (Id)((Object)this.defaultValue(this.fields()[0])));
                record.orderType = this.fieldSetFlags()[1] ? this.orderType : (OrderType)((Object)this.defaultValue(this.fields()[1]));
                TimeInForce timeInForce = record.timeInForce = this.fieldSetFlags()[2] ? this.timeInForce : (TimeInForce)((Object)this.defaultValue(this.fields()[2]));
                if (this.originalSizeBuilder != null) {
                    record.originalSize = this.originalSizeBuilder.build();
                } else {
                    Size size = record.originalSize = this.fieldSetFlags()[3] ? this.originalSize : (Size)((Object)this.defaultValue(this.fields()[3]));
                }
                record.fills = this.fillsBuilder != null ? this.fillsBuilder.build() : (this.fieldSetFlags()[4] ? this.fills : (Fills)((Object)this.defaultValue(this.fields()[4])));
                record.isDMAInteractable = this.fieldSetFlags()[5] ? this.isDMAInteractable : (Boolean)this.defaultValue(this.fields()[5]);
                ExecType execType = record.executionPricePreference = this.fieldSetFlags()[6] ? this.executionPricePreference : (ExecType)((Object)this.defaultValue(this.fields()[6]));
                record.uvOrderId = this.uvOrderIdBuilder != null ? this.uvOrderIdBuilder.build() : (this.fieldSetFlags()[7] ? this.uvOrderId : (Id)((Object)this.defaultValue(this.fields()[7])));
                boolean bl = record.isPseudoPosition = this.fieldSetFlags()[8] ? this.isPseudoPosition : (Boolean)this.defaultValue(this.fields()[8]);
                record.nextPseudoPositionId = this.nextPseudoPositionIdBuilder != null ? this.nextPseudoPositionIdBuilder.build() : (this.fieldSetFlags()[9] ? this.nextPseudoPositionId : (Id)((Object)this.defaultValue(this.fields()[9])));
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

