/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.avro;

import avro.shaded.com.google.common.collect.ImmutableMap;
import io.confluent.connect.avro.AvroConverter;
import io.confluent.connect.avro.DeprecatedTestTopicNameStrategy;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.subject.RecordNameStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

public class AvroConverterTest {
    private static final String TOPIC = "topic";
    private static final Map<String, ?> SR_CONFIG = Collections.singletonMap("schema.registry.url", "localhost");
    private final SchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
    private final AvroConverter converter = new AvroConverter(this.schemaRegistry);

    @Before
    public void setUp() {
        this.converter.configure(Collections.singletonMap("schema.registry.url", "http://fake-url"), false);
    }

    @Test
    public void testConfigure() {
        this.converter.configure(SR_CONFIG, true);
        Assert.assertTrue((boolean)((Boolean)Whitebox.getInternalState((Object)this.converter, (String)"isKey")));
        Assert.assertNotNull((Object)Whitebox.getInternalState((Object)Whitebox.getInternalState((Object)this.converter, (String)"serializer"), (String)"schemaRegistry"));
    }

    @Test
    public void testConfigureAlt() {
        this.converter.configure(SR_CONFIG, false);
        Assert.assertFalse((boolean)((Boolean)Whitebox.getInternalState((Object)this.converter, (String)"isKey")));
        Assert.assertNotNull((Object)Whitebox.getInternalState((Object)Whitebox.getInternalState((Object)this.converter, (String)"serializer"), (String)"schemaRegistry"));
    }

    @Test
    public void testPrimitive() {
        SchemaAndValue original = new SchemaAndValue(org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA, (Object)true);
        byte[] converted = this.converter.fromConnectData(TOPIC, original.schema(), original.value());
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, converted);
        SchemaAndValue expected = new SchemaAndValue(SchemaBuilder.bool().version(Integer.valueOf(1)).build(), (Object)true);
        Assert.assertEquals((Object)expected, (Object)schemaAndValue);
    }

    @Test
    public void testComplex() {
        SchemaBuilder builder = SchemaBuilder.struct().field("int8", SchemaBuilder.int8().defaultValue((Object)2).doc("int8 field").build()).field("int16", org.apache.kafka.connect.data.Schema.INT16_SCHEMA).field("int32", org.apache.kafka.connect.data.Schema.INT32_SCHEMA).field("int64", org.apache.kafka.connect.data.Schema.INT64_SCHEMA).field("float32", org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA).field("float64", org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA).field("boolean", org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA).field("string", org.apache.kafka.connect.data.Schema.STRING_SCHEMA).field("bytes", org.apache.kafka.connect.data.Schema.BYTES_SCHEMA).field("array", SchemaBuilder.array((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA).build()).field("map", SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build()).field("mapNonStringKeys", SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA, (org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).build());
        org.apache.kafka.connect.data.Schema schema = builder.build();
        Struct original = new Struct(schema).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)ByteBuffer.wrap("foo".getBytes())).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1)).put("mapNonStringKeys", Collections.singletonMap(1, 1));
        org.apache.kafka.connect.data.Schema expectedSchema = builder.version(Integer.valueOf(1)).build();
        Struct expected = new Struct(expectedSchema).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)ByteBuffer.wrap("foo".getBytes())).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1)).put("mapNonStringKeys", Collections.singletonMap(1, 1));
        byte[] converted = this.converter.fromConnectData(TOPIC, original.schema(), (Object)original);
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, converted);
        Assert.assertEquals((Object)expected, (Object)schemaAndValue.value());
    }

    @Test
    public void testNull() {
        byte[] converted = this.converter.fromConnectData(TOPIC, org.apache.kafka.connect.data.Schema.OPTIONAL_BOOLEAN_SCHEMA, null);
        Assert.assertNull((Object)converted);
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, converted);
        Assert.assertEquals((Object)SchemaAndValue.NULL, (Object)schemaAndValue);
    }

    @Test
    public void testVersionExtractedForDefaultSubjectNameStrategy() throws Exception {
        String subject = "topic-value";
        KafkaAvroSerializer serializer = new KafkaAvroSerializer(this.schemaRegistry);
        AvroConverter avroConverter = new AvroConverter(this.schemaRegistry);
        avroConverter.configure(Collections.singletonMap("schema.registry.url", "http://fake-url"), false);
        this.testVersionExtracted(subject, serializer, avroConverter);
    }

    @Test
    public void testVersionExtractedForRecordSubjectNameStrategy() throws Exception {
        String subject = "Foo";
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"http://fake-url", (Object)"value.subject.name.strategy", (Object)RecordNameStrategy.class.getName());
        KafkaAvroSerializer serializer = new KafkaAvroSerializer(this.schemaRegistry);
        serializer.configure((Map)configs, false);
        AvroConverter avroConverter = new AvroConverter(this.schemaRegistry);
        avroConverter.configure((Map)configs, false);
        this.testVersionExtracted(subject, serializer, avroConverter);
    }

    private void testVersionExtracted(String subject, KafkaAvroSerializer serializer, AvroConverter avroConverter) throws IOException, RestClientException {
        Schema avroSchema1 = (Schema)org.apache.avro.SchemaBuilder.record((String)"Foo").fields().requiredInt("key").endRecord();
        this.schemaRegistry.register(subject, avroSchema1);
        Schema avroSchema2 = (Schema)org.apache.avro.SchemaBuilder.record((String)"Foo").fields().requiredInt("key").requiredString("value").endRecord();
        this.schemaRegistry.register(subject, avroSchema2);
        GenericData.Record avroRecord1 = new GenericRecordBuilder(avroSchema1).set("key", (Object)15).build();
        byte[] serializedRecord1 = serializer.serialize(TOPIC, (Object)avroRecord1);
        GenericData.Record avroRecord2 = new GenericRecordBuilder(avroSchema2).set("key", (Object)15).set("value", (Object)"bar").build();
        byte[] serializedRecord2 = serializer.serialize(TOPIC, (Object)avroRecord2);
        SchemaAndValue converted1 = avroConverter.toConnectData(TOPIC, serializedRecord1);
        Assert.assertEquals((long)1L, (long)converted1.schema().version().intValue());
        SchemaAndValue converted2 = avroConverter.toConnectData(TOPIC, serializedRecord2);
        Assert.assertEquals((long)2L, (long)converted2.schema().version().intValue());
    }

    @Test
    public void testVersionMaintained() {
        org.apache.kafka.connect.data.Schema newerSchema = SchemaBuilder.struct().version(Integer.valueOf(2)).field("orig", org.apache.kafka.connect.data.Schema.OPTIONAL_INT16_SCHEMA).field("new", org.apache.kafka.connect.data.Schema.OPTIONAL_INT16_SCHEMA).build();
        SchemaAndValue newer = new SchemaAndValue(newerSchema, (Object)new Struct(newerSchema));
        byte[] newerSerialized = this.converter.fromConnectData(TOPIC, newer.schema(), newer.value());
        org.apache.kafka.connect.data.Schema olderSchema = SchemaBuilder.struct().version(Integer.valueOf(1)).field("orig", org.apache.kafka.connect.data.Schema.OPTIONAL_INT16_SCHEMA).build();
        SchemaAndValue older = new SchemaAndValue(olderSchema, (Object)new Struct(olderSchema));
        byte[] olderSerialized = this.converter.fromConnectData(TOPIC, older.schema(), older.value());
        Assert.assertEquals((long)2L, (long)this.converter.toConnectData(TOPIC, newerSerialized).schema().version().intValue());
        Assert.assertEquals((long)1L, (long)this.converter.toConnectData(TOPIC, olderSerialized).schema().version().intValue());
    }

    @Test
    public void testSameSchemaMultipleTopicForValue() throws IOException, RestClientException {
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        AvroConverter avroConverter = new AvroConverter((SchemaRegistryClient)schemaRegistry);
        avroConverter.configure(SR_CONFIG, false);
        this.assertSameSchemaMultipleTopic(avroConverter, (SchemaRegistryClient)schemaRegistry, false);
    }

    @Test
    public void testSameSchemaMultipleTopicForKey() throws IOException, RestClientException {
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        AvroConverter avroConverter = new AvroConverter((SchemaRegistryClient)schemaRegistry);
        avroConverter.configure(SR_CONFIG, true);
        this.assertSameSchemaMultipleTopic(avroConverter, (SchemaRegistryClient)schemaRegistry, true);
    }

    @Test
    public void testSameSchemaMultipleTopicWithDeprecatedSubjectNameStrategyForValue() throws IOException, RestClientException {
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        AvroConverter avroConverter = new AvroConverter((SchemaRegistryClient)schemaRegistry);
        ImmutableMap converterConfig = ImmutableMap.of((Object)"schema.registry.url", (Object)"localhost", (Object)"value.subject.name.strategy", (Object)DeprecatedTestTopicNameStrategy.class.getName());
        avroConverter.configure((Map)converterConfig, false);
        this.assertSameSchemaMultipleTopic(avroConverter, (SchemaRegistryClient)schemaRegistry, false);
    }

    @Test
    public void testSameSchemaMultipleTopicWithDeprecatedSubjectNameStrategyForKey() throws IOException, RestClientException {
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        AvroConverter avroConverter = new AvroConverter((SchemaRegistryClient)schemaRegistry);
        ImmutableMap converterConfig = ImmutableMap.of((Object)"schema.registry.url", (Object)"localhost", (Object)"key.subject.name.strategy", (Object)DeprecatedTestTopicNameStrategy.class.getName());
        avroConverter.configure((Map)converterConfig, true);
        this.assertSameSchemaMultipleTopic(avroConverter, (SchemaRegistryClient)schemaRegistry, true);
    }

    private void assertSameSchemaMultipleTopic(AvroConverter converter, SchemaRegistryClient schemaRegistry, boolean isKey) throws IOException, RestClientException {
        Schema avroSchema1 = (Schema)org.apache.avro.SchemaBuilder.record((String)"Foo").fields().requiredInt("key").endRecord();
        Schema avroSchema2_1 = (Schema)org.apache.avro.SchemaBuilder.record((String)"Foo").fields().requiredInt("key").requiredString("value").endRecord();
        Schema avroSchema2_2 = (Schema)org.apache.avro.SchemaBuilder.record((String)"Foo").fields().requiredInt("key").requiredString("value").endRecord();
        String subjectSuffix = isKey ? "key" : "value";
        schemaRegistry.register("topic1-" + subjectSuffix, avroSchema2_1);
        schemaRegistry.register("topic2-" + subjectSuffix, avroSchema1);
        schemaRegistry.register("topic2-" + subjectSuffix, avroSchema2_2);
        GenericData.Record avroRecord1 = new GenericRecordBuilder(avroSchema2_1).set("key", (Object)15).set("value", (Object)"bar").build();
        GenericData.Record avroRecord2 = new GenericRecordBuilder(avroSchema2_2).set("key", (Object)15).set("value", (Object)"bar").build();
        KafkaAvroSerializer serializer = new KafkaAvroSerializer(schemaRegistry);
        serializer.configure(SR_CONFIG, isKey);
        byte[] serializedRecord1 = serializer.serialize("topic1", (Object)avroRecord1);
        byte[] serializedRecord2 = serializer.serialize("topic2", (Object)avroRecord2);
        SchemaAndValue converted1 = converter.toConnectData("topic1", serializedRecord1);
        Assert.assertEquals((long)1L, (long)converted1.schema().version().intValue());
        SchemaAndValue converted2 = converter.toConnectData("topic2", serializedRecord2);
        Assert.assertEquals((long)2L, (long)converted2.schema().version().intValue());
        converted2 = converter.toConnectData("topic2", serializedRecord2);
        Assert.assertEquals((long)2L, (long)converted2.schema().version().intValue());
    }
}

