/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.avro;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.avro.AvroDataConfig;
import io.test.avro.core.AvroMessage;
import io.test.avro.doc.DocTestRecord;
import io.test.avro.union.FirstOption;
import io.test.avro.union.MultiTypeUnionMessage;
import io.test.avro.union.SecondOption;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.Union;
import org.apache.avro.specific.SpecificData;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.co.jemos.podam.api.PodamFactoryImpl;

public class AdditionalAvroDataTest {
    private AvroData avroData;

    @Before
    public void before() {
        AvroDataConfig avroDataConfig = new AvroDataConfig.Builder().with("schemas.cache.config", (Object)1).with("connect.meta.data", (Object)false).with("enhanced.avro.schema.support", (Object)true).build();
        this.avroData = new AvroData(avroDataConfig);
    }

    @Test
    public void testDocumentationPreservedSchema() throws IOException {
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/DocTestRecord.avsc"));
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Schema outputAvroSchema = this.avroData.fromConnectSchema(connectSchema);
        Assert.assertEquals((Object)avroSchema, (Object)outputAvroSchema);
    }

    @Test
    public void testDocumentationPreservedData() throws IOException {
        PodamFactoryImpl factory = new PodamFactoryImpl();
        DocTestRecord testRecord = (DocTestRecord)((Object)factory.manufacturePojo(DocTestRecord.class, new Type[0]));
        SchemaAndValue connectSchemaAndValue = this.avroData.toConnectData(testRecord.getSchema(), (Object)testRecord);
        Object output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)testRecord), (Object)SpecificData.get().toString(output));
    }

    @Test
    public void testComplexUnionSchema() throws IOException {
        Schema avroSchema = new Schema.Parser().parse(new File("src/test/avro/AvroMessage.avsc"));
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(avroSchema);
        Schema outputAvroSchema = this.avroData.fromConnectSchema(connectSchema);
        Assert.assertEquals((Object)avroSchema, (Object)outputAvroSchema);
    }

    @Test
    public void testComplexUnionData() throws IOException {
        PodamFactoryImpl factory = new PodamFactoryImpl();
        AvroMessage avroMessage = (AvroMessage)((Object)factory.manufacturePojo(AvroMessage.class, new Type[0]));
        SchemaAndValue connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        Object output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
    }

    @Test
    public void testComplexMultiUnionData() throws IOException {
        PodamFactoryImpl factory = new PodamFactoryImpl();
        MultiTypeUnionMessage avroMessage = (MultiTypeUnionMessage)((Object)factory.manufacturePojo(MultiTypeUnionMessage.class, new Type[0]));
        SchemaAndValue connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        Object output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
        avroMessage.setCompositeRecord((Object)new FirstOption("x", 2L));
        connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
        avroMessage.setCompositeRecord((Object)new SecondOption("y", 3L));
        connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
        avroMessage.setCompositeRecord(Arrays.asList("1", "2"));
        connectSchemaAndValue = this.avroData.toConnectData(avroMessage.getSchema(), (Object)avroMessage);
        output = this.avroData.fromConnectData(connectSchemaAndValue.schema(), connectSchemaAndValue.value());
        Assert.assertEquals((Object)SpecificData.get().toString((Object)avroMessage), (Object)SpecificData.get().toString(output));
    }

    @Test
    public void testNestedUnion() {
        Schema myAvroObjectSchema = new Schema.Parser().parse("{  \"type\" : \"record\",  \"name\" : \"MyObjectToPersist\",  \"namespace\" : \"io.confluent.connect.avro.AdditionalAvroDataTest$\",  \"fields\" : [ {    \"name\" : \"obj\",    \"type\" : [ \"null\", {      \"type\" : \"record\",      \"name\" : \"MyImpl1\",      \"fields\" : [ {        \"name\" : \"data\",        \"type\" : [ \"null\", \"string\" ],        \"default\" : null      } ]    }, {      \"type\" : \"record\",      \"name\" : \"MyImpl2\",      \"fields\" : [ {        \"name\" : \"data\",        \"type\" : [ \"null\", \"string\" ],        \"default\" : null      } ]    } ],    \"default\" : null  } ]}");
        Schema myImpl1Schema = ReflectData.AllowNull.get().getSchema(MyImpl1.class);
        GenericData.Record nestedRecord = new GenericRecordBuilder(myImpl1Schema).set("data", (Object)"mydata").build();
        GenericData.Record obj = new GenericRecordBuilder(myAvroObjectSchema).set("obj", (Object)nestedRecord).build();
        org.apache.kafka.connect.data.Schema connectSchema = this.avroData.toConnectSchema(myAvroObjectSchema);
        SchemaAndValue schemaAndValue = this.avroData.toConnectData(myAvroObjectSchema, (Object)obj);
        Object o = this.avroData.fromConnectData(schemaAndValue.schema(), schemaAndValue.value());
        Assert.assertEquals((Object)obj, (Object)o);
        this.avroData.fromConnectSchema(connectSchema);
    }

    static class MyObjectToPersist {
        private MyInterface obj;

        MyObjectToPersist() {
        }
    }

    static class MyImpl2
    implements MyInterface {
        private String data;

        MyImpl2() {
        }
    }

    static class MyImpl1
    implements MyInterface {
        private String data;

        MyImpl1() {
        }
    }

    @Union(value={MyImpl1.class, MyImpl2.class})
    static interface MyInterface {
    }
}

