/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.testutil.MockSchemaRegistry;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import io.confluent.kafka.serializers.GenericContainerWithVersion;
import io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.subject.RecordNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.common.config.ConfigException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractKafkaAvroDeserializerTest {
    private Map<String, ?> defaultConfigs;
    private SchemaRegistryClient schemaRegistry;
    private KafkaAvroSerializer avroSerializer;
    private Deserializer deserializer;

    @Before
    public void setUp() {
        this.defaultConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus");
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.avroSerializer = new KafkaAvroSerializer(this.schemaRegistry, this.defaultConfigs);
        this.deserializer = new Deserializer(this.schemaRegistry);
    }

    private IndexedRecord createAvroRecord() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    public void assertSchemaNotCopiedWhenDeserializedWithVersion(String topic, SubjectNameStrategy subjectNameStrategy) throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.builder().putAll(this.defaultConfigs).put((Object)"auto.register.schemas", (Object)false).put((Object)"value.subject.name.strategy", subjectNameStrategy.getClass()).build();
        IndexedRecord avroRecord = this.createAvroRecord();
        String subject = subjectNameStrategy.subjectName(topic, false, (ParsedSchema)new AvroSchema(avroRecord.getSchema()));
        this.avroSerializer.configure((Map)configs, false);
        this.deserializer.configure(new KafkaAvroDeserializerConfig((Map)configs));
        this.schemaRegistry.register(subject, (ParsedSchema)new AvroSchema(avroRecord.getSchema()));
        byte[] bytes = this.avroSerializer.serialize(topic, (Object)avroRecord);
        IndexedRecord deserialized = (IndexedRecord)this.deserializer.deserializeWithSchemaAndVersion(topic, false, bytes).container();
        Assert.assertThat((Object)deserialized.getSchema(), (Matcher)CoreMatchers.sameInstance((Object)avroRecord.getSchema()));
    }

    @Test
    public void testSchemaNotCopiedForTopicNameStrategy() throws IOException, RestClientException {
        this.assertSchemaNotCopiedWhenDeserializedWithVersion("test-topic", (SubjectNameStrategy)new TopicNameStrategy());
    }

    @Test
    public void testSchemaNotCopiedForRecordNameStrategy() throws IOException, RestClientException {
        this.assertSchemaNotCopiedWhenDeserializedWithVersion("test-topic", (SubjectNameStrategy)new RecordNameStrategy());
    }

    @Test
    public void testSchemaNotCopiedForTopicRecordNameStrategy() throws IOException, RestClientException {
        this.assertSchemaNotCopiedWhenDeserializedWithVersion("test-topic", (SubjectNameStrategy)new TopicRecordNameStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSchemaInternalHashCode(Schema avroSchema) throws NoSuchFieldException, IllegalAccessException {
        Field hashCodeField = Schema.class.getDeclaredField("hashCode");
        boolean accessible = hashCodeField.isAccessible();
        hashCodeField.setAccessible(true);
        try {
            int n = (Integer)hashCodeField.get(avroSchema);
            return n;
        }
        finally {
            hashCodeField.setAccessible(accessible);
        }
    }

    @Test
    public void testSchemaVersionSet() throws IOException, RestClientException {
        IndexedRecord avroRecord = this.createAvroRecord();
        int version = this.schemaRegistry.register("topic", (ParsedSchema)new AvroSchema(avroRecord.getSchema()));
        byte[] bytes = this.avroSerializer.serialize("topic", (Object)avroRecord);
        GenericContainerWithVersion genericContainerWithVersion = this.deserializer.deserializeWithSchemaAndVersion("topic", false, bytes);
        Schema avroSchema = genericContainerWithVersion.container().getSchema();
        Integer schemaVersion = genericContainerWithVersion.version();
        Assert.assertThat((Object)schemaVersion, (Matcher)CoreMatchers.equalTo((Object)version));
    }

    @Test
    public void testHashCodeNotReset() throws NoSuchFieldException, IllegalAccessException {
        IndexedRecord avroRecord = this.createAvroRecord();
        byte[] bytes = this.avroSerializer.serialize("topic", (Object)avroRecord);
        IndexedRecord deserialized1 = (IndexedRecord)this.deserializer.deserializeWithSchemaAndVersion("topic", false, bytes).container();
        int hashCode = deserialized1.getSchema().hashCode();
        IndexedRecord deserialized2 = (IndexedRecord)this.deserializer.deserializeWithSchemaAndVersion("topic", false, bytes).container();
        Assert.assertThat((Object)deserialized1.getSchema(), (Matcher)CoreMatchers.sameInstance((Object)deserialized2.getSchema()));
        Schema avroSchema = deserialized2.getSchema();
        Assert.assertThat((Object)this.getSchemaInternalHashCode(avroSchema), (Matcher)CoreMatchers.equalTo((Object)hashCode));
    }

    @Test
    public void testMockUrl() {
        KafkaAvroSerializer kafkaAvroSerializer = new KafkaAvroSerializer();
        kafkaAvroSerializer.configure(Collections.singletonMap("schema.registry.url", "mock://asdf"), false);
        Assert.assertSame((Object)MockSchemaRegistry.getClientForScope((String)"asdf"), (Object)kafkaAvroSerializer.schemaRegistry);
        Assert.assertNotSame((Object)MockSchemaRegistry.getClientForScope((String)"qwer"), (Object)kafkaAvroSerializer.schemaRegistry);
    }

    @Test
    public void testMockUrlsAreRejected() {
        KafkaAvroSerializer kafkaAvroSerializer = new KafkaAvroSerializer();
        try {
            kafkaAvroSerializer.configure(Collections.singletonMap("schema.registry.url", "mock://asdf,mock://qwer"), false);
            Assert.fail();
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)"Only one mock scope is permitted for 'schema.registry.url'. Got: [mock://asdf, mock://qwer]", (Object)e.getMessage());
        }
        Assert.assertNull((Object)kafkaAvroSerializer.schemaRegistry);
    }

    @Test
    public void testMixedUrlsAreRejected() {
        KafkaAvroSerializer kafkaAvroSerializer = new KafkaAvroSerializer();
        try {
            kafkaAvroSerializer.configure(Collections.singletonMap("schema.registry.url", "mock://asdf,http://qwer"), false);
            Assert.fail();
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)"Cannot mix mock and real urls for 'schema.registry.url'. Got: [mock://asdf, http://qwer]", (Object)e.getMessage());
        }
        try {
            kafkaAvroSerializer.configure(Collections.singletonMap("schema.registry.url", "http://qwer,mock://asdf"), false);
            Assert.fail();
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)"Cannot mix mock and real urls for 'schema.registry.url'. Got: [http://qwer, mock://asdf]", (Object)e.getMessage());
        }
        Assert.assertNull((Object)kafkaAvroSerializer.schemaRegistry);
    }

    private static class Deserializer
    extends AbstractKafkaAvroDeserializer {
        Deserializer(SchemaRegistryClient schemaRegistry) {
            this.schemaRegistry = schemaRegistry;
        }
    }
}

