/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;

public class AvroSchemaTest {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final Schema.Parser parser = new Schema.Parser();
    private static final Schema recordSchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"null\", \"type\": \"null\"},\n     {\"name\": \"boolean\", \"type\": \"boolean\"},\n     {\"name\": \"int\", \"type\": \"int\"},\n     {\"name\": \"long\", \"type\": \"long\"},\n     {\"name\": \"float\", \"type\": \"float\"},\n     {\"name\": \"double\", \"type\": \"double\"},\n     {\"name\": \"bytes\", \"type\": \"bytes\"},\n     {\"name\": \"string\", \"type\": \"string\", \"aliases\": [\"string_alias\"]},\n     {\"name\": \"null_default\", \"type\": \"null\", \"default\": null},\n     {\"name\": \"boolean_default\", \"type\": \"boolean\", \"default\": false},\n     {\"name\": \"int_default\", \"type\": \"int\", \"default\": 24},\n     {\"name\": \"long_default\", \"type\": \"long\", \"default\": 4000000000},\n     {\"name\": \"float_default\", \"type\": \"float\", \"default\": 12.3},\n     {\"name\": \"double_default\", \"type\": \"double\", \"default\": 23.2},\n     {\"name\": \"bytes_default\", \"type\": \"bytes\", \"default\": \"bytes\"},\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": \"default string\"}\n]\n}");
    private static final Schema arraySchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"array\",\n \"name\": \"test\",\n \"items\": \"string\"\n}");
    private static final Schema mapSchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"map\",\n \"name\": \"test\",\n \"values\": \"string\"\n}");
    private static final Schema unionSchema = new Schema.Parser().parse("{\"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"union\", \"type\": [\"string\", \"int\"]}\n]}");
    private static final Schema enumSchema = new Schema.Parser().parse("{ \"type\": \"enum\",\n  \"name\": \"Suit\",\n  \"symbols\" : [\"SPADES\", \"HEARTS\", \"DIAMONDS\", \"CLUBS\"]\n}");

    @Test
    public void testPrimitiveTypesToAvro() throws Exception {
        Object result = AvroSchemaUtils.toObject((JsonNode)null, (AvroSchema)AvroSchemaTest.createPrimitiveSchema("null"));
        Assert.assertTrue((result == null ? 1 : 0) != 0);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("true"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("boolean"));
        Assert.assertEquals((Object)true, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("false"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("boolean"));
        Assert.assertEquals((Object)false, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("12"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("int"));
        Assert.assertTrue((boolean)(result instanceof Integer));
        Assert.assertEquals((Object)12, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("12"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("long"));
        Assert.assertTrue((boolean)(result instanceof Long));
        Assert.assertEquals((Object)12L, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("5000000000"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("long"));
        Assert.assertTrue((boolean)(result instanceof Long));
        Assert.assertEquals((Object)5000000000L, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("23.2"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("float"));
        Assert.assertTrue((boolean)(result instanceof Float));
        Assert.assertEquals((Object)Float.valueOf(23.2f), (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("23"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("float"));
        Assert.assertTrue((boolean)(result instanceof Float));
        Assert.assertEquals((Object)Float.valueOf(23.0f), (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("23.2"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("double"));
        Assert.assertTrue((boolean)(result instanceof Double));
        Assert.assertEquals((Object)23.2, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("23"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("double"));
        Assert.assertTrue((boolean)(result instanceof Double));
        Assert.assertEquals((Object)23.0, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)new TextNode("hello"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("bytes"));
        Assert.assertTrue((boolean)(result instanceof ByteBuffer));
        Assert.assertArrayEquals((byte[])Base64.getEncoder().encode("hello".getBytes()), (byte[])Base64.getEncoder().encode(((ByteBuffer)result).array()));
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("\"a string\""), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("string"));
        Assert.assertTrue((boolean)(result instanceof Utf8));
        Assert.assertEquals((Object)new Utf8("a string"), (Object)result);
    }

    @Test
    public void testPrimitiveTypeToAvroSchemaMismatches() throws Exception {
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("12"), AvroSchemaTest.createPrimitiveSchema("null"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("12"), AvroSchemaTest.createPrimitiveSchema("boolean"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("int"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("5000000000"), AvroSchemaTest.createPrimitiveSchema("int"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("long"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("float"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("double"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("bytes"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("string"));
    }

    @Test
    public void testRecordToAvro() throws Exception {
        String json = "{\n    \"null\": null,\n    \"boolean\": true,\n    \"int\": 12,\n    \"long\": 5000000000,\n    \"float\": 23.4,\n    \"double\": 800.25,\n    \"bytes\": \"hello\",\n    \"string\": \"string\",\n    \"null_default\": null,\n    \"boolean_default\": false,\n    \"int_default\": 24,\n    \"long_default\": 4000000000,\n    \"float_default\": 12.3,\n    \"double_default\": 23.2,\n    \"bytes_default\": \"bytes\",\n    \"string_default\": \"default\"\n}";
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree(json), (AvroSchema)new AvroSchema(recordSchema));
        Assert.assertTrue((boolean)(result instanceof GenericRecord));
        GenericRecord resultRecord = (GenericRecord)result;
        Assert.assertEquals(null, (Object)resultRecord.get("null"));
        Assert.assertEquals((Object)true, (Object)resultRecord.get("boolean"));
        Assert.assertEquals((Object)12, (Object)resultRecord.get("int"));
        Assert.assertEquals((Object)5000000000L, (Object)resultRecord.get("long"));
        Assert.assertEquals((Object)Float.valueOf(23.4f), (Object)resultRecord.get("float"));
        Assert.assertEquals((Object)800.25, (Object)resultRecord.get("double"));
        Assert.assertArrayEquals((byte[])Base64.getEncoder().encode("hello".getBytes()), (byte[])Base64.getEncoder().encode(((ByteBuffer)resultRecord.get("bytes")).array()));
        Assert.assertEquals((Object)"string", (Object)resultRecord.get("string").toString());
    }

    @Test
    public void testArrayToAvro() throws Exception {
        String json = "[\"one\", \"two\", \"three\"]";
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree(json), (AvroSchema)new AvroSchema(arraySchema));
        Assert.assertTrue((boolean)(result instanceof GenericArray));
        Assert.assertArrayEquals((Object[])new Utf8[]{new Utf8("one"), new Utf8("two"), new Utf8("three")}, (Object[])((GenericArray)result).toArray());
    }

    @Test
    public void testMapToAvro() throws Exception {
        String json = "{\"first\": \"one\", \"second\": \"two\"}";
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree(json), (AvroSchema)new AvroSchema(mapSchema));
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
    }

    @Test
    public void testUnionToAvro() throws Exception {
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("{\"union\":{\"string\":\"test string\"}}"), (AvroSchema)new AvroSchema(unionSchema));
        Object foo = ((GenericRecord)result).get("union");
        Assert.assertTrue((boolean)(((GenericRecord)result).get("union") instanceof Utf8));
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("{\"union\":{\"int\":12}}"), (AvroSchema)new AvroSchema(unionSchema));
        Assert.assertTrue((boolean)(((GenericRecord)result).get("union") instanceof Integer));
        try {
            AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("12.4"), (AvroSchema)new AvroSchema(unionSchema));
            Assert.fail((String)"Trying to convert floating point number to union(string,int) schema should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testEnumToAvro() throws Exception {
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("\"SPADES\""), (AvroSchema)new AvroSchema(enumSchema));
        Assert.assertTrue((boolean)(result instanceof GenericEnumSymbol));
    }

    @Test
    public void testPrimitiveTypesToJson() throws Exception {
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)0));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)0L));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)Float.valueOf(0.1f)));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)0.1));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)true));
        Assert.assertTrue((boolean)result.isBoolean());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)"abcdefg"));
        Assert.assertTrue((boolean)result.isTextual());
        Assert.assertEquals((Object)"abcdefg", (Object)result.textValue());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)ByteBuffer.wrap("hello".getBytes())));
        Assert.assertTrue((boolean)result.isTextual());
        Assert.assertEquals((Object)"hello", (Object)result.textValue());
    }

    @Test
    public void testUnsupportedJavaPrimitivesToJson() throws Exception {
        AvroSchemaTest.expectConversionException((byte)0);
        AvroSchemaTest.expectConversionException(Character.valueOf('\u0000'));
        AvroSchemaTest.expectConversionException((short)0);
    }

    @Test
    public void testRecordToJson() throws Exception {
        GenericData.Record data = new GenericRecordBuilder(recordSchema).set("null", null).set("boolean", (Object)true).set("int", (Object)12).set("long", (Object)5000000000L).set("float", (Object)Float.valueOf(23.4f)).set("double", (Object)800.25).set("bytes", (Object)ByteBuffer.wrap("bytes".getBytes())).set("string", (Object)"string").build();
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)data));
        Assert.assertTrue((boolean)result.isObject());
        Assert.assertTrue((boolean)result.get("null").isNull());
        Assert.assertTrue((boolean)result.get("boolean").isBoolean());
        Assert.assertEquals((Object)true, (Object)result.get("boolean").booleanValue());
        Assert.assertTrue((boolean)result.get("int").isIntegralNumber());
        Assert.assertEquals((long)12L, (long)result.get("int").intValue());
        Assert.assertTrue((boolean)result.get("long").isIntegralNumber());
        Assert.assertEquals((long)5000000000L, (long)result.get("long").longValue());
        Assert.assertTrue((boolean)result.get("float").isFloatingPointNumber());
        Assert.assertEquals((double)23.4f, (double)result.get("float").floatValue(), (double)0.1);
        Assert.assertTrue((boolean)result.get("double").isFloatingPointNumber());
        Assert.assertEquals((double)800.25, (double)result.get("double").doubleValue(), (double)0.01);
        Assert.assertTrue((boolean)result.get("bytes").isTextual());
        Assert.assertEquals((Object)"bytes", (Object)result.get("bytes").textValue());
        Assert.assertTrue((boolean)result.get("string").isTextual());
        Assert.assertEquals((Object)"string", (Object)result.get("string").textValue());
    }

    @Test
    public void testArrayToJson() throws Exception {
        GenericData.Array data = new GenericData.Array(arraySchema, Arrays.asList("one", "two", "three"));
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)data));
        Assert.assertTrue((boolean)result.isArray());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("one"), (Object)result.get(0));
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("two"), (Object)result.get(1));
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("three"), (Object)result.get(2));
    }

    @Test
    public void testMapToJson() throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("first", "one");
        data.put("second", "two");
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson(data));
        Assert.assertTrue((boolean)result.isObject());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNotNull((Object)result.get("first"));
        Assert.assertEquals((Object)"one", (Object)result.get("first").asText());
        Assert.assertNotNull((Object)result.get("second"));
        Assert.assertEquals((Object)"two", (Object)result.get("second").asText());
    }

    @Test
    public void testEnumToJson() throws Exception {
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)new GenericData.EnumSymbol(enumSchema, "SPADES")));
        Assert.assertTrue((boolean)result.isTextual());
        Assert.assertEquals((Object)"SPADES", (Object)result.textValue());
    }

    private static void expectConversionException(JsonNode obj, AvroSchema schema) {
        try {
            AvroSchemaUtils.toObject((JsonNode)obj, (AvroSchema)schema);
            Assert.fail((String)("Expected conversion of " + (obj == null ? "null" : obj.toString()) + " to schema " + schema.toString() + " to fail"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void expectConversionException(Object obj) {
        try {
            AvroSchemaUtils.toJson((Object)obj);
            Assert.fail((String)("Expected conversion of " + (obj == null ? "null" : obj.toString() + " (" + obj.getClass().getName() + ")") + " to fail"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static AvroSchema createPrimitiveSchema(String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return new AvroSchema(parser.parse(schemaString));
    }

    private static JsonNode jsonTree(String jsonData) {
        try {
            return objectMapper.readTree(jsonData);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JSON", e);
        }
    }
}

