/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import io.confluent.kafka.formatter.AvroMessageFormatter;
import io.confluent.kafka.formatter.AvroMessageReader;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KafkaAvroFormatterTest {
    private Properties props;
    private AvroMessageFormatter formatter;
    private Schema recordSchema = null;
    private Schema intSchema = null;
    private SchemaRegistryClient schemaRegistry = null;

    @Before
    public void setUp() {
        this.props = new Properties();
        this.props.put("schema.registry.url", "bogus");
        String userSchema = "{\"namespace\": \"example.avro\",\"type\": \"record\",\"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        this.recordSchema = parser.parse(userSchema);
        this.intSchema = parser.parse("{\"type\" : \"int\"}");
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.formatter = new AvroMessageFormatter(this.schemaRegistry, null);
    }

    @Test
    public void testKafkaAvroValueFormatter() {
        this.formatter.init(this.props);
        String inputJson = "{\"name\":\"myname\"}\n";
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(inputJson.getBytes())));
        AvroMessageReader avroReader = new AvroMessageReader(this.schemaRegistry, null, this.recordSchema, "topic1", false, reader, true);
        ProducerRecord message = avroReader.readMessage();
        byte[] serializedValue = (byte[])message.value();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord crecord = new ConsumerRecord("topic1", 0, 200L, 1000L, TimestampType.LOG_APPEND_TIME, 0L, 0, serializedValue.length, null, (Object)serializedValue);
        this.formatter.writeTo(crecord, ps);
        String outputJson = baos.toString();
        Assert.assertEquals((String)"Input value json should match output value json", (Object)inputJson, (Object)outputJson);
    }

    @Test
    public void testKafkaAvroKeyValueFormatter() {
        this.props.put("print.key", "true");
        this.formatter.init(this.props);
        String inputJson = "10\t{\"name\":\"myname\"}\n";
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(inputJson.getBytes())));
        AvroMessageReader avroReader = new AvroMessageReader(this.schemaRegistry, this.intSchema, this.recordSchema, "topic1", true, reader, true);
        ProducerRecord message = avroReader.readMessage();
        byte[] serializedKey = (byte[])message.key();
        byte[] serializedValue = (byte[])message.value();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord crecord = new ConsumerRecord("topic1", 0, 200L, 1000L, TimestampType.LOG_APPEND_TIME, 0L, serializedKey.length, serializedValue.length, (Object)serializedKey, (Object)serializedValue);
        this.formatter.writeTo(crecord, ps);
        String outputJson = baos.toString();
        Assert.assertEquals((String)"Input key/value json should match output key/value json", (Object)inputJson, (Object)outputJson);
    }

    @Test
    public void testInvalidFormat() {
        String inputJson = "{\"invalid-field-name\":\"myname\"}\n";
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(inputJson.getBytes())));
        AvroMessageReader avroReader = new AvroMessageReader(this.schemaRegistry, null, this.recordSchema, "topic1", false, reader, true);
        try {
            avroReader.readMessage();
        }
        catch (SerializationException e) {
            Assert.assertTrue((String)"The cause of the exception should be avro", (boolean)(e.getCause() instanceof AvroRuntimeException));
        }
    }

    @Test
    public void testStringKey() {
        this.props.put("print.key", "true");
        this.formatter = new AvroMessageFormatter(this.schemaRegistry, (Deserializer)new StringDeserializer());
        this.formatter.init(this.props);
        String inputJson = "{\"name\":\"myname\"}\n";
        String expectedJson = "TestKey\t" + inputJson;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(inputJson.getBytes())));
        AvroMessageReader avroReader = new AvroMessageReader(this.schemaRegistry, null, this.recordSchema, "topic1", false, reader, true);
        ProducerRecord message = avroReader.readMessage();
        byte[] serializedKey = "TestKey".getBytes();
        byte[] serializedValue = (byte[])message.value();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord crecord = new ConsumerRecord("topic1", 0, 200L, 1000L, TimestampType.LOG_APPEND_TIME, 0L, serializedKey.length, serializedValue.length, (Object)serializedKey, (Object)serializedValue);
        this.formatter.writeTo(crecord, ps);
        String outputJson = baos.toString();
        Assert.assertEquals((String)"Input key/value json should match output key/value json", (Object)expectedJson, (Object)outputJson);
    }
}

