/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import avro.shaded.com.google.common.collect.ImmutableMap;
import io.confluent.kafka.example.ExtendedUser;
import io.confluent.kafka.example.User;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.KafkaAvroDecoder;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.utils.VerifiableProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.apache.kafka.common.errors.SerializationException;
import org.junit.Assert;
import org.junit.Test;

public class KafkaAvroSerializerTest {
    private final SchemaRegistryClient schemaRegistry;
    private final KafkaAvroSerializer avroSerializer;
    private final KafkaAvroDeserializer avroDeserializer;
    private final KafkaAvroDecoder avroDecoder;
    private final String topic;
    private final KafkaAvroDeserializer specificAvroDeserializer;
    private final KafkaAvroDecoder specificAvroDecoder;

    public KafkaAvroSerializerTest() {
        Properties defaultConfig = new Properties();
        defaultConfig.put("schema.registry.url", "bogus");
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.avroSerializer = new KafkaAvroSerializer(this.schemaRegistry, new HashMap<Object, Object>(defaultConfig));
        this.avroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry);
        this.avroDecoder = new KafkaAvroDecoder(this.schemaRegistry, new VerifiableProperties(defaultConfig));
        this.topic = "test";
        HashMap<String, String> specificDeserializerProps = new HashMap<String, String>();
        specificDeserializerProps.put("schema.registry.url", "bogus");
        specificDeserializerProps.put("specific.avro.reader", "true");
        this.specificAvroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, specificDeserializerProps);
        Properties specificDecoderProps = new Properties();
        specificDecoderProps.setProperty("schema.registry.url", "bogus");
        specificDecoderProps.setProperty("specific.avro.reader", "true");
        this.specificAvroDecoder = new KafkaAvroDecoder(this.schemaRegistry, new VerifiableProperties(specificDecoderProps));
    }

    private IndexedRecord createAvroRecord() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    private IndexedRecord createAccountRecord() {
        String accountSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"Account\",\"fields\": [{\"name\": \"accountNumber\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(accountSchema);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("accountNumber", (Object)"0123456789");
        return avroRecord;
    }

    private IndexedRecord createSpecificAvroRecord() {
        return User.newBuilder().setName("testUser").build();
    }

    private IndexedRecord createExtendedSpecificAvroRecord() {
        return ExtendedUser.newBuilder().setName("testUser").setAge(99).build();
    }

    private IndexedRecord createInvalidAvroRecord() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"f1\", \"type\": \"string\"},{\"name\": \"f2\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("f1", (Object)"value1");
        avroRecord.put("f1", (Object)12);
        return avroRecord;
    }

    @Test
    public void testKafkaAvroSerializer() {
        IndexedRecord avroRecord = this.createAvroRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, null);
        Assert.assertEquals(null, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals(null, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)true);
        Assert.assertEquals((Object)true, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)true, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)123);
        Assert.assertEquals((Object)123, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)123, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)345L);
        Assert.assertEquals((Object)345L, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)345L, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)Float.valueOf(1.23f));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)2.34);
        Assert.assertEquals((Object)2.34, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)2.34, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)"abc");
        Assert.assertEquals((Object)"abc", (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)"abc", (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)"abc".getBytes());
        Assert.assertArrayEquals((byte[])"abc".getBytes(), (byte[])((byte[])this.avroDeserializer.deserialize(this.topic, bytes)));
        Assert.assertArrayEquals((byte[])"abc".getBytes(), (byte[])((byte[])this.avroDecoder.fromBytes(bytes)));
        bytes = this.avroSerializer.serialize(this.topic, (Object)new Utf8("abc"));
        Assert.assertEquals((Object)"abc", (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)"abc", (Object)this.avroDecoder.fromBytes(bytes));
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroSerializerWithoutAutoRegister() {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false);
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord avroRecord = this.createAvroRecord();
        this.avroSerializer.serialize(this.topic, (Object)avroRecord);
    }

    @Test
    public void testKafkaAvroSerializerWithPreRegistered() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false);
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord avroRecord = this.createAvroRecord();
        this.schemaRegistry.register(this.topic + "-value", avroRecord.getSchema());
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDecoder.fromBytes(bytes));
    }

    @Test
    public void testKafkaAvroSerializerWithMultiType() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"value.subject.name.strategy", (Object)TopicRecordNameStrategy.class.getName());
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord record1 = this.createAvroRecord();
        IndexedRecord record2 = this.createAccountRecord();
        byte[] bytes1 = this.avroSerializer.serialize(this.topic, (Object)record1);
        byte[] bytes2 = this.avroSerializer.serialize(this.topic, (Object)record2);
        Assert.assertNotNull((Object)this.schemaRegistry.getLatestSchemaMetadata(this.topic + "-example.avro.User"));
        Assert.assertNotNull((Object)this.schemaRegistry.getLatestSchemaMetadata(this.topic + "-example.avro.Account"));
        Assert.assertEquals((Object)record1, (Object)this.avroDeserializer.deserialize(this.topic, bytes1));
        Assert.assertEquals((Object)record2, (Object)this.avroDeserializer.deserialize(this.topic, bytes2));
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroSerializerWithMultiTypeError() {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"value.subject.name.strategy", (Object)TopicRecordNameStrategy.class.getName());
        this.avroSerializer.configure((Map)configs, false);
        this.avroSerializer.serialize(this.topic, (Object)"a string should not be allowed");
    }

    @Test
    public void testKafkaAvroSerializerWithProjection() {
        IndexedRecord avroRecord = this.createExtendedSpecificAvroRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Object obj = this.avroDecoder.fromBytes(bytes);
        GenericData.Record extendedUser = (GenericData.Record)obj;
        Assert.assertTrue((String)"Returned object should be a GenericData Record", (boolean)GenericData.Record.class.isInstance(obj));
        Assert.assertNotNull((Object)extendedUser.get("age"));
        obj = this.avroDecoder.fromBytes(bytes, User.getClassSchema());
        Assert.assertTrue((String)"Returned object should be a GenericData Record", (boolean)GenericData.Record.class.isInstance(obj));
        GenericData.Record decoderProjection = (GenericData.Record)obj;
        Assert.assertEquals((Object)"testUser", (Object)decoderProjection.get("name").toString());
        Assert.assertNull((Object)decoderProjection.get("age"));
        obj = this.avroDeserializer.deserialize(this.topic, bytes, User.getClassSchema());
        Assert.assertTrue((String)"Returned object should be a GenericData Record", (boolean)GenericData.Record.class.isInstance(obj));
        GenericData.Record deserializeProjection = (GenericData.Record)obj;
        Assert.assertEquals((Object)"testUser", (Object)deserializeProjection.get("name").toString());
        Assert.assertNull((Object)deserializeProjection.get("age"));
    }

    @Test
    public void testKafkaAvroSerializerSpecificRecord() {
        IndexedRecord avroRecord = this.createSpecificAvroRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Object obj = this.avroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Returned object should be a GenericData Record", (boolean)GenericData.Record.class.isInstance(obj));
        obj = this.specificAvroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Returned object should be a io.confluent.kafka.example.User", (boolean)User.class.isInstance(obj));
        Assert.assertEquals((Object)avroRecord, (Object)obj);
        obj = this.specificAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a io.confluent.kafka.example.User", (boolean)User.class.isInstance(obj));
        Assert.assertEquals((Object)avroRecord, (Object)obj);
    }

    @Test
    public void testKafkaAvroSerializerSpecificRecordWithProjection() {
        IndexedRecord avroRecord = this.createExtendedSpecificAvroRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Object obj = this.specificAvroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Full object should be a io.confluent.kafka.example.ExtendedUser", (boolean)ExtendedUser.class.isInstance(obj));
        Assert.assertEquals((Object)avroRecord, (Object)obj);
        obj = this.specificAvroDecoder.fromBytes(bytes, User.getClassSchema());
        Assert.assertTrue((String)"Projection object should be a io.confluent.kafka.example.User", (boolean)User.class.isInstance(obj));
        Assert.assertEquals((Object)"testUser", (Object)((User)((Object)obj)).getName().toString());
        obj = this.specificAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Full object should be a io.confluent.kafka.example.ExtendedUser", (boolean)ExtendedUser.class.isInstance(obj));
        Assert.assertEquals((Object)avroRecord, (Object)obj);
        obj = this.specificAvroDeserializer.deserialize(this.topic, bytes, User.getClassSchema());
        Assert.assertTrue((String)"Projection object should be a io.confluent.kafka.example.User", (boolean)User.class.isInstance(obj));
        Assert.assertEquals((Object)"testUser", (Object)((User)((Object)obj)).getName().toString());
    }

    @Test
    public void testKafkaAvroSerializerNonexistantSpecificRecord() {
        IndexedRecord avroRecord = this.createAvroRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        try {
            this.specificAvroDecoder.fromBytes(bytes);
            Assert.fail((String)"Did not throw an exception when class for specific avro record does not exist.");
        }
        catch (SerializationException serializationException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Threw the incorrect exception when class for specific avro record does not exist.");
        }
        try {
            this.specificAvroDeserializer.deserialize(this.topic, bytes);
            Assert.fail((String)"Did not throw an exception when class for specific avro record does not exist.");
        }
        catch (SerializationException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Threw the incorrect exception when class for specific avro record does not exist.");
        }
    }

    @Test
    public void testNull() {
        SchemaRegistryClient nullSchemaRegistryClient = null;
        KafkaAvroSerializer nullAvroSerializer = new KafkaAvroSerializer(nullSchemaRegistryClient);
        Assert.assertEquals(null, (Object)nullAvroSerializer.serialize("test", null));
    }

    @Test
    public void testAvroSerializerInvalidInput() {
        IndexedRecord invalidRecord = this.createInvalidAvroRecord();
        try {
            this.avroSerializer.serialize(this.topic, (Object)invalidRecord);
            Assert.fail((String)"Sending invalid record should fail serializer");
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    @Test
    public void test_schemas_per_subject() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("schema.registry.url", "bogus");
        props.put("specific.avro.reader", "true");
        props.put("max.schemas.per.subject", "5");
        this.avroSerializer.configure(props, false);
    }

    @Test
    public void testKafkaAvroSerializerSpecificRecordWithPrimitives() {
        String message = "testKafkaAvroSerializerSpecificRecordWithPrimitives";
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)message);
        Object obj = this.avroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        obj = this.specificAvroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        Assert.assertEquals((Object)message, (Object)obj);
        obj = this.specificAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        Assert.assertEquals((Object)message, (Object)obj);
    }
}

