/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import avro.shaded.com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import io.confluent.kafka.serializers.GenericContainerWithVersion;
import io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.subject.RecordNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractKafkaAvroDeserializerTest {
    private Map<String, ?> defaultConfigs;
    private SchemaRegistryClient schemaRegistry;
    private KafkaAvroSerializer avroSerializer;
    private Deserializer deserializer;

    @Before
    public void setUp() {
        this.defaultConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus");
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.avroSerializer = new KafkaAvroSerializer(this.schemaRegistry, this.defaultConfigs);
        this.deserializer = new Deserializer(this.schemaRegistry);
    }

    private IndexedRecord createAvroRecord() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    public void assertSchemaNotCopiedWhenDeserializedWithVersion(String topic, SubjectNameStrategy<Schema> subjectNameStrategy) throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.builder().putAll(this.defaultConfigs).put((Object)"auto.register.schemas", (Object)false).put((Object)"value.subject.name.strategy", subjectNameStrategy.getClass()).build();
        IndexedRecord avroRecord = this.createAvroRecord();
        String subject = subjectNameStrategy.subjectName(topic, false, (Object)avroRecord.getSchema());
        this.avroSerializer.configure((Map)configs, false);
        this.deserializer.configure(new KafkaAvroDeserializerConfig((Map)configs));
        this.schemaRegistry.register(subject, avroRecord.getSchema());
        byte[] bytes = this.avroSerializer.serialize(topic, (Object)avroRecord);
        IndexedRecord deserialized = (IndexedRecord)this.deserializer.deserializeWithSchemaAndVersion(topic, false, bytes).container();
        Assert.assertThat((Object)deserialized.getSchema(), (Matcher)CoreMatchers.sameInstance((Object)avroRecord.getSchema()));
    }

    @Test
    public void testSchemaNotCopiedForTopicNameStrategy() throws IOException, RestClientException {
        this.assertSchemaNotCopiedWhenDeserializedWithVersion("test-topic", (SubjectNameStrategy<Schema>)new TopicNameStrategy());
    }

    @Test
    public void testSchemaNotCopiedForRecordNameStrategy() throws IOException, RestClientException {
        this.assertSchemaNotCopiedWhenDeserializedWithVersion("test-topic", (SubjectNameStrategy<Schema>)new RecordNameStrategy());
    }

    @Test
    public void testSchemaNotCopiedForTopicRecordNameStrategy() throws IOException, RestClientException {
        this.assertSchemaNotCopiedWhenDeserializedWithVersion("test-topic", (SubjectNameStrategy<Schema>)new TopicRecordNameStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSchemaInternalHashCode(Schema avroSchema) throws NoSuchFieldException, IllegalAccessException {
        Field hashCodeField = Schema.class.getDeclaredField("hashCode");
        boolean accessible = hashCodeField.isAccessible();
        hashCodeField.setAccessible(true);
        try {
            int n = (Integer)hashCodeField.get(avroSchema);
            return n;
        }
        finally {
            hashCodeField.setAccessible(accessible);
        }
    }

    @Test
    public void testSchemaVersionSet() throws IOException, RestClientException {
        IndexedRecord avroRecord = this.createAvroRecord();
        int version = this.schemaRegistry.register("topic", avroRecord.getSchema());
        byte[] bytes = this.avroSerializer.serialize("topic", (Object)avroRecord);
        GenericContainerWithVersion genericContainerWithVersion = this.deserializer.deserializeWithSchemaAndVersion("topic", false, bytes);
        Schema avroSchema = genericContainerWithVersion.container().getSchema();
        Integer schemaVersion = genericContainerWithVersion.version();
        Assert.assertThat((Object)schemaVersion, (Matcher)CoreMatchers.equalTo((Object)version));
    }

    @Test
    public void testHashCodeNotReset() throws NoSuchFieldException, IllegalAccessException {
        IndexedRecord avroRecord = this.createAvroRecord();
        byte[] bytes = this.avroSerializer.serialize("topic", (Object)avroRecord);
        IndexedRecord deserialized1 = (IndexedRecord)this.deserializer.deserializeWithSchemaAndVersion("topic", false, bytes).container();
        int hashCode = deserialized1.getSchema().hashCode();
        IndexedRecord deserialized2 = (IndexedRecord)this.deserializer.deserializeWithSchemaAndVersion("topic", false, bytes).container();
        Assert.assertThat((Object)deserialized1.getSchema(), (Matcher)CoreMatchers.sameInstance((Object)deserialized2.getSchema()));
        Schema avroSchema = deserialized2.getSchema();
        Assert.assertThat((Object)this.getSchemaInternalHashCode(avroSchema), (Matcher)CoreMatchers.equalTo((Object)hashCode));
    }

    private static class Deserializer
    extends AbstractKafkaAvroDeserializer {
        Deserializer(SchemaRegistryClient schemaRegistry) {
            this.schemaRegistry = schemaRegistry;
        }
    }
}

