/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import io.confluent.kafka.formatter.AvroMessageFormatter;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AvroMessageFormatterTest {
    private static final byte MAGIC_BYTE = 0;
    private static final String KEY_STRING = "These are other bytes.";
    private static final String A_STRING = "These are bytes.";
    private static final byte[] KEY_BYTES = "These are other bytes.".getBytes();
    private static final byte[] SOME_BYTES = "These are bytes.".getBytes();
    private static final int KEY_SCHEMA_ID = 2;
    private static final int VALUE_SCHEMA_ID = 1;
    private static final byte[] KEY_SCHEMA_ID_BYTES = ByteBuffer.allocate(4).putInt(2).array();
    private static final byte[] SCHEMA_ID_BYTES = ByteBuffer.allocate(4).putInt(1).array();
    private AvroMessageFormatter formatter;
    private Properties props;
    private SchemaRegistryClient schemaRegistry;
    private ConsumerRecord<byte[], byte[]> recordWithValue;
    private ConsumerRecord<byte[], byte[]> recordWithKeyAndValue;

    @Before
    public void setup() throws IOException, RestClientException {
        this.props = new Properties();
        this.props.put("schema.registry.url", "bogus");
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.recordWithValue = this.createConsumerRecord(false);
        this.recordWithKeyAndValue = this.createConsumerRecord(true);
        Schema schema1 = Schema.create((Schema.Type)Schema.Type.BYTES);
        Schema schema2 = Schema.create((Schema.Type)Schema.Type.BYTES);
        schema2.addProp("foo", "bar");
        this.schemaRegistry.register("topicname", schema1);
        this.schemaRegistry.register("othertopic", schema2);
        this.formatter = new AvroMessageFormatter(this.schemaRegistry, null);
    }

    @Test
    public void testDeserializeBytesIssue506() throws IOException, RestClientException {
        this.formatter.init(this.props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.formatter.writeTo(this.recordWithValue, ps);
        Assert.assertEquals((Object)"\"These are bytes.\"\n", (Object)baos.toString());
    }

    @Test
    public void testDeserializeRecordWithKeyAndValue() throws IOException, RestClientException {
        this.formatter.init(this.props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.formatter.writeTo(this.recordWithKeyAndValue, ps);
        Assert.assertEquals((Object)"\"These are bytes.\"\n", (Object)baos.toString());
    }

    @Test
    public void testDeserializeRecordWithKeyAndValueAndPrintingKey() throws IOException, RestClientException {
        this.props.put("print.key", "true");
        this.formatter.init(this.props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.formatter.writeTo(this.recordWithKeyAndValue, ps);
        Assert.assertEquals((Object)"\"These are other bytes.\"\t\"These are bytes.\"\n", (Object)baos.toString());
    }

    @Test
    public void testDeserializeRecordWithKeyAndValueAndPrintingKeyWithoutSchemaId() throws IOException, RestClientException {
        this.props.put("print.key", "true");
        this.props.put("print.schema.ids", "false");
        this.formatter.init(this.props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.formatter.writeTo(this.recordWithKeyAndValue, ps);
        Assert.assertEquals((Object)"\"These are other bytes.\"\t\"These are bytes.\"\n", (Object)baos.toString());
    }

    @Test
    public void testDeserializeRecordWithKeyAndValueAndPrintingKeyAndSchemaIds() throws IOException, RestClientException {
        this.props.put("print.key", "true");
        this.props.put("print.schema.ids", "true");
        this.formatter.init(this.props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.formatter.writeTo(this.recordWithKeyAndValue, ps);
        Assert.assertEquals((Object)"\"These are other bytes.\"\t2\t\"These are bytes.\"\t1\n", (Object)baos.toString());
    }

    @Test
    public void testDeserializeRecordWithKeyAndValueAndPrintingSchemaIds() throws IOException, RestClientException {
        this.props.put("print.key", "false");
        this.props.put("print.schema.ids", "true");
        this.formatter.init(this.props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.formatter.writeTo(this.recordWithKeyAndValue, ps);
        Assert.assertEquals((Object)"\"These are bytes.\"\t1\n", (Object)baos.toString());
    }

    @Test
    public void testDeserializeRecordWithKeyAndValueAndPrintingSchemaIdsWithDelimiter() throws IOException, RestClientException {
        this.props.put("print.key", "false");
        this.props.put("print.schema.ids", "true");
        this.props.put("schema.id.separator", "___");
        this.formatter.init(this.props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.formatter.writeTo(this.recordWithKeyAndValue, ps);
        Assert.assertEquals((Object)"\"These are bytes.\"___1\n", (Object)baos.toString());
    }

    @Test
    public void testDeserializeRecordWithKeyAndValueAndPrintingKeysAndSchemaIdsWithDelimiter() throws IOException, RestClientException {
        this.props.put("print.key", "true");
        this.props.put("print.schema.ids", "true");
        this.props.put("schema.id.separator", "___");
        this.formatter.init(this.props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.formatter.writeTo(this.recordWithKeyAndValue, ps);
        Assert.assertEquals((Object)"\"These are other bytes.\"___2\t\"These are bytes.\"___1\n", (Object)baos.toString());
    }

    protected ConsumerRecord<byte[], byte[]> createConsumerRecord(boolean includeKey) {
        byte[] key = new byte[1 + KEY_SCHEMA_ID_BYTES.length + KEY_BYTES.length];
        key[0] = 0;
        System.arraycopy(KEY_SCHEMA_ID_BYTES, 0, key, 1, KEY_SCHEMA_ID_BYTES.length);
        System.arraycopy(KEY_BYTES, 0, key, 1 + KEY_SCHEMA_ID_BYTES.length, KEY_BYTES.length);
        byte[] value = new byte[1 + SCHEMA_ID_BYTES.length + SOME_BYTES.length];
        value[0] = 0;
        System.arraycopy(SCHEMA_ID_BYTES, 0, value, 1, SCHEMA_ID_BYTES.length);
        System.arraycopy(SOME_BYTES, 0, value, 1 + SCHEMA_ID_BYTES.length, SOME_BYTES.length);
        return new ConsumerRecord("topic1", 0, 200L, 1000L, TimestampType.LOG_APPEND_TIME, 0L, 0, value.length, (Object)((byte[])(includeKey ? key : null)), (Object)value);
    }
}

