/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.storage;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.rest.RestConfigException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DekRegistryConfig
extends SchemaRegistryConfig {
    private static final Logger log = LoggerFactory.getLogger(DekRegistryConfig.class);
    public static final String DEK_REGISTRY_TOPIC_CONFIG = "dek.registry.topic";
    public static final String DEK_REGISTRY_MAX_KEYS_CONFIG = "dek.registry.max.keys";
    public static final String DEK_REGISTRY_UPDATE_HANDLERS_CONFIG = "dek.registry.update.handlers";
    protected static final String DEK_REGISTRY_TOPIC_DEFAULT = "_dek_registry_keys";
    protected static final int DEK_REGISTRY_MAX_KEYS_DEFAULT = 10000;
    protected static final String DEK_REGISTRY_TOPIC_DOC = "The topic used to persist keys for the dek registry.";
    protected static final String DEK_REGISTRY_MAX_KEYS_DOC = "Maximum number of keys per tenant.";
    protected static final String DEK_REGISTRY_UPDATE_HANDLERS_DOC = "A list of classes to use as CacheUpdateHandler. Implementing the interface <code>CacheUpdateHandler</code> allows you to handle Kafka cache update events.";
    private static final ConfigDef serverConfig = DekRegistryConfig.baseSchemaRegistryConfigDef().define("dek.registry.topic", ConfigDef.Type.STRING, (Object)"_dek_registry_keys", ConfigDef.Importance.HIGH, "The topic used to persist keys for the dek registry.").define("dek.registry.max.keys", ConfigDef.Type.INT, (Object)10000, ConfigDef.Importance.LOW, "Maximum number of keys per tenant.").define("dek.registry.update.handlers", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as CacheUpdateHandler. Implementing the interface <code>CacheUpdateHandler</code> allows you to handle Kafka cache update events.");

    private static Properties getPropsFromFile(String propsFile) throws RestConfigException {
        Properties props = new Properties();
        if (propsFile == null) {
            return props;
        }
        try (FileInputStream propStream = new FileInputStream(propsFile);){
            props.load(propStream);
        }
        catch (IOException e) {
            throw new RestConfigException("Couldn't load properties from " + propsFile, (Throwable)e);
        }
        return props;
    }

    public DekRegistryConfig(String propsFile) throws RestConfigException {
        this(DekRegistryConfig.getPropsFromFile(propsFile));
    }

    public DekRegistryConfig(Properties props) throws RestConfigException {
        this(serverConfig, props);
    }

    public DekRegistryConfig(ConfigDef configDef, Properties props) throws RestConfigException {
        super(configDef, props);
    }

    public String topic() {
        return this.getString(DEK_REGISTRY_TOPIC_CONFIG);
    }

    public int maxKeys() {
        return this.getInt(DEK_REGISTRY_MAX_KEYS_CONFIG);
    }
}

