/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.web.rest;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.testing.FakeTicker;
import com.google.crypto.tink.Aead;
import io.confluent.dekregistry.DekRegistryResourceExtension;
import io.confluent.dekregistry.client.CachedDekRegistryClient;
import io.confluent.dekregistry.client.rest.DekRegistryRestService;
import io.confluent.dekregistry.client.rest.entities.Dek;
import io.confluent.dekregistry.client.rest.entities.Kek;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.encryption.tink.Cryptor;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RestApiTest
extends ClusterTestHarness {
    FakeTicker fakeTicker;
    CachedDekRegistryClient client;

    public RestApiTest() {
        super(1, true);
    }

    public Properties getSchemaRegistryProperties() throws Exception {
        Properties props = new Properties();
        props.put("resource.extension.class", DekRegistryResourceExtension.class.getName());
        props.put("inter.instance.headers.whitelist", "X-Forward");
        return props;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fakeTicker = new FakeTicker();
        this.client = new CachedDekRegistryClient(new DekRegistryRestService(this.restApp.restClient.getBaseUrls().urls()), 1000, 60, null, null, (Ticker)this.fakeTicker);
        ((KafkaSchemaRegistry)this.restApp.schemaRegistry()).setRuleSetHandler(new RuleSetHandler(){

            public void handle(String subject, ConfigUpdateRequest request) {
            }

            public void handle(String subject, boolean normalize, RegisterSchemaRequest request) {
            }

            public io.confluent.kafka.schemaregistry.storage.RuleSet transform(RuleSet ruleSet) {
                return ruleSet != null ? new io.confluent.kafka.schemaregistry.storage.RuleSet(ruleSet) : null;
            }
        });
    }

    @Test
    public void testBasic() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/vnd.schemaregistry.v1+json");
        this.testBasic(headers, false);
    }

    @Test
    public void testForwarding() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/vnd.schemaregistry.v1+json");
        headers.put("X-Forward", "false");
        this.testBasic(headers, false);
    }

    @Test
    public void testBasicImport() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/vnd.schemaregistry.v1+json");
        this.testBasic(headers, true);
    }

    private void testBasic(Map<String, String> headers, boolean isImport) throws Exception {
        String kekName = "kek1";
        String kmsType = "test-kms";
        String kmsKeyId = "myid";
        String subject = "mysubject";
        String badSubject = "badSubject";
        String subject2 = "mysubject2";
        DekFormat algorithm = DekFormat.AES256_GCM;
        Kek kek = new Kek(kekName, kmsType, kmsKeyId, null, null, false, null, null);
        if (isImport) {
            this.client.setMode("IMPORT");
        }
        Kek newKek = this.client.createKek(headers, kekName, kmsType, kmsKeyId, null, null, false, false);
        Assert.assertEquals((Object)kek, (Object)newKek);
        this.client.deleteKek(headers, kekName, false);
        newKek = this.client.createKek(headers, kekName, kmsType, kmsKeyId, null, null, false, false);
        Assert.assertEquals((Object)kek, (Object)newKek);
        newKek = this.client.getKek(kekName, false);
        Assert.assertEquals((Object)kek, (Object)newKek);
        List keks = this.client.listKeks(false);
        Assert.assertEquals(Collections.singletonList(kekName), (Object)keks);
        try {
            this.client.deleteKek(headers, kekName, true);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40471L, (long)e.getErrorCode());
        }
        this.client.deleteKek(headers, kekName, false);
        Map<String, String> kmsProps = Collections.singletonMap("hi", "there");
        String doc = "mydoc";
        try {
            this.client.updateKek(headers, kekName, kmsProps, doc, Boolean.valueOf(true));
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40470L, (long)e.getErrorCode());
        }
        keks = this.client.listKeks(false);
        Assert.assertEquals(Collections.emptyList(), (Object)keks);
        keks = this.client.listKeks(true);
        Assert.assertEquals(Collections.singletonList(kekName), (Object)keks);
        try {
            this.client.getKek(kekName, false);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40470L, (long)e.getErrorCode());
        }
        newKek = this.client.getKek(kekName, true);
        Assert.assertEquals((Object)kek, (Object)newKek);
        this.client.deleteKek(headers, kekName, true);
        try {
            this.client.getKek(kekName, false);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40470L, (long)e.getErrorCode());
        }
        try {
            this.client.getKek(kekName, true);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40470L, (long)e.getErrorCode());
        }
        keks = this.client.listKeks(false);
        Assert.assertEquals(Collections.emptyList(), (Object)keks);
        keks = this.client.listKeks(true);
        Assert.assertEquals(Collections.emptyList(), (Object)keks);
        newKek = this.client.createKek(headers, kekName, kmsType, kmsKeyId, null, null, false, false);
        Assert.assertEquals((Object)kek, (Object)newKek);
        newKek = this.client.getKek(kekName, false);
        Assert.assertEquals((Object)kek, (Object)newKek);
        byte[] rawDek = new Cryptor(algorithm).generateKey();
        String rawDekStr = new String(Base64.getEncoder().encode(rawDek), StandardCharsets.UTF_8);
        Aead aead = kek.toAead(Collections.emptyMap());
        byte[] encryptedDek = aead.encrypt(rawDek, new byte[0]);
        String encryptedDekStr = new String(Base64.getEncoder().encode(encryptedDek), StandardCharsets.UTF_8);
        Dek dek = new Dek(kekName, subject, 1, algorithm, encryptedDekStr, null, null, null);
        Dek newDek = this.client.createDek(headers, kekName, subject, null, algorithm, encryptedDekStr, false);
        Assert.assertEquals((Object)dek, (Object)newDek);
        this.client.deleteDek(headers, kekName, subject, algorithm, false);
        newDek = this.client.createDek(headers, kekName, subject, null, algorithm, encryptedDekStr, false);
        Assert.assertEquals((Object)dek, (Object)newDek);
        newDek = this.client.getDek(kekName, subject, algorithm, false);
        Assert.assertEquals((Object)dek, (Object)newDek);
        Assert.assertNotNull((Object)newDek.getTimestamp());
        try {
            newDek = this.client.createDek(headers, kekName, badSubject, null, algorithm, null, false);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)42271L, (long)e.getErrorCode());
        }
        newDek = this.client.getDek(kekName, subject, algorithm, false);
        Assert.assertEquals((Object)dek, (Object)newDek);
        Assert.assertNotNull((Object)newDek.getTimestamp());
        Kek kek2 = new Kek(kekName, kmsType, kmsKeyId, kmsProps, doc, true, null, null);
        newKek = this.client.updateKek(headers, kekName, kmsProps, doc, Boolean.valueOf(true));
        Assert.assertEquals((Object)kek2, (Object)newKek);
        this.fakeTicker.advance(61L, TimeUnit.SECONDS);
        Dek dek2 = new Dek(kekName, subject, 1, algorithm, encryptedDekStr, rawDekStr, null, null);
        newDek = this.client.getDek(kekName, subject, algorithm, true);
        Assert.assertEquals((Object)dek2, (Object)newDek);
        Assert.assertNotNull((Object)newDek.getTimestamp());
        newDek = this.client.createDek(headers, kekName, subject2, null, algorithm, null, false);
        Assert.assertNotNull((Object)newDek.getEncryptedKeyMaterial());
        if (isImport) {
            Assert.assertNull((Object)newDek.getKeyMaterial());
        } else {
            Assert.assertNotNull((Object)newDek.getKeyMaterial());
        }
        Assert.assertNotNull((Object)newDek.getTimestamp());
        newDek = this.client.createDek(headers, kekName, subject2, Integer.valueOf(2), algorithm, null, false);
        Assert.assertEquals((long)2L, (long)newDek.getVersion());
        List deks = this.client.listDeks(kekName, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)subject, (Object)subject2), (Object)deks);
        List versions = this.client.listDekVersions(kekName, subject2, null, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)2), (Object)versions);
        try {
            this.client.deleteKek(headers, kekName, false);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)42272L, (long)e.getErrorCode());
        }
        try {
            this.client.deleteDek(headers, kekName, subject, algorithm, true);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40471L, (long)e.getErrorCode());
        }
        this.client.deleteDek(headers, kekName, subject, algorithm, false);
        try {
            this.client.getDek(kekName, subject, algorithm, false);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40470L, (long)e.getErrorCode());
        }
        newDek = this.client.getDek(kekName, subject, algorithm, true);
        Assert.assertEquals((Object)dek2, (Object)newDek);
        Assert.assertNotNull((Object)newDek.getTimestamp());
        deks = this.client.listDeks(kekName, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)subject2), (Object)deks);
        deks = this.client.listDeks(kekName, true);
        Assert.assertEquals((Object)ImmutableList.of((Object)subject, (Object)subject2), (Object)deks);
        this.client.deleteDekVersion(headers, kekName, subject2, 2, null, false);
        versions = this.client.listDekVersions(kekName, subject2, null, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)1), (Object)versions);
        this.client.undeleteDekVersion(headers, kekName, subject2, 2, null);
        versions = this.client.listDekVersions(kekName, subject2, null, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)2), (Object)versions);
        this.client.deleteDek(headers, kekName, subject2, algorithm, false);
        this.client.deleteKek(headers, kekName, false);
        try {
            deks = this.client.listDeks(kekName, false);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40470L, (long)e.getErrorCode());
        }
        deks = this.client.listDeks(kekName, true);
        Assert.assertEquals((Object)ImmutableList.of((Object)subject, (Object)subject2), (Object)deks);
        try {
            this.client.undeleteDek(headers, kekName, subject2, algorithm);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40472L, (long)e.getErrorCode());
        }
        this.client.undeleteKek(headers, kekName);
        newKek = this.client.getKek(kekName, false);
        Assert.assertEquals((Object)kek2, (Object)newKek);
        this.client.undeleteDek(headers, kekName, subject2, algorithm);
        deks = this.client.listDeks(kekName, false);
        Assert.assertEquals((Object)ImmutableList.of((Object)subject2), (Object)deks);
        this.client.deleteDek(headers, kekName, subject2, algorithm, false);
        this.client.deleteKek(headers, kekName, false);
        try {
            this.client.deleteKek(headers, kekName, true);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)42272L, (long)e.getErrorCode());
        }
        this.client.deleteDek(headers, kekName, subject, algorithm, true);
        try {
            this.client.deleteDek(headers, kekName, subject, algorithm, true);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40470L, (long)e.getErrorCode());
        }
        this.client.deleteDek(headers, kekName, subject2, algorithm, true);
        try {
            deks = this.client.listDeks(kekName, false);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40470L, (long)e.getErrorCode());
        }
        deks = this.client.listDeks(kekName, true);
        Assert.assertEquals(Collections.emptyList(), (Object)deks);
        this.client.deleteKek(headers, kekName, true);
        try {
            this.client.deleteKek(headers, kekName, true);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)40470L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testUnknownKmsType() throws Exception {
        String kekName = "kek1";
        String kmsType = "unknown-kms";
        String kmsKeyId = "myid";
        String subject = "mysubject";
        String subject2 = "mysubject2";
        DekFormat algorithm = DekFormat.AES256_GCM;
        Kek kek = new Kek(kekName, kmsType, kmsKeyId, null, null, false, null, null);
        Kek newKek = this.client.createKek(kekName, kmsType, kmsKeyId, null, null, false);
        Assert.assertEquals((Object)kek, (Object)newKek);
        newKek = this.client.getKek(kekName, false);
        Assert.assertEquals((Object)kek, (Object)newKek);
        List keks = this.client.listKeks(false);
        Assert.assertEquals(Collections.singletonList(kekName), (Object)keks);
        Kek testKek = new Kek(kekName, "test-kms", kmsKeyId, null, null, false, null, null);
        byte[] rawDek = new Cryptor(algorithm).generateKey();
        Aead aead = testKek.toAead(Collections.emptyMap());
        byte[] encryptedDek = aead.encrypt(rawDek, new byte[0]);
        String encryptedDekStr = new String(Base64.getEncoder().encode(encryptedDek), StandardCharsets.UTF_8);
        Dek dek = new Dek(kekName, subject, 1, algorithm, encryptedDekStr, null, null, null);
        Dek newDek = this.client.createDek(kekName, subject, algorithm, encryptedDekStr);
        Assert.assertEquals((Object)dek, (Object)newDek);
        newDek = this.client.getDek(kekName, subject, algorithm, false);
        Assert.assertEquals((Object)dek, (Object)newDek);
        Assert.assertNotNull((Object)newDek.getTimestamp());
        try {
            newDek = this.client.createDek(kekName, subject2, algorithm, null);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)42271L, (long)e.getErrorCode());
        }
        Map<String, String> kmsProps = Collections.singletonMap("hi", "there");
        String doc = "mydoc";
        Kek kek2 = new Kek(kekName, kmsType, kmsKeyId, kmsProps, doc, true, null, null);
        newKek = this.client.updateKek(kekName, kmsProps, doc, Boolean.valueOf(true));
        Assert.assertEquals((Object)kek2, (Object)newKek);
        this.fakeTicker.advance(61L, TimeUnit.SECONDS);
        Dek dek2 = new Dek(kekName, subject, 1, algorithm, encryptedDekStr, null, null, null);
        try {
            newDek = this.client.getDek(kekName, subject, algorithm, true);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)50070L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testRegisterCreatesKmsDefaults() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        Map<String, String> params = Collections.singletonMap("encrypt.kms.key.id", "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab");
        Rule r1 = new Rule("foo", null, null, RuleMode.WRITEREAD, "ENCRYPT", null, params, null, null, null, false);
        List<Rule> rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(null, rules);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setRuleSet(ruleSet);
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(request1, subject, false).getId());
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema1, subject);
        SortedMap newParams = ((Rule)schemaString.getRuleSet().getDomainRules().get(0)).getParams();
        Assert.assertEquals((Object)"aws-kms-us-west-2-111122223333-key-1234abcd-12ab-34cd-56ef-1234567890ab", newParams.get("encrypt.kek.name"));
        Assert.assertEquals((Object)"aws-kms", newParams.get("encrypt.kms.type"));
    }
}

