/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry;

import com.google.inject.Module;
import com.netflix.governator.InjectorBuilder;
import com.netflix.governator.LifecycleInjector;
import com.netflix.governator.LifecycleInjectorCreator;
import com.netflix.governator.spi.InjectorCreator;
import io.confluent.dekregistry.DekRegistryModule;
import io.confluent.dekregistry.storage.DekRegistry;
import io.confluent.dekregistry.web.rest.resources.DekRegistryResource;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import java.io.IOException;
import javax.ws.rs.core.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DekRegistryResourceExtension
implements SchemaRegistryResourceExtension {
    private static final Logger LOG = LoggerFactory.getLogger(DekRegistryResourceExtension.class);
    private LifecycleInjector injector;
    private DekRegistry dekRegistry;

    public void register(Configurable<?> configurable, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) throws SchemaRegistryException {
        LOG.debug("registering injector");
        this.injector = (LifecycleInjector)InjectorBuilder.fromModules((Module[])new Module[]{new DekRegistryModule(schemaRegistry)}).createInjector((InjectorCreator)new LifecycleInjectorCreator());
        LOG.debug("done registering injector");
        LOG.debug("registering rest classes");
        configurable.register(this.injector.getInstance(DekRegistryResource.class));
        LOG.debug("done registering rest classes");
        this.dekRegistry = (DekRegistry)this.injector.getInstance(DekRegistry.class);
    }

    public boolean initialized() {
        return this.dekRegistry != null && this.dekRegistry.initialized();
    }

    public void close() throws IOException {
        if (this.injector != null) {
            this.injector.close();
            this.injector = null;
        }
    }
}

