/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Dek {
    private final String kekName;
    private final String subject;
    private final int version;
    private final DekFormat algorithm;
    private final String encryptedKeyMaterial;
    private final String keyMaterial;
    private final Long timestamp;
    private final Boolean deleted;

    @JsonCreator
    public Dek(@JsonProperty(value="kekName") String kekName, @JsonProperty(value="subject") String subject, @JsonProperty(value="version") int version, @JsonProperty(value="algorithm") DekFormat algorithm, @JsonProperty(value="encryptedKeyMaterial") String encryptedKeyMaterial, @JsonProperty(value="keyMaterial") String keyMaterial, @JsonProperty(value="ts") Long timestamp, @JsonProperty(value="deleted") Boolean deleted) {
        this.kekName = kekName;
        this.subject = subject;
        this.version = version;
        this.algorithm = algorithm;
        this.encryptedKeyMaterial = encryptedKeyMaterial;
        this.keyMaterial = keyMaterial;
        this.timestamp = timestamp;
        this.deleted = deleted;
    }

    @JsonProperty(value="kekName")
    public String getKekName() {
        return this.kekName;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonProperty(value="algorithm")
    public DekFormat getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="encryptedKeyMaterial")
    public String getEncryptedKeyMaterial() {
        return this.encryptedKeyMaterial;
    }

    @JsonProperty(value="keyMaterial")
    public String getKeyMaterial() {
        return this.keyMaterial;
    }

    @JsonProperty(value="ts")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonIgnore
    public boolean isDeleted() {
        return Boolean.TRUE.equals(this.deleted);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dek dek = (Dek)o;
        return this.version == dek.version && Objects.equals(this.kekName, dek.kekName) && Objects.equals(this.subject, dek.subject) && this.algorithm == dek.algorithm && Objects.equals(this.encryptedKeyMaterial, dek.encryptedKeyMaterial) && Objects.equals(this.keyMaterial, dek.keyMaterial);
    }

    public int hashCode() {
        return Objects.hash(this.kekName, this.subject, this.version, this.algorithm, this.encryptedKeyMaterial, this.keyMaterial);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }
}

