/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

public class ThrowStatement
extends Statement {
    public final Expression expression;

    public ThrowStatement(Expression expression) {
        super(ExpressionType.Throw, Void.TYPE);
        this.expression = expression;
    }

    public Statement accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        Expression expression = this.expression.accept(visitor);
        return visitor.visit(this, expression);
    }

    void accept0(ExpressionWriter writer) {
        writer.append("throw ").append(this.expression).append(';').newlineAndIndent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThrowStatement that = (ThrowStatement)o;
        return !(this.expression != null ? !this.expression.equals(that.expression) : that.expression != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        return result;
    }
}

