/*
 * Decompiled with CFR 0.152.
 */
package voldemort.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMSource;
import org.xml.sax.SAXException;
import voldemort.client.RoutingTier;
import voldemort.routing.RoutingStrategyType;
import voldemort.serialization.Compression;
import voldemort.serialization.SerializerDefinition;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreDefinitionBuilder;
import voldemort.store.StoreUtils;
import voldemort.store.views.View;
import voldemort.store.views.ViewStorageConfiguration;
import voldemort.utils.ReflectUtils;
import voldemort.xml.MappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreDefinitionsMapper {
    public static final String STORES_ELMT = "stores";
    public static final String STORE_ELMT = "store";
    public static final String STORE_NAME_ELMT = "name";
    public static final String STORE_PERSISTENCE_ELMT = "persistence";
    public static final String STORE_KEY_SERIALIZER_ELMT = "key-serializer";
    public static final String STORE_VALUE_SERIALIZER_ELMT = "value-serializer";
    public static final String STORE_SERIALIZATION_TYPE_ELMT = "type";
    public static final String STORE_SERIALIZATION_META_ELMT = "schema-info";
    public static final String STORE_COMPRESSION_ELMT = "compression";
    public static final String STORE_COMPRESSION_TYPE_ELMT = "type";
    public static final String STORE_COMPRESSION_OPTIONS_ELMT = "options";
    public static final String STORE_ROUTING_TIER_ELMT = "routing";
    public static final String STORE_REPLICATION_FACTOR_ELMT = "replication-factor";
    public static final String STORE_REQUIRED_WRITES_ELMT = "required-writes";
    public static final String STORE_PREFERRED_WRITES_ELMT = "preferred-writes";
    public static final String STORE_REQUIRED_READS_ELMT = "required-reads";
    public static final String STORE_PREFERRED_READS_ELMT = "preferred-reads";
    public static final String STORE_RETENTION_POLICY_ELMT = "retention-days";
    public static final String STORE_RETENTION_SCAN_THROTTLE_RATE_ELMT = "retention-scan-throttle-rate";
    public static final String STORE_ROUTING_STRATEGY = "routing-strategy";
    public static final String VIEW_ELMT = "view";
    public static final String VIEW_TARGET_ELMT = "view-of";
    public static final String VIEW_TRANS_ELMT = "view-class";
    private static final String STORE_VERSION_ATTR = "version";
    private final Schema schema;

    public StoreDefinitionsMapper() {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource source = new StreamSource(StoreDefinitionsMapper.class.getResourceAsStream("stores.xsd"));
            this.schema = factory.newSchema(source);
        }
        catch (SAXException e) {
            throw new MappingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreDefinition> readStoreList(File f) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(f);
            List<StoreDefinition> list = this.readStoreList(reader);
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public List<StoreDefinition> readStoreList(Reader input) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(input);
            Validator validator = this.schema.newValidator();
            validator.validate(new JDOMSource(doc));
            Element root = doc.getRootElement();
            if (!root.getName().equals(STORES_ELMT)) {
                throw new MappingException("Invalid root element: " + doc.getRootElement().getName());
            }
            ArrayList<StoreDefinition> stores = new ArrayList<StoreDefinition>();
            for (Object store : root.getChildren(STORE_ELMT)) {
                stores.add(this.readStore((Element)store));
            }
            for (Object view : root.getChildren(VIEW_ELMT)) {
                stores.add(this.readView((Element)view, stores));
            }
            return stores;
        }
        catch (JDOMException e) {
            throw new MappingException(e);
        }
        catch (SAXException e) {
            throw new MappingException(e);
        }
        catch (IOException e) {
            throw new MappingException(e);
        }
    }

    public StoreDefinition readStore(Reader input) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(input);
            Element root = doc.getRootElement();
            return this.readStore(root);
        }
        catch (JDOMException e) {
            throw new MappingException(e);
        }
        catch (IOException e) {
            throw new MappingException(e);
        }
    }

    private StoreDefinition readStore(Element store) {
        SerializerDefinition keySerializer;
        String name = store.getChildText(STORE_NAME_ELMT);
        String storeType = store.getChildText(STORE_PERSISTENCE_ELMT);
        int replicationFactor = Integer.parseInt(store.getChildText(STORE_REPLICATION_FACTOR_ELMT));
        int requiredReads = Integer.parseInt(store.getChildText(STORE_REQUIRED_READS_ELMT));
        int requiredWrites = Integer.parseInt(store.getChildText(STORE_REQUIRED_WRITES_ELMT));
        String preferredReadsStr = store.getChildText(STORE_PREFERRED_READS_ELMT);
        Integer preferredReads = null;
        if (preferredReadsStr != null) {
            preferredReads = Integer.parseInt(preferredReadsStr);
        }
        String preferredWritesStr = store.getChildText(STORE_PREFERRED_WRITES_ELMT);
        Integer preferredWrites = null;
        if (preferredWritesStr != null) {
            preferredWrites = Integer.parseInt(preferredWritesStr);
        }
        if ((keySerializer = this.readSerializer(store.getChild(STORE_KEY_SERIALIZER_ELMT))).getAllSchemaInfoVersions().size() > 1) {
            throw new MappingException("Only a single schema is allowed for the store key.");
        }
        SerializerDefinition valueSerializer = this.readSerializer(store.getChild(STORE_VALUE_SERIALIZER_ELMT));
        RoutingTier routingTier = RoutingTier.fromDisplay(store.getChildText(STORE_ROUTING_TIER_ELMT));
        String routingStrategyType = null != store.getChildText(STORE_ROUTING_STRATEGY) ? store.getChildText(STORE_ROUTING_STRATEGY) : RoutingStrategyType.CONSISTENT_STRATEGY;
        Element retention = store.getChild(STORE_RETENTION_POLICY_ELMT);
        Integer retentionPolicyDays = null;
        Integer retentionThrottleRate = null;
        if (retention != null) {
            retentionPolicyDays = Integer.parseInt(retention.getText());
            Element throttleRate = store.getChild(STORE_RETENTION_SCAN_THROTTLE_RATE_ELMT);
            if (throttleRate != null) {
                retentionThrottleRate = Integer.parseInt(throttleRate.getText());
            }
        }
        return new StoreDefinitionBuilder().setName(name).setType(storeType).setKeySerializer(keySerializer).setValueSerializer(valueSerializer).setRoutingPolicy(routingTier).setRoutingStrategyType(routingStrategyType).setReplicationFactor(replicationFactor).setPreferredReads(preferredReads).setRequiredReads(requiredReads).setPreferredWrites(preferredWrites).setRequiredWrites(requiredWrites).setRetentionPeriodDays(retentionPolicyDays).setRetentionScanThrottleRate(retentionThrottleRate).build();
    }

    private StoreDefinition readView(Element store, List<StoreDefinition> stores) {
        String name = store.getChildText(STORE_NAME_ELMT);
        String targetName = store.getChildText(VIEW_TARGET_ELMT);
        StoreDefinition target = StoreUtils.getStoreDef(stores, targetName);
        if (target == null) {
            throw new MappingException("View \"" + name + "\" has target store \"" + targetName + "\" but no such store exists");
        }
        int requiredReads = this.getChildWithDefault(store, STORE_REQUIRED_READS_ELMT, target.getRequiredReads());
        int preferredReads = this.getChildWithDefault(store, STORE_PREFERRED_READS_ELMT, target.getRequiredReads());
        int requiredWrites = this.getChildWithDefault(store, STORE_REQUIRED_WRITES_ELMT, target.getRequiredReads());
        int preferredWrites = this.getChildWithDefault(store, STORE_PREFERRED_WRITES_ELMT, target.getRequiredReads());
        SerializerDefinition keySerializer = target.getKeySerializer();
        SerializerDefinition valueSerializer = target.getValueSerializer();
        if (store.getChild(STORE_VALUE_SERIALIZER_ELMT) != null) {
            valueSerializer = this.readSerializer(store.getChild(STORE_VALUE_SERIALIZER_ELMT));
        }
        RoutingTier policy = target.getRoutingPolicy();
        if (store.getChild(STORE_ROUTING_STRATEGY) != null) {
            policy = RoutingTier.fromDisplay(store.getChildText(STORE_ROUTING_STRATEGY));
        }
        View<?, ?, ?> valTrans = this.loadTransformation(store.getChildText(VIEW_TRANS_ELMT));
        return new StoreDefinitionBuilder().setName(name).setViewOf(targetName).setType(ViewStorageConfiguration.TYPE_NAME).setRoutingPolicy(policy).setRoutingStrategyType(target.getRoutingStrategyType()).setKeySerializer(keySerializer).setValueSerializer(valueSerializer).setReplicationFactor(target.getReplicationFactor()).setPreferredReads(preferredReads).setRequiredReads(requiredReads).setPreferredWrites(preferredWrites).setRequiredWrites(requiredWrites).setView(valTrans).build();
    }

    private View<?, ?, ?> loadTransformation(String className) {
        if (className == null) {
            return null;
        }
        Class<?> transClass = ReflectUtils.loadClass(className.trim());
        return (View)ReflectUtils.callConstructor(transClass, new Object[0]);
    }

    private SerializerDefinition readSerializer(Element elmt) {
        String name = elmt.getChild("type").getText();
        boolean hasVersion = true;
        HashMap<Integer, String> schemaInfosByVersion = new HashMap<Integer, String>();
        for (Object schemaInfo : elmt.getChildren(STORE_SERIALIZATION_META_ELMT)) {
            int version;
            Element schemaInfoElmt = (Element)schemaInfo;
            String versionStr = schemaInfoElmt.getAttributeValue(STORE_VERSION_ATTR);
            if (versionStr == null) {
                version = 0;
            } else if (versionStr.equals("none")) {
                version = 0;
                hasVersion = false;
            } else {
                version = Integer.parseInt(versionStr);
            }
            String info = schemaInfoElmt.getText();
            String previous = schemaInfosByVersion.put(version, info);
            if (previous == null) continue;
            throw new MappingException("Duplicate version " + version + " found in schema info.");
        }
        if (!hasVersion && schemaInfosByVersion.size() > 1) {
            throw new IllegalArgumentException("Specified multiple schemas AND version=none, which is not permitted.");
        }
        Element compressionElmt = elmt.getChild(STORE_COMPRESSION_ELMT);
        Compression compression = null;
        if (compressionElmt != null) {
            compression = new Compression(compressionElmt.getChildText("type"), compressionElmt.getChildText(STORE_COMPRESSION_OPTIONS_ELMT));
        }
        return new SerializerDefinition(name, schemaInfosByVersion, hasVersion, compression);
    }

    public String writeStoreList(List<StoreDefinition> stores) {
        Element root = new Element(STORES_ELMT);
        for (StoreDefinition def : stores) {
            if (def.isView()) {
                root.addContent(this.viewToElement(def));
                continue;
            }
            root.addContent(this.storeToElement(def));
        }
        XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());
        return serializer.outputString(root);
    }

    public String writeStore(StoreDefinition store) {
        XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());
        if (store.isView()) {
            return serializer.outputString(this.viewToElement(store));
        }
        return serializer.outputString(this.storeToElement(store));
    }

    private Element storeToElement(StoreDefinition storeDefinition) {
        Element store = new Element(STORE_ELMT);
        store.addContent(new Element(STORE_NAME_ELMT).setText(storeDefinition.getName()));
        store.addContent(new Element(STORE_PERSISTENCE_ELMT).setText(storeDefinition.getType()));
        store.addContent(new Element(STORE_ROUTING_TIER_ELMT).setText(storeDefinition.getRoutingPolicy().toDisplay()));
        store.addContent(new Element(STORE_REPLICATION_FACTOR_ELMT).setText(Integer.toString(storeDefinition.getReplicationFactor())));
        if (storeDefinition.hasPreferredReads()) {
            store.addContent(new Element(STORE_PREFERRED_READS_ELMT).setText(Integer.toString(storeDefinition.getPreferredReads())));
        }
        store.addContent(new Element(STORE_REQUIRED_READS_ELMT).setText(Integer.toString(storeDefinition.getRequiredReads())));
        if (storeDefinition.hasPreferredWrites()) {
            store.addContent(new Element(STORE_PREFERRED_WRITES_ELMT).setText(Integer.toString(storeDefinition.getPreferredWrites())));
        }
        store.addContent(new Element(STORE_REQUIRED_WRITES_ELMT).setText(Integer.toString(storeDefinition.getRequiredWrites())));
        Element keySerializer = new Element(STORE_KEY_SERIALIZER_ELMT);
        this.addSerializer(keySerializer, storeDefinition.getKeySerializer());
        store.addContent(keySerializer);
        Element valueSerializer = new Element(STORE_VALUE_SERIALIZER_ELMT);
        this.addSerializer(valueSerializer, storeDefinition.getValueSerializer());
        store.addContent(valueSerializer);
        if (storeDefinition.hasRetentionPeriod()) {
            store.addContent(new Element(STORE_RETENTION_POLICY_ELMT).setText(Integer.toString(storeDefinition.getRetentionDays())));
        }
        if (storeDefinition.hasRetentionScanThrottleRate()) {
            store.addContent(new Element(STORE_RETENTION_SCAN_THROTTLE_RATE_ELMT).setText(Integer.toString(storeDefinition.getRetentionScanThrottleRate())));
        }
        return store;
    }

    private Element viewToElement(StoreDefinition storeDefinition) {
        Element store = new Element(VIEW_ELMT);
        store.addContent(new Element(STORE_NAME_ELMT).setText(storeDefinition.getName()));
        store.addContent(new Element(VIEW_TARGET_ELMT).setText(storeDefinition.getViewTargetStoreName()));
        if (storeDefinition.getValueTransformation() == null) {
            throw new MappingException("View " + storeDefinition.getName() + " has no defined transformation class.");
        }
        store.addContent(new Element(VIEW_TRANS_ELMT).setText(storeDefinition.getValueTransformation().getClass().getName()));
        store.addContent(new Element(STORE_ROUTING_TIER_ELMT).setText(storeDefinition.getRoutingPolicy().toDisplay()));
        if (storeDefinition.hasPreferredReads()) {
            store.addContent(new Element(STORE_PREFERRED_READS_ELMT).setText(Integer.toString(storeDefinition.getPreferredReads())));
        }
        store.addContent(new Element(STORE_REQUIRED_READS_ELMT).setText(Integer.toString(storeDefinition.getRequiredReads())));
        if (storeDefinition.hasPreferredWrites()) {
            store.addContent(new Element(STORE_PREFERRED_WRITES_ELMT).setText(Integer.toString(storeDefinition.getPreferredWrites())));
        }
        store.addContent(new Element(STORE_REQUIRED_WRITES_ELMT).setText(Integer.toString(storeDefinition.getRequiredWrites())));
        Element valueSerializer = new Element(STORE_VALUE_SERIALIZER_ELMT);
        this.addSerializer(valueSerializer, storeDefinition.getValueSerializer());
        store.addContent(valueSerializer);
        return store;
    }

    private void addSerializer(Element parent, SerializerDefinition def) {
        parent.addContent(new Element("type").setText(def.getName()));
        if (def.hasSchemaInfo()) {
            for (Map.Entry<Integer, String> entry : def.getAllSchemaInfoVersions().entrySet()) {
                Element schemaElmt = new Element(STORE_SERIALIZATION_META_ELMT);
                if (def.hasVersion()) {
                    schemaElmt.setAttribute(STORE_VERSION_ATTR, Integer.toString(entry.getKey()));
                } else {
                    schemaElmt.setAttribute(STORE_VERSION_ATTR, "none");
                }
                schemaElmt.setText(entry.getValue());
                parent.addContent(schemaElmt);
            }
        }
        if (def.hasCompression()) {
            Compression compression = def.getCompression();
            Element compressionElmt = new Element(STORE_COMPRESSION_ELMT);
            Element type = new Element("type");
            type.setText(compression.getType());
            compressionElmt.addContent(type);
            String optionsText = compression.getOptions();
            if (optionsText != null) {
                Element options = new Element(STORE_COMPRESSION_OPTIONS_ELMT);
                options.setText(optionsText);
                compressionElmt.addContent(options);
            }
            parent.addContent(compressionElmt);
        }
    }

    public Integer getChildWithDefault(Element elmt, String property, Integer defaultVal) {
        if (elmt.getChildText(property) == null) {
            return defaultVal;
        }
        return Integer.parseInt(elmt.getChildText(property));
    }
}

