/*
 * Decompiled with CFR 0.152.
 */
package voldemort.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMSource;
import org.xml.sax.SAXException;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.xml.MappingException;

public class ClusterMapper {
    private static final Pattern COMMA_SEP = Pattern.compile("\\s*,\\s*");
    private static final String SERVER_ID_ELMT = "id";
    private static final String SERVER_PARTITIONS_ELMT = "partitions";
    private static final String SERVER_ELMT = "server";
    private static final String CLUSTER_NAME_ELMT = "name";
    private static final String CLUSTER_ELMT = "cluster";
    private static final String HOST_ELMT = "host";
    private static final String HTTP_PORT_ELMT = "http-port";
    private static final String SOCKET_PORT_ELMT = "socket-port";
    private static final String ADMIN_PORT_ELMT = "admin-port";
    private final Schema schema;

    public ClusterMapper() {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource source = new StreamSource(ClusterMapper.class.getResourceAsStream("cluster.xsd"));
            this.schema = factory.newSchema(source);
        }
        catch (SAXException e) {
            throw new MappingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cluster readCluster(File f) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(f);
            Cluster cluster = this.readCluster(reader);
            return cluster;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public Cluster readCluster(Reader input) {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(input);
            Validator validator = this.schema.newValidator();
            validator.validate(new JDOMSource(doc));
            Element root = doc.getRootElement();
            if (!root.getName().equals(CLUSTER_ELMT)) {
                throw new MappingException("Invalid root element: " + doc.getRootElement().getName());
            }
            String name = root.getChildText(CLUSTER_NAME_ELMT);
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Element node : root.getChildren(SERVER_ELMT)) {
                nodes.add(this.readServer(node));
            }
            return new Cluster(name, nodes);
        }
        catch (JDOMException e) {
            throw new MappingException(e);
        }
        catch (SAXException e) {
            throw new MappingException(e);
        }
        catch (IOException e) {
            throw new MappingException(e);
        }
    }

    public Node readServer(Element server) {
        int id = Integer.parseInt(server.getChildText(SERVER_ID_ELMT));
        String host = server.getChildText(HOST_ELMT);
        int httpPort = Integer.parseInt(server.getChildText(HTTP_PORT_ELMT));
        int socketPort = Integer.parseInt(server.getChildText(SOCKET_PORT_ELMT));
        int adminPort = null != server.getChildText(ADMIN_PORT_ELMT) ? Integer.parseInt(server.getChildText(ADMIN_PORT_ELMT)) : -1;
        String partitionsText = server.getChildText(SERVER_PARTITIONS_ELMT).trim();
        ArrayList<Integer> partitions = new ArrayList<Integer>();
        for (String aPartition : COMMA_SEP.split(partitionsText)) {
            if (aPartition.trim().length() <= 0) continue;
            partitions.add(Integer.parseInt(aPartition.trim()));
        }
        return new Node(id, host, httpPort, socketPort, adminPort, partitions);
    }

    public String writeCluster(Cluster cluster) {
        Document doc = new Document(new Element(CLUSTER_ELMT));
        doc.getRootElement().addContent(new Element(CLUSTER_NAME_ELMT).setText(cluster.getName()));
        for (Node n : cluster.getNodes()) {
            doc.getRootElement().addContent(this.mapServer(n));
        }
        XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());
        return serializer.outputString(doc.getRootElement());
    }

    private Element mapServer(Node node) {
        Element server = new Element(SERVER_ELMT);
        server.addContent(new Element(SERVER_ID_ELMT).setText(Integer.toString(node.getId())));
        server.addContent(new Element(HOST_ELMT).setText(node.getHost()));
        server.addContent(new Element(HTTP_PORT_ELMT).setText(Integer.toString(node.getHttpPort())));
        server.addContent(new Element(SOCKET_PORT_ELMT).setText(Integer.toString(node.getSocketPort())));
        server.addContent(new Element(ADMIN_PORT_ELMT).setText(Integer.toString(node.getAdminPort())));
        String serverPartitionsText = StringUtils.join(node.getPartitionIds().toArray(), ", ");
        server.addContent(new Element(SERVER_PARTITIONS_ELMT).setText(serverPartitionsText));
        return server;
    }
}

