/*
 * Decompiled with CFR 0.152.
 */
package voldemort.versioning;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.Occured;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorClockInconsistencyResolver<T>
implements InconsistencyResolver<Versioned<T>> {
    @Override
    public List<Versioned<T>> resolveConflicts(List<Versioned<T>> items) {
        int size = items.size();
        if (size <= 1) {
            return items;
        }
        ArrayList<Versioned<T>> newItems = Lists.newArrayList();
        for (Versioned<T> v1 : items) {
            boolean found = false;
            ListIterator<Versioned<T>> it2 = newItems.listIterator();
            while (it2.hasNext()) {
                Versioned v2 = (Versioned)it2.next();
                Occured compare = v1.getVersion().compare(v2.getVersion());
                if (compare == Occured.AFTER) {
                    if (found) {
                        it2.remove();
                    } else {
                        it2.set(v1);
                    }
                }
                if (compare == Occured.CONCURRENTLY) continue;
                found = true;
            }
            if (found) continue;
            newItems.add(v1);
        }
        return newItems;
    }
}

