/*
 * Decompiled with CFR 0.152.
 */
package voldemort.versioning;

import java.util.Collections;
import java.util.List;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedInconsistencyResolver<T>
implements InconsistencyResolver<Versioned<T>> {
    @Override
    public List<Versioned<T>> resolveConflicts(List<Versioned<T>> items) {
        if (items.size() <= 1) {
            return items;
        }
        Versioned<T> max = items.get(0);
        long maxTime = ((VectorClock)items.get(0).getVersion()).getTimestamp();
        for (Versioned<T> versioned : items) {
            VectorClock clock = (VectorClock)versioned.getVersion();
            if (clock.getTimestamp() <= maxTime) continue;
            max = versioned;
            maxTime = ((VectorClock)versioned.getVersion()).getTimestamp();
        }
        return Collections.singletonList(max);
    }
}

