/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.pool;

import java.util.concurrent.TimeUnit;

public class ResourcePoolConfig {
    private int poolMaxSize = 20;
    private long timeoutNs = Long.MAX_VALUE;
    private int maxInvalidResourceCreations = Integer.MAX_VALUE;
    private boolean isFair = true;

    public int getMaxPoolSize() {
        return this.poolMaxSize;
    }

    public ResourcePoolConfig setMaxPoolSize(int poolSize) {
        if (poolSize <= 0) {
            throw new IllegalArgumentException("Pool size must be a positive number.");
        }
        this.poolMaxSize = poolSize;
        return this;
    }

    public long getTimeout(TimeUnit unit) {
        return unit.convert(this.timeoutNs, unit);
    }

    public ResourcePoolConfig setTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("The timeout must be a non-negative number.");
        }
        this.timeoutNs = TimeUnit.NANOSECONDS.convert(timeout, unit);
        return this;
    }

    public ResourcePoolConfig setMaxInvalidAttempts(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be a positive number.");
        }
        this.maxInvalidResourceCreations = limit;
        return this;
    }

    public int getMaximumInvalidResourceCreationLimit() {
        return this.maxInvalidResourceCreations;
    }

    public boolean isFair() {
        return this.isFair;
    }

    public ResourcePoolConfig setIsFair(boolean isFair) {
        this.isFair = isFair;
        return this;
    }
}

