/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import voldemort.VoldemortException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String NEWLINE = System.getProperty("line.separator");

    public static void croak(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public static void croak(String message, int errorCode) {
        System.err.println(message);
        System.exit(errorCode);
    }

    public static void rm(File file) {
        if (file != null) {
            Utils.rm(Collections.singletonList(file));
        }
    }

    public static void rm(File[] files) {
        if (files != null) {
            for (File f : files) {
                Utils.rm(f);
            }
        }
    }

    public static void rm(String file) {
        if (file != null) {
            Utils.rm(Collections.singletonList(new File(file)));
        }
    }

    public static void rm(Iterable<File> files) {
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    Utils.rm(Arrays.asList(f.listFiles()));
                    f.delete();
                    continue;
                }
                f.delete();
            }
        }
    }

    public static void move(File source, File dest) {
        if (!source.exists()) {
            throw new VoldemortException("File " + source.toString() + " does not exist.");
        }
        Utils.rm(dest);
        boolean succeeded = source.renameTo(dest);
        if (!succeeded) {
            throw new VoldemortException("Rename of " + source + " to " + dest + " failed.");
        }
    }

    public static boolean isReadableFile(String fileName) {
        return Utils.isReadableFile(new File(fileName));
    }

    public static boolean isReadableFile(File f) {
        return f.exists() && f.isFile() && f.canRead();
    }

    public static boolean isReadableDir(String dirName) {
        return Utils.isReadableDir(new File(dirName));
    }

    public static boolean isReadableDir(File d) {
        return d.exists() && d.isDirectory() && d.canRead();
    }

    public static void assertNotNull(Object ... objects) {
        Utils.assertNotNull("Null argument not allowed", objects);
    }

    public static void assertNotNull(String s, Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            throw new IllegalArgumentException(s);
        }
    }

    public static <T> T notNull(T t, String message) {
        if (t == null) {
            throw new IllegalArgumentException(message);
        }
        return t;
    }

    public static <T> T notNull(T t) {
        if (t == null) {
            throw new IllegalArgumentException("This object MUST be non-null.");
        }
        return t;
    }

    public static int inRange(int value, int min, int max) {
        if (value < min) {
            throw new IllegalArgumentException("The value " + value + " is lower than the minimum value of " + min);
        }
        if (value > max) {
            throw new IllegalArgumentException("The value " + value + " is greater than the maximum value of " + max);
        }
        return value;
    }

    public static int deepHashCode(Object o) {
        if (o == null) {
            return 0;
        }
        if (!o.getClass().isArray()) {
            return o.hashCode();
        }
        if (o instanceof Object[]) {
            return Arrays.deepHashCode((Object[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.hashCode((boolean[])o);
        }
        if (o instanceof char[]) {
            return Arrays.hashCode((char[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.hashCode((byte[])o);
        }
        if (o instanceof short[]) {
            return Arrays.hashCode((short[])o);
        }
        if (o instanceof int[]) {
            return Arrays.hashCode((int[])o);
        }
        if (o instanceof long[]) {
            return Arrays.hashCode((long[])o);
        }
        if (o instanceof float[]) {
            return Arrays.hashCode((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.hashCode((double[])o);
        }
        throw new AssertionError();
    }

    public static boolean deepEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> type1 = o1.getClass();
        Class<?> type2 = o2.getClass();
        if (!type1.isArray() || !type2.isArray()) {
            return o1.equals(o2);
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.deepEquals((Object[])o1, (Object[])o2);
        }
        if (type1 != type2) {
            return false;
        }
        if (o1 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        if (o1 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        throw new AssertionError();
    }

    public static <T> List<T> sorted(List<T> l, Comparator<T> comparator) {
        ArrayList<T> copy = new ArrayList<T>(l);
        Collections.sort(copy, comparator);
        return copy;
    }

    public static <T extends Comparable<T>> List<T> sorted(List<T> l) {
        ArrayList<T> copy = new ArrayList<T>(l);
        Collections.sort(copy);
        return copy;
    }

    public static <T> List<T> reversed(List<T> l) {
        ArrayList<T> copy = new ArrayList<T>(l);
        Collections.reverse(copy);
        return copy;
    }

    public static URI parseUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new VoldemortException(e);
        }
    }

    public static <T1, T2> T1 uncheckedCast(T2 t2) {
        return (T1)t2;
    }
}

