/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.server.VoldemortConfig;
import voldemort.store.StoreDefinition;
import voldemort.versioning.Occured;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebalanceUtils {
    private static Logger logger = Logger.getLogger(RebalanceUtils.class);
    public static List<String> rebalancingStoreEngineBlackList = Arrays.asList("read-only");

    public static boolean containsNode(Cluster cluster, int nodeId) {
        try {
            cluster.getNodeById(nodeId);
            return true;
        }
        catch (VoldemortException e) {
            return false;
        }
    }

    public static Cluster createUpdatedCluster(Cluster cluster, Node stealerNode, Node donorNode, List<Integer> partitionList) {
        ArrayList<Integer> stealerPartitionList = new ArrayList<Integer>(stealerNode.getPartitionIds());
        ArrayList<Integer> donorPartitionList = new ArrayList<Integer>(donorNode.getPartitionIds());
        for (int p : cluster.getNodeById(stealerNode.getId()).getPartitionIds()) {
            if (stealerPartitionList.contains(p)) continue;
            stealerPartitionList.add(p);
        }
        for (int p : partitionList) {
            RebalanceUtils.removePartition(donorPartitionList, p);
            if (stealerPartitionList.contains(p)) continue;
            stealerPartitionList.add(p);
        }
        Collections.sort(stealerPartitionList);
        Collections.sort(donorPartitionList);
        logger.debug("stealerNode: " + stealerNode);
        logger.debug("donorNode: " + donorNode);
        logger.debug("stealerPartitionList: " + stealerPartitionList);
        logger.debug("donorPartitionList: " + donorPartitionList);
        stealerNode = RebalanceUtils.updateNode(stealerNode, stealerPartitionList);
        donorNode = RebalanceUtils.updateNode(donorNode, donorPartitionList);
        Cluster updatedCluster = RebalanceUtils.updateCluster(cluster, Arrays.asList(stealerNode, donorNode));
        logger.debug("currentCluster: " + cluster + " updatedCluster:" + updatedCluster);
        return updatedCluster;
    }

    private static void removePartition(List<Integer> donorPartitionList, int partition) {
        for (int i = 0; i < donorPartitionList.size(); ++i) {
            if (partition != donorPartitionList.get(i)) continue;
            donorPartitionList.remove(i);
        }
    }

    public static Cluster updateCluster(Cluster currentCluster, List<Node> updatedNodeList) {
        ArrayList<Node> newNodeList = new ArrayList<Node>(updatedNodeList);
        for (Node currentNode : currentCluster.getNodes()) {
            if (updatedNodeList.contains(currentNode)) continue;
            newNodeList.add(currentNode);
        }
        Collections.sort(newNodeList);
        return new Cluster(currentCluster.getName(), newNodeList);
    }

    public static Node updateNode(Node node, List<Integer> partitionsList) {
        return new Node(node.getId(), node.getHost(), node.getHttpPort(), node.getSocketPort(), node.getAdminPort(), partitionsList);
    }

    public static Map<Integer, Integer> getCurrentPartitionMapping(Cluster currentCluster) {
        HashMap<Integer, Integer> partitionToNode = new HashMap<Integer, Integer>();
        for (Node n : currentCluster.getNodes()) {
            for (Integer partition : n.getPartitionIds()) {
                partitionToNode.put(partition, n.getId());
            }
        }
        return partitionToNode;
    }

    public static Versioned<Cluster> getLatestCluster(List<Integer> requiredNodes, AdminClient adminClient) {
        Versioned<Cluster> latestCluster = new Versioned<Cluster>(adminClient.getAdminClientCluster());
        ArrayList<Versioned<Cluster>> clusterList = new ArrayList<Versioned<Cluster>>();
        clusterList.add(latestCluster);
        for (Node node : adminClient.getAdminClientCluster().getNodes()) {
            try {
                Versioned<Cluster> versionedCluster = adminClient.getRemoteCluster(node.getId());
                VectorClock newClock = (VectorClock)versionedCluster.getVersion();
                if (null == newClock || clusterList.contains(versionedCluster)) continue;
                RebalanceUtils.checkNotConcurrent(clusterList, newClock);
                clusterList.add(versionedCluster);
                Occured occured = newClock.compare(latestCluster.getVersion());
                if (!Occured.AFTER.equals((Object)occured)) continue;
                latestCluster = versionedCluster;
            }
            catch (Exception e) {
                if (null != requiredNodes && requiredNodes.contains(node.getId())) {
                    throw new VoldemortException("Failed to get Cluster version from node:" + node, e);
                }
                logger.info("Failed to get Cluster version from node:" + node, e);
            }
        }
        return latestCluster;
    }

    private static void checkNotConcurrent(ArrayList<Versioned<Cluster>> clockList, VectorClock newClock) {
        for (Versioned<Cluster> versionedCluster : clockList) {
            VectorClock clock = (VectorClock)versionedCluster.getVersion();
            if (!Occured.CONCURRENTLY.equals((Object)clock.compare(newClock))) continue;
            throw new VoldemortException("Cluster is in inconsistent state got conflicting clocks " + clock + " and " + newClock);
        }
    }

    public static void propagateCluster(AdminClient adminClient, Cluster cluster, VectorClock clock, List<Integer> requireNodeIds) {
        ArrayList<Integer> allNodeIds = new ArrayList<Integer>();
        for (Node node : cluster.getNodes()) {
            allNodeIds.add(node.getId());
        }
        RebalanceUtils.propagateCluster(adminClient, cluster, clock, allNodeIds, requireNodeIds);
    }

    public static void propagateCluster(AdminClient adminClient, Cluster cluster, VectorClock clock, List<Integer> attemptNodeIds, List<Integer> requiredNodeIds) {
        ArrayList<Integer> failures = new ArrayList<Integer>();
        for (int nodeId : attemptNodeIds) {
            if (requiredNodeIds.contains(nodeId)) continue;
            try {
                adminClient.updateRemoteCluster(nodeId, cluster, clock);
            }
            catch (VoldemortException e) {
                logger.debug("Failed to copy new cluster.xml(" + cluster + ") on non-required node:" + nodeId, e);
            }
        }
        for (int nodeId : requiredNodeIds) {
            Node node = cluster.getNodeById(nodeId);
            try {
                logger.debug("Updating remote node:" + nodeId + " with cluster:" + cluster);
                adminClient.updateRemoteCluster(node.getId(), cluster, clock);
            }
            catch (Exception e) {
                failures.add(node.getId());
                logger.debug(e);
            }
        }
        if (failures.size() > 0) {
            throw new VoldemortException("Failed to copy updated cluster.xml:" + cluster + " on required nodes:" + failures);
        }
    }

    public static AdminClient createTempAdminClient(VoldemortConfig voldemortConfig, Cluster cluster, int numThreads, int numConnPerNode) {
        AdminClientConfig config = new AdminClientConfig().setMaxConnectionsPerNode(numConnPerNode).setMaxThreads(numThreads).setAdminConnectionTimeoutSec(voldemortConfig.getAdminConnectionTimeout()).setAdminSocketTimeoutSec(voldemortConfig.getAdminSocketTimeout()).setAdminSocketBufferSize(voldemortConfig.getAdminSocketBufferSize());
        return new AdminClient(cluster, config);
    }

    public static List<StoreDefinition> getStoreNameList(Cluster cluster, AdminClient adminClient) {
        for (Node node : cluster.getNodes()) {
            try {
                List<StoreDefinition> storeDefList = adminClient.getRemoteStoreDefList(node.getId()).getValue();
                return RebalanceUtils.getWritableStores(storeDefList);
            }
            catch (VoldemortException e) {
                logger.warn(e);
            }
        }
        throw new VoldemortException("Unable to get StoreDefList from any node for cluster:" + cluster);
    }

    public static List<StoreDefinition> getWritableStores(List<StoreDefinition> storeDefList) {
        ArrayList<StoreDefinition> storeNameList = new ArrayList<StoreDefinition>(storeDefList.size());
        for (StoreDefinition def : storeDefList) {
            if (!def.isView() && !rebalancingStoreEngineBlackList.contains(def.getName())) {
                storeNameList.add(def);
            }
            if (rebalancingStoreEngineBlackList.contains(def.getType())) continue;
            logger.debug("ignoring store " + def.getName() + " for rebalancing");
        }
        return storeNameList;
    }

    public static StoreDefinition getMaxReplicationStore(List<StoreDefinition> storeDefList) {
        int maxReplication = 0;
        StoreDefinition maxStore = null;
        for (StoreDefinition def : storeDefList) {
            if (maxReplication >= def.getReplicationFactor()) continue;
            maxReplication = def.getReplicationFactor();
            maxStore = def;
        }
        return maxStore;
    }

    public static List<String> getStoreNames(List<StoreDefinition> storeDefList) {
        ArrayList<String> storeList = new ArrayList<String>(storeDefList.size());
        for (StoreDefinition def : storeDefList) {
            storeList.add(def.getName());
        }
        return storeList;
    }
}

