/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import com.google.common.collect.AbstractIterator;
import java.io.File;
import java.util.Arrays;
import java.util.Stack;
import voldemort.annotations.concurrency.NotThreadsafe;
import voldemort.utils.ClosableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadsafe
public class DirectoryIterator
extends AbstractIterator<File>
implements ClosableIterator<File> {
    private final Stack<File> stack = new Stack();

    public DirectoryIterator(String ... basis) {
        for (String f : basis) {
            this.stack.add(new File(f));
        }
    }

    public DirectoryIterator(File ... basis) {
        this.stack.addAll(Arrays.asList(basis));
    }

    @Override
    protected File computeNext() {
        while (this.stack.size() > 0) {
            File f = this.stack.pop();
            if (f.isDirectory()) {
                for (File sub : f.listFiles()) {
                    this.stack.push(sub);
                }
                continue;
            }
            return f;
        }
        return (File)this.endOfData();
    }

    @Override
    public void close() {
    }

    public static void main(String[] args) {
        DirectoryIterator iter = new DirectoryIterator(args);
        while (iter.hasNext()) {
            System.out.println(((File)iter.next()).getAbsolutePath());
        }
    }
}

