/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.views;

import com.google.common.collect.AbstractIterator;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.serialization.Serializer;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.serialized.SerializingStore;
import voldemort.store.views.View;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewStorageEngine
implements StorageEngine<ByteArray, byte[]> {
    private final String name;
    private final Store<Object, Object> serializingStore;
    private final StorageEngine<ByteArray, byte[]> target;
    private final Serializer<Object> valSerializer;
    private final Serializer<Object> targetKeySerializer;
    private final Serializer<Object> targetValSerializer;
    private final View<Object, Object, Object> view;

    public ViewStorageEngine(String name, StorageEngine<ByteArray, byte[]> target, Serializer<?> valSerializer, Serializer<?> targetKeySerializer, Serializer<?> targetValSerializer, View<?, ?, ?> valueTrans) {
        this.name = name;
        this.target = Utils.notNull(target);
        this.serializingStore = new SerializingStore(target, targetKeySerializer, targetValSerializer);
        this.valSerializer = valSerializer;
        this.targetKeySerializer = targetKeySerializer;
        this.targetValSerializer = targetValSerializer;
        this.view = valueTrans;
        if (valueTrans == null) {
            throw new IllegalArgumentException("View without either a key transformation or a value transformation.");
        }
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        return this.target.delete(key, version);
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key) throws VoldemortException {
        List<Versioned<byte[]>> values = this.target.get(key);
        for (Versioned versioned : values) {
            versioned.setObject(this.valueToViewSchema(key, (byte[])versioned.getValue()));
        }
        return values;
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys) throws VoldemortException {
        return StoreUtils.getAll(this, keys);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return this.target.getVersions(key);
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value) throws VoldemortException {
        this.target.put(key, Versioned.value(this.valueFromViewSchema(key, value.getValue()), value.getVersion()));
    }

    @Override
    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        return new ViewIterator(this.target.entries());
    }

    @Override
    public ClosableIterator<ByteArray> keys() {
        return StoreUtils.keys(this.entries());
    }

    @Override
    public void truncate() {
        ViewIterator iterator = new ViewIterator(this.target.entries());
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            this.target.delete((ByteArray)pair.getFirst(), ((Versioned)pair.getSecond()).getVersion());
        }
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (capability == StoreCapabilityType.VIEW_TARGET) {
            return this.target;
        }
        return null;
    }

    @Override
    public void close() throws VoldemortException {
    }

    private byte[] valueFromViewSchema(ByteArray key, byte[] value) {
        return this.targetValSerializer.toBytes(this.view.viewToStore(this.serializingStore, this.targetKeySerializer.toObject(key.get()), this.valSerializer.toObject(value)));
    }

    private byte[] valueToViewSchema(ByteArray key, byte[] value) {
        return this.valSerializer.toBytes(this.view.storeToView(this.serializingStore, this.targetKeySerializer.toObject(key.get()), this.targetValSerializer.toObject(value)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ViewIterator
    extends AbstractIterator<Pair<ByteArray, Versioned<byte[]>>>
    implements ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> {
        private final ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> inner;

        public ViewIterator(ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> inner) {
            this.inner = inner;
        }

        @Override
        public void close() {
            this.inner.close();
        }

        @Override
        protected Pair<ByteArray, Versioned<byte[]>> computeNext() {
            Pair p = (Pair)this.inner.next();
            Versioned<byte[]> newVal = Versioned.value(ViewStorageEngine.this.valueToViewSchema((ByteArray)p.getFirst(), (byte[])((Versioned)p.getSecond()).getValue()), ((Versioned)p.getSecond()).getVersion());
            return Pair.create(p.getFirst(), newVal);
        }
    }
}

