/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.views;

import java.util.List;
import voldemort.VoldemortException;
import voldemort.serialization.DefaultSerializerFactory;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageConfiguration;
import voldemort.store.StorageEngine;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreUtils;
import voldemort.store.views.ViewStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewStorageConfiguration
implements StorageConfiguration {
    public static String TYPE_NAME = "view";
    private StoreRepository storeRepo;
    private List<StoreDefinition> storeDefs;

    public ViewStorageConfiguration(VoldemortConfig config, List<StoreDefinition> stores, StoreRepository repo) {
        this.storeDefs = Utils.notNull(stores);
        this.storeRepo = repo;
    }

    @Override
    public void close() {
    }

    @Override
    public StorageEngine<ByteArray, byte[]> getStore(String name) {
        StoreDefinition def = StoreUtils.getStoreDef(this.storeDefs, name);
        String targetName = def.getViewTargetStoreName();
        StoreDefinition targetDef = StoreUtils.getStoreDef(this.storeDefs, targetName);
        StorageEngine<ByteArray, byte[]> target = this.storeRepo.getStorageEngine(targetName);
        if (target == null) {
            throw new VoldemortException("View \"" + name + "\" has a target store \"" + targetName + "\" which does not exist.");
        }
        DefaultSerializerFactory factory = new DefaultSerializerFactory();
        return new ViewStorageEngine(name, target, factory.getSerializer(def.getValueSerializer()), factory.getSerializer(targetDef.getKeySerializer()), factory.getSerializer(targetDef.getValueSerializer()), def.getValueTransformation());
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }
}

