/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.versioned;

import voldemort.VoldemortException;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.utils.Time;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionIncrementingStore<K, V>
extends DelegatingStore<K, V>
implements Store<K, V> {
    private final short nodeId;
    private final Time time;

    public VersionIncrementingStore(Store<K, V> innerStore, int nodeId, Time time) {
        super(innerStore);
        this.nodeId = (short)nodeId;
        this.time = time;
    }

    @Override
    public void put(K key, Versioned<V> value) throws VoldemortException {
        value = value.cloneVersioned();
        VectorClock clock = (VectorClock)value.getVersion();
        clock.incrementVersion(this.nodeId, this.time.getMilliseconds());
        super.put(key, value);
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (StoreCapabilityType.VERSION_INCREMENTING.equals((Object)capability)) {
            return true;
        }
        return super.getCapability(capability);
    }
}

