/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.versioned;

import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InconsistencyResolvingStore<K, V>
extends DelegatingStore<K, V> {
    private final InconsistencyResolver<Versioned<V>> resolver;

    public InconsistencyResolvingStore(Store<K, V> innerStore, InconsistencyResolver<Versioned<V>> resolver) {
        super(innerStore);
        this.resolver = resolver;
    }

    @Override
    public List<Versioned<V>> get(K key) throws VoldemortException {
        return this.resolver.resolveConflicts(super.get(key));
    }

    @Override
    public Map<K, List<Versioned<V>>> getAll(Iterable<K> keys) throws VoldemortException {
        Map m = super.getAll(keys);
        for (Map.Entry entry : m.entrySet()) {
            m.put(entry.getKey(), this.resolver.resolveConflicts(entry.getValue()));
        }
        return m;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (capability == StoreCapabilityType.INCONSISTENCY_RESOLVER) {
            return this.resolver;
        }
        return super.getCapability(capability);
    }
}

