/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import com.google.common.collect.ImmutableList;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.store.stats.StoreStats;
import voldemort.store.stats.Tracked;

@JmxManaged
public class StoreStatsJmx {
    private StoreStats stats;

    public StoreStatsJmx(StoreStats stats) {
        this.stats = stats;
    }

    @JmxGetter(name="numberOfCallsToGetAll", description="The number of calls to GET_ALL since the last reset.")
    public long getNumberOfCallsToGetAll() {
        return this.stats.getCount(Tracked.GET_ALL);
    }

    @JmxGetter(name="averageGetAllCompletionTimeInMs", description="The avg. time in ms for GET_ALL calls to complete.")
    public double getAverageGetAllCompletionTimeInMs() {
        return this.stats.getAvgTimeInMs(Tracked.GET_ALL);
    }

    @JmxGetter(name="GetAllThroughput", description="Throughput of GET_ALL requests.")
    public float getGetAllThroughput() {
        return this.stats.getThroughput(Tracked.GET_ALL);
    }

    @JmxGetter(name="numberOfCallsToGet", description="The number of calls to GET since the last reset.")
    public long getNumberOfCallsToGet() {
        return this.stats.getCount(Tracked.GET);
    }

    @JmxGetter(name="averageGetCompletionTimeInMs", description="The avg. time in ms for GET calls to complete.")
    public double getAverageGetCompletionTimeInMs() {
        return this.stats.getAvgTimeInMs(Tracked.GET);
    }

    @JmxGetter(name="GetThroughput", description="Throughput of GET requests.")
    public float getGetThroughput() {
        return this.stats.getThroughput(Tracked.GET);
    }

    @JmxGetter(name="numberOfCallsToPut", description="The number of calls to PUT since the last reset.")
    public long getNumberOfCallsToPut() {
        return this.stats.getCount(Tracked.PUT);
    }

    @JmxGetter(name="averagePutCompletionTimeInMs", description="The avg. time in ms for PUT calls to complete.")
    public double getAveragePutCompletionTimeInMs() {
        return this.stats.getAvgTimeInMs(Tracked.PUT);
    }

    @JmxGetter(name="PutThroughput", description="Throughput of PUT requests.")
    public float getPutThroughput() {
        return this.stats.getThroughput(Tracked.PUT);
    }

    @JmxGetter(name="numberOfCallsToDelete", description="The number of calls to DELETE since the last reset.")
    public long getNumberOfCallsToDelete() {
        return this.stats.getCount(Tracked.DELETE);
    }

    @JmxGetter(name="averageDeleteCompletionTimeInMs", description="The avg. time in ms for DELETE calls to complete.")
    public double getAverageDeleteCompletionTimeInMs() {
        return this.stats.getAvgTimeInMs(Tracked.DELETE);
    }

    @JmxGetter(name="DeleteThroughput", description="Throughput of DELETE requests.")
    public float getDeleteThroughput() {
        return this.stats.getThroughput(Tracked.DELETE);
    }

    @JmxGetter(name="numberOfObsoleteVersions", description="Number of ObsoleteVersionExceptions since the last reset.")
    public long getNumberOfObsoleteVersions() {
        return this.stats.getCount(Tracked.OBSOLETE);
    }

    @JmxGetter(name="numberOfExceptions", description="The number of exceptions since the last reset.")
    public long getNumberOfExceptions() {
        return this.stats.getCount(Tracked.EXCEPTION);
    }

    @JmxGetter(name="averageOperationTimeInMs", description="The total nuber of all operations that have occured.")
    public double getAvgOperationCompletionTimeInMs() {
        double sum = 0.0;
        double weightedTime = 0.0;
        for (Tracked stat : ImmutableList.of(Tracked.DELETE, Tracked.GET, Tracked.GET_ALL, Tracked.PUT)) {
            sum += (double)this.stats.getCount(stat);
            weightedTime += (double)this.stats.getCount(stat) * this.stats.getAvgTimeInMs(stat);
        }
        if (sum <= 0.0) {
            return 0.0;
        }
        return weightedTime / sum;
    }

    @JmxGetter(name="AllOperationThroughput", description="The number of exceptions since the last reset.")
    public double getOperationThroughput() {
        return this.stats.getThroughput(Tracked.DELETE) + this.stats.getThroughput(Tracked.GET) + this.stats.getThroughput(Tracked.GET_ALL) + this.stats.getThroughput(Tracked.PUT);
    }
}

