/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import voldemort.store.stats.RequestCounter;
import voldemort.store.stats.Tracked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreStats {
    private final StoreStats parent;
    private final Map<Tracked, RequestCounter> counters = new EnumMap<Tracked, RequestCounter>(Tracked.class);

    public StoreStats() {
        this(null);
    }

    public StoreStats(StoreStats parent) {
        for (Tracked tracked : Tracked.values()) {
            this.counters.put(tracked, new RequestCounter(300000));
        }
        this.parent = parent;
    }

    public long getCount(Tracked op) {
        return this.counters.get((Object)op).getCount();
    }

    public float getThroughput(Tracked op) {
        return this.counters.get((Object)op).getThroughput();
    }

    public double getAvgTimeInMs(Tracked op) {
        return this.counters.get((Object)op).getAverageTimeInMs();
    }

    public void recordTime(Tracked op, long timeNS) {
        this.counters.get((Object)op).addRequest(timeNS);
        if (this.parent != null) {
            this.parent.recordTime(op, timeNS);
        }
    }

    public Map<Tracked, RequestCounter> getCounters() {
        return Collections.unmodifiableMap(this.counters);
    }
}

