/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.stats.StoreStats;
import voldemort.store.stats.Tracked;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatTrackingStore<K, V>
extends DelegatingStore<K, V> {
    private StoreStats stats;

    public StatTrackingStore(Store<K, V> innerStore, StoreStats parentStats) {
        super(innerStore);
        this.stats = new StoreStats(parentStats);
    }

    @Override
    public boolean delete(K key, Version version) throws VoldemortException {
        long start = System.nanoTime();
        try {
            boolean bl = super.delete(key, version);
            return bl;
        }
        catch (VoldemortException e) {
            this.stats.recordTime(Tracked.EXCEPTION, System.nanoTime() - start);
            throw e;
        }
        finally {
            this.stats.recordTime(Tracked.DELETE, System.nanoTime() - start);
        }
    }

    @Override
    public List<Versioned<V>> get(K key) throws VoldemortException {
        long start = System.nanoTime();
        try {
            List list = super.get(key);
            return list;
        }
        catch (VoldemortException e) {
            this.stats.recordTime(Tracked.EXCEPTION, System.nanoTime() - start);
            throw e;
        }
        finally {
            this.stats.recordTime(Tracked.GET, System.nanoTime() - start);
        }
    }

    @Override
    public Map<K, List<Versioned<V>>> getAll(Iterable<K> keys) throws VoldemortException {
        long start = System.nanoTime();
        try {
            Map map = super.getAll(keys);
            return map;
        }
        catch (VoldemortException e) {
            this.stats.recordTime(Tracked.EXCEPTION, System.nanoTime() - start);
            throw e;
        }
        finally {
            this.stats.recordTime(Tracked.GET_ALL, System.nanoTime() - start);
        }
    }

    @Override
    public void put(K key, Versioned<V> value) throws VoldemortException {
        long start = System.nanoTime();
        try {
            super.put(key, value);
        }
        catch (ObsoleteVersionException e) {
            this.stats.recordTime(Tracked.OBSOLETE, System.nanoTime() - start);
            throw e;
        }
        catch (VoldemortException e) {
            this.stats.recordTime(Tracked.EXCEPTION, System.nanoTime() - start);
            throw e;
        }
        finally {
            this.stats.recordTime(Tracked.PUT, System.nanoTime() - start);
        }
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (StoreCapabilityType.STAT_TRACKER.equals((Object)capability)) {
            return this.stats;
        }
        return super.getCapability(capability);
    }

    public StoreStats getStats() {
        return this.stats;
    }

    @JmxOperation(description="Reset statistics.", impact=1)
    public void resetStatistics() {
        this.stats = new StoreStats();
    }
}

