/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.util.concurrent.atomic.AtomicReference;

public class RequestCounter {
    private final AtomicReference<Accumulator> values = new AtomicReference<Accumulator>(new Accumulator());
    private final int durationMS;

    public RequestCounter(int durationMS) {
        this.durationMS = durationMS;
    }

    public long getCount() {
        return this.getValidAccumulator().count;
    }

    public long getTotalCount() {
        return this.getValidAccumulator().total;
    }

    public float getThroughput() {
        Accumulator oldv = this.getValidAccumulator();
        double elapsed = (double)(System.currentTimeMillis() - oldv.startTimeMS) / 1000.0;
        if (elapsed > 0.0) {
            return (float)((double)oldv.count / elapsed);
        }
        return -1.0f;
    }

    public String getDisplayThroughput() {
        return String.format("%.2f", Float.valueOf(this.getThroughput()));
    }

    public double getAverageTimeInMs() {
        return this.getValidAccumulator().getAverageTimeNS() / 1000000.0;
    }

    public String getDisplayAverageTimeInMs() {
        return String.format("%.4f", this.getAverageTimeInMs());
    }

    public int getDuration() {
        return this.durationMS;
    }

    private Accumulator getValidAccumulator() {
        Accumulator accum = this.values.get();
        long now = System.currentTimeMillis();
        if (now - accum.startTimeMS <= (long)this.durationMS) {
            return accum;
        }
        Accumulator newWithTotal = accum.newWithTotal();
        if (this.values.compareAndSet(accum, newWithTotal)) {
            return newWithTotal;
        }
        return this.values.get();
    }

    public void addRequest(long timeNS) {
        for (int i = 0; i < 3; ++i) {
            long total;
            long totalTimeNS;
            long count;
            long startTimeMS;
            Accumulator oldv = this.getValidAccumulator();
            if (!this.values.compareAndSet(oldv, new Accumulator(startTimeMS = oldv.startTimeMS, count = oldv.count + 1L, totalTimeNS = oldv.totalTimeNS + timeNS, total = oldv.total + 1L))) continue;
            return;
        }
    }

    private static class Accumulator {
        final long startTimeMS;
        final long count;
        final long totalTimeNS;
        final long total;

        public Accumulator() {
            this(System.currentTimeMillis(), 0L, 0L, 0L);
        }

        public Accumulator newWithTotal() {
            return new Accumulator(System.currentTimeMillis(), 0L, 0L, this.total);
        }

        public Accumulator(long startTimeMS, long count, long totalTimeNS, long total) {
            this.startTimeMS = startTimeMS;
            this.count = count;
            this.totalTimeNS = totalTimeNS;
            this.total = total;
        }

        public double getAverageTimeNS() {
            return this.count > 0L ? (double)(1.0f * (float)this.totalTimeNS / (float)this.count) : -0.0;
        }
    }
}

