/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.text.NumberFormat;

public class DataSetStats {
    private long numEntries = 0L;
    private long keyBytes = 0L;
    private long valueBytes = 0L;
    private int minKeySize = Integer.MAX_VALUE;
    private int minValueSize = Integer.MAX_VALUE;
    private int maxKeySize = Integer.MIN_VALUE;
    private int maxValueSize = Integer.MIN_VALUE;

    public void countEntry(int keySize, int valueSize) {
        ++this.numEntries;
        this.keyBytes += (long)keySize;
        this.valueBytes += (long)valueSize;
        if (keySize > this.maxKeySize) {
            this.maxKeySize = keySize;
        }
        if (keySize < this.minKeySize) {
            this.maxKeySize = keySize;
        }
        if (valueSize > this.maxValueSize) {
            this.maxValueSize = valueSize;
        }
        if (valueSize < this.minValueSize) {
            this.minValueSize = valueSize;
        }
    }

    public long getTotalEntries() {
        return this.numEntries;
    }

    public long getTotalKeyBytes() {
        return this.keyBytes;
    }

    public long getTotalValueBytes() {
        return this.valueBytes;
    }

    public int getMaxKeySize() {
        return this.maxKeySize;
    }

    public int getMaxValueSize() {
        return this.maxValueSize;
    }

    public int getMinKeySize() {
        return this.minKeySize;
    }

    public int getMinValueSize() {
        return this.minValueSize;
    }

    public long getTotalBytes() {
        return this.getTotalKeyBytes() + this.getTotalValueBytes();
    }

    public double getAvgKeySize() {
        return (double)this.getTotalKeyBytes() / (double)this.getTotalEntries();
    }

    public double getAvgValueSize() {
        return (double)this.getTotalValueBytes() / (double)this.getTotalEntries();
    }

    public double getAvgEntrySize() {
        return (double)this.getTotalBytes() / (double)this.getTotalEntries();
    }

    public void add(DataSetStats stats) {
        this.numEntries += stats.getTotalEntries();
        this.keyBytes += stats.getTotalKeyBytes();
        this.valueBytes = stats.getTotalValueBytes();
        this.minKeySize = Math.min(this.minKeySize, stats.getMinKeySize());
        this.minValueSize = Math.min(this.minValueSize, stats.getMinValueSize());
        this.maxKeySize = Math.max(this.maxKeySize, stats.getMaxKeySize());
        this.maxValueSize = Math.max(this.maxValueSize, stats.getMaxValueSize());
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(1);
        return "Total entries: " + this.getTotalEntries() + "\n" + "Total bytes: " + this.getTotalBytes() + "\n" + "Avg. key size: " + nf.format(this.getAvgKeySize()) + "\n" + "Avg. value size: " + nf.format(this.getAvgValueSize()) + "\n" + "Smallest key size: " + this.getMinValueSize() + "\n" + "Largest key size: " + this.getMinValueSize() + "\n" + "Smallest value size: " + this.getMinValueSize() + "\n" + "Largest value size: " + this.getMaxValueSize();
    }
}

