/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormat;
import voldemort.client.protocol.RequestFormatFactory;
import voldemort.server.RequestRoutingType;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.UnreachableStoreException;
import voldemort.store.socket.SocketAndStreams;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketPool;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketStore
implements Store<ByteArray, byte[]> {
    private static final Logger logger = Logger.getLogger(SocketStore.class);
    private final RequestFormatFactory requestFormatFactory = new RequestFormatFactory();
    private final String name;
    private final SocketPool pool;
    private final SocketDestination destination;
    private final RequestFormat requestFormat;
    private final RequestRoutingType requestType;

    public SocketStore(String name, SocketDestination dest, SocketPool socketPool, boolean reroute) {
        this.name = Utils.notNull(name);
        this.pool = Utils.notNull(socketPool);
        this.destination = dest;
        this.requestFormat = this.requestFormatFactory.getRequestFormat(dest.getRequestFormatType());
        this.requestType = RequestRoutingType.getRequestRoutingType(reroute, false);
    }

    public SocketStore(String name, SocketDestination dest, SocketPool socketPool, RequestRoutingType requestType) {
        this.name = Utils.notNull(name);
        this.pool = Utils.notNull(socketPool);
        this.destination = dest;
        this.requestFormat = this.requestFormatFactory.getRequestFormat(dest.getRequestFormatType());
        this.requestType = requestType;
    }

    @Override
    public void close() throws VoldemortException {
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        SocketAndStreams sands = this.pool.checkout(this.destination);
        try {
            this.requestFormat.writeDeleteRequest(sands.getOutputStream(), this.name, key, (VectorClock)version, this.requestType);
            sands.getOutputStream().flush();
            boolean bl = this.requestFormat.readDeleteResponse(sands.getInputStream());
            return bl;
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            throw new UnreachableStoreException("Failure in delete on " + this.destination + ": " + e.getMessage(), e);
        }
        finally {
            this.pool.checkin(this.destination, sands);
        }
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        SocketAndStreams sands = this.pool.checkout(this.destination);
        try {
            this.requestFormat.writeGetAllRequest(sands.getOutputStream(), this.name, keys, this.requestType);
            sands.getOutputStream().flush();
            Map<ByteArray, List<Versioned<byte[]>>> map = this.requestFormat.readGetAllResponse(sands.getInputStream());
            return map;
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            throw new UnreachableStoreException("Failure in getAll() on " + this.destination + ": " + e.getMessage(), e);
        }
        finally {
            this.pool.checkin(this.destination, sands);
        }
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        SocketAndStreams sands = this.pool.checkout(this.destination);
        try {
            this.requestFormat.writeGetRequest(sands.getOutputStream(), this.name, key, this.requestType);
            sands.getOutputStream().flush();
            List<Versioned<byte[]>> list = this.requestFormat.readGetResponse(sands.getInputStream());
            return list;
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            throw new UnreachableStoreException("Failure in get on " + this.destination + ": " + e.getMessage(), e);
        }
        finally {
            this.pool.checkin(this.destination, sands);
        }
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> versioned) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        SocketAndStreams sands = this.pool.checkout(this.destination);
        try {
            this.requestFormat.writePutRequest(sands.getOutputStream(), this.name, key, versioned.getValue(), (VectorClock)versioned.getVersion(), this.requestType);
            sands.getOutputStream().flush();
            this.requestFormat.readPutResponse(sands.getInputStream());
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            throw new UnreachableStoreException("Failure in put on " + this.destination + ": " + e.getMessage(), e);
        }
        finally {
            this.pool.checkin(this.destination, sands);
        }
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (StoreCapabilityType.SOCKET_POOL.equals((Object)capability)) {
            return this.pool;
        }
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void close(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close socket");
        }
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        StoreUtils.assertValidKey(key);
        SocketAndStreams sands = this.pool.checkout(this.destination);
        try {
            this.requestFormat.writeGetVersionRequest(sands.getOutputStream(), this.name, key, this.requestType);
            sands.getOutputStream().flush();
            List<Version> list = this.requestFormat.readGetVersionResponse(sands.getInputStream());
            return list;
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            throw new UnreachableStoreException("Failure in getVersion on " + this.destination + ": " + e.getMessage(), e);
        }
        finally {
            this.pool.checkin(this.destination, sands);
        }
    }
}

