/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxSetter;
import voldemort.store.UnreachableStoreException;
import voldemort.store.socket.SocketAndStreams;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketResourceFactory;
import voldemort.utils.pool.KeyedResourcePool;
import voldemort.utils.pool.ResourcePoolConfig;

@JmxManaged(description="Voldemort socket pool.")
public class SocketPool {
    private final AtomicInteger monitoringInterval = new AtomicInteger(10000);
    private final AtomicInteger checkouts;
    private final AtomicLong waitNs;
    private final AtomicLong avgWaitNs;
    private final KeyedResourcePool<SocketDestination, SocketAndStreams> pool;
    private final SocketResourceFactory socketFactory;

    public SocketPool(int maxConnectionsPerNode, int connectionTimeoutMs, int soTimeoutMs, int socketBufferSize, boolean socketKeepAlive) {
        ResourcePoolConfig config = new ResourcePoolConfig().setIsFair(true).setMaxPoolSize(maxConnectionsPerNode).setMaxInvalidAttempts(maxConnectionsPerNode).setTimeout(connectionTimeoutMs, TimeUnit.MILLISECONDS);
        this.socketFactory = new SocketResourceFactory(soTimeoutMs, socketBufferSize, socketKeepAlive);
        this.pool = new KeyedResourcePool<SocketDestination, SocketAndStreams>(this.socketFactory, config);
        this.checkouts = new AtomicInteger(0);
        this.waitNs = new AtomicLong(0L);
        this.avgWaitNs = new AtomicLong(0L);
    }

    public SocketPool(int maxConnectionsPerNode, int connectionTimeoutMs, int soTimeoutMs, int socketBufferSize) {
        this(maxConnectionsPerNode, connectionTimeoutMs, soTimeoutMs, socketBufferSize, false);
    }

    public SocketAndStreams checkout(SocketDestination destination) {
        try {
            long start = System.nanoTime();
            SocketAndStreams sas = this.pool.checkout(destination);
            this.updateStats(System.nanoTime() - start);
            return sas;
        }
        catch (Exception e) {
            throw new UnreachableStoreException("Failure while checking out socket for " + destination + ": ", e);
        }
    }

    private void updateStats(long checkoutTimeNs) {
        int interval;
        long wait = this.waitNs.getAndAdd(checkoutTimeNs);
        int count = this.checkouts.getAndIncrement();
        if (count % (interval = this.monitoringInterval.get()) == interval - 1) {
            this.waitNs.set(0L);
            this.checkouts.set(0);
            this.avgWaitNs.set(wait / (long)count);
        }
    }

    public void checkin(SocketDestination destination, SocketAndStreams socket) {
        try {
            this.pool.checkin(destination, socket);
        }
        catch (Exception e) {
            throw new VoldemortException("Failure while checking in socket for " + destination + ": ", e);
        }
    }

    public void close(SocketDestination destination) {
        destination.setLastClosedTimestamp();
        this.pool.close(destination);
    }

    public void close() {
        this.pool.close();
    }

    @JmxGetter(name="socketsCreated", description="The total number of sockets created by this pool.")
    public int getNumberSocketsCreated() {
        return this.socketFactory.getNumberCreated();
    }

    @JmxGetter(name="socketsDestroyed", description="The total number of sockets destroyed by this pool.")
    public int getNumberSocketsDestroyed() {
        return this.socketFactory.getNumberDestroyed();
    }

    @JmxGetter(name="numberOfConnections", description="The number of active connections.")
    public int getNumberOfActiveConnections() {
        return this.pool.getTotalResourceCount();
    }

    @JmxGetter(name="numberOfIdleConnections", description="The number of active connections.")
    public int getNumberOfCheckedInConnections() {
        return this.pool.getCheckedInResourceCount();
    }

    @JmxGetter(name="avgWaitTimeMs", description="The avg. ms of wait time to acquire a connection.")
    public double getAvgWaitTimeMs() {
        return this.avgWaitNs.doubleValue() / 1000000.0;
    }

    @JmxSetter(name="monitoringInterval", description="The number of checkouts over which performance statistics are calculated.")
    public void setMonitoringInterval(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Monitoring interval must be a positive number.");
        }
        this.monitoringInterval.set(count);
    }
}

