/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket;

import com.google.common.base.Objects;
import voldemort.client.protocol.RequestFormatType;
import voldemort.utils.Utils;

public class SocketDestination {
    private final String host;
    private final int port;
    private final RequestFormatType requestFormatType;
    private long lastClosedTimestamp;

    public SocketDestination(String host, int port, RequestFormatType requestFormatType) {
        this.host = Utils.notNull(host);
        this.port = Utils.notNull(port);
        this.requestFormatType = Utils.notNull(requestFormatType);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public RequestFormatType getRequestFormatType() {
        return this.requestFormatType;
    }

    public long getLastClosedTimestamp() {
        return this.lastClosedTimestamp;
    }

    public void setLastClosedTimestamp() {
        this.lastClosedTimestamp = System.nanoTime();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(SocketDestination.class)) {
            return false;
        }
        SocketDestination d = (SocketDestination)obj;
        return this.getHost().equals(d.getHost()) && this.getPort() == d.getPort() && this.getRequestFormatType().equals((Object)d.getRequestFormatType());
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.host, this.port, this.requestFormatType});
    }

    public String toString() {
        return this.host + ":" + this.port + "(" + this.requestFormatType.getCode() + ")";
    }
}

