/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import voldemort.client.protocol.RequestFormatType;

public class SocketAndStreams {
    private static final int DEFAULT_BUFFER_SIZE = 1000;
    private final Socket socket;
    private final RequestFormatType requestFormatType;
    private final DataInputStream inputStream;
    private final DataOutputStream outputStream;
    private final long createTimestamp;

    public SocketAndStreams(Socket socket, RequestFormatType requestFormatType) throws IOException {
        this(socket, 1000, requestFormatType);
    }

    public SocketAndStreams(Socket socket, int bufferSizeBytes, RequestFormatType type) throws IOException {
        this.socket = socket;
        this.inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream(), bufferSizeBytes));
        this.outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), bufferSizeBytes));
        this.requestFormatType = type;
        this.createTimestamp = System.nanoTime();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public DataInputStream getInputStream() {
        return this.inputStream;
    }

    public DataOutputStream getOutputStream() {
        return this.outputStream;
    }

    public RequestFormatType getRequestFormatType() {
        return this.requestFormatType;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }
}

