/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.slop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import voldemort.VoldemortException;
import voldemort.store.DelegatingStore;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.Store;
import voldemort.store.StoreUtils;
import voldemort.store.UnreachableStoreException;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SloppyStore
extends DelegatingStore<ByteArray, byte[]> {
    private final int node;
    private final List<Store<ByteArray, Slop>> backupStores;

    public SloppyStore(int node, Store<ByteArray, byte[]> innerStore, Collection<? extends Store<ByteArray, Slop>> backupStores) {
        super(innerStore);
        this.node = node;
        this.backupStores = new ArrayList<Store<ByteArray, Slop>>(backupStores);
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        try {
            return this.getInnerStore().delete(key, version);
        }
        catch (UnreachableStoreException e) {
            ArrayList<UnreachableStoreException> failures = new ArrayList<UnreachableStoreException>();
            failures.add(e);
            Slop slop = new Slop(this.getName(), Slop.Operation.DELETE, key, null, this.node, new Date());
            for (Store<ByteArray, Slop> slopStore : this.backupStores) {
                try {
                    slopStore.put(slop.makeKey(), new Versioned<Slop>(slop, version));
                    return false;
                }
                catch (UnreachableStoreException u) {
                    failures.add(u);
                }
            }
            throw new InsufficientOperationalNodesException("All slop servers are unavailable from node " + this.node + ".", failures);
        }
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        try {
            this.getInnerStore().put(key, value);
        }
        catch (UnreachableStoreException e) {
            ArrayList<UnreachableStoreException> failures = new ArrayList<UnreachableStoreException>();
            failures.add(e);
            boolean persisted = false;
            Slop slop = new Slop(this.getName(), Slop.Operation.PUT, key, value.getValue(), this.node, new Date());
            for (Store<ByteArray, Slop> slopStore : this.backupStores) {
                try {
                    slopStore.put(slop.makeKey(), new Versioned<Slop>(slop, value.getVersion()));
                    persisted = true;
                    break;
                }
                catch (UnreachableStoreException u) {
                    failures.add(u);
                }
            }
            if (persisted) {
                throw new UnreachableStoreException("Put operation failed on node " + this.node + ", but has been persisted to slop storage for eventual replication.", e);
            }
            throw new InsufficientOperationalNodesException("All slop servers are unavailable from node " + this.node + ".", failures);
        }
    }

    public List<Store<ByteArray, Slop>> getBackupStores() {
        return new ArrayList<Store<ByteArray, Slop>>(this.backupStores);
    }
}

